/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.io.PrintStream;
import java.net.InetSocketAddress;
import java.net.URI;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.management.ObjectName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.HadoopIllegalArgumentException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.ReconfigurableBase;
import org.apache.hadoop.conf.ReconfigurationException;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Trash;
import org.apache.hadoop.ha.HAServiceProtocol;
import org.apache.hadoop.ha.HAServiceStatus;
import org.apache.hadoop.ha.HealthCheckFailedException;
import org.apache.hadoop.ha.ServiceFailedException;
import org.apache.hadoop.hdfs.DFSConfigKeys;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.hdfs.DFSUtilClient;
import org.apache.hadoop.hdfs.HAUtil;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.protocol.ClientProtocol;
import org.apache.hadoop.hdfs.protocol.HdfsConstants;
import org.apache.hadoop.hdfs.security.token.delegation.DelegationTokenIdentifier;
import org.apache.hadoop.hdfs.server.aliasmap.InMemoryAliasMap;
import org.apache.hadoop.hdfs.server.aliasmap.InMemoryLevelDBAliasMapServer;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockManager;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeManager;
import org.apache.hadoop.hdfs.server.common.HdfsServerConstants;
import org.apache.hadoop.hdfs.server.common.MetricsLoggerTask;
import org.apache.hadoop.hdfs.server.common.Storage;
import org.apache.hadoop.hdfs.server.common.TokenVerifier;
import org.apache.hadoop.hdfs.server.namenode.BackupNode;
import org.apache.hadoop.hdfs.server.namenode.EditLogInputStream;
import org.apache.hadoop.hdfs.server.namenode.FSEditLog;
import org.apache.hadoop.hdfs.server.namenode.FSEditLogOp;
import org.apache.hadoop.hdfs.server.namenode.FSEditLogOpCodes;
import org.apache.hadoop.hdfs.server.namenode.FSImage;
import org.apache.hadoop.hdfs.server.namenode.FSImageFormat;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.namenode.MetaRecoveryContext;
import org.apache.hadoop.hdfs.server.namenode.NNStorage;
import org.apache.hadoop.hdfs.server.namenode.NameNodeFormatException;
import org.apache.hadoop.hdfs.server.namenode.NameNodeHttpServer;
import org.apache.hadoop.hdfs.server.namenode.NameNodeRpcServer;
import org.apache.hadoop.hdfs.server.namenode.NameNodeStatusMXBean;
import org.apache.hadoop.hdfs.server.namenode.NameNodeUtils;
import org.apache.hadoop.hdfs.server.namenode.ha.ActiveState;
import org.apache.hadoop.hdfs.server.namenode.ha.BootstrapStandby;
import org.apache.hadoop.hdfs.server.namenode.ha.HAContext;
import org.apache.hadoop.hdfs.server.namenode.ha.HAState;
import org.apache.hadoop.hdfs.server.namenode.ha.StandbyState;
import org.apache.hadoop.hdfs.server.namenode.metrics.NameNodeMetrics;
import org.apache.hadoop.hdfs.server.namenode.startupprogress.StartupProgress;
import org.apache.hadoop.hdfs.server.namenode.startupprogress.StartupProgressMetrics;
import org.apache.hadoop.hdfs.server.protocol.DatanodeProtocol;
import org.apache.hadoop.hdfs.server.protocol.NamenodeProtocol;
import org.apache.hadoop.hdfs.server.protocol.NamenodeProtocols;
import org.apache.hadoop.hdfs.server.protocol.NamenodeRegistration;
import org.apache.hadoop.hdfs.server.protocol.NamespaceInfo;
import org.apache.hadoop.http.HttpServer2;
import org.apache.hadoop.ipc.ExternalCall;
import org.apache.hadoop.ipc.RefreshCallQueueProtocol;
import org.apache.hadoop.ipc.RetriableException;
import org.apache.hadoop.ipc.Server;
import org.apache.hadoop.ipc.StandbyException;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import org.apache.hadoop.metrics2.util.MBeans;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.security.RefreshUserMappingsProtocol;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authorize.RefreshAuthorizationPolicyProtocol;
import org.apache.hadoop.tools.GetUserMappingsProtocol;
import org.apache.hadoop.tracing.TraceAdminProtocol;
import org.apache.hadoop.tracing.TraceUtils;
import org.apache.hadoop.tracing.TracerConfigurationManager;
import org.apache.hadoop.util.ExitUtil;
import org.apache.hadoop.util.GcTimeMonitor;
import org.apache.hadoop.util.GenericOptionsParser;
import org.apache.hadoop.util.JvmPauseMonitor;
import org.apache.hadoop.util.ServicePlugin;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.util.Time;
import org.apache.hadoop.util.ToolRunner;
import org.apache.htrace.core.Tracer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class NameNode
extends ReconfigurableBase
implements NameNodeStatusMXBean,
TokenVerifier<DelegationTokenIdentifier> {
    private InMemoryLevelDBAliasMapServer levelDBAliasMapServer;
    public static final String[] NAMENODE_SPECIFIC_KEYS;
    public static final String[] NAMESERVICE_SPECIFIC_KEYS;
    private String ipcClientRPCBackoffEnable;
    private final TreeSet<String> reconfigurableProperties = Sets.newTreeSet((Iterable)Lists.newArrayList((Object[])new String[]{"dfs.heartbeat.interval", "dfs.namenode.heartbeat.recheck-interval", "fs.protected.directories", "hadoop.caller.context.enabled", "dfs.storage.policy.satisfier.mode", "dfs.namenode.replication.max-streams", "dfs.namenode.replication.max-streams-hard-limit", "dfs.namenode.replication.work.multiplier.per.iteration", "dfs.block.replicator.classname", "dfs.block.placement.ec.classname"}));
    private static final String USAGE;
    @Deprecated
    public static final int DEFAULT_PORT = 8020;
    public static final Logger LOG;
    public static final Logger stateChangeLog;
    public static final Logger blockStateChangeLog;
    public static final HAState ACTIVE_STATE;
    public static final HAState STANDBY_STATE;
    public static final HAState OBSERVER_STATE;
    private static final String NAMENODE_HTRACE_PREFIX = "namenode.htrace.";
    public static final Log MetricsLog;
    protected FSNamesystem namesystem;
    protected final HdfsServerConstants.NamenodeRole role;
    private volatile HAState state;
    private final boolean haEnabled;
    private final HAContext haContext;
    protected final boolean allowStaleStandbyReads;
    private AtomicBoolean started = new AtomicBoolean(false);
    private final boolean notBecomeActiveInSafemode;
    private static final int HEALTH_MONITOR_WARN_THRESHOLD_MS = 5000;
    protected NameNodeHttpServer httpServer;
    private Thread emptier;
    protected boolean stopRequested = false;
    protected NamenodeRegistration nodeRegistration;
    private List<ServicePlugin> plugins;
    private NameNodeRpcServer rpcServer;
    private JvmPauseMonitor pauseMonitor;
    private GcTimeMonitor gcTimeMonitor;
    private ObjectName nameNodeStatusBeanName;
    protected final Tracer tracer;
    protected final TracerConfigurationManager tracerConfigurationManager;
    ScheduledThreadPoolExecutor metricsLoggerTimer;
    private String clientNamenodeAddress;
    static NameNodeMetrics metrics;
    private static final StartupProgress startupProgress;

    public long getProtocolVersion(String protocol, long clientVersion) throws IOException {
        if (protocol.equals(ClientProtocol.class.getName())) {
            return 69L;
        }
        if (protocol.equals(DatanodeProtocol.class.getName())) {
            return 28L;
        }
        if (protocol.equals(NamenodeProtocol.class.getName())) {
            return 6L;
        }
        if (protocol.equals(RefreshAuthorizationPolicyProtocol.class.getName())) {
            return 1L;
        }
        if (protocol.equals(RefreshUserMappingsProtocol.class.getName())) {
            return 1L;
        }
        if (protocol.equals(RefreshCallQueueProtocol.class.getName())) {
            return 1L;
        }
        if (protocol.equals(GetUserMappingsProtocol.class.getName())) {
            return 1L;
        }
        if (protocol.equals(TraceAdminProtocol.class.getName())) {
            return 1L;
        }
        throw new IOException("Unknown protocol to name node: " + protocol);
    }

    public static void format(Configuration conf) throws IOException {
        NameNode.format(conf, true, true);
    }

    public FSNamesystem getNamesystem() {
        return this.namesystem;
    }

    public NamenodeProtocols getRpcServer() {
        return this.rpcServer;
    }

    @VisibleForTesting
    public HttpServer2 getHttpServer() {
        return this.httpServer.getHttpServer();
    }

    public void queueExternalCall(ExternalCall<?> extCall) throws IOException, InterruptedException {
        if (this.rpcServer == null) {
            throw new RetriableException("Namenode is in startup mode");
        }
        this.rpcServer.getClientRpcServer().queueCall(extCall);
    }

    public static void initMetrics(Configuration conf, HdfsServerConstants.NamenodeRole role) {
        metrics = NameNodeMetrics.create(conf, role);
    }

    public static NameNodeMetrics getNameNodeMetrics() {
        return metrics;
    }

    public static StartupProgress getStartupProgress() {
        return startupProgress;
    }

    public String getTokenServiceName() {
        return this.getClientNamenodeAddress();
    }

    public String getClientNamenodeAddress() {
        return this.clientNamenodeAddress;
    }

    public static void setServiceAddress(Configuration conf, String address) {
        LOG.info("Setting ADDRESS {}", (Object)address);
        conf.set("dfs.namenode.servicerpc-address", address);
    }

    public static InetSocketAddress getServiceAddress(Configuration conf, boolean fallback) {
        String addr = conf.getTrimmed("dfs.namenode.servicerpc-address");
        if (addr == null || addr.isEmpty()) {
            return fallback ? DFSUtilClient.getNNAddress((Configuration)conf) : null;
        }
        return DFSUtilClient.getNNAddress((String)addr);
    }

    public HdfsServerConstants.NamenodeRole getRole() {
        return this.role;
    }

    boolean isRole(HdfsServerConstants.NamenodeRole that) {
        return this.role.equals((Object)that);
    }

    public static String composeNotStartedMessage(HdfsServerConstants.NamenodeRole role) {
        return (Object)((Object)role) + " still not started";
    }

    InetSocketAddress getLifelineRpcServerAddress(Configuration conf) {
        String addr = NameNode.getTrimmedOrNull(conf, "dfs.namenode.lifeline.rpc-address");
        if (addr == null) {
            return null;
        }
        return NetUtils.createSocketAddr((String)addr);
    }

    protected InetSocketAddress getServiceRpcServerAddress(Configuration conf) {
        return NameNode.getServiceAddress(conf, false);
    }

    protected InetSocketAddress getRpcServerAddress(Configuration conf) {
        return DFSUtilClient.getNNAddress((Configuration)conf);
    }

    String getLifelineRpcServerBindHost(Configuration conf) {
        return NameNode.getTrimmedOrNull(conf, "dfs.namenode.lifeline.rpc-bind-host");
    }

    protected String getServiceRpcServerBindHost(Configuration conf) {
        return NameNode.getTrimmedOrNull(conf, "dfs.namenode.servicerpc-bind-host");
    }

    protected String getRpcServerBindHost(Configuration conf) {
        return NameNode.getTrimmedOrNull(conf, "dfs.namenode.rpc-bind-host");
    }

    private static String getTrimmedOrNull(Configuration conf, String key) {
        String addr = conf.getTrimmed(key);
        if (addr == null || addr.isEmpty()) {
            return null;
        }
        return addr;
    }

    void setRpcLifelineServerAddress(Configuration conf, InetSocketAddress lifelineRPCAddress) {
        LOG.info("Setting lifeline RPC address {}", (Object)lifelineRPCAddress);
        conf.set("dfs.namenode.lifeline.rpc-address", NetUtils.getHostPortString((InetSocketAddress)lifelineRPCAddress));
    }

    protected void setRpcServiceServerAddress(Configuration conf, InetSocketAddress serviceRPCAddress) {
        NameNode.setServiceAddress(conf, NetUtils.getHostPortString((InetSocketAddress)serviceRPCAddress));
    }

    protected void setRpcServerAddress(Configuration conf, InetSocketAddress rpcAddress) {
        FileSystem.setDefaultUri((Configuration)conf, (URI)DFSUtilClient.getNNUri((InetSocketAddress)rpcAddress));
    }

    protected InetSocketAddress getHttpServerAddress(Configuration conf) {
        return NameNode.getHttpAddress(conf);
    }

    protected InetSocketAddress getHttpServerBindAddress(Configuration conf) {
        InetSocketAddress bindAddress = this.getHttpServerAddress(conf);
        String bindHost = conf.getTrimmed("dfs.namenode.http-bind-host");
        if (bindHost != null && !bindHost.isEmpty()) {
            bindAddress = new InetSocketAddress(bindHost, bindAddress.getPort());
        }
        return bindAddress;
    }

    public static InetSocketAddress getHttpAddress(Configuration conf) {
        return NetUtils.createSocketAddr((String)conf.getTrimmed("dfs.namenode.http-address", "0.0.0.0:9870"));
    }

    protected void loadNamesystem(Configuration conf) throws IOException {
        this.namesystem = FSNamesystem.loadFromDisk(conf);
    }

    NamenodeRegistration getRegistration() {
        return this.nodeRegistration;
    }

    NamenodeRegistration setRegistration() {
        this.nodeRegistration = new NamenodeRegistration(NetUtils.getHostPortString((InetSocketAddress)this.getNameNodeAddress()), NetUtils.getHostPortString((InetSocketAddress)this.getHttpAddress()), this.getFSImage().getStorage(), this.getRole());
        return this.nodeRegistration;
    }

    public static UserGroupInformation getRemoteUser() throws IOException {
        UserGroupInformation ugi = Server.getRemoteUser();
        return ugi != null ? ugi : UserGroupInformation.getCurrentUser();
    }

    @Override
    public void verifyToken(DelegationTokenIdentifier id, byte[] password) throws IOException {
        if (this.namesystem == null) {
            throw new RetriableException("Namenode is in startup mode");
        }
        this.namesystem.verifyToken(id, password);
    }

    void loginAsNameNodeUser(Configuration conf) throws IOException {
        InetSocketAddress socAddr = this.getRpcServerAddress(conf);
        SecurityUtil.login((Configuration)conf, (String)"dfs.namenode.keytab.file", (String)"dfs.namenode.kerberos.principal", (String)socAddr.getHostName());
    }

    protected void initialize(Configuration conf) throws IOException {
        String intervals;
        if (conf.get("hadoop.user.group.metrics.percentiles.intervals") == null && (intervals = conf.get("dfs.metrics.percentiles.intervals")) != null) {
            conf.set("hadoop.user.group.metrics.percentiles.intervals", intervals);
        }
        UserGroupInformation.setConfiguration((Configuration)conf);
        this.loginAsNameNodeUser(conf);
        NameNode.initMetrics(conf, this.getRole());
        StartupProgressMetrics.register(startupProgress);
        this.pauseMonitor = new JvmPauseMonitor();
        this.pauseMonitor.init(conf);
        this.pauseMonitor.start();
        metrics.getJvmMetrics().setPauseMonitor(this.pauseMonitor);
        if (conf.getBoolean("dfs.namenode.gc.time.monitor.enable", true)) {
            long observationWindow = conf.getTimeDuration("dfs.namenode.gc.time.monitor.observation.window.ms", DFSConfigKeys.DFS_NAMENODE_GC_TIME_MONITOR_OBSERVATION_WINDOW_MS_DEFAULT, TimeUnit.MILLISECONDS);
            long sleepInterval = conf.getTimeDuration("dfs.namenode.gc.time.monitor.sleep.interval.ms", DFSConfigKeys.DFS_NAMENODE_GC_TIME_MONITOR_SLEEP_INTERVAL_MS_DEFAULT, TimeUnit.MILLISECONDS);
            this.gcTimeMonitor = new GcTimeMonitor.Builder().observationWindowMs(observationWindow).sleepIntervalMs(sleepInterval).build();
            this.gcTimeMonitor.start();
            metrics.getJvmMetrics().setGcTimeMonitor(this.gcTimeMonitor);
        }
        if (HdfsServerConstants.NamenodeRole.NAMENODE == this.role) {
            this.startHttpServer(conf);
        }
        this.loadNamesystem(conf);
        this.startAliasMapServerIfNecessary(conf);
        this.rpcServer = this.createRpcServer(conf);
        this.initReconfigurableBackoffKey();
        if (this.clientNamenodeAddress == null) {
            this.clientNamenodeAddress = NetUtils.getHostPortString((InetSocketAddress)this.getNameNodeAddress());
            LOG.info("Clients are to use " + this.clientNamenodeAddress + " to access this namenode/service.");
        }
        if (HdfsServerConstants.NamenodeRole.NAMENODE == this.role) {
            this.httpServer.setNameNodeAddress(this.getNameNodeAddress());
            this.httpServer.setFSImage(this.getFSImage());
            if (this.levelDBAliasMapServer != null) {
                this.httpServer.setAliasMap(this.levelDBAliasMapServer.getAliasMap());
            }
        }
        this.startCommonServices(conf);
        this.startMetricsLogger(conf);
    }

    @VisibleForTesting
    public InMemoryLevelDBAliasMapServer getAliasMapServer() {
        return this.levelDBAliasMapServer;
    }

    private void startAliasMapServerIfNecessary(Configuration conf) throws IOException {
        if (conf.getBoolean("dfs.namenode.provided.enabled", false) && conf.getBoolean("dfs.provided.aliasmap.inmemory.enabled", false)) {
            this.levelDBAliasMapServer = new InMemoryLevelDBAliasMapServer(InMemoryAliasMap::init, this.namesystem.getBlockPoolId());
            this.levelDBAliasMapServer.setConf(conf);
            this.levelDBAliasMapServer.start();
        }
    }

    private void initReconfigurableBackoffKey() {
        this.ipcClientRPCBackoffEnable = NameNode.buildBackoffEnableKey(this.rpcServer.getClientRpcServer().getPort());
        this.reconfigurableProperties.add(this.ipcClientRPCBackoffEnable);
    }

    static String buildBackoffEnableKey(int port) {
        String format = "%s.%d.%s";
        return String.format(format, "ipc", port, "backoff.enable");
    }

    protected void startMetricsLogger(Configuration conf) {
        long metricsLoggerPeriodSec = conf.getInt("dfs.namenode.metrics.logger.period.seconds", 600);
        if (metricsLoggerPeriodSec <= 0L) {
            return;
        }
        MetricsLoggerTask.makeMetricsLoggerAsync(MetricsLog);
        this.metricsLoggerTimer = new ScheduledThreadPoolExecutor(1);
        this.metricsLoggerTimer.setExecuteExistingDelayedTasksAfterShutdownPolicy(false);
        this.metricsLoggerTimer.scheduleWithFixedDelay(new MetricsLoggerTask(MetricsLog, "NameNode", 128), metricsLoggerPeriodSec, metricsLoggerPeriodSec, TimeUnit.SECONDS);
    }

    protected void stopMetricsLogger() {
        if (this.metricsLoggerTimer != null) {
            this.metricsLoggerTimer.shutdown();
            this.metricsLoggerTimer = null;
        }
    }

    protected NameNodeRpcServer createRpcServer(Configuration conf) throws IOException {
        return new NameNodeRpcServer(conf, this);
    }

    private void startCommonServices(Configuration conf) throws IOException {
        this.namesystem.startCommonServices(conf, this.haContext);
        this.registerNNSMXBean();
        if (HdfsServerConstants.NamenodeRole.NAMENODE != this.role) {
            this.startHttpServer(conf);
            this.httpServer.setNameNodeAddress(this.getNameNodeAddress());
            this.httpServer.setFSImage(this.getFSImage());
            if (this.levelDBAliasMapServer != null) {
                this.httpServer.setAliasMap(this.levelDBAliasMapServer.getAliasMap());
            }
        }
        this.rpcServer.start();
        try {
            this.plugins = conf.getInstances("dfs.namenode.plugins", ServicePlugin.class);
        }
        catch (RuntimeException e) {
            String pluginsValue = conf.get("dfs.namenode.plugins");
            LOG.error("Unable to load NameNode plugins. Specified list of plugins: " + pluginsValue, (Throwable)e);
            throw e;
        }
        for (ServicePlugin p : this.plugins) {
            try {
                p.start((Object)this);
            }
            catch (Throwable t) {
                LOG.warn("ServicePlugin " + p + " could not be started", t);
            }
        }
        LOG.info((Object)((Object)this.getRole()) + " RPC up at: " + this.getNameNodeAddress());
        if (this.rpcServer.getServiceRpcAddress() != null) {
            LOG.info((Object)((Object)this.getRole()) + " service RPC up at: " + this.rpcServer.getServiceRpcAddress());
        }
    }

    private void stopCommonServices() {
        if (this.rpcServer != null) {
            this.rpcServer.stop();
        }
        if (this.namesystem != null) {
            this.namesystem.close();
        }
        if (this.pauseMonitor != null) {
            this.pauseMonitor.stop();
        }
        if (this.plugins != null) {
            for (ServicePlugin p : this.plugins) {
                try {
                    p.stop();
                }
                catch (Throwable t) {
                    LOG.warn("ServicePlugin " + p + " could not be stopped", t);
                }
            }
        }
        this.stopHttpServer();
    }

    private void startTrashEmptier(final Configuration conf) throws IOException {
        long trashInterval = conf.getLong("fs.trash.interval", 0L);
        if (trashInterval == 0L) {
            return;
        }
        if (trashInterval < 0L) {
            throw new IOException("Cannot start trash emptier with negative interval. Set fs.trash.interval to a positive value.");
        }
        FileSystem fs = (FileSystem)SecurityUtil.doAsLoginUser((PrivilegedExceptionAction)new PrivilegedExceptionAction<FileSystem>(){

            @Override
            public FileSystem run() throws IOException {
                return FileSystem.get((Configuration)conf);
            }
        });
        this.emptier = new Thread(new Trash(fs, conf).getEmptier(), "Trash Emptier");
        this.emptier.setDaemon(true);
        this.emptier.start();
    }

    private void stopTrashEmptier() {
        if (this.emptier != null) {
            this.emptier.interrupt();
            this.emptier = null;
        }
    }

    private void startHttpServer(Configuration conf) throws IOException {
        this.httpServer = new NameNodeHttpServer(conf, this, this.getHttpServerBindAddress(conf));
        this.httpServer.start();
        this.httpServer.setStartupProgress(startupProgress);
    }

    private void stopHttpServer() {
        try {
            if (this.httpServer != null) {
                this.httpServer.stop();
            }
        }
        catch (Exception e) {
            LOG.error("Exception while stopping httpserver", (Throwable)e);
        }
    }

    public NameNode(Configuration conf) throws IOException {
        this(conf, HdfsServerConstants.NamenodeRole.NAMENODE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected NameNode(Configuration conf, HdfsServerConstants.NamenodeRole role) throws IOException {
        super(conf);
        this.tracer = new Tracer.Builder("NameNode").conf(TraceUtils.wrapHadoopConf((String)NAMENODE_HTRACE_PREFIX, (Configuration)conf)).build();
        this.tracerConfigurationManager = new TracerConfigurationManager(NAMENODE_HTRACE_PREFIX, conf);
        this.role = role;
        String nsId = this.getNameServiceId(conf);
        String namenodeId = HAUtil.getNameNodeId(conf, nsId);
        this.clientNamenodeAddress = NameNodeUtils.getClientNamenodeAddress(conf, nsId);
        if (this.clientNamenodeAddress != null) {
            LOG.info("Clients should use {} to access this namenode/service.", (Object)this.clientNamenodeAddress);
        }
        this.haEnabled = HAUtil.isHAEnabled(conf, nsId);
        this.state = this.createHAState(NameNode.getStartupOption(conf));
        this.allowStaleStandbyReads = HAUtil.shouldAllowStandbyReads(conf);
        this.haContext = this.createHAContext();
        try {
            NameNode.initializeGenericKeys(conf, nsId, namenodeId);
            this.initialize(this.getConf());
            this.state.prepareToEnterState(this.haContext);
            try {
                this.haContext.writeLock();
                this.state.enterState(this.haContext);
            }
            finally {
                this.haContext.writeUnlock();
            }
        }
        catch (IOException e) {
            this.stopAtException(e);
            throw e;
        }
        catch (HadoopIllegalArgumentException e) {
            this.stopAtException((Exception)((Object)e));
            throw e;
        }
        this.notBecomeActiveInSafemode = conf.getBoolean("dfs.ha.nn.not-become-active-in-safemode", false);
        this.started.set(true);
    }

    private void stopAtException(Exception e) {
        try {
            this.stop();
        }
        catch (Exception ex) {
            LOG.warn("Encountered exception when handling exception (" + e.getMessage() + "):", (Throwable)ex);
        }
    }

    protected HAState createHAState(HdfsServerConstants.StartupOption startOpt) {
        if (!this.haEnabled || startOpt == HdfsServerConstants.StartupOption.UPGRADE || startOpt == HdfsServerConstants.StartupOption.UPGRADEONLY) {
            return ACTIVE_STATE;
        }
        if (startOpt == HdfsServerConstants.StartupOption.OBSERVER) {
            return OBSERVER_STATE;
        }
        return STANDBY_STATE;
    }

    protected HAContext createHAContext() {
        return new NameNodeHAContext();
    }

    public void join() {
        try {
            this.rpcServer.join();
        }
        catch (InterruptedException ie) {
            LOG.info("Caught interrupted exception", (Throwable)ie);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        NameNode nameNode = this;
        synchronized (nameNode) {
            if (this.stopRequested) {
                return;
            }
            this.stopRequested = true;
        }
        try {
            if (this.state != null) {
                this.state.exitState(this.haContext);
            }
        }
        catch (ServiceFailedException e) {
            LOG.warn("Encountered exception while exiting state", (Throwable)e);
        }
        finally {
            this.stopMetricsLogger();
            this.stopCommonServices();
            if (metrics != null) {
                metrics.shutdown();
            }
            if (this.namesystem != null) {
                this.namesystem.shutdown();
            }
            if (this.nameNodeStatusBeanName != null) {
                MBeans.unregister((ObjectName)this.nameNodeStatusBeanName);
                this.nameNodeStatusBeanName = null;
            }
            if (this.levelDBAliasMapServer != null) {
                this.levelDBAliasMapServer.close();
            }
        }
        this.tracer.close();
    }

    synchronized boolean isStopRequested() {
        return this.stopRequested;
    }

    public boolean isInSafeMode() {
        return this.namesystem.isInSafeMode();
    }

    @VisibleForTesting
    public FSImage getFSImage() {
        return this.namesystem.getFSImage();
    }

    public InetSocketAddress getNameNodeAddress() {
        return this.rpcServer.getRpcAddress();
    }

    public Set<InetSocketAddress> getAuxiliaryNameNodeAddresses() {
        return this.rpcServer.getAuxiliaryRpcAddresses();
    }

    public String getNameNodeAddressHostPortString() {
        return NetUtils.getHostPortString((InetSocketAddress)this.getNameNodeAddress());
    }

    @VisibleForTesting
    public String getNNAuxiliaryRpcAddress() {
        Set<InetSocketAddress> auxiliaryAddrs = this.getAuxiliaryNameNodeAddresses();
        if (auxiliaryAddrs.isEmpty()) {
            return null;
        }
        InetSocketAddress addr = auxiliaryAddrs.iterator().next();
        return NetUtils.getHostPortString((InetSocketAddress)addr);
    }

    public InetSocketAddress getServiceRpcAddress() {
        InetSocketAddress serviceAddr = this.rpcServer.getServiceRpcAddress();
        return serviceAddr == null ? this.getNameNodeAddress() : serviceAddr;
    }

    public InetSocketAddress getHttpAddress() {
        return this.httpServer.getHttpAddress();
    }

    public InetSocketAddress getHttpsAddress() {
        return this.httpServer.getHttpsAddress();
    }

    @VisibleForTesting
    public void joinHttpServer() {
        if (this.httpServer != null) {
            try {
                this.httpServer.join();
            }
            catch (InterruptedException e) {
                LOG.info("Caught InterruptedException joining NameNodeHttpServer", (Throwable)e);
                Thread.currentThread().interrupt();
            }
        }
    }

    private static boolean format(Configuration conf, boolean force, boolean isInteractive) throws IOException {
        String nsId = DFSUtil.getNamenodeNameServiceId(conf);
        String namenodeId = HAUtil.getNameNodeId(conf, nsId);
        NameNode.initializeGenericKeys(conf, nsId, namenodeId);
        NameNode.checkAllowFormat(conf);
        if (UserGroupInformation.isSecurityEnabled()) {
            InetSocketAddress socAddr = DFSUtilClient.getNNAddress((Configuration)conf);
            SecurityUtil.login((Configuration)conf, (String)"dfs.namenode.keytab.file", (String)"dfs.namenode.kerberos.principal", (String)socAddr.getHostName());
        }
        Collection<URI> nameDirsToFormat = FSNamesystem.getNamespaceDirs(conf);
        List<URI> sharedDirs = FSNamesystem.getSharedEditsDirs(conf);
        ArrayList<URI> dirsToPrompt = new ArrayList<URI>();
        dirsToPrompt.addAll(nameDirsToFormat);
        dirsToPrompt.addAll(sharedDirs);
        List<URI> editDirsToFormat = FSNamesystem.getNamespaceEditsDirs(conf);
        String clusterId = HdfsServerConstants.StartupOption.FORMAT.getClusterId();
        if (clusterId == null || clusterId.equals("")) {
            clusterId = NNStorage.newClusterID();
        }
        LOG.info("Formatting using clusterid: {}", (Object)clusterId);
        FSImage fsImage = new FSImage(conf, nameDirsToFormat, editDirsToFormat);
        try {
            FSNamesystem fsn = new FSNamesystem(conf, fsImage);
            fsImage.getEditLog().initJournalsForWrite();
            if (conf.getBoolean("dfs.reformat.disabled", false)) {
                force = false;
                isInteractive = false;
                for (Storage.StorageDirectory sd : fsImage.storage.dirIterable(null)) {
                    if (!sd.hasSomeData()) continue;
                    throw new NameNodeFormatException("NameNode format aborted as reformat is disabled for this cluster.");
                }
            }
            if (!fsImage.confirmFormat(force, isInteractive)) {
                return true;
            }
            fsImage.format(fsn, clusterId, force);
        }
        catch (IOException ioe) {
            LOG.warn("Encountered exception during format", (Throwable)ioe);
            fsImage.close();
            throw ioe;
        }
        return false;
    }

    public static void checkAllowFormat(Configuration conf) throws IOException {
        if (!conf.getBoolean("dfs.namenode.support.allow.format", true)) {
            throw new IOException("The option dfs.namenode.support.allow.format is set to false for this filesystem, so it cannot be formatted. You will need to set dfs.namenode.support.allow.format parameter to true in order to format this filesystem");
        }
    }

    @VisibleForTesting
    public static boolean initializeSharedEdits(Configuration conf) throws IOException {
        return NameNode.initializeSharedEdits(conf, true);
    }

    @VisibleForTesting
    public static boolean initializeSharedEdits(Configuration conf, boolean force) throws IOException {
        return NameNode.initializeSharedEdits(conf, force, false);
    }

    private static Configuration getConfigurationWithoutSharedEdits(Configuration conf) throws IOException {
        List<URI> editsDirs = FSNamesystem.getNamespaceEditsDirs(conf, false);
        String editsDirsString = Joiner.on((String)",").join(editsDirs);
        Configuration confWithoutShared = new Configuration(conf);
        confWithoutShared.unset("dfs.namenode.shared.edits.dir");
        confWithoutShared.setStrings("dfs.namenode.edits.dir", new String[]{editsDirsString});
        return confWithoutShared;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean initializeSharedEdits(Configuration conf, boolean force, boolean interactive) throws IOException {
        String nsId = DFSUtil.getNamenodeNameServiceId(conf);
        String namenodeId = HAUtil.getNameNodeId(conf, nsId);
        NameNode.initializeGenericKeys(conf, nsId, namenodeId);
        if (conf.get("dfs.namenode.shared.edits.dir") == null) {
            LOG.error("No shared edits directory configured for namespace " + nsId + " namenode " + namenodeId);
            return false;
        }
        if (UserGroupInformation.isSecurityEnabled()) {
            InetSocketAddress socAddr = DFSUtilClient.getNNAddress((Configuration)conf);
            SecurityUtil.login((Configuration)conf, (String)"dfs.namenode.keytab.file", (String)"dfs.namenode.kerberos.principal", (String)socAddr.getHostName());
        }
        NNStorage existingStorage = null;
        FSImage sharedEditsImage = null;
        try {
            FSNamesystem fsns = FSNamesystem.loadFromDisk(NameNode.getConfigurationWithoutSharedEdits(conf));
            existingStorage = fsns.getFSImage().getStorage();
            NamespaceInfo nsInfo = existingStorage.getNamespaceInfo();
            List<URI> sharedEditsDirs = FSNamesystem.getSharedEditsDirs(conf);
            sharedEditsImage = new FSImage(conf, Lists.newArrayList(), sharedEditsDirs);
            sharedEditsImage.getEditLog().initJournalsForWrite();
            if (!sharedEditsImage.confirmFormat(force, interactive)) {
                boolean bl = true;
                return bl;
            }
            NNStorage newSharedStorage = sharedEditsImage.getStorage();
            newSharedStorage.format(nsInfo);
            sharedEditsImage.getEditLog().formatNonFileJournals(nsInfo, force);
            fsns.getFSImage().getEditLog().close();
            fsns.getFSImage().getEditLog().initJournalsForWrite();
            fsns.getFSImage().getEditLog().recoverUnclosedStreams();
            NameNode.copyEditLogSegmentsToSharedDir(fsns, sharedEditsDirs, newSharedStorage, conf);
        }
        catch (IOException ioe) {
            LOG.error("Could not initialize shared edits dir", (Throwable)ioe);
            boolean bl = true;
            return bl;
        }
        finally {
            if (sharedEditsImage != null) {
                try {
                    sharedEditsImage.close();
                }
                catch (IOException ioe) {
                    LOG.warn("Could not close sharedEditsImage", (Throwable)ioe);
                }
            }
            if (existingStorage != null) {
                try {
                    existingStorage.unlockAll();
                }
                catch (IOException ioe) {
                    LOG.warn("Could not unlock storage directories", (Throwable)ioe);
                    return true;
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void copyEditLogSegmentsToSharedDir(FSNamesystem fsns, Collection<URI> sharedEditsDirs, NNStorage newSharedStorage, Configuration conf) throws IOException {
        Preconditions.checkArgument((!sharedEditsDirs.isEmpty() ? 1 : 0) != 0, (Object)"No shared edits specified");
        ArrayList<URI> sharedEditsUris = new ArrayList<URI>(sharedEditsDirs);
        FSEditLog newSharedEditLog = new FSEditLog(conf, newSharedStorage, sharedEditsUris);
        newSharedEditLog.initJournalsForWrite();
        newSharedEditLog.recoverUnclosedStreams();
        FSEditLog sourceEditLog = fsns.getFSImage().editLog;
        long fromTxId = fsns.getFSImage().getMostRecentCheckpointTxId();
        Collection<EditLogInputStream> streams = null;
        try {
            streams = sourceEditLog.selectInputStreams(fromTxId + 1L, 0L);
            newSharedEditLog.setNextTxId(fromTxId + 1L);
            for (EditLogInputStream stream : streams) {
                FSEditLogOp op;
                LOG.debug("Beginning to copy stream {} to shared edits", (Object)stream);
                boolean segmentOpen = false;
                while ((op = stream.readOp()) != null) {
                    LOG.trace("copying op: {}", (Object)op);
                    if (!segmentOpen) {
                        newSharedEditLog.startLogSegment(op.txid, false, fsns.getEffectiveLayoutVersion());
                        segmentOpen = true;
                    }
                    newSharedEditLog.logEdit(op);
                    if (op.opCode != FSEditLogOpCodes.OP_END_LOG_SEGMENT) continue;
                    newSharedEditLog.endCurrentLogSegment(false);
                    LOG.debug("ending log segment because of END_LOG_SEGMENT op in {}", (Object)stream);
                    segmentOpen = false;
                }
                if (!segmentOpen) continue;
                LOG.debug("ending log segment because of end of stream in {}", (Object)stream);
                newSharedEditLog.logSync();
                newSharedEditLog.endCurrentLogSegment(false);
                segmentOpen = false;
            }
        }
        finally {
            if (streams != null) {
                FSEditLog.closeAllStreams(streams);
            }
        }
    }

    @VisibleForTesting
    public static boolean doRollback(Configuration conf, boolean isConfirmationNeeded) throws IOException {
        String nsId = DFSUtil.getNamenodeNameServiceId(conf);
        String namenodeId = HAUtil.getNameNodeId(conf, nsId);
        NameNode.initializeGenericKeys(conf, nsId, namenodeId);
        FSNamesystem nsys = new FSNamesystem(conf, new FSImage(conf));
        System.err.print("\"rollBack\" will remove the current state of the file system,\nreturning you to the state prior to initiating your recent.\nupgrade. This action is permanent and cannot be undone. If you\nare performing a rollback in an HA environment, you should be\ncertain that no NameNode process is running on any host.");
        if (isConfirmationNeeded && !ToolRunner.confirmPrompt((String)"Roll back file system state?")) {
            System.err.println("Rollback aborted.");
            return true;
        }
        nsys.getFSImage().doRollback(nsys);
        return false;
    }

    private static void printUsage(PrintStream out) {
        out.println(USAGE + "\n");
    }

    @VisibleForTesting
    static HdfsServerConstants.StartupOption parseArguments(String[] args) {
        int argsLen = args == null ? 0 : args.length;
        HdfsServerConstants.StartupOption startOpt = HdfsServerConstants.StartupOption.REGULAR;
        for (int i = 0; i < argsLen; ++i) {
            String cmd = args[i];
            if (HdfsServerConstants.StartupOption.FORMAT.getName().equalsIgnoreCase(cmd)) {
                startOpt = HdfsServerConstants.StartupOption.FORMAT;
                ++i;
                while (i < argsLen) {
                    if (args[i].equalsIgnoreCase(HdfsServerConstants.StartupOption.CLUSTERID.getName())) {
                        if (++i >= argsLen) {
                            LOG.error("Must specify a valid cluster ID after the " + HdfsServerConstants.StartupOption.CLUSTERID.getName() + " flag");
                            return null;
                        }
                        String clusterId = args[i];
                        if (clusterId.isEmpty() || clusterId.equalsIgnoreCase(HdfsServerConstants.StartupOption.FORCE.getName()) || clusterId.equalsIgnoreCase(HdfsServerConstants.StartupOption.NONINTERACTIVE.getName())) {
                            LOG.error("Must specify a valid cluster ID after the " + HdfsServerConstants.StartupOption.CLUSTERID.getName() + " flag");
                            return null;
                        }
                        startOpt.setClusterId(clusterId);
                    }
                    if (args[i].equalsIgnoreCase(HdfsServerConstants.StartupOption.FORCE.getName())) {
                        startOpt.setForceFormat(true);
                    }
                    if (args[i].equalsIgnoreCase(HdfsServerConstants.StartupOption.NONINTERACTIVE.getName())) {
                        startOpt.setInteractiveFormat(false);
                    }
                    ++i;
                }
                continue;
            }
            if (HdfsServerConstants.StartupOption.GENCLUSTERID.getName().equalsIgnoreCase(cmd)) {
                startOpt = HdfsServerConstants.StartupOption.GENCLUSTERID;
                continue;
            }
            if (HdfsServerConstants.StartupOption.REGULAR.getName().equalsIgnoreCase(cmd)) {
                startOpt = HdfsServerConstants.StartupOption.REGULAR;
                continue;
            }
            if (HdfsServerConstants.StartupOption.BACKUP.getName().equalsIgnoreCase(cmd)) {
                startOpt = HdfsServerConstants.StartupOption.BACKUP;
                continue;
            }
            if (HdfsServerConstants.StartupOption.CHECKPOINT.getName().equalsIgnoreCase(cmd)) {
                startOpt = HdfsServerConstants.StartupOption.CHECKPOINT;
                continue;
            }
            if (HdfsServerConstants.StartupOption.OBSERVER.getName().equalsIgnoreCase(cmd)) {
                startOpt = HdfsServerConstants.StartupOption.OBSERVER;
                continue;
            }
            if (HdfsServerConstants.StartupOption.UPGRADE.getName().equalsIgnoreCase(cmd) || HdfsServerConstants.StartupOption.UPGRADEONLY.getName().equalsIgnoreCase(cmd)) {
                HdfsServerConstants.StartupOption startupOption = startOpt = HdfsServerConstants.StartupOption.UPGRADE.getName().equalsIgnoreCase(cmd) ? HdfsServerConstants.StartupOption.UPGRADE : HdfsServerConstants.StartupOption.UPGRADEONLY;
                while (i + 1 < argsLen) {
                    String flag = args[i + 1];
                    if (flag.equalsIgnoreCase(HdfsServerConstants.StartupOption.CLUSTERID.getName())) {
                        if (i + 2 < argsLen) {
                            startOpt.setClusterId(args[i += 2]);
                            continue;
                        }
                        LOG.error("Must specify a valid cluster ID after the " + HdfsServerConstants.StartupOption.CLUSTERID.getName() + " flag");
                        return null;
                    }
                    if (flag.equalsIgnoreCase(HdfsServerConstants.StartupOption.RENAMERESERVED.getName())) {
                        if (i + 2 < argsLen) {
                            FSImageFormat.setRenameReservedPairs(args[i + 2]);
                            i += 2;
                            continue;
                        }
                        FSImageFormat.useDefaultRenameReservedPairs();
                        ++i;
                        continue;
                    }
                    LOG.error("Unknown upgrade flag: {}", (Object)flag);
                    return null;
                }
                continue;
            }
            if (HdfsServerConstants.StartupOption.ROLLINGUPGRADE.getName().equalsIgnoreCase(cmd)) {
                startOpt = HdfsServerConstants.StartupOption.ROLLINGUPGRADE;
                if (++i >= argsLen) {
                    LOG.error("Must specify a rolling upgrade startup option " + HdfsServerConstants.RollingUpgradeStartupOption.getAllOptionString());
                    return null;
                }
                startOpt.setRollingUpgradeStartupOption(args[i]);
                continue;
            }
            if (HdfsServerConstants.StartupOption.ROLLBACK.getName().equalsIgnoreCase(cmd)) {
                startOpt = HdfsServerConstants.StartupOption.ROLLBACK;
                continue;
            }
            if (HdfsServerConstants.StartupOption.IMPORT.getName().equalsIgnoreCase(cmd)) {
                startOpt = HdfsServerConstants.StartupOption.IMPORT;
                continue;
            }
            if (HdfsServerConstants.StartupOption.BOOTSTRAPSTANDBY.getName().equalsIgnoreCase(cmd)) {
                startOpt = HdfsServerConstants.StartupOption.BOOTSTRAPSTANDBY;
                return startOpt;
            }
            if (HdfsServerConstants.StartupOption.INITIALIZESHAREDEDITS.getName().equalsIgnoreCase(cmd)) {
                startOpt = HdfsServerConstants.StartupOption.INITIALIZESHAREDEDITS;
                ++i;
                while (i < argsLen) {
                    if (HdfsServerConstants.StartupOption.NONINTERACTIVE.getName().equals(args[i])) {
                        startOpt.setInteractiveFormat(false);
                    } else if (HdfsServerConstants.StartupOption.FORCE.getName().equals(args[i])) {
                        startOpt.setForceFormat(true);
                    } else {
                        LOG.error("Invalid argument: " + args[i]);
                        return null;
                    }
                    ++i;
                }
                return startOpt;
            }
            if (HdfsServerConstants.StartupOption.RECOVER.getName().equalsIgnoreCase(cmd)) {
                if (startOpt != HdfsServerConstants.StartupOption.REGULAR) {
                    throw new RuntimeException("Can't combine -recover with other startup options.");
                }
                startOpt = HdfsServerConstants.StartupOption.RECOVER;
                while (++i < argsLen) {
                    if (args[i].equalsIgnoreCase(HdfsServerConstants.StartupOption.FORCE.getName())) {
                        startOpt.setForce(1);
                        continue;
                    }
                    throw new RuntimeException("Error parsing recovery options: can't understand option \"" + args[i] + "\"");
                }
                continue;
            }
            if (HdfsServerConstants.StartupOption.METADATAVERSION.getName().equalsIgnoreCase(cmd)) {
                startOpt = HdfsServerConstants.StartupOption.METADATAVERSION;
                continue;
            }
            return null;
        }
        return startOpt;
    }

    private static void setStartupOption(Configuration conf, HdfsServerConstants.StartupOption opt) {
        conf.set("dfs.namenode.startup", opt.name());
    }

    public static HdfsServerConstants.StartupOption getStartupOption(Configuration conf) {
        return HdfsServerConstants.StartupOption.valueOf(conf.get("dfs.namenode.startup", HdfsServerConstants.StartupOption.REGULAR.toString()));
    }

    private static void doRecovery(HdfsServerConstants.StartupOption startOpt, Configuration conf) throws IOException {
        String nsId = DFSUtil.getNamenodeNameServiceId(conf);
        String namenodeId = HAUtil.getNameNodeId(conf, nsId);
        NameNode.initializeGenericKeys(conf, nsId, namenodeId);
        if (startOpt.getForce() < 2 && !ToolRunner.confirmPrompt((String)"You have selected Metadata Recovery mode.  This mode is intended to recover lost metadata on a corrupt filesystem.  Metadata recovery mode often permanently deletes data from your HDFS filesystem.  Please back up your edit log and fsimage before trying this!\n\nAre you ready to proceed? (Y/N)\n")) {
            System.err.println("Recovery aborted at user request.\n");
            return;
        }
        MetaRecoveryContext.LOG.info("starting recovery...");
        UserGroupInformation.setConfiguration((Configuration)conf);
        NameNode.initMetrics(conf, startOpt.toNodeRole());
        try (FSNamesystem fsn = null;){
            fsn = FSNamesystem.loadFromDisk(conf);
            fsn.getFSImage().saveNamespace(fsn);
            MetaRecoveryContext.LOG.info("RECOVERY COMPLETE");
        }
    }

    private static boolean printMetadataVersion(Configuration conf) throws IOException {
        String nsId = DFSUtil.getNamenodeNameServiceId(conf);
        String namenodeId = HAUtil.getNameNodeId(conf, nsId);
        NameNode.initializeGenericKeys(conf, nsId, namenodeId);
        FSImage fsImage = new FSImage(conf);
        FSNamesystem fs = new FSNamesystem(conf, fsImage, false);
        return fsImage.recoverTransitionRead(HdfsServerConstants.StartupOption.METADATAVERSION, fs, null);
    }

    public static NameNode createNameNode(String[] argv, Configuration conf) throws IOException {
        GenericOptionsParser hParser;
        HdfsServerConstants.StartupOption startOpt;
        LOG.info("createNameNode " + Arrays.asList(argv));
        if (conf == null) {
            conf = new HdfsConfiguration();
        }
        if ((startOpt = NameNode.parseArguments(argv = (hParser = new GenericOptionsParser(conf, argv)).getRemainingArgs())) == null) {
            NameNode.printUsage(System.err);
            return null;
        }
        NameNode.setStartupOption(conf, startOpt);
        boolean aborted = false;
        switch (startOpt) {
            case FORMAT: {
                aborted = NameNode.format(conf, startOpt.getForceFormat(), startOpt.getInteractiveFormat());
                ExitUtil.terminate((int)(aborted ? 1 : 0));
                return null;
            }
            case GENCLUSTERID: {
                String clusterID = NNStorage.newClusterID();
                LOG.info("Generated new cluster id: {}", (Object)clusterID);
                ExitUtil.terminate((int)0);
                return null;
            }
            case ROLLBACK: {
                aborted = NameNode.doRollback(conf, true);
                ExitUtil.terminate((int)(aborted ? 1 : 0));
                return null;
            }
            case BOOTSTRAPSTANDBY: {
                String[] toolArgs = Arrays.copyOfRange(argv, 1, argv.length);
                int rc = BootstrapStandby.run(toolArgs, conf);
                ExitUtil.terminate((int)rc);
                return null;
            }
            case INITIALIZESHAREDEDITS: {
                aborted = NameNode.initializeSharedEdits(conf, startOpt.getForceFormat(), startOpt.getInteractiveFormat());
                ExitUtil.terminate((int)(aborted ? 1 : 0));
                return null;
            }
            case BACKUP: 
            case CHECKPOINT: {
                HdfsServerConstants.NamenodeRole role = startOpt.toNodeRole();
                DefaultMetricsSystem.initialize((String)role.toString().replace(" ", ""));
                return new BackupNode(conf, role);
            }
            case RECOVER: {
                NameNode.doRecovery(startOpt, conf);
                return null;
            }
            case METADATAVERSION: {
                NameNode.printMetadataVersion(conf);
                ExitUtil.terminate((int)0);
                return null;
            }
            case UPGRADEONLY: {
                DefaultMetricsSystem.initialize((String)"NameNode");
                new NameNode(conf);
                ExitUtil.terminate((int)0);
                return null;
            }
        }
        DefaultMetricsSystem.initialize((String)"NameNode");
        return new NameNode(conf);
    }

    public static void initializeGenericKeys(Configuration conf, String nameserviceId, String namenodeId) {
        if (nameserviceId != null && !nameserviceId.isEmpty() || namenodeId != null && !namenodeId.isEmpty()) {
            if (nameserviceId != null) {
                conf.set("dfs.nameservice.id", nameserviceId);
            }
            if (namenodeId != null) {
                conf.set("dfs.ha.namenode.id", namenodeId);
            }
            DFSUtil.setGenericConf(conf, nameserviceId, namenodeId, NAMENODE_SPECIFIC_KEYS);
            DFSUtil.setGenericConf(conf, nameserviceId, null, NAMESERVICE_SPECIFIC_KEYS);
        }
        if (conf.get("dfs.namenode.rpc-address") != null) {
            URI defaultUri = URI.create("hdfs://" + conf.get("dfs.namenode.rpc-address"));
            conf.set("fs.defaultFS", defaultUri.toString());
            LOG.debug("Setting {} to {}", (Object)"fs.defaultFS", (Object)defaultUri);
        }
    }

    protected String getNameServiceId(Configuration conf) {
        return DFSUtil.getNamenodeNameServiceId(conf);
    }

    public static void main(String[] argv) throws Exception {
        if (DFSUtil.parseHelpArgument(argv, USAGE, System.out, true)) {
            System.exit(0);
        }
        try {
            StringUtils.startupShutdownMessage(NameNode.class, (String[])argv, (Logger)LOG);
            NameNode namenode = NameNode.createNameNode(argv, null);
            if (namenode != null) {
                namenode.join();
            }
        }
        catch (Throwable e) {
            LOG.error("Failed to start namenode.", e);
            ExitUtil.terminate((int)1, (Throwable)e);
        }
    }

    synchronized void monitorHealth() throws HealthCheckFailedException, AccessControlException {
        this.namesystem.checkSuperuserPrivilege();
        if (!this.haEnabled) {
            return;
        }
        long start = Time.monotonicNow();
        this.getNamesystem().checkAvailableResources();
        long end = Time.monotonicNow();
        if (end - start >= 5000L) {
            LOG.warn("Remote IP {} checking available resources took {}ms", (Object)Server.getRemoteIp(), (Object)(end - start));
        }
        if (!this.getNamesystem().nameNodeHasResourcesAvailable()) {
            throw new HealthCheckFailedException("The NameNode has no resources available");
        }
        if (this.notBecomeActiveInSafemode && this.isInSafeMode()) {
            throw new HealthCheckFailedException("The NameNode is configured to report UNHEALTHY to ZKFC in Safemode.");
        }
    }

    synchronized void transitionToActive() throws ServiceFailedException, AccessControlException {
        this.namesystem.checkSuperuserPrivilege();
        if (!this.haEnabled) {
            throw new ServiceFailedException("HA for namenode is not enabled");
        }
        if (this.state == OBSERVER_STATE) {
            throw new ServiceFailedException("Cannot transition from '" + OBSERVER_STATE + "' to '" + ACTIVE_STATE + "'");
        }
        if (this.notBecomeActiveInSafemode && this.isInSafeMode()) {
            throw new ServiceFailedException((Object)((Object)this.getRole()) + " still not leave safemode");
        }
        this.state.setState(this.haContext, ACTIVE_STATE);
    }

    synchronized void transitionToStandby() throws ServiceFailedException, AccessControlException {
        this.namesystem.checkSuperuserPrivilege();
        if (!this.haEnabled) {
            throw new ServiceFailedException("HA for namenode is not enabled");
        }
        this.state.setState(this.haContext, STANDBY_STATE);
    }

    synchronized void transitionToObserver() throws ServiceFailedException, AccessControlException {
        this.namesystem.checkSuperuserPrivilege();
        if (!this.haEnabled) {
            throw new ServiceFailedException("HA for namenode is not enabled");
        }
        if (this.state == ACTIVE_STATE) {
            throw new ServiceFailedException("Cannot transition from '" + ACTIVE_STATE + "' to '" + OBSERVER_STATE + "'");
        }
        this.state.setState(this.haContext, OBSERVER_STATE);
    }

    synchronized HAServiceStatus getServiceStatus() throws ServiceFailedException, AccessControlException {
        if (!this.haEnabled) {
            throw new ServiceFailedException("HA for namenode is not enabled");
        }
        if (this.state == null) {
            return new HAServiceStatus(HAServiceProtocol.HAServiceState.INITIALIZING);
        }
        HAServiceProtocol.HAServiceState retState = this.state.getServiceState();
        HAServiceStatus ret = new HAServiceStatus(retState);
        if (retState == HAServiceProtocol.HAServiceState.STANDBY) {
            if (this.namesystem.isInSafeMode()) {
                ret.setNotReadyToBecomeActive("The NameNode is in safemode. " + this.namesystem.getSafeModeTip());
            } else {
                ret.setReadyToBecomeActive();
            }
        } else if (retState == HAServiceProtocol.HAServiceState.ACTIVE) {
            ret.setReadyToBecomeActive();
        } else {
            ret.setNotReadyToBecomeActive("State is " + this.state);
        }
        return ret;
    }

    synchronized HAServiceProtocol.HAServiceState getServiceState() {
        if (this.state == null) {
            return HAServiceProtocol.HAServiceState.INITIALIZING;
        }
        return this.state.getServiceState();
    }

    private void registerNNSMXBean() {
        this.nameNodeStatusBeanName = MBeans.register((String)"NameNode", (String)"NameNodeStatus", (Object)this);
    }

    @Override
    public String getNNRole() {
        HdfsServerConstants.NamenodeRole role = this.getRole();
        return Objects.toString((Object)role, "");
    }

    @Override
    public String getState() {
        HAServiceProtocol.HAServiceState servState = this.getServiceState();
        return Objects.toString(servState, "");
    }

    @Override
    public String getHostAndPort() {
        return this.getNameNodeAddressHostPortString();
    }

    @Override
    public boolean isSecurityEnabled() {
        return UserGroupInformation.isSecurityEnabled();
    }

    @Override
    public long getLastHATransitionTime() {
        return this.state.getLastHATransitionTime();
    }

    @Override
    public long getBytesWithFutureGenerationStamps() {
        return this.getNamesystem().getBytesInFuture();
    }

    @Override
    public String getSlowPeersReport() {
        return this.namesystem.getBlockManager().getDatanodeManager().getSlowPeersReport();
    }

    @Override
    public String getSlowDisksReport() {
        return this.namesystem.getBlockManager().getDatanodeManager().getSlowDisksReport();
    }

    protected synchronized void doImmediateShutdown(Throwable t) throws ExitUtil.ExitException {
        try {
            LOG.error("Error encountered requiring NN shutdown. Shutting down immediately.", t);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        ExitUtil.terminate((int)1, (Throwable)t);
    }

    public boolean isStandbyState() {
        return this.state.equals(STANDBY_STATE);
    }

    public boolean isActiveState() {
        return this.state.equals(ACTIVE_STATE);
    }

    public boolean isObserverState() {
        return this.state.equals(OBSERVER_STATE);
    }

    boolean isStarted() {
        return this.started.get();
    }

    void checkHaStateChange(HAServiceProtocol.StateChangeRequestInfo req) throws AccessControlException {
        boolean autoHaEnabled = this.getConf().getBoolean("dfs.ha.automatic-failover.enabled", false);
        switch (req.getSource()) {
            case REQUEST_BY_USER: {
                if (!autoHaEnabled) break;
                throw new AccessControlException("Manual HA control for this NameNode is disallowed, because automatic HA is enabled.");
            }
            case REQUEST_BY_USER_FORCED: {
                if (!autoHaEnabled) break;
                LOG.warn("Allowing manual HA control from " + Server.getRemoteAddress() + " even though automatic HA is enabled, because the user specified the force flag");
                break;
            }
            case REQUEST_BY_ZKFC: {
                if (autoHaEnabled) break;
                throw new AccessControlException("Request from ZK failover controller at " + Server.getRemoteAddress() + " denied since automatic HA is not enabled");
            }
        }
    }

    public Collection<String> getReconfigurableProperties() {
        return this.reconfigurableProperties;
    }

    protected String reconfigurePropertyImpl(String property, String newVal) throws ReconfigurationException {
        DatanodeManager datanodeManager = this.namesystem.getBlockManager().getDatanodeManager();
        if (property.equals("dfs.heartbeat.interval")) {
            return this.reconfHeartbeatInterval(datanodeManager, property, newVal);
        }
        if (property.equals("dfs.namenode.heartbeat.recheck-interval")) {
            return this.reconfHeartbeatRecheckInterval(datanodeManager, property, newVal);
        }
        if (property.equals("fs.protected.directories")) {
            return this.reconfProtectedDirectories(newVal);
        }
        if (property.equals("hadoop.caller.context.enabled")) {
            return this.reconfCallerContextEnabled(newVal);
        }
        if (property.equals(this.ipcClientRPCBackoffEnable)) {
            return this.reconfigureIPCBackoffEnabled(newVal);
        }
        if (property.equals("dfs.storage.policy.satisfier.mode")) {
            return this.reconfigureSPSModeEvent(newVal, property);
        }
        if (property.equals("dfs.namenode.replication.max-streams") || property.equals("dfs.namenode.replication.max-streams-hard-limit") || property.equals("dfs.namenode.replication.work.multiplier.per.iteration")) {
            return this.reconfReplicationParameters(newVal, property);
        }
        if (property.equals("dfs.block.replicator.classname") || property.equals("dfs.block.placement.ec.classname")) {
            this.reconfBlockPlacementPolicy();
            return newVal;
        }
        throw new ReconfigurationException(property, newVal, this.getConf().get(property));
    }

    private String reconfReplicationParameters(String newVal, String property) throws ReconfigurationException {
        BlockManager bm = this.namesystem.getBlockManager();
        this.namesystem.writeLock();
        try {
            int newSetting;
            if (property.equals("dfs.namenode.replication.max-streams")) {
                bm.setMaxReplicationStreams(this.adjustNewVal(2, newVal));
                newSetting = bm.getMaxReplicationStreams();
            } else if (property.equals("dfs.namenode.replication.max-streams-hard-limit")) {
                bm.setReplicationStreamsHardLimit(this.adjustNewVal(4, newVal));
                newSetting = bm.getReplicationStreamsHardLimit();
            } else if (property.equals("dfs.namenode.replication.work.multiplier.per.iteration")) {
                bm.setBlocksReplWorkMultiplier(this.adjustNewVal(2, newVal));
                newSetting = bm.getBlocksReplWorkMultiplier();
            } else {
                throw new IllegalArgumentException("Unexpected property " + property + "in reconfReplicationParameters");
            }
            LOG.info("RECONFIGURE* changed {} to {}", (Object)property, (Object)newSetting);
            String string = String.valueOf(newSetting);
            return string;
        }
        catch (IllegalArgumentException e) {
            throw new ReconfigurationException(property, newVal, this.getConf().get(property), (Throwable)e);
        }
        finally {
            this.namesystem.writeUnlock();
        }
    }

    private void reconfBlockPlacementPolicy() {
        this.getNamesystem().getBlockManager().refreshBlockPlacementPolicy(this.getNewConf());
    }

    private int adjustNewVal(int defaultVal, String newVal) {
        if (newVal == null) {
            return defaultVal;
        }
        return Integer.parseInt(newVal);
    }

    private String reconfHeartbeatInterval(DatanodeManager datanodeManager, String property, String newVal) throws ReconfigurationException {
        this.namesystem.writeLock();
        try {
            if (newVal == null) {
                datanodeManager.setHeartbeatInterval(3L);
                String string = String.valueOf(3L);
                return string;
            }
            long newInterval = this.getConf().getTimeDurationHelper("dfs.heartbeat.interval", newVal, TimeUnit.SECONDS);
            datanodeManager.setHeartbeatInterval(newInterval);
            String string = String.valueOf(datanodeManager.getHeartbeatInterval());
            return string;
        }
        catch (NumberFormatException nfe) {
            throw new ReconfigurationException(property, newVal, this.getConf().get(property), (Throwable)nfe);
        }
        finally {
            this.namesystem.writeUnlock();
            LOG.info("RECONFIGURE* changed heartbeatInterval to " + datanodeManager.getHeartbeatInterval());
        }
    }

    private String reconfHeartbeatRecheckInterval(DatanodeManager datanodeManager, String property, String newVal) throws ReconfigurationException {
        this.namesystem.writeLock();
        try {
            if (newVal == null) {
                datanodeManager.setHeartbeatRecheckInterval(300000);
                String string = String.valueOf(300000);
                return string;
            }
            datanodeManager.setHeartbeatRecheckInterval(Integer.parseInt(newVal));
            String string = String.valueOf(datanodeManager.getHeartbeatRecheckInterval());
            return string;
        }
        catch (NumberFormatException nfe) {
            throw new ReconfigurationException(property, newVal, this.getConf().get(property), (Throwable)nfe);
        }
        finally {
            this.namesystem.writeUnlock();
            LOG.info("RECONFIGURE* changed heartbeatRecheckInterval to " + datanodeManager.getHeartbeatRecheckInterval());
        }
    }

    private String reconfProtectedDirectories(String newVal) {
        return this.getNamesystem().getFSDirectory().setProtectedDirectories(newVal);
    }

    private String reconfCallerContextEnabled(String newVal) {
        Boolean callerContextEnabled = newVal == null ? Boolean.valueOf(false) : Boolean.valueOf(Boolean.parseBoolean(newVal));
        this.namesystem.setCallerContextEnabled(callerContextEnabled);
        return Boolean.toString(callerContextEnabled);
    }

    String reconfigureIPCBackoffEnabled(String newVal) {
        boolean clientBackoffEnabled = newVal == null ? false : Boolean.parseBoolean(newVal);
        this.rpcServer.getClientRpcServer().setClientBackoffEnabled(clientBackoffEnabled);
        return Boolean.toString(clientBackoffEnabled);
    }

    String reconfigureSPSModeEvent(String newVal, String property) throws ReconfigurationException {
        if (newVal == null || HdfsConstants.StoragePolicySatisfierMode.fromString((String)newVal) == null) {
            throw new ReconfigurationException(property, newVal, this.getConf().get(property), (Throwable)new HadoopIllegalArgumentException("For enabling or disabling storage policy satisfier, must pass either internal/external/none string value only"));
        }
        if (!this.isActiveState()) {
            throw new ReconfigurationException(property, newVal, this.getConf().get(property), (Throwable)new HadoopIllegalArgumentException("Enabling or disabling storage policy satisfier service on " + this.state + " NameNode is not allowed"));
        }
        HdfsConstants.StoragePolicySatisfierMode mode = HdfsConstants.StoragePolicySatisfierMode.fromString((String)newVal);
        if (mode == HdfsConstants.StoragePolicySatisfierMode.NONE) {
            if (this.namesystem.getBlockManager().getSPSManager() != null) {
                this.namesystem.getBlockManager().getSPSManager().changeModeEvent(mode);
                this.namesystem.getBlockManager().disableSPS();
            }
        } else {
            boolean spsCreated;
            boolean bl = spsCreated = this.namesystem.getBlockManager().getSPSManager() != null;
            if (!spsCreated) {
                spsCreated = this.namesystem.getBlockManager().createSPSManager(this.getConf(), newVal);
            }
            if (spsCreated) {
                this.namesystem.getBlockManager().getSPSManager().changeModeEvent(mode);
            }
        }
        return newVal;
    }

    protected Configuration getNewConf() {
        return new HdfsConfiguration();
    }

    static {
        HdfsConfiguration.init();
        NAMENODE_SPECIFIC_KEYS = new String[]{"dfs.namenode.rpc-address", "dfs.namenode.rpc-bind-host", "dfs.namenode.name.dir", "dfs.namenode.edits.dir", "dfs.namenode.shared.edits.dir", "dfs.namenode.checkpoint.dir", "dfs.namenode.checkpoint.edits.dir", "dfs.namenode.lifeline.rpc-address", "dfs.namenode.lifeline.rpc-bind-host", "dfs.namenode.servicerpc-address", "dfs.namenode.servicerpc-bind-host", "dfs.namenode.http-address", "dfs.namenode.https-address", "dfs.namenode.http-bind-host", "dfs.namenode.https-bind-host", "dfs.namenode.keytab.file", "dfs.namenode.secondary.http-address", "dfs.namenode.secondary.https-address", "dfs.secondary.namenode.keytab.file", "dfs.namenode.backup.address", "dfs.namenode.backup.http-address", "dfs.namenode.backup.dnrpc-address", "dfs.namenode.kerberos.principal", "dfs.namenode.kerberos.internal.spnego.principal", "dfs.ha.fencing.methods", "dfs.ha.zkfc.port"};
        NAMESERVICE_SPECIFIC_KEYS = new String[]{"dfs.ha.automatic-failover.enabled"};
        USAGE = "Usage: hdfs namenode [" + HdfsServerConstants.StartupOption.BACKUP.getName() + "] | \n\t[" + HdfsServerConstants.StartupOption.CHECKPOINT.getName() + "] | \n\t[" + HdfsServerConstants.StartupOption.FORMAT.getName() + " [" + HdfsServerConstants.StartupOption.CLUSTERID.getName() + " cid ] [" + HdfsServerConstants.StartupOption.FORCE.getName() + "] [" + HdfsServerConstants.StartupOption.NONINTERACTIVE.getName() + "] ] | \n\t[" + HdfsServerConstants.StartupOption.UPGRADE.getName() + " [" + HdfsServerConstants.StartupOption.CLUSTERID.getName() + " cid] [" + HdfsServerConstants.StartupOption.RENAMERESERVED.getName() + "<k-v pairs>] ] | \n\t[" + HdfsServerConstants.StartupOption.UPGRADEONLY.getName() + " [" + HdfsServerConstants.StartupOption.CLUSTERID.getName() + " cid] [" + HdfsServerConstants.StartupOption.RENAMERESERVED.getName() + "<k-v pairs>] ] | \n\t[" + HdfsServerConstants.StartupOption.ROLLBACK.getName() + "] | \n\t[" + HdfsServerConstants.StartupOption.ROLLINGUPGRADE.getName() + " " + HdfsServerConstants.RollingUpgradeStartupOption.getAllOptionString() + " ] | \n\t[" + HdfsServerConstants.StartupOption.IMPORT.getName() + "] | \n\t[" + HdfsServerConstants.StartupOption.INITIALIZESHAREDEDITS.getName() + "] | \n\t[" + HdfsServerConstants.StartupOption.BOOTSTRAPSTANDBY.getName() + " [" + HdfsServerConstants.StartupOption.FORCE.getName() + "] [" + HdfsServerConstants.StartupOption.NONINTERACTIVE.getName() + "] [" + HdfsServerConstants.StartupOption.SKIPSHAREDEDITSCHECK.getName() + "] ] | \n\t[" + HdfsServerConstants.StartupOption.RECOVER.getName() + " [ " + HdfsServerConstants.StartupOption.FORCE.getName() + "] ] | \n\t[" + HdfsServerConstants.StartupOption.METADATAVERSION.getName() + " ]";
        LOG = LoggerFactory.getLogger((String)NameNode.class.getName());
        stateChangeLog = LoggerFactory.getLogger((String)"org.apache.hadoop.hdfs.StateChange");
        blockStateChangeLog = LoggerFactory.getLogger((String)"BlockStateChange");
        ACTIVE_STATE = new ActiveState();
        STANDBY_STATE = new StandbyState();
        OBSERVER_STATE = new StandbyState(true);
        MetricsLog = LogFactory.getLog((String)"NameNodeMetricsLog");
        startupProgress = new StartupProgress();
    }

    protected class NameNodeHAContext
    implements HAContext {
        protected NameNodeHAContext() {
        }

        @Override
        public void setState(HAState s) {
            NameNode.this.state = s;
        }

        @Override
        public HAState getState() {
            return NameNode.this.state;
        }

        @Override
        public void startActiveServices() throws IOException {
            try {
                NameNode.this.namesystem.startActiveServices();
                NameNode.this.startTrashEmptier(NameNode.this.getConf());
            }
            catch (Throwable t) {
                NameNode.this.doImmediateShutdown(t);
            }
        }

        @Override
        public void stopActiveServices() throws IOException {
            try {
                if (NameNode.this.namesystem != null) {
                    NameNode.this.namesystem.stopActiveServices();
                }
                NameNode.this.stopTrashEmptier();
            }
            catch (Throwable t) {
                NameNode.this.doImmediateShutdown(t);
            }
        }

        @Override
        public void startStandbyServices() throws IOException {
            try {
                NameNode.this.namesystem.startStandbyServices(NameNode.this.getConf(), NameNode.this.state == OBSERVER_STATE);
            }
            catch (Throwable t) {
                NameNode.this.doImmediateShutdown(t);
            }
        }

        @Override
        public void prepareToStopStandbyServices() throws ServiceFailedException {
            try {
                NameNode.this.namesystem.prepareToStopStandbyServices();
            }
            catch (Throwable t) {
                NameNode.this.doImmediateShutdown(t);
            }
        }

        @Override
        public void stopStandbyServices() throws IOException {
            try {
                if (NameNode.this.namesystem != null) {
                    NameNode.this.namesystem.stopStandbyServices();
                }
            }
            catch (Throwable t) {
                NameNode.this.doImmediateShutdown(t);
            }
        }

        @Override
        public void writeLock() {
            NameNode.this.namesystem.writeLock();
            NameNode.this.namesystem.lockRetryCache();
        }

        @Override
        public void writeUnlock() {
            NameNode.this.namesystem.unlockRetryCache();
            NameNode.this.namesystem.writeUnlock();
        }

        @Override
        public void checkOperation(OperationCategory op) throws StandbyException {
            NameNode.this.state.checkOperation(NameNode.this.haContext, op);
        }

        @Override
        public boolean allowStaleReads() {
            if (NameNode.this.state == OBSERVER_STATE) {
                return true;
            }
            return NameNode.this.allowStaleStandbyReads;
        }
    }

    public static enum OperationCategory {
        UNCHECKED,
        READ,
        WRITE,
        CHECKPOINT,
        JOURNAL;

    }
}

