/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.mover;

import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.URI;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.StorageType;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.MiniDFSNNTopology;
import org.apache.hadoop.hdfs.NameNodeProxies;
import org.apache.hadoop.hdfs.StripedFileTestUtil;
import org.apache.hadoop.hdfs.client.HdfsDataOutputStream;
import org.apache.hadoop.hdfs.protocol.ClientProtocol;
import org.apache.hadoop.hdfs.protocol.DatanodeInfoWithStorage;
import org.apache.hadoop.hdfs.protocol.ErasureCodingPolicy;
import org.apache.hadoop.hdfs.protocol.HdfsConstants;
import org.apache.hadoop.hdfs.protocol.LocatedBlock;
import org.apache.hadoop.hdfs.protocol.LocatedBlocks;
import org.apache.hadoop.hdfs.server.balancer.Dispatcher;
import org.apache.hadoop.hdfs.server.balancer.ExitStatus;
import org.apache.hadoop.hdfs.server.balancer.NameNodeConnector;
import org.apache.hadoop.hdfs.server.balancer.TestBalancer;
import org.apache.hadoop.hdfs.server.common.HdfsServerConstants;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.datanode.InternalDataNodeTestUtils;
import org.apache.hadoop.hdfs.server.mover.Mover;
import org.apache.hadoop.hdfs.server.namenode.ha.HATestUtil;
import org.apache.hadoop.http.HttpConfig;
import org.apache.hadoop.minikdc.MiniKdc;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authentication.util.KerberosName;
import org.apache.hadoop.security.ssl.KeyStoreTestUtil;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.thirdparty.com.google.common.collect.Maps;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestMover {
    private static final Logger LOG = LoggerFactory.getLogger(TestMover.class);
    private static final int DEFAULT_BLOCK_SIZE = 100;
    private File keytabFile;
    private String principal;
    private final ErasureCodingPolicy ecPolicy = StripedFileTestUtil.getDefaultECPolicy();
    private final int dataBlocks = this.ecPolicy.getNumDataUnits();
    private final int parityBlocks = this.ecPolicy.getNumParityUnits();
    private final int cellSize = this.ecPolicy.getCellSize();
    private final int stripesPerBlock = 4;
    private final int defaultBlockSize = this.cellSize * 4;

    static void initConf(Configuration conf) {
        conf.setLong("dfs.blocksize", 100L);
        conf.setInt("dfs.bytes-per-checksum", 100);
        conf.setLong("dfs.heartbeat.interval", 1L);
        conf.setLong("dfs.namenode.redundancy.interval.seconds", 1L);
        conf.setLong("dfs.balancer.movedWinWidth", 2000L);
        conf.set("dfs.storage.policy.satisfier.mode", HdfsConstants.StoragePolicySatisfierMode.NONE.toString());
    }

    static Mover newMover(Configuration conf) throws IOException {
        Collection namenodes = DFSUtil.getInternalNsRpcUris((Configuration)conf);
        Assert.assertEquals((long)1L, (long)namenodes.size());
        HashMap nnMap = Maps.newHashMap();
        for (URI nn : namenodes) {
            nnMap.put(nn, null);
        }
        List nncs = NameNodeConnector.newNameNodeConnectors((Map)nnMap, (String)Mover.class.getSimpleName(), (Path)HdfsServerConstants.MOVER_ID_PATH, (Configuration)conf, (int)5);
        return new Mover((NameNodeConnector)nncs.get(0), conf, new AtomicInteger(0), new HashMap());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testScheduleSameBlock() throws IOException {
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.set("dfs.storage.policy.satisfier.mode", HdfsConstants.StoragePolicySatisfierMode.NONE.toString());
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(4).build();
        try {
            cluster.waitActive();
            DistributedFileSystem dfs = cluster.getFileSystem();
            String file = "/testScheduleSameBlock/file";
            FSDataOutputStream out = dfs.create(new Path("/testScheduleSameBlock/file"));
            out.writeChars("testScheduleSameBlock");
            out.close();
            Mover mover = TestMover.newMover((Configuration)conf);
            mover.init();
            Mover.Processor processor = new Mover.Processor(mover);
            LocatedBlock lb = dfs.getClient().getLocatedBlocks("/testScheduleSameBlock/file", 0L).get(0);
            List locations = Mover.MLocation.toLocations((LocatedBlock)lb);
            Mover.MLocation ml = (Mover.MLocation)locations.get(0);
            Dispatcher.DBlock db = mover.newDBlock(lb, locations, null);
            ArrayList<StorageType> storageTypes = new ArrayList<StorageType>(Arrays.asList(StorageType.DEFAULT, StorageType.DEFAULT));
            Assert.assertTrue((boolean)processor.scheduleMoveReplica(db, ml, storageTypes));
            Assert.assertFalse((boolean)processor.scheduleMoveReplica(db, ml, storageTypes));
        }
        finally {
            cluster.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testWithinSameNode(Configuration conf) throws Exception {
        MiniDFSCluster cluster = new MiniDFSCluster.Builder(conf).numDataNodes(3).storageTypes(new StorageType[]{StorageType.DISK, StorageType.ARCHIVE}).build();
        try {
            StorageType[] storageTypes;
            cluster.waitActive();
            DistributedFileSystem dfs = cluster.getFileSystem();
            String file = "/testScheduleWithinSameNode/file";
            Path dir = new Path("/testScheduleWithinSameNode");
            dfs.mkdirs(dir);
            dfs.setStoragePolicy(dir, "HOT");
            FSDataOutputStream out = dfs.create(new Path("/testScheduleWithinSameNode/file"));
            out.writeChars("testScheduleWithinSameNode");
            out.close();
            LocatedBlock lb = dfs.getClient().getLocatedBlocks("/testScheduleWithinSameNode/file", 0L).get(0);
            for (StorageType storageType : storageTypes = lb.getStorageTypes()) {
                Assert.assertTrue((StorageType.DISK == storageType ? 1 : 0) != 0);
            }
            dfs.setStoragePolicy(dir, "COLD");
            int rc = ToolRunner.run((Configuration)conf, (Tool)new Mover.Cli(), (String[])new String[]{"-p", dir.toString()});
            Assert.assertEquals((String)"Movement to ARCHIVE should be successful", (long)0L, (long)rc);
            this.waitForLocatedBlockWithArchiveStorageType(dfs, "/testScheduleWithinSameNode/file", 3);
        }
        finally {
            cluster.shutdown();
        }
    }

    private void setupStoragePoliciesAndPaths(DistributedFileSystem dfs1, DistributedFileSystem dfs2, Path dir, String file) throws Exception {
        StorageType[] storageTypes;
        dfs1.mkdirs(dir);
        dfs2.mkdirs(dir);
        dfs1.setStoragePolicy(dir, "HOT");
        FSDataOutputStream out = dfs1.create(new Path(file));
        out.writeChars("testScheduleWithinSameNode");
        out.close();
        dfs2.setStoragePolicy(dir, "COLD");
        out = dfs2.create(new Path(file));
        out.writeChars("testScheduleWithinSameNode");
        out.close();
        LocatedBlock lb = dfs1.getClient().getLocatedBlocks(file, 0L).get(0);
        for (StorageType storageType : storageTypes = lb.getStorageTypes()) {
            Assert.assertTrue((StorageType.DISK == storageType ? 1 : 0) != 0);
        }
        lb = dfs2.getClient().getLocatedBlocks(file, 0L).get(0);
        for (StorageType storageType : storageTypes = lb.getStorageTypes()) {
            Assert.assertTrue((StorageType.ARCHIVE == storageType ? 1 : 0) != 0);
        }
    }

    private void waitForLocatedBlockWithDiskStorageType(final DistributedFileSystem dfs, final String file, final int expectedDiskCount) throws Exception {
        GenericTestUtils.waitFor((Supplier)new Supplier<Boolean>(){

            @Override
            public Boolean get() {
                LocatedBlock lb = null;
                try {
                    lb = dfs.getClient().getLocatedBlocks(file, 0L).get(0);
                }
                catch (IOException e) {
                    LOG.error("Exception while getting located blocks", (Throwable)e);
                    return false;
                }
                int diskCount = 0;
                for (StorageType storageType : lb.getStorageTypes()) {
                    if (StorageType.DISK != storageType) continue;
                    ++diskCount;
                }
                LOG.info("Archive replica count, expected={} and actual={}", (Object)expectedDiskCount, (Object)diskCount);
                return expectedDiskCount == diskCount;
            }
        }, (long)100L, (long)3000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=300000L)
    public void testWithFederateClusterWithinSameNode() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        TestMover.initConf((Configuration)conf);
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(4).storageTypes(new StorageType[]{StorageType.DISK, StorageType.ARCHIVE}).nnTopology(MiniDFSNNTopology.simpleFederatedTopology(2)).build();
        DFSTestUtil.setFederatedConfiguration(cluster, (Configuration)conf);
        try {
            cluster.waitActive();
            String file = "/test/file";
            Path dir = new Path("/test");
            DistributedFileSystem dfs1 = cluster.getFileSystem(0);
            DistributedFileSystem dfs2 = cluster.getFileSystem(1);
            URI nn1 = dfs1.getUri();
            URI nn2 = dfs2.getUri();
            this.setupStoragePoliciesAndPaths(dfs1, dfs2, dir, "/test/file");
            dfs1.setStoragePolicy(dir, "COLD");
            int rc = ToolRunner.run((Configuration)conf, (Tool)new Mover.Cli(), (String[])new String[]{"-p", nn1 + dir.toString()});
            Assert.assertEquals((String)"Movement to ARCHIVE should be successful", (long)0L, (long)rc);
            dfs2.setStoragePolicy(dir, "HOT");
            rc = ToolRunner.run((Configuration)conf, (Tool)new Mover.Cli(), (String[])new String[]{"-p", nn2 + dir.toString()});
            Assert.assertEquals((String)"Movement to DISK should be successful", (long)0L, (long)rc);
            this.waitForLocatedBlockWithArchiveStorageType(dfs1, "/test/file", 3);
            this.waitForLocatedBlockWithDiskStorageType(dfs2, "/test/file", 3);
        }
        finally {
            cluster.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=300000L)
    public void testWithFederatedCluster() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        TestMover.initConf((Configuration)conf);
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).storageTypes(new StorageType[]{StorageType.DISK, StorageType.ARCHIVE}).nnTopology(MiniDFSNNTopology.simpleFederatedTopology(2)).numDataNodes(4).build();
        DFSTestUtil.setFederatedConfiguration(cluster, (Configuration)conf);
        try {
            cluster.waitActive();
            String file = "/test/file";
            Path dir = new Path("/test");
            DistributedFileSystem dfs1 = cluster.getFileSystem(0);
            DistributedFileSystem dfs2 = cluster.getFileSystem(1);
            URI nn1 = dfs1.getUri();
            URI nn2 = dfs2.getUri();
            this.setupStoragePoliciesAndPaths(dfs1, dfs2, dir, "/test/file");
            dfs1.setStoragePolicy(dir, "COLD");
            dfs2.setStoragePolicy(dir, "HOT");
            int rc = ToolRunner.run((Configuration)conf, (Tool)new Mover.Cli(), (String[])new String[]{"-p", nn1 + dir.toString(), nn2 + dir.toString()});
            Assert.assertEquals((String)"Movement to DISK should be successful", (long)0L, (long)rc);
            this.waitForLocatedBlockWithArchiveStorageType(dfs1, "/test/file", 3);
            this.waitForLocatedBlockWithDiskStorageType(dfs2, "/test/file", 3);
        }
        finally {
            cluster.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=300000L)
    public void testWithFederatedHACluster() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        TestMover.initConf((Configuration)conf);
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).storageTypes(new StorageType[]{StorageType.DISK, StorageType.ARCHIVE}).nnTopology(MiniDFSNNTopology.simpleHAFederatedTopology(2)).numDataNodes(4).build();
        DFSTestUtil.setFederatedHAConfiguration(cluster, (Configuration)conf);
        try {
            Collection namenodes = DFSUtil.getInternalNsRpcUris((Configuration)conf);
            Iterator iter = namenodes.iterator();
            URI nn1 = (URI)iter.next();
            URI nn2 = (URI)iter.next();
            cluster.transitionToActive(0);
            cluster.transitionToActive(2);
            String file = "/test/file";
            Path dir = new Path("/test");
            DistributedFileSystem dfs1 = (DistributedFileSystem)FileSystem.get((URI)nn1, (Configuration)conf);
            DistributedFileSystem dfs2 = (DistributedFileSystem)FileSystem.get((URI)nn2, (Configuration)conf);
            this.setupStoragePoliciesAndPaths(dfs1, dfs2, dir, "/test/file");
            dfs1.setStoragePolicy(dir, "COLD");
            dfs2.setStoragePolicy(dir, "HOT");
            int rc = ToolRunner.run((Configuration)conf, (Tool)new Mover.Cli(), (String[])new String[]{"-p", nn1 + dir.toString(), nn2 + dir.toString()});
            Assert.assertEquals((String)"Movement to DISK should be successful", (long)0L, (long)rc);
            this.waitForLocatedBlockWithArchiveStorageType(dfs1, "/test/file", 3);
            this.waitForLocatedBlockWithDiskStorageType(dfs2, "/test/file", 3);
        }
        finally {
            cluster.shutdown();
        }
    }

    private void waitForLocatedBlockWithArchiveStorageType(final DistributedFileSystem dfs, final String file, final int expectedArchiveCount) throws Exception {
        GenericTestUtils.waitFor((Supplier)new Supplier<Boolean>(){

            @Override
            public Boolean get() {
                LocatedBlock lb = null;
                try {
                    lb = dfs.getClient().getLocatedBlocks(file, 0L).get(0);
                }
                catch (IOException e) {
                    LOG.error("Exception while getting located blocks", (Throwable)e);
                    return false;
                }
                int archiveCount = 0;
                for (StorageType storageType : lb.getStorageTypes()) {
                    if (StorageType.ARCHIVE != storageType) continue;
                    ++archiveCount;
                }
                LOG.info("Archive replica count, expected={} and actual={}", (Object)expectedArchiveCount, (Object)archiveCount);
                return expectedArchiveCount == archiveCount;
            }
        }, (long)100L, (long)3000L);
    }

    @Test
    public void testScheduleBlockWithinSameNode() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        TestMover.initConf((Configuration)conf);
        this.testWithinSameNode((Configuration)conf);
    }

    private void checkMovePaths(List<Path> actual, Path ... expected) {
        Assert.assertEquals((long)expected.length, (long)actual.size());
        for (Path p : expected) {
            Assert.assertTrue((boolean)actual.contains(p));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMoverCli() throws Exception {
        HdfsConfiguration clusterConf = new HdfsConfiguration();
        clusterConf.set("dfs.storage.policy.satisfier.mode", HdfsConstants.StoragePolicySatisfierMode.NONE.toString());
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)clusterConf).numDataNodes(0).build();
        try {
            Configuration conf = cluster.getConfiguration(0);
            try {
                Mover.Cli.getNameNodePathsToMove((Configuration)conf, (String[])new String[]{"-p", "/foo", "bar"});
                Assert.fail((String)"Expected exception for illegal path bar");
            }
            catch (IllegalArgumentException e) {
                GenericTestUtils.assertExceptionContains((String)"bar is not absolute", (Throwable)e);
            }
            Map movePaths = Mover.Cli.getNameNodePathsToMove((Configuration)conf, (String[])new String[0]);
            Collection namenodes = DFSUtil.getInternalNsRpcUris((Configuration)conf);
            Assert.assertEquals((long)1L, (long)namenodes.size());
            Assert.assertEquals((long)1L, (long)movePaths.size());
            URI nn = (URI)namenodes.iterator().next();
            Assert.assertTrue((boolean)movePaths.containsKey(nn));
            Assert.assertNull(movePaths.get(nn));
            movePaths = Mover.Cli.getNameNodePathsToMove((Configuration)conf, (String[])new String[]{"-p", "/foo", "/bar"});
            namenodes = DFSUtil.getInternalNsRpcUris((Configuration)conf);
            Assert.assertEquals((long)1L, (long)movePaths.size());
            nn = (URI)namenodes.iterator().next();
            Assert.assertTrue((boolean)movePaths.containsKey(nn));
            this.checkMovePaths((List)movePaths.get(nn), new Path("/foo"), new Path("/bar"));
        }
        finally {
            cluster.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMoverCliWithHAConf() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.set("dfs.storage.policy.satisfier.mode", HdfsConstants.StoragePolicySatisfierMode.NONE.toString());
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).nnTopology(MiniDFSNNTopology.simpleHATopology()).numDataNodes(0).build();
        HATestUtil.setFailoverConfigurations(cluster, (Configuration)conf, "MyCluster");
        try {
            Map movePaths = Mover.Cli.getNameNodePathsToMove((Configuration)conf, (String[])new String[]{"-p", "/foo", "/bar"});
            Collection namenodes = DFSUtil.getInternalNsRpcUris((Configuration)conf);
            Assert.assertEquals((long)1L, (long)namenodes.size());
            Assert.assertEquals((long)1L, (long)movePaths.size());
            URI nn = (URI)namenodes.iterator().next();
            Assert.assertEquals((Object)new URI("hdfs://MyCluster"), (Object)nn);
            Assert.assertTrue((boolean)movePaths.containsKey(nn));
            this.checkMovePaths((List)movePaths.get(nn), new Path("/foo"), new Path("/bar"));
        }
        finally {
            cluster.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMoverCliWithFederation() throws Exception {
        HdfsConfiguration clusterConf = new HdfsConfiguration();
        clusterConf.set("dfs.storage.policy.satisfier.mode", HdfsConstants.StoragePolicySatisfierMode.NONE.toString());
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)clusterConf).nnTopology(MiniDFSNNTopology.simpleFederatedTopology(3)).numDataNodes(0).build();
        HdfsConfiguration conf = new HdfsConfiguration();
        clusterConf.set("dfs.storage.policy.satisfier.mode", HdfsConstants.StoragePolicySatisfierMode.NONE.toString());
        DFSTestUtil.setFederatedConfiguration(cluster, (Configuration)conf);
        try {
            Collection namenodes = DFSUtil.getInternalNsRpcUris((Configuration)conf);
            Assert.assertEquals((long)3L, (long)namenodes.size());
            try {
                Mover.Cli.getNameNodePathsToMove((Configuration)conf, (String[])new String[]{"-p", "/foo"});
                Assert.fail((String)"Expect exception for missing authority information");
            }
            catch (IllegalArgumentException e) {
                GenericTestUtils.assertExceptionContains((String)"does not contain scheme and authority", (Throwable)e);
            }
            try {
                Mover.Cli.getNameNodePathsToMove((Configuration)conf, (String[])new String[]{"-p", "hdfs:///foo"});
                Assert.fail((String)"Expect exception for missing authority information");
            }
            catch (IllegalArgumentException e) {
                GenericTestUtils.assertExceptionContains((String)"does not contain scheme and authority", (Throwable)e);
            }
            try {
                Mover.Cli.getNameNodePathsToMove((Configuration)conf, (String[])new String[]{"-p", "wrong-hdfs://ns1/foo"});
                Assert.fail((String)"Expect exception for wrong scheme");
            }
            catch (IllegalArgumentException e) {
                GenericTestUtils.assertExceptionContains((String)"Cannot resolve the path", (Throwable)e);
            }
            Iterator iter = namenodes.iterator();
            URI nn1 = (URI)iter.next();
            URI nn2 = (URI)iter.next();
            Map movePaths = Mover.Cli.getNameNodePathsToMove((Configuration)conf, (String[])new String[]{"-p", nn1 + "/foo", nn1 + "/bar", nn2 + "/foo/bar"});
            Assert.assertEquals((long)2L, (long)movePaths.size());
            this.checkMovePaths((List)movePaths.get(nn1), new Path("/foo"), new Path("/bar"));
            this.checkMovePaths((List)movePaths.get(nn2), new Path("/foo/bar"));
        }
        finally {
            cluster.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMoverCliWithFederationHA() throws Exception {
        HdfsConfiguration clusterConf = new HdfsConfiguration();
        clusterConf.set("dfs.storage.policy.satisfier.mode", HdfsConstants.StoragePolicySatisfierMode.NONE.toString());
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)clusterConf).nnTopology(MiniDFSNNTopology.simpleHAFederatedTopology(3)).numDataNodes(0).build();
        HdfsConfiguration conf = new HdfsConfiguration();
        clusterConf.set("dfs.storage.policy.satisfier.mode", HdfsConstants.StoragePolicySatisfierMode.NONE.toString());
        DFSTestUtil.setFederatedHAConfiguration(cluster, (Configuration)conf);
        try {
            Collection namenodes = DFSUtil.getInternalNsRpcUris((Configuration)conf);
            Assert.assertEquals((long)3L, (long)namenodes.size());
            Iterator iter = namenodes.iterator();
            URI nn1 = (URI)iter.next();
            URI nn2 = (URI)iter.next();
            URI nn3 = (URI)iter.next();
            Map movePaths = Mover.Cli.getNameNodePathsToMove((Configuration)conf, (String[])new String[]{"-p", nn1 + "/foo", nn1 + "/bar", nn2 + "/foo/bar", nn3 + "/foobar"});
            Assert.assertEquals((long)3L, (long)movePaths.size());
            this.checkMovePaths((List)movePaths.get(nn1), new Path("/foo"), new Path("/bar"));
            this.checkMovePaths((List)movePaths.get(nn2), new Path("/foo/bar"));
            this.checkMovePaths((List)movePaths.get(nn3), new Path("/foobar"));
        }
        finally {
            cluster.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=300000L)
    public void testTwoReplicaSameStorageTypeShouldNotSelect() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        TestMover.initConf((Configuration)conf);
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(3).storageTypes(new StorageType[][]{{StorageType.DISK, StorageType.ARCHIVE}, {StorageType.DISK, StorageType.DISK}, {StorageType.DISK, StorageType.ARCHIVE}}).build();
        try {
            StorageType[] storageTypes;
            cluster.waitActive();
            DistributedFileSystem dfs = cluster.getFileSystem();
            String file = "/testForTwoReplicaSameStorageTypeShouldNotSelect";
            FSDataOutputStream out = dfs.create(new Path("/testForTwoReplicaSameStorageTypeShouldNotSelect"), (short)2);
            out.writeChars("testForTwoReplicaSameStorageTypeShouldNotSelect");
            out.close();
            LocatedBlock lb = dfs.getClient().getLocatedBlocks("/testForTwoReplicaSameStorageTypeShouldNotSelect", 0L).get(0);
            for (StorageType storageType : storageTypes = lb.getStorageTypes()) {
                Assert.assertTrue((StorageType.DISK == storageType ? 1 : 0) != 0);
            }
            dfs.setStoragePolicy(new Path("/testForTwoReplicaSameStorageTypeShouldNotSelect"), "COLD");
            int rc = ToolRunner.run((Configuration)conf, (Tool)new Mover.Cli(), (String[])new String[]{"-p", "/testForTwoReplicaSameStorageTypeShouldNotSelect".toString()});
            Assert.assertEquals((String)"Movement to ARCHIVE should be successful", (long)0L, (long)rc);
            this.waitForLocatedBlockWithArchiveStorageType(dfs, "/testForTwoReplicaSameStorageTypeShouldNotSelect", 2);
        }
        finally {
            cluster.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=300000L)
    public void testMoveWhenStoragePolicyNotSatisfying() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.set("dfs.storage.policy.satisfier.mode", HdfsConstants.StoragePolicySatisfierMode.NONE.toString());
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(3).storageTypes(new StorageType[][]{{StorageType.DISK}, {StorageType.DISK}, {StorageType.DISK}}).build();
        try {
            cluster.waitActive();
            DistributedFileSystem dfs = cluster.getFileSystem();
            String file = "/testMoveWhenStoragePolicyNotSatisfying";
            FSDataOutputStream out = dfs.create(new Path("/testMoveWhenStoragePolicyNotSatisfying"));
            out.writeChars("testMoveWhenStoragePolicyNotSatisfying");
            out.close();
            dfs.setStoragePolicy(new Path("/testMoveWhenStoragePolicyNotSatisfying"), "COLD");
            int rc = ToolRunner.run((Configuration)conf, (Tool)new Mover.Cli(), (String[])new String[]{"-p", "/testMoveWhenStoragePolicyNotSatisfying".toString()});
            int exitcode = ExitStatus.NO_MOVE_BLOCK.getExitCode();
            Assert.assertEquals((String)("Exit code should be " + exitcode), (long)exitcode, (long)rc);
        }
        finally {
            cluster.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=300000L)
    public void testMoveWhenStoragePolicySatisfierIsRunning() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.set("dfs.storage.policy.satisfier.mode", HdfsConstants.StoragePolicySatisfierMode.EXTERNAL.toString());
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(3).storageTypes(new StorageType[][]{{StorageType.DISK}, {StorageType.DISK}, {StorageType.DISK}}).build();
        try {
            cluster.waitActive();
            DFSTestUtil.getNameNodeConnector((Configuration)conf, HdfsServerConstants.MOVER_ID_PATH, 1, true);
            DistributedFileSystem dfs = cluster.getFileSystem();
            String file = "/testMoveWhenStoragePolicySatisfierIsRunning";
            FSDataOutputStream out = dfs.create(new Path("/testMoveWhenStoragePolicySatisfierIsRunning"));
            out.writeChars("testMoveWhenStoragePolicySatisfierIsRunning");
            out.close();
            dfs.setStoragePolicy(new Path("/testMoveWhenStoragePolicySatisfierIsRunning"), "COLD");
            int rc = ToolRunner.run((Configuration)conf, (Tool)new Mover.Cli(), (String[])new String[]{"-p", "/testMoveWhenStoragePolicySatisfierIsRunning".toString()});
            int exitcode = ExitStatus.IO_EXCEPTION.getExitCode();
            Assert.assertEquals((String)("Exit code should be " + exitcode), (long)exitcode, (long)rc);
        }
        finally {
            cluster.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMoverFailedRetry() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        TestMover.initConf((Configuration)conf);
        conf.set("dfs.mover.retry.max.attempts", "2");
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(3).storageTypes(new StorageType[][]{{StorageType.DISK, StorageType.ARCHIVE}, {StorageType.DISK, StorageType.ARCHIVE}, {StorageType.DISK, StorageType.ARCHIVE}}).build();
        try {
            cluster.waitActive();
            DistributedFileSystem dfs = cluster.getFileSystem();
            String file = "/testMoverFailedRetry";
            FSDataOutputStream out = dfs.create(new Path("/testMoverFailedRetry"), (short)2);
            out.writeChars("testMoverFailedRetry");
            out.close();
            LocatedBlock lb = dfs.getClient().getLocatedBlocks("/testMoverFailedRetry", 0L).get(0);
            cluster.corruptBlockOnDataNodesByDeletingBlockFile(lb.getBlock());
            dfs.setStoragePolicy(new Path("/testMoverFailedRetry"), "COLD");
            int rc = ToolRunner.run((Configuration)conf, (Tool)new Mover.Cli(), (String[])new String[]{"-p", "/testMoverFailedRetry".toString()});
            Assert.assertEquals((String)"Movement should fail after some retry", (long)ExitStatus.NO_MOVE_PROGRESS.getExitCode(), (long)rc);
        }
        finally {
            cluster.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=100000L)
    public void testBalancerMaxIterationTimeNotAffectMover() throws Exception {
        long blockSize = 0xA00000L;
        HdfsConfiguration conf = new HdfsConfiguration();
        TestMover.initConf((Configuration)conf);
        conf.setInt("dfs.mover.moverThreads", 1);
        conf.setInt("dfs.datanode.balance.max.concurrent.moves", 1);
        conf.setLong("dfs.blocksize", blockSize);
        conf.setLong("dfs.bytes-per-checksum", blockSize);
        conf.setLong("dfs.balancer.max-iteration-time", 200L);
        conf.setInt("dfs.mover.retry.max.attempts", 1);
        conf.setLong("dfs.client.socket-timeout", 1000L);
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(2).storageTypes(new StorageType[][]{{StorageType.DISK, StorageType.DISK}, {StorageType.ARCHIVE, StorageType.ARCHIVE}}).build();
        try {
            cluster.waitActive();
            DistributedFileSystem fs = cluster.getFileSystem();
            String file = "/testMaxIterationTime.dat";
            Path path = new Path("/testMaxIterationTime.dat");
            short rep_factor = 1;
            int seed = 0xFAFAFA;
            DFSTestUtil.createFile((FileSystem)fs, path, 4L * blockSize, rep_factor, seed);
            fs.setStoragePolicy(new Path("/testMaxIterationTime.dat"), "COLD");
            int rc = ToolRunner.run((Configuration)conf, (Tool)new Mover.Cli(), (String[])new String[]{"-p", "/testMaxIterationTime.dat"});
            Assert.assertEquals((String)"Retcode expected to be ExitStatus.SUCCESS (0).", (long)ExitStatus.SUCCESS.getExitCode(), (long)rc);
        }
        finally {
            cluster.shutdown();
        }
    }

    void initConfWithStripe(Configuration conf) {
        conf.setLong("dfs.blocksize", (long)this.defaultBlockSize);
        conf.setLong("dfs.heartbeat.interval", 1L);
        conf.setLong("dfs.namenode.redundancy.interval.seconds", 1L);
        conf.setBoolean("dfs.namenode.redundancy.considerLoad", false);
        conf.set("dfs.storage.policy.satisfier.mode", HdfsConstants.StoragePolicySatisfierMode.NONE.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=300000L)
    public void testMoverWithStripedFile() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        this.initConfWithStripe((Configuration)conf);
        int numOfDatanodes = 10;
        int storagesPerDatanode = 2;
        long capacity = 10 * this.defaultBlockSize;
        long[][] capacities = new long[numOfDatanodes][storagesPerDatanode];
        for (int i = 0; i < numOfDatanodes; ++i) {
            for (int j = 0; j < storagesPerDatanode; ++j) {
                capacities[i][j] = capacity;
            }
        }
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(numOfDatanodes).storagesPerDatanode(storagesPerDatanode).storageTypes(new StorageType[][]{{StorageType.DISK, StorageType.DISK}, {StorageType.DISK, StorageType.DISK}, {StorageType.DISK, StorageType.DISK}, {StorageType.DISK, StorageType.DISK}, {StorageType.DISK, StorageType.DISK}, {StorageType.DISK, StorageType.ARCHIVE}, {StorageType.DISK, StorageType.ARCHIVE}, {StorageType.DISK, StorageType.ARCHIVE}, {StorageType.DISK, StorageType.ARCHIVE}, {StorageType.DISK, StorageType.ARCHIVE}}).storageCapacities(capacities).build();
        try {
            cluster.waitActive();
            cluster.getFileSystem().enableErasureCodingPolicy(StripedFileTestUtil.getDefaultECPolicy().getName());
            ClientProtocol client = (ClientProtocol)NameNodeProxies.createProxy((Configuration)conf, (URI)cluster.getFileSystem(0).getUri(), ClientProtocol.class).getProxy();
            String barDir = "/bar";
            client.mkdirs(barDir, new FsPermission(777), true);
            client.setStoragePolicy(barDir, "HOT");
            client.setErasureCodingPolicy(barDir, StripedFileTestUtil.getDefaultECPolicy().getName());
            String fooFile = "/bar/foo";
            long fileLen = 20 * this.defaultBlockSize;
            DFSTestUtil.createFile((FileSystem)cluster.getFileSystem(), new Path("/bar/foo"), fileLen, (short)3, 0L);
            LocatedBlocks locatedBlocks = client.getBlockLocations("/bar/foo", 0L, fileLen);
            for (LocatedBlock lb : locatedBlocks.getLocatedBlocks()) {
                for (StorageType type : lb.getStorageTypes()) {
                    Assert.assertEquals((Object)StorageType.DISK, (Object)type);
                }
            }
            StripedFileTestUtil.verifyLocatedStripedBlocks(locatedBlocks, this.dataBlocks + this.parityBlocks);
            numOfDatanodes += 5;
            capacities = new long[5][storagesPerDatanode];
            for (int i = 0; i < 5; ++i) {
                for (int j = 0; j < storagesPerDatanode; ++j) {
                    capacities[i][j] = capacity;
                }
            }
            cluster.startDataNodes((Configuration)conf, 5, new StorageType[][]{{StorageType.ARCHIVE, StorageType.ARCHIVE}, {StorageType.ARCHIVE, StorageType.ARCHIVE}, {StorageType.ARCHIVE, StorageType.ARCHIVE}, {StorageType.ARCHIVE, StorageType.ARCHIVE}, {StorageType.ARCHIVE, StorageType.ARCHIVE}}, true, null, null, null, capacities, null, false, false, false, null);
            cluster.triggerHeartbeats();
            client.setStoragePolicy(barDir, "COLD");
            int rc = ToolRunner.run((Configuration)conf, (Tool)new Mover.Cli(), (String[])new String[]{"-p", barDir});
            Assert.assertEquals((String)"Movement to ARCHIVE should be successful", (long)0L, (long)rc);
            locatedBlocks = client.getBlockLocations("/bar/foo", 0L, fileLen);
            for (LocatedBlock lb : locatedBlocks.getLocatedBlocks()) {
                for (StorageType type : lb.getStorageTypes()) {
                    Assert.assertEquals((Object)StorageType.ARCHIVE, (Object)type);
                }
            }
            StripedFileTestUtil.verifyLocatedStripedBlocks(locatedBlocks, this.dataBlocks + this.parityBlocks);
            numOfDatanodes += 5;
            capacities = new long[5][storagesPerDatanode];
            for (int i = 0; i < 5; ++i) {
                for (int j = 0; j < storagesPerDatanode; ++j) {
                    capacities[i][j] = capacity;
                }
            }
            cluster.startDataNodes((Configuration)conf, 5, new StorageType[][]{{StorageType.SSD, StorageType.DISK}, {StorageType.SSD, StorageType.DISK}, {StorageType.SSD, StorageType.DISK}, {StorageType.SSD, StorageType.DISK}, {StorageType.SSD, StorageType.DISK}}, true, null, null, null, capacities, null, false, false, false, null);
            cluster.triggerHeartbeats();
            client.setStoragePolicy(barDir, "ONE_SSD");
            rc = ToolRunner.run((Configuration)conf, (Tool)new Mover.Cli(), (String[])new String[]{"-p", barDir});
            locatedBlocks = client.getBlockLocations("/bar/foo", 0L, fileLen);
            for (LocatedBlock lb : locatedBlocks.getLocatedBlocks()) {
                for (StorageType type : lb.getStorageTypes()) {
                    Assert.assertEquals((Object)StorageType.ARCHIVE, (Object)type);
                }
            }
        }
        finally {
            cluster.shutdown();
        }
    }

    private void initSecureConf(Configuration conf) throws Exception {
        String username = "mover";
        File baseDir = GenericTestUtils.getTestDir((String)TestMover.class.getSimpleName());
        FileUtil.fullyDelete((File)baseDir);
        Assert.assertTrue((boolean)baseDir.mkdirs());
        Properties kdcConf = MiniKdc.createConf();
        MiniKdc kdc = new MiniKdc(kdcConf, baseDir);
        kdc.start();
        SecurityUtil.setAuthenticationMethod((UserGroupInformation.AuthenticationMethod)UserGroupInformation.AuthenticationMethod.KERBEROS, (Configuration)conf);
        UserGroupInformation.setConfiguration((Configuration)conf);
        KerberosName.resetDefaultRealm();
        Assert.assertTrue((String)"Expected configuration to enable security", (boolean)UserGroupInformation.isSecurityEnabled());
        this.keytabFile = new File(baseDir, username + ".keytab");
        String keytab = this.keytabFile.getAbsolutePath();
        String krbInstance = Path.WINDOWS ? "127.0.0.1" : "localhost";
        this.principal = username + "/" + krbInstance + "@" + kdc.getRealm();
        String spnegoPrincipal = "HTTP/" + krbInstance + "@" + kdc.getRealm();
        kdc.createPrincipal(this.keytabFile, new String[]{username, username + "/" + krbInstance, "HTTP/" + krbInstance});
        conf.set("dfs.namenode.kerberos.principal", this.principal);
        conf.set("dfs.namenode.keytab.file", keytab);
        conf.set("dfs.datanode.kerberos.principal", this.principal);
        conf.set("dfs.datanode.keytab.file", keytab);
        conf.set("dfs.web.authentication.kerberos.principal", spnegoPrincipal);
        conf.setBoolean("dfs.block.access.token.enable", true);
        conf.set("dfs.data.transfer.protection", "authentication");
        conf.set("dfs.http.policy", HttpConfig.Policy.HTTPS_ONLY.name());
        conf.set("dfs.namenode.https-address", "localhost:0");
        conf.set("dfs.datanode.https.address", "localhost:0");
        conf.setInt("ipc.client.connect.max.retries.on.sasl", 10);
        conf.setBoolean("dfs.mover.keytab.enabled", true);
        conf.set("dfs.mover.address", "localhost:0");
        conf.set("dfs.mover.keytab.file", keytab);
        conf.set("dfs.mover.kerberos.principal", this.principal);
        String keystoresDir = baseDir.getAbsolutePath();
        String sslConfDir = KeyStoreTestUtil.getClasspathDir(TestMover.class);
        KeyStoreTestUtil.setupSSLConfig((String)keystoresDir, (String)sslConfDir, (Configuration)conf, (boolean)false);
        conf.set("dfs.client.https.keystore.resource", KeyStoreTestUtil.getClientSSLConfigFileName());
        conf.set("dfs.https.server.keystore.resource", KeyStoreTestUtil.getServerSSLConfigFileName());
        TestMover.initConf(conf);
    }

    @Test(timeout=300000L)
    public void testMoverWithKeytabs() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        try {
            this.initSecureConf((Configuration)conf);
            UserGroupInformation ugi = UserGroupInformation.loginUserFromKeytabAndReturnUGI((String)this.principal, (String)this.keytabFile.getAbsolutePath());
            ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>((Configuration)conf){
                final /* synthetic */ Configuration val$conf;
                {
                    this.val$conf = configuration;
                }

                @Override
                public Void run() throws Exception {
                    TestMover.this.testWithinSameNode(this.val$conf);
                    Assert.assertTrue((boolean)UserGroupInformation.isLoginKeytabBased());
                    return null;
                }
            });
        }
        finally {
            UserGroupInformation.reset();
            UserGroupInformation.setConfiguration((Configuration)new Configuration());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=90000L)
    public void testMoverWithPinnedBlocks() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        TestMover.initConf((Configuration)conf);
        conf.setInt("dfs.mover.retry.max.attempts", 10000);
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(3).build();
        try {
            StorageType[] storageTypes;
            cluster.waitActive();
            DistributedFileSystem dfs = cluster.getFileSystem();
            String file = "/testMoverWithPinnedBlocks/file";
            Path dir = new Path("/testMoverWithPinnedBlocks");
            dfs.mkdirs(dir);
            dfs.setStoragePolicy(dir, "HOT");
            FSDataOutputStream out = dfs.create(new Path("/testMoverWithPinnedBlocks/file"));
            byte[] fileData = StripedFileTestUtil.generateBytes(300);
            out.write(fileData);
            out.close();
            LocatedBlock lb = dfs.getClient().getLocatedBlocks("/testMoverWithPinnedBlocks/file", 0L).get(0);
            for (StorageType storageType : storageTypes = lb.getStorageTypes()) {
                Assert.assertTrue((StorageType.DISK == storageType ? 1 : 0) != 0);
            }
            StorageType[][] newtypes = new StorageType[][]{{StorageType.SSD}};
            this.startAdditionalDNs((Configuration)conf, 1, newtypes, cluster);
            for (int i = 0; i < cluster.getDataNodes().size(); ++i) {
                DataNode dn = cluster.getDataNodes().get(i);
                LOG.info("Simulate block pinning in datanode {}", (Object)dn);
                InternalDataNodeTestUtils.mockDatanodeBlkPinning(dn, true);
            }
            dfs.setStoragePolicy(dir, "ONE_SSD");
            int rc = ToolRunner.run((Configuration)conf, (Tool)new Mover.Cli(), (String[])new String[]{"-p", dir.toString()});
            int exitcode = ExitStatus.NO_MOVE_BLOCK.getExitCode();
            Assert.assertEquals((String)"Movement should fail", (long)exitcode, (long)rc);
        }
        finally {
            cluster.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=90000L)
    public void testMoverFailedRetryWithPinnedBlocks() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        TestMover.initConf((Configuration)conf);
        conf.set("dfs.mover.retry.max.attempts", "2");
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(2).storageTypes(new StorageType[][]{{StorageType.DISK, StorageType.ARCHIVE}, {StorageType.DISK, StorageType.ARCHIVE}}).build();
        try {
            cluster.waitActive();
            DistributedFileSystem dfs = cluster.getFileSystem();
            String parenDir = "/parent";
            dfs.mkdirs(new Path("/parent"));
            String file1 = "/parent/testMoverFailedRetryWithPinnedBlocks1";
            FSDataOutputStream out = dfs.create(new Path("/parent/testMoverFailedRetryWithPinnedBlocks1"), (short)2);
            byte[] fileData = StripedFileTestUtil.generateBytes(200);
            out.write(fileData);
            out.close();
            this.createFileWithFavoredDatanodes((Configuration)conf, cluster, dfs);
            LocatedBlocks locatedBlocks = dfs.getClient().getLocatedBlocks("/parent/testMoverFailedRetryWithPinnedBlocks1", 0L);
            Assert.assertEquals((String)"Wrong block count", (long)2L, (long)locatedBlocks.locatedBlockCount());
            LocatedBlock lb = locatedBlocks.get(0);
            cluster.corruptBlockOnDataNodesByDeletingBlockFile(lb.getBlock());
            dfs.setStoragePolicy(new Path("/parent"), "COLD");
            int rc = ToolRunner.run((Configuration)conf, (Tool)new Mover.Cli(), (String[])new String[]{"-p", "/parent".toString()});
            Assert.assertEquals((String)"Movement should fail after some retry", (long)ExitStatus.NO_MOVE_PROGRESS.getExitCode(), (long)rc);
        }
        finally {
            cluster.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=300000L)
    public void testMoverWhenStoragePolicyUnset() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        TestMover.initConf((Configuration)conf);
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(1).storageTypes(new StorageType[][]{{StorageType.DISK, StorageType.ARCHIVE}}).build();
        try {
            cluster.waitActive();
            DistributedFileSystem dfs = cluster.getFileSystem();
            String file = "/testMoverWhenStoragePolicyUnset";
            DFSTestUtil.createFile((FileSystem)dfs, new Path("/testMoverWhenStoragePolicyUnset"), 1L, (short)1, 0L);
            dfs.setStoragePolicy(new Path("/testMoverWhenStoragePolicyUnset"), "COLD");
            int rc = ToolRunner.run((Configuration)conf, (Tool)new Mover.Cli(), (String[])new String[]{"-p", "/testMoverWhenStoragePolicyUnset".toString()});
            Assert.assertEquals((String)"Movement to ARCHIVE should be successful", (long)0L, (long)rc);
            this.waitForLocatedBlockWithArchiveStorageType(dfs, "/testMoverWhenStoragePolicyUnset", 1);
            LocatedBlock lb = dfs.getClient().getLocatedBlocks("/testMoverWhenStoragePolicyUnset", 0L).get(0);
            Assert.assertTrue((StorageType.ARCHIVE == lb.getStorageTypes()[0] ? 1 : 0) != 0);
            dfs.unsetStoragePolicy(new Path("/testMoverWhenStoragePolicyUnset"));
            rc = ToolRunner.run((Configuration)conf, (Tool)new Mover.Cli(), (String[])new String[]{"-p", "/testMoverWhenStoragePolicyUnset".toString()});
            Assert.assertEquals((String)"Movement to DISK should be successful", (long)0L, (long)rc);
            lb = dfs.getClient().getLocatedBlocks("/testMoverWhenStoragePolicyUnset", 0L).get(0);
            Assert.assertTrue((StorageType.DISK == lb.getStorageTypes()[0] ? 1 : 0) != 0);
        }
        finally {
            cluster.shutdown();
        }
    }

    private void createFileWithFavoredDatanodes(Configuration conf, MiniDFSCluster cluster, DistributedFileSystem dfs) throws IOException {
        StorageType[][] newtypes = new StorageType[][]{{StorageType.DISK}, {StorageType.DISK}};
        this.startAdditionalDNs(conf, 2, newtypes, cluster);
        ArrayList<DataNode> dataNodes = cluster.getDataNodes();
        InetSocketAddress[] favoredNodes = new InetSocketAddress[2];
        int j = 0;
        for (int i = dataNodes.size() - 1; i >= 2; --i) {
            favoredNodes[j++] = dataNodes.get(i).getXferAddress();
        }
        String file = "/parent/testMoverFailedRetryWithPinnedBlocks2";
        HdfsDataOutputStream out = dfs.create(new Path("/parent/testMoverFailedRetryWithPinnedBlocks2"), FsPermission.getDefault(), true, 100, (short)2, 100L, null, favoredNodes);
        byte[] fileData = StripedFileTestUtil.generateBytes(200);
        out.write(fileData);
        out.close();
        LocatedBlocks locatedBlocks = dfs.getClient().getLocatedBlocks("/parent/testMoverFailedRetryWithPinnedBlocks2", 0L);
        Assert.assertEquals((String)"Wrong block count", (long)2L, (long)locatedBlocks.locatedBlockCount());
        LocatedBlock lb = locatedBlocks.get(0);
        DatanodeInfoWithStorage datanodeInfo = lb.getLocations()[0];
        for (DataNode dn : cluster.getDataNodes()) {
            if (!dn.getDatanodeId().getDatanodeUuid().equals(datanodeInfo.getDatanodeUuid())) continue;
            LOG.info("Simulate block pinning in datanode {}", (Object)datanodeInfo);
            InternalDataNodeTestUtils.mockDatanodeBlkPinning(dn, true);
            break;
        }
    }

    private void startAdditionalDNs(Configuration conf, int newNodesRequired, StorageType[][] newTypes, MiniDFSCluster cluster) throws IOException {
        cluster.startDataNodes(conf, newNodesRequired, newTypes, true, null, null, null, null, null, false, false, false, null);
        cluster.triggerHeartbeats();
    }

    static {
        TestBalancer.initTestSetup();
    }
}

