/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode.ha;

import java.io.Closeable;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URI;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.ha.HAServiceProtocol;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HAUtil;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.MiniDFSNNTopology;
import org.apache.hadoop.hdfs.server.common.Storage;
import org.apache.hadoop.hdfs.server.namenode.EditLogFileOutputStream;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.hdfs.server.namenode.NameNodeAdapter;
import org.apache.hadoop.hdfs.server.namenode.NameNodeLayoutVersion;
import org.apache.hadoop.hdfs.server.namenode.ha.EditLogTailer;
import org.apache.hadoop.hdfs.server.namenode.ha.HATestUtil;
import org.apache.hadoop.hdfs.server.namenode.ha.TestStandbyIsHot;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.test.MultithreadedTestUtil;
import org.apache.hadoop.thirdparty.com.google.common.util.concurrent.Uninterruptibles;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.event.Level;

public class TestHAStateTransitions {
    protected static final Logger LOG = LoggerFactory.getLogger(TestStandbyIsHot.class);
    private static final Path TEST_DIR = new Path("/test");
    private static final Path TEST_FILE_PATH = new Path(TEST_DIR, "foo");
    private static final String TEST_FILE_STR = TEST_FILE_PATH.toUri().getPath();
    private static final String TEST_FILE_DATA = "Hello state transitioning world";
    private static final HAServiceProtocol.StateChangeRequestInfo REQ_INFO = new HAServiceProtocol.StateChangeRequestInfo(HAServiceProtocol.RequestSource.REQUEST_BY_USER_FORCED);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=300000L)
    public void testTransitionActiveToStandby() throws Exception {
        Configuration conf = new Configuration();
        MiniDFSCluster cluster = new MiniDFSCluster.Builder(conf).nnTopology(MiniDFSNNTopology.simpleHATopology()).numDataNodes(1).build();
        try {
            cluster.waitActive();
            cluster.transitionToActive(0);
            DistributedFileSystem fs = cluster.getFileSystem(0);
            fs.mkdirs(TEST_DIR);
            cluster.transitionToStandby(0);
            try {
                fs.mkdirs(new Path("/x"));
                Assert.fail((String)"Didn't throw trying to mutate FS in standby state");
            }
            catch (Throwable t) {
                GenericTestUtils.assertExceptionContains((String)"Operation category WRITE is not supported", (Throwable)t);
            }
            cluster.transitionToActive(0);
            DFSTestUtil.createFile((FileSystem)fs, new Path(TEST_DIR, "foo"), 10L, (short)1, 1L);
            fs.delete(TEST_DIR, true);
            cluster.transitionToStandby(0);
            cluster.transitionToActive(0);
            Assert.assertFalse((boolean)fs.exists(TEST_DIR));
        }
        finally {
            cluster.shutdown();
        }
    }

    private void addCrmThreads(MiniDFSCluster cluster, LinkedList<Thread> crmThreads) {
        for (int nn = 0; nn <= 1; ++nn) {
            Thread thread = cluster.getNameNode(nn).getNamesystem().getCacheManager().getCacheReplicationMonitor();
            if (thread == null) continue;
            crmThreads.add(thread);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=300000L)
    public void testTransitionToCurrentStateIsANop() throws Exception {
        Configuration conf = new Configuration();
        conf.setLong("dfs.namenode.path.based.cache.refresh.interval.ms", 1L);
        MiniDFSCluster cluster = new MiniDFSCluster.Builder(conf).nnTopology(MiniDFSNNTopology.simpleHATopology()).numDataNodes(1).build();
        LinkedList<Thread> crmThreads = new LinkedList<Thread>();
        try {
            cluster.waitActive();
            this.addCrmThreads(cluster, crmThreads);
            cluster.transitionToActive(0);
            this.addCrmThreads(cluster, crmThreads);
            cluster.transitionToActive(0);
            this.addCrmThreads(cluster, crmThreads);
            cluster.transitionToStandby(0);
            this.addCrmThreads(cluster, crmThreads);
            cluster.transitionToStandby(0);
            this.addCrmThreads(cluster, crmThreads);
        }
        finally {
            cluster.shutdown();
        }
        for (Thread thread : crmThreads) {
            Uninterruptibles.joinUninterruptibly((Thread)thread);
        }
    }

    private void testManualFailoverFailback(MiniDFSCluster cluster, Configuration conf, int nsIndex) throws Exception {
        int nn0 = 2 * nsIndex;
        int nn1 = 2 * nsIndex + 1;
        cluster.transitionToActive(nn0);
        LOG.info("Starting with NN 0 active in namespace " + nsIndex);
        DistributedFileSystem fs = HATestUtil.configureFailoverFs(cluster, conf);
        fs.mkdirs(TEST_DIR);
        LOG.info("Failing over to NN 1 in namespace " + nsIndex);
        cluster.transitionToStandby(nn0);
        cluster.transitionToActive(nn1);
        Assert.assertTrue((boolean)fs.exists(TEST_DIR));
        DFSTestUtil.writeFile((FileSystem)fs, TEST_FILE_PATH, TEST_FILE_DATA);
        LOG.info("Failing over to NN 0 in namespace " + nsIndex);
        cluster.transitionToStandby(nn1);
        cluster.transitionToActive(nn0);
        Assert.assertTrue((boolean)fs.exists(TEST_DIR));
        Assert.assertEquals((Object)TEST_FILE_DATA, (Object)DFSTestUtil.readFile((FileSystem)fs, TEST_FILE_PATH));
        LOG.info("Removing test file");
        fs.delete(TEST_DIR, true);
        Assert.assertFalse((boolean)fs.exists(TEST_DIR));
        LOG.info("Failing over to NN 1 in namespace " + nsIndex);
        cluster.transitionToStandby(nn0);
        cluster.transitionToActive(nn1);
        Assert.assertFalse((boolean)fs.exists(TEST_DIR));
    }

    @Test(timeout=300000L)
    public void testManualFailoverAndFailback() throws Exception {
        Configuration conf = new Configuration();
        MiniDFSCluster cluster = new MiniDFSCluster.Builder(conf).nnTopology(MiniDFSNNTopology.simpleHATopology()).numDataNodes(1).build();
        try {
            cluster.waitActive();
            this.testManualFailoverFailback(cluster, conf, 0);
        }
        finally {
            cluster.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=120000L)
    public void testTransitionSynchronization() throws Exception {
        Configuration conf = new Configuration();
        final MiniDFSCluster cluster = new MiniDFSCluster.Builder(conf).nnTopology(MiniDFSNNTopology.simpleHATopology()).numDataNodes(0).build();
        try {
            cluster.waitActive();
            ReentrantReadWriteLock spyLock = NameNodeAdapter.spyOnFsLock(cluster.getNameNode(0).getNamesystem());
            ((ReentrantReadWriteLock)Mockito.doAnswer((Answer)new GenericTestUtils.SleepAnswer(50)).when((Object)spyLock)).writeLock();
            DistributedFileSystem fs = HATestUtil.configureFailoverFs(cluster, conf);
            MultithreadedTestUtil.TestContext ctx = new MultithreadedTestUtil.TestContext();
            int i = 0;
            while (i < 50) {
                final int finalI = i++;
                ctx.addThread((MultithreadedTestUtil.TestingThread)new MultithreadedTestUtil.RepeatingTestThread(ctx, (FileSystem)fs){
                    final /* synthetic */ FileSystem val$fs;
                    {
                        this.val$fs = fileSystem;
                        super(x0);
                    }

                    public void doAnAction() throws Exception {
                        Path p = new Path("/test-" + finalI);
                        this.val$fs.mkdirs(p);
                        this.val$fs.delete(p, true);
                    }
                });
            }
            ctx.addThread((MultithreadedTestUtil.TestingThread)new MultithreadedTestUtil.RepeatingTestThread(ctx){

                public void doAnAction() throws Exception {
                    cluster.transitionToStandby(0);
                    Thread.sleep(50L);
                    cluster.transitionToActive(0);
                }
            });
            ctx.startThreads();
            ctx.waitFor(20000L);
            ctx.stop();
        }
        finally {
            cluster.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=120000L)
    public void testLeasesRenewedOnTransition() throws Exception {
        Configuration conf = new Configuration();
        conf.setInt("dfs.ha.tail-edits.period", 1);
        MiniDFSCluster cluster = new MiniDFSCluster.Builder(conf).nnTopology(MiniDFSNNTopology.simpleHATopology()).numDataNodes(1).build();
        FSDataOutputStream stm = null;
        DistributedFileSystem fs = HATestUtil.configureFailoverFs(cluster, conf);
        NameNode nn0 = cluster.getNameNode(0);
        NameNode nn1 = cluster.getNameNode(1);
        try {
            cluster.waitActive();
            cluster.transitionToActive(0);
            LOG.info("Starting with NN 0 active");
            stm = fs.create(TEST_FILE_PATH);
            long nn0t0 = NameNodeAdapter.getLeaseRenewalTime(nn0, TEST_FILE_STR);
            Assert.assertTrue((nn0t0 > 0L ? 1 : 0) != 0);
            long nn1t0 = NameNodeAdapter.getLeaseRenewalTime(nn1, TEST_FILE_STR);
            Assert.assertEquals((String)"Lease should not yet exist on nn1", (long)-1L, (long)nn1t0);
            Thread.sleep(5L);
            HATestUtil.waitForStandbyToCatchUp(nn0, nn1);
            long nn1t1 = NameNodeAdapter.getLeaseRenewalTime(nn1, TEST_FILE_STR);
            Assert.assertTrue((String)("Lease should have been created on standby. Time was: " + nn1t1), (nn1t1 > nn0t0 ? 1 : 0) != 0);
            Thread.sleep(5L);
            LOG.info("Failing over to NN 1");
            cluster.transitionToStandby(0);
            cluster.transitionToActive(1);
            long nn1t2 = NameNodeAdapter.getLeaseRenewalTime(nn1, TEST_FILE_STR);
            Assert.assertTrue((String)"Lease should have been renewed by failover process", (nn1t2 > nn1t1 ? 1 : 0) != 0);
        }
        catch (Throwable throwable) {
            IOUtils.closeStream(stm);
            cluster.shutdown();
            throw throwable;
        }
        IOUtils.closeStream((Closeable)stm);
        cluster.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=300000L)
    public void testDelegationTokensAfterFailover() throws IOException {
        Configuration conf = new Configuration();
        conf.setBoolean("dfs.namenode.delegation.token.always-use", true);
        MiniDFSCluster cluster = new MiniDFSCluster.Builder(conf).nnTopology(MiniDFSNNTopology.simpleHATopology()).numDataNodes(0).build();
        try {
            cluster.waitActive();
            cluster.transitionToActive(0);
            NameNode nn1 = cluster.getNameNode(0);
            NameNode nn2 = cluster.getNameNode(1);
            String renewer = UserGroupInformation.getLoginUser().getUserName();
            Token token = nn1.getRpcServer().getDelegationToken(new Text(renewer));
            LOG.info("Failing over to NN 1");
            cluster.transitionToStandby(0);
            cluster.transitionToActive(1);
            nn2.getRpcServer().renewDelegationToken(token);
            nn2.getRpcServer().cancelDelegationToken(token);
            token = nn2.getRpcServer().getDelegationToken(new Text(renewer));
            Assert.assertTrue((token != null ? 1 : 0) != 0);
        }
        finally {
            cluster.shutdown();
        }
    }

    @Test(timeout=300000L)
    public void testManualFailoverFailbackFederationHA() throws Exception {
        Configuration conf = new Configuration();
        MiniDFSCluster cluster = new MiniDFSCluster.Builder(conf).nnTopology(MiniDFSNNTopology.simpleHAFederatedTopology(2)).numDataNodes(1).build();
        try {
            cluster.waitActive();
            this.testManualFailoverFailback(cluster, conf, 0);
            this.testManualFailoverFailback(cluster, conf, 1);
        }
        finally {
            cluster.shutdown();
        }
    }

    @Test(timeout=300000L)
    public void testFailoverWithEmptyInProgressEditLog() throws Exception {
        TestHAStateTransitions.testFailoverAfterCrashDuringLogRoll(false);
    }

    @Test(timeout=300000L)
    public void testFailoverWithEmptyInProgressEditLogWithHeader() throws Exception {
        TestHAStateTransitions.testFailoverAfterCrashDuringLogRoll(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void testFailoverAfterCrashDuringLogRoll(boolean writeHeader) throws Exception {
        Configuration conf = new Configuration();
        conf.setInt("dfs.ha.tail-edits.period", Integer.MAX_VALUE);
        MiniDFSCluster cluster = new MiniDFSCluster.Builder(conf).nnTopology(MiniDFSNNTopology.simpleHATopology()).numDataNodes(0).build();
        DistributedFileSystem fs = HATestUtil.configureFailoverFs(cluster, conf);
        try {
            cluster.transitionToActive(0);
            NameNode nn0 = cluster.getNameNode(0);
            nn0.getRpcServer().rollEditLog();
            cluster.shutdownNameNode(0);
            TestHAStateTransitions.createEmptyInProgressEditLog(cluster, nn0, writeHeader);
            cluster.transitionToActive(1);
        }
        catch (Throwable throwable) {
            IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{fs});
            cluster.shutdown();
            throw throwable;
        }
        IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{fs});
        cluster.shutdown();
    }

    private static void createEmptyInProgressEditLog(MiniDFSCluster cluster, NameNode nn, boolean writeHeader) throws IOException {
        long txid = nn.getNamesystem().getEditLog().getLastWrittenTxId();
        URI sharedEditsUri = cluster.getSharedEditsDir(0, 1);
        File sharedEditsDir = new File(sharedEditsUri.getPath());
        Storage.StorageDirectory storageDir = new Storage.StorageDirectory(sharedEditsDir);
        File inProgressFile = NameNodeAdapter.getInProgressEditsFile(storageDir, txid + 1L);
        Assert.assertTrue((String)"Failed to create in-progress edits file", (boolean)inProgressFile.createNewFile());
        if (writeHeader) {
            DataOutputStream out = new DataOutputStream(new FileOutputStream(inProgressFile));
            EditLogFileOutputStream.writeHeader((int)NameNodeLayoutVersion.CURRENT_LAYOUT_VERSION, (DataOutputStream)out);
            out.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=60000L)
    public void testSecretManagerState() throws Exception {
        Configuration conf = new Configuration();
        conf.setBoolean("dfs.namenode.delegation.token.always-use", true);
        conf.setInt("dfs.namenode.delegation.key.update-interval", 50);
        conf.setInt("dfs.blocksize", 1024);
        MiniDFSCluster cluster = new MiniDFSCluster.Builder(conf).nnTopology(MiniDFSNNTopology.simpleHATopology()).numDataNodes(1).waitSafeMode(false).build();
        try {
            cluster.transitionToActive(0);
            DFSTestUtil.createFile((FileSystem)cluster.getFileSystem(0), TEST_FILE_PATH, 6000L, (short)1, 1L);
            cluster.getConfiguration(0).setInt("dfs.namenode.safemode.extension", 60000);
            cluster.restartNameNode(0);
            NameNode nn = cluster.getNameNode(0);
            TestHAStateTransitions.banner("Started in state 1.");
            Assert.assertTrue((boolean)nn.isStandbyState());
            Assert.assertTrue((boolean)nn.isInSafeMode());
            Assert.assertFalse((boolean)this.isDTRunning(nn));
            TestHAStateTransitions.banner("Transition 1->2. Should not start secret manager");
            NameNodeAdapter.leaveSafeMode(nn);
            Assert.assertTrue((boolean)nn.isStandbyState());
            Assert.assertFalse((boolean)nn.isInSafeMode());
            Assert.assertFalse((boolean)this.isDTRunning(nn));
            TestHAStateTransitions.banner("Transition 2->1. Should not start secret manager.");
            NameNodeAdapter.enterSafeMode(nn, false);
            Assert.assertTrue((boolean)nn.isStandbyState());
            Assert.assertTrue((boolean)nn.isInSafeMode());
            Assert.assertFalse((boolean)this.isDTRunning(nn));
            TestHAStateTransitions.banner("Transition 1->3. Should not start secret manager.");
            nn.getRpcServer().transitionToActive(REQ_INFO);
            Assert.assertFalse((boolean)nn.isStandbyState());
            Assert.assertTrue((boolean)nn.isInSafeMode());
            Assert.assertFalse((boolean)this.isDTRunning(nn));
            TestHAStateTransitions.banner("Transition 3->1. Should not start secret manager.");
            nn.getRpcServer().transitionToStandby(REQ_INFO);
            Assert.assertTrue((boolean)nn.isStandbyState());
            Assert.assertTrue((boolean)nn.isInSafeMode());
            Assert.assertFalse((boolean)this.isDTRunning(nn));
            TestHAStateTransitions.banner("Transition 1->3->4. Should start secret manager.");
            nn.getRpcServer().transitionToActive(REQ_INFO);
            NameNodeAdapter.leaveSafeMode(nn);
            Assert.assertFalse((boolean)nn.isStandbyState());
            Assert.assertFalse((boolean)nn.isInSafeMode());
            Assert.assertTrue((boolean)this.isDTRunning(nn));
            TestHAStateTransitions.banner("Transition 4->3. Should stop secret manager");
            NameNodeAdapter.enterSafeMode(nn, false);
            Assert.assertFalse((boolean)nn.isStandbyState());
            Assert.assertTrue((boolean)nn.isInSafeMode());
            Assert.assertFalse((boolean)this.isDTRunning(nn));
            TestHAStateTransitions.banner("Transition 3->4. Should start secret manager");
            NameNodeAdapter.leaveSafeMode(nn);
            Assert.assertFalse((boolean)nn.isStandbyState());
            Assert.assertFalse((boolean)nn.isInSafeMode());
            Assert.assertTrue((boolean)this.isDTRunning(nn));
            for (int i = 0; i < 20; ++i) {
                TestHAStateTransitions.banner("Transition 4->2. Should stop secret manager.");
                nn.getRpcServer().transitionToStandby(REQ_INFO);
                Assert.assertTrue((boolean)nn.isStandbyState());
                Assert.assertFalse((boolean)nn.isInSafeMode());
                Assert.assertFalse((boolean)this.isDTRunning(nn));
                TestHAStateTransitions.banner("Transition 2->4. Should start secret manager");
                nn.getRpcServer().transitionToActive(REQ_INFO);
                Assert.assertFalse((boolean)nn.isStandbyState());
                Assert.assertFalse((boolean)nn.isInSafeMode());
                Assert.assertTrue((boolean)this.isDTRunning(nn));
            }
        }
        finally {
            cluster.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=300000L)
    public void testIsAtLeastOneActive() throws Exception {
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)new HdfsConfiguration()).nnTopology(MiniDFSNNTopology.simpleHATopology()).numDataNodes(0).build();
        try {
            HdfsConfiguration conf = new HdfsConfiguration();
            HATestUtil.setFailoverConfigurations(cluster, (Configuration)conf);
            List namenodes = HAUtil.getProxiesForAllNameNodesInNameservice((Configuration)conf, (String)HATestUtil.getLogicalHostname(cluster));
            Assert.assertEquals((long)2L, (long)namenodes.size());
            Assert.assertFalse((boolean)HAUtil.isAtLeastOneActive((List)namenodes));
            cluster.transitionToActive(0);
            Assert.assertTrue((boolean)HAUtil.isAtLeastOneActive((List)namenodes));
            cluster.transitionToStandby(0);
            Assert.assertFalse((boolean)HAUtil.isAtLeastOneActive((List)namenodes));
            cluster.transitionToActive(1);
            Assert.assertTrue((boolean)HAUtil.isAtLeastOneActive((List)namenodes));
            cluster.transitionToStandby(1);
            Assert.assertFalse((boolean)HAUtil.isAtLeastOneActive((List)namenodes));
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    private boolean isDTRunning(NameNode nn) {
        return NameNodeAdapter.getDtSecretManager(nn.getNamesystem()).isRunning();
    }

    static void banner(String string) {
        LOG.info("\n\n\n\n================================================\n" + string + "\n==================================================\n\n");
    }

    static {
        GenericTestUtils.setLogLevel((Logger)EditLogTailer.LOG, (Level)Level.TRACE);
    }
}

