/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode.ha;

import java.io.IOException;
import java.util.EnumSet;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.CreateFlag;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.protocol.LocatedBlock;
import org.apache.hadoop.hdfs.qjournal.MiniQJMHACluster;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockInfo;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeManager;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeStorageInfo;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.namenode.INodeFile;
import org.apache.hadoop.hdfs.server.namenode.NameNodeAdapter;
import org.apache.hadoop.hdfs.server.protocol.NamenodeProtocols;
import org.apache.hadoop.hdfs.server.protocol.ReceivedDeletedBlockInfo;
import org.apache.hadoop.hdfs.server.protocol.StorageReceivedDeletedBlocks;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestUpdateBlockTailing {
    private static final int BLOCK_SIZE = 8192;
    private static final String TEST_DIR = "/TestUpdateBlockTailing";
    private static MiniQJMHACluster qjmhaCluster;
    private static MiniDFSCluster dfsCluster;
    private static DistributedFileSystem dfs;
    private static FSNamesystem fsn0;
    private static FSNamesystem fsn1;
    private static DataNode dn0;

    @BeforeClass
    public static void startUpCluster() throws Exception {
        Configuration conf = new Configuration();
        conf.setBoolean("dfs.ha.tail-edits.in-progress", true);
        MiniQJMHACluster.Builder qjmBuilder = new MiniQJMHACluster.Builder(conf).setNumNameNodes(2);
        qjmBuilder.getDfsBuilder().numDataNodes(1);
        qjmhaCluster = qjmBuilder.build();
        dfsCluster = qjmhaCluster.getDfsCluster();
        dfsCluster.waitActive();
        dfsCluster.transitionToActive(0);
        dfs = dfsCluster.getFileSystem(0);
        fsn0 = dfsCluster.getNameNode(0).getNamesystem();
        fsn1 = dfsCluster.getNameNode(1).getNamesystem();
        dfs.mkdirs(new Path(TEST_DIR), new FsPermission("755"));
        dn0 = dfsCluster.getDataNodes().get(0);
    }

    @AfterClass
    public static void shutDownCluster() throws IOException {
        if (qjmhaCluster != null) {
            qjmhaCluster.shutdown();
        }
    }

    @Before
    public void reset() throws Exception {
        dfsCluster.transitionToStandby(1);
        dfsCluster.transitionToActive(0);
    }

    @Test
    public void testStandbyAddBlockIBRRace() throws Exception {
        String testFile = "/TestUpdateBlockTailing/testStandbyAddBlockIBRRace";
        Assert.assertEquals((String)"Global Generation stamps on NNs should be the same", (long)NameNodeAdapter.getGenerationStamp(fsn0), (long)NameNodeAdapter.getGenerationStamp(fsn1));
        dfs.create(new Path(testFile), true, dfs.getConf().getInt("io.file.buffer.size", 4096), (short)1, 8192L);
        DatanodeManager dnManager = fsn0.getBlockManager().getDatanodeManager();
        DatanodeStorageInfo[] targets = dnManager.getDatanode(dn0.getDatanodeId()).getStorageInfos();
        targets = new DatanodeStorageInfo[]{targets[0]};
        BlockInfo newBlock = NameNodeAdapter.addBlockNoJournal(fsn0, testFile, targets);
        fsn0.getEditLog().logSync();
        fsn1.getEditLogTailer().doTailEdits();
        Assert.assertEquals((String)"Global Generation stamps on NN0 and impending on NN1 should be equal", (long)NameNodeAdapter.getGenerationStamp(fsn0), (long)NameNodeAdapter.getImpendingGenerationStamp(fsn1));
        StorageReceivedDeletedBlocks[] report = DFSTestUtil.makeReportForReceivedBlock((Block)newBlock, ReceivedDeletedBlockInfo.BlockStatus.RECEIVED_BLOCK, dn0.getFSDataset().getStorage(targets[0].getStorageID()));
        fsn1.processIncrementalBlockReport(dn0.getDatanodeId(), report[0]);
        INodeFile file = (INodeFile)fsn0.getFSDirectory().getINode(testFile);
        NameNodeAdapter.persistBlocks(fsn0, testFile, file);
        fsn0.getEditLog().logSync();
        fsn1.getEditLogTailer().doTailEdits();
        Assert.assertEquals((String)"Global Generation stamps on NN0 and impending on NN1 should be equal", (long)NameNodeAdapter.getGenerationStamp(fsn0), (long)NameNodeAdapter.getImpendingGenerationStamp(fsn1));
        BlockInfo newBlock1 = NameNodeAdapter.getStoredBlock(fsn1, (Block)newBlock);
        Assert.assertTrue((String)"New block on NN1 should contain the replica", (boolean)newBlock1.getStorageInfos().hasNext());
        Assert.assertEquals((String)"Generation stamps of the block on NNs should be the same", (long)newBlock.getGenerationStamp(), (long)newBlock1.getGenerationStamp());
        Assert.assertEquals((String)"Global Generation stamps on NNs should be the same", (long)NameNodeAdapter.getGenerationStamp(fsn0), (long)NameNodeAdapter.getGenerationStamp(fsn1));
        NamenodeProtocols rpc0 = dfsCluster.getNameNode(0).getRpcServer();
        NamenodeProtocols rpc1 = dfsCluster.getNameNode(1).getRpcServer();
        LocatedBlock lb = rpc0.getBlockLocations(testFile, 0L, 0L).get(0);
        rpc0.updateBlockForPipeline(lb.getBlock(), dfs.getClient().getClientName());
        long gs0 = NameNodeAdapter.getGenerationStamp(fsn0);
        dfsCluster.transitionToStandby(0);
        dfsCluster.transitionToActive(1);
        Assert.assertEquals((String)"Global Generation stamps on new active should be the same as on the old one", (long)gs0, (long)NameNodeAdapter.getGenerationStamp(fsn1));
        rpc1.delete(testFile, false);
    }

    @Test
    public void testStandbyAppendBlock() throws Exception {
        String testFile = "/TestUpdateBlockTailing/testStandbyAppendBlock";
        long fileLen = 65536L;
        DFSTestUtil.createFile((FileSystem)dfs, new Path("/TestUpdateBlockTailing/testStandbyAppendBlock"), 65536L, (short)1, 0L);
        fsn0.getEditLog().logSync();
        fsn1.getEditLogTailer().doTailEdits();
        Assert.assertEquals((String)"Global Generation stamps on NN0 and NN1 should be equal", (long)NameNodeAdapter.getGenerationStamp(fsn0), (long)NameNodeAdapter.getGenerationStamp(fsn1));
        try (FSDataOutputStream out = dfs.append(new Path("/TestUpdateBlockTailing/testStandbyAppendBlock"));){
            byte[] data = new byte[65536];
            ThreadLocalRandom.current().nextBytes(data);
            out.write(data);
        }
        fsn0.getEditLog().logSync();
        fsn1.getEditLogTailer().doTailEdits();
        Assert.assertEquals((String)"Global Generation stamps on NN0 and NN1 should be equal", (long)NameNodeAdapter.getGenerationStamp(fsn0), (long)NameNodeAdapter.getGenerationStamp(fsn1));
        NamenodeProtocols rpc0 = dfsCluster.getNameNode(0).getRpcServer();
        rpc0.delete("/TestUpdateBlockTailing/testStandbyAppendBlock", false);
    }

    @Test
    public void testStandbyAppendNewBlock() throws Exception {
        String testFile = "/TestUpdateBlockTailing/testStandbyAppendNewBlock";
        long fileLen = 65536L;
        DFSTestUtil.createFile((FileSystem)dfs, new Path("/TestUpdateBlockTailing/testStandbyAppendNewBlock"), 65536L, (short)1, 0L);
        fsn0.getEditLog().logSync();
        fsn1.getEditLogTailer().doTailEdits();
        Assert.assertEquals((String)"Global Generation stamps on NN0 and NN1 should be equal", (long)NameNodeAdapter.getGenerationStamp(fsn0), (long)NameNodeAdapter.getGenerationStamp(fsn1));
        try (FSDataOutputStream out = dfs.append(new Path("/TestUpdateBlockTailing/testStandbyAppendNewBlock"), EnumSet.of(CreateFlag.APPEND, CreateFlag.NEW_BLOCK), 4096, null);){
            byte[] data = new byte[65536];
            ThreadLocalRandom.current().nextBytes(data);
            out.write(data);
        }
        fsn0.getEditLog().logSync();
        fsn1.getEditLogTailer().doTailEdits();
        Assert.assertEquals((String)"Global Generation stamps on NN0 and NN1 should be equal", (long)NameNodeAdapter.getGenerationStamp(fsn0), (long)NameNodeAdapter.getGenerationStamp(fsn1));
        NamenodeProtocols rpc0 = dfsCluster.getNameNode(0).getRpcServer();
        rpc0.delete("/TestUpdateBlockTailing/testStandbyAppendNewBlock", false);
    }

    @Test
    public void testStandbyTruncateBlock() throws Exception {
        String testFile = "/TestUpdateBlockTailing/testStandbyTruncateBlock";
        long fileLen = 65536L;
        DFSTestUtil.createFile((FileSystem)dfs, new Path("/TestUpdateBlockTailing/testStandbyTruncateBlock"), 65536L, (short)1, 0L);
        fsn0.getEditLog().logSync();
        fsn1.getEditLogTailer().doTailEdits();
        Assert.assertEquals((String)"Global Generation stamps on NN0 and NN1 should be equal", (long)NameNodeAdapter.getGenerationStamp(fsn0), (long)NameNodeAdapter.getGenerationStamp(fsn1));
        dfs.truncate(new Path("/TestUpdateBlockTailing/testStandbyTruncateBlock"), 32768L);
        fsn0.getEditLog().logSync();
        fsn1.getEditLogTailer().doTailEdits();
        Assert.assertEquals((String)"Global Generation stamps on NN0 and NN1 should be equal", (long)NameNodeAdapter.getGenerationStamp(fsn0), (long)NameNodeAdapter.getGenerationStamp(fsn1));
        NamenodeProtocols rpc0 = dfsCluster.getNameNode(0).getRpcServer();
        rpc0.delete("/TestUpdateBlockTailing/testStandbyTruncateBlock", false);
    }
}

