/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.balancer;

import java.net.URI;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.MiniDFSNNTopology;
import org.apache.hadoop.hdfs.NameNodeProxies;
import org.apache.hadoop.hdfs.protocol.ClientProtocol;
import org.apache.hadoop.hdfs.server.balancer.Balancer;
import org.apache.hadoop.hdfs.server.balancer.BalancerParameters;
import org.apache.hadoop.hdfs.server.balancer.TestBalancer;
import org.apache.hadoop.hdfs.server.namenode.ha.HATestUtil;
import org.apache.hadoop.test.GenericTestUtils;
import org.junit.Assert;
import org.junit.Test;

public class TestBalancerService {
    private MiniDFSCluster cluster;
    private ClientProtocol client;
    private long totalUsedSpace;
    private static final String[] TEST_RACKS = new String[]{"/rack0", "/rack1"};
    private static final long[] TEST_CAPACITIES = new long[]{5000L, 5000L};
    private static final double USED = 0.3;

    private void setupCluster(Configuration conf) throws Exception {
        MiniDFSNNTopology.NNConf nn1Conf = new MiniDFSNNTopology.NNConf("nn1");
        nn1Conf.setIpcPort(8020);
        Configuration copiedConf = new Configuration(conf);
        conf.setInt("dfs.client.failover.max.attempts", 2);
        conf.setInt("dfs.client.failover.sleep.base.millis", 0);
        this.cluster = new MiniDFSCluster.Builder(copiedConf).nnTopology(MiniDFSNNTopology.simpleHATopology()).numDataNodes(TEST_CAPACITIES.length).racks(TEST_RACKS).simulatedCapacities(TEST_CAPACITIES).build();
        HATestUtil.setFailoverConfigurations(this.cluster, conf);
        this.cluster.waitActive();
        this.cluster.transitionToActive(0);
        this.client = (ClientProtocol)NameNodeProxies.createProxy((Configuration)conf, (URI)FileSystem.getDefaultUri((Configuration)conf), ClientProtocol.class).getProxy();
        int numOfDatanodes = TEST_CAPACITIES.length;
        long totalCapacity = TestBalancer.sum(TEST_CAPACITIES);
        this.totalUsedSpace = (long)((double)totalCapacity * 0.3);
        TestBalancer.createFile(this.cluster, TestBalancer.filePath, this.totalUsedSpace / (long)numOfDatanodes, (short)numOfDatanodes, 0);
    }

    private long addOneDataNode(Configuration conf) throws Exception {
        this.cluster.startDataNodes(conf, 1, true, null, new String[]{"/rack2"}, new long[]{5000L});
        long totalCapacity = (long)this.cluster.getDataNodes().size() * 5000L;
        TestBalancer.waitForHeartBeat(this.totalUsedSpace, totalCapacity, this.client, this.cluster);
        return totalCapacity;
    }

    private Thread newBalancerService(final Configuration conf, final String[] args) {
        return new Thread(new Runnable(){

            @Override
            public void run() {
                Balancer.Cli cli = new Balancer.Cli();
                cli.setConf(conf);
                try {
                    cli.run(args);
                }
                catch (Exception e) {
                    Assert.fail((String)("balancer failed for " + e));
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=60000L)
    public void testBalancerServiceBalanceTwice() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.setTimeDuration("dfs.balancer.service.interval", 5L, TimeUnit.SECONDS);
        TestBalancer.initConf((Configuration)conf);
        try {
            this.setupCluster((Configuration)conf);
            long totalCapacity = this.addOneDataNode((Configuration)conf);
            Thread balancerThread = this.newBalancerService((Configuration)conf, new String[]{"-asService"});
            balancerThread.start();
            TestBalancer.waitForBalancer(this.totalUsedSpace, totalCapacity, this.client, this.cluster, BalancerParameters.DEFAULT);
            this.cluster.triggerHeartbeats();
            this.cluster.triggerBlockReports();
            totalCapacity = this.addOneDataNode((Configuration)conf);
            TestBalancer.waitForBalancer(this.totalUsedSpace, totalCapacity, this.client, this.cluster, BalancerParameters.DEFAULT);
            Balancer.stop();
            balancerThread.join();
        }
        finally {
            if (this.cluster != null) {
                this.cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=60000L)
    public void testBalancerServiceOnError() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.setTimeDuration("dfs.balancer.service.interval", 5L, TimeUnit.SECONDS);
        conf.setInt("ipc.client.connect.max.retries", 1);
        TestBalancer.initConf((Configuration)conf);
        try {
            this.setupCluster((Configuration)conf);
            Thread balancerThread = this.newBalancerService((Configuration)conf, new String[]{"-asService"});
            balancerThread.start();
            this.cluster.shutdownNameNode(0);
            GenericTestUtils.waitFor(() -> Balancer.getExceptionsSinceLastBalance() > 0, (long)1000L, (long)10000L);
            Assert.assertTrue((Balancer.getExceptionsSinceLastBalance() > 0 ? 1 : 0) != 0);
            this.cluster.restartNameNode(0);
            this.cluster.transitionToActive(0);
            this.cluster.waitActive();
            long totalCapacity = this.addOneDataNode((Configuration)conf);
            TestBalancer.waitForBalancer(this.totalUsedSpace, totalCapacity, this.client, this.cluster, BalancerParameters.DEFAULT);
            Balancer.stop();
            balancerThread.join();
            Assert.assertEquals((long)Balancer.getExceptionsSinceLastBalance(), (long)0L);
        }
        finally {
            if (this.cluster != null) {
                this.cluster.shutdown();
            }
        }
    }

    static {
        TestBalancer.initTestSetup();
    }
}

