/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.TestFileCreation;
import org.apache.hadoop.hdfs.server.namenode.FSEditLog;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.slf4j.event.Level;

public class TestRenameWhileOpen {
    public TestRenameWhileOpen() {
        DFSTestUtil.setNameNodeLogLevel(Level.TRACE);
    }

    private static void checkFullFile(FileSystem fs, Path p) throws IOException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testWhileOpenRenameParent() throws IOException {
        HdfsConfiguration conf = new HdfsConfiguration();
        int MAX_IDLE_TIME = 2000;
        conf.setInt("ipc.client.connection.maxidletime", 2000);
        conf.setInt("dfs.namenode.heartbeat.recheck-interval", 1000);
        conf.setInt("dfs.heartbeat.interval", 1);
        conf.setInt("dfs.namenode.safemode.threshold-pct", 1);
        conf.setInt("dfs.blocksize", 8192);
        System.out.println("Test 1*****************************");
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).build();
        DistributedFileSystem fs = null;
        try {
            cluster.waitActive();
            fs = cluster.getFileSystem();
            FSEditLog spyLog = (FSEditLog)Mockito.spy((Object)cluster.getNameNode().getFSImage().getEditLog());
            ((FSEditLog)Mockito.doNothing().when((Object)spyLog)).endCurrentLogSegment(Mockito.anyBoolean());
            DFSTestUtil.setEditLogForTesting(cluster.getNamesystem(), spyLog);
            Path dir1 = new Path("/user/a+b/dir1");
            Path file1 = new Path(dir1, "file1");
            FSDataOutputStream stm1 = TestFileCreation.createFile((FileSystem)fs, file1, 1);
            System.out.println("testFileCreationDeleteParent: Created file " + file1);
            TestFileCreation.writeFile(stm1);
            stm1.hflush();
            Path dir2 = new Path("/user/dir2");
            Path file2 = new Path(dir2, "file2");
            FSDataOutputStream stm2 = TestFileCreation.createFile((FileSystem)fs, file2, 1);
            System.out.println("testFileCreationDeleteParent: Created file " + file2);
            TestFileCreation.writeFile(stm2);
            stm2.hflush();
            Path dir3 = new Path("/user/dir3");
            fs.mkdirs(dir3);
            fs.rename(dir1, dir3);
            Path file3 = new Path(dir3, "file3");
            FSDataOutputStream stm3 = fs.create(file3);
            fs.rename(file3, new Path(dir3, "bozo"));
            TestFileCreation.writeFile(stm3, 8193);
            stm3.hflush();
            cluster.getNameNode().stop();
            cluster.shutdown();
            try {
                Thread.sleep(4000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            cluster = new MiniDFSCluster.Builder((Configuration)conf).format(false).build();
            cluster.waitActive();
            cluster.shutdown();
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            cluster = new MiniDFSCluster.Builder((Configuration)conf).format(false).build();
            cluster.waitActive();
            fs = cluster.getFileSystem();
            Path newfile = new Path("/user/dir3/dir1", "file1");
            Assert.assertTrue((!fs.exists(file1) ? 1 : 0) != 0);
            Assert.assertTrue((boolean)fs.exists(file2));
            Assert.assertTrue((boolean)fs.exists(newfile));
            TestRenameWhileOpen.checkFullFile((FileSystem)fs, newfile);
        }
        finally {
            fs.close();
            cluster.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testWhileOpenRenameParentToNonexistentDir() throws IOException {
        HdfsConfiguration conf = new HdfsConfiguration();
        int MAX_IDLE_TIME = 2000;
        conf.setInt("ipc.client.connection.maxidletime", 2000);
        conf.setInt("dfs.namenode.heartbeat.recheck-interval", 1000);
        conf.setInt("dfs.heartbeat.interval", 1);
        conf.setInt("dfs.namenode.safemode.threshold-pct", 1);
        System.out.println("Test 2************************************");
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).build();
        DistributedFileSystem fs = null;
        try {
            cluster.waitActive();
            fs = cluster.getFileSystem();
            Path dir1 = new Path("/user/dir1");
            Path file1 = new Path(dir1, "file1");
            FSDataOutputStream stm1 = TestFileCreation.createFile((FileSystem)fs, file1, 1);
            System.out.println("testFileCreationDeleteParent: Created file " + file1);
            TestFileCreation.writeFile(stm1);
            stm1.hflush();
            Path dir2 = new Path("/user/dir2");
            Path file2 = new Path(dir2, "file2");
            FSDataOutputStream stm2 = TestFileCreation.createFile((FileSystem)fs, file2, 1);
            System.out.println("testFileCreationDeleteParent: Created file " + file2);
            TestFileCreation.writeFile(stm2);
            stm2.hflush();
            Path dir3 = new Path("/user/dir3");
            fs.rename(dir1, dir3);
            cluster.shutdown();
            try {
                Thread.sleep(4000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            cluster = new MiniDFSCluster.Builder((Configuration)conf).format(false).build();
            cluster.waitActive();
            cluster.shutdown();
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            cluster = new MiniDFSCluster.Builder((Configuration)conf).format(false).build();
            cluster.waitActive();
            fs = cluster.getFileSystem();
            Path newfile = new Path("/user/dir3", "file1");
            Assert.assertTrue((!fs.exists(file1) ? 1 : 0) != 0);
            Assert.assertTrue((boolean)fs.exists(file2));
            Assert.assertTrue((boolean)fs.exists(newfile));
            TestRenameWhileOpen.checkFullFile((FileSystem)fs, newfile);
        }
        finally {
            fs.close();
            cluster.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testWhileOpenRenameToExistentDirectory() throws IOException {
        HdfsConfiguration conf = new HdfsConfiguration();
        int MAX_IDLE_TIME = 2000;
        conf.setInt("ipc.client.connection.maxidletime", 2000);
        conf.setInt("dfs.namenode.heartbeat.recheck-interval", 1000);
        conf.setInt("dfs.heartbeat.interval", 1);
        conf.setInt("dfs.namenode.safemode.threshold-pct", 1);
        System.out.println("Test 3************************************");
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).build();
        DistributedFileSystem fs = null;
        try {
            cluster.waitActive();
            fs = cluster.getFileSystem();
            Path dir1 = new Path("/user/dir1");
            Path file1 = new Path(dir1, "file1");
            FSDataOutputStream stm1 = TestFileCreation.createFile((FileSystem)fs, file1, 1);
            System.out.println("testFileCreationDeleteParent: Created file " + file1);
            TestFileCreation.writeFile(stm1);
            stm1.hflush();
            Path dir2 = new Path("/user/dir2");
            fs.mkdirs(dir2);
            fs.rename(file1, dir2);
            cluster.shutdown();
            try {
                Thread.sleep(4000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            cluster = new MiniDFSCluster.Builder((Configuration)conf).format(false).build();
            cluster.waitActive();
            cluster.shutdown();
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            cluster = new MiniDFSCluster.Builder((Configuration)conf).format(false).build();
            cluster.waitActive();
            fs = cluster.getFileSystem();
            Path newfile = new Path("/user/dir2", "file1");
            Assert.assertTrue((!fs.exists(file1) ? 1 : 0) != 0);
            Assert.assertTrue((boolean)fs.exists(newfile));
            TestRenameWhileOpen.checkFullFile((FileSystem)fs, newfile);
        }
        finally {
            fs.close();
            cluster.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testWhileOpenRenameToNonExistentDirectory() throws IOException {
        HdfsConfiguration conf = new HdfsConfiguration();
        int MAX_IDLE_TIME = 2000;
        conf.setInt("ipc.client.connection.maxidletime", 2000);
        conf.setInt("dfs.namenode.heartbeat.recheck-interval", 1000);
        conf.setInt("dfs.heartbeat.interval", 1);
        conf.setInt("dfs.namenode.safemode.threshold-pct", 1);
        System.out.println("Test 4************************************");
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).build();
        DistributedFileSystem fs = null;
        try {
            cluster.waitActive();
            fs = cluster.getFileSystem();
            Path dir1 = new Path("/user/dir1");
            Path file1 = new Path(dir1, "file1");
            FSDataOutputStream stm1 = TestFileCreation.createFile((FileSystem)fs, file1, 1);
            System.out.println("testFileCreationDeleteParent: Created file " + file1);
            TestFileCreation.writeFile(stm1);
            stm1.hflush();
            Path dir2 = new Path("/user/dir2");
            fs.rename(file1, dir2);
            cluster.shutdown();
            try {
                Thread.sleep(4000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            cluster = new MiniDFSCluster.Builder((Configuration)conf).format(false).build();
            cluster.waitActive();
            cluster.shutdown();
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            cluster = new MiniDFSCluster.Builder((Configuration)conf).format(false).build();
            cluster.waitActive();
            fs = cluster.getFileSystem();
            Path newfile = new Path("/user", "dir2");
            Assert.assertTrue((!fs.exists(file1) ? 1 : 0) != 0);
            Assert.assertTrue((boolean)fs.exists(newfile));
            TestRenameWhileOpen.checkFullFile((FileSystem)fs, newfile);
        }
        finally {
            fs.close();
            cluster.shutdown();
        }
    }
}

