/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.protocol.HdfsConstants;
import org.apache.hadoop.hdfs.server.protocol.DatanodeStorageReport;
import org.apache.hadoop.hdfs.server.protocol.NamenodeProtocols;
import org.apache.hadoop.test.GenericTestUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestNameNodeRpcServerMethods {
    private static NamenodeProtocols nnRpc;
    private static Configuration conf;
    private static MiniDFSCluster cluster;

    @Before
    public void setup() throws Exception {
        conf = new HdfsConfiguration();
        cluster = new MiniDFSCluster.Builder(conf).build();
        cluster.waitActive();
        nnRpc = cluster.getNameNode().getRpcServer();
    }

    @After
    public void cleanup() throws IOException {
        if (cluster != null) {
            cluster.shutdown();
            cluster = null;
        }
    }

    @Test
    public void testDeleteSnapshotWhenSnapshotNameIsEmpty() throws Exception {
        String dir = "/testNamenodeRetryCache/testDelete";
        try {
            nnRpc.deleteSnapshot(dir, null);
            Assert.fail((String)"testdeleteSnapshot is not thrown expected exception ");
        }
        catch (IOException e) {
            GenericTestUtils.assertExceptionContains((String)"The snapshot name is null or empty.", (Throwable)e);
        }
        try {
            nnRpc.deleteSnapshot(dir, "");
            Assert.fail((String)"testdeleteSnapshot is not thrown expected exception");
        }
        catch (IOException e) {
            GenericTestUtils.assertExceptionContains((String)"The snapshot name is null or empty.", (Throwable)e);
        }
    }

    @Test
    public void testGetDatanodeStorageReportWithNumBLocksNotZero() throws Exception {
        DatanodeStorageReport[] reports;
        int buffSize = 1024;
        long blockSize = 0x100000L;
        String file = "/testFile";
        DistributedFileSystem dfs = cluster.getFileSystem();
        FSDataOutputStream outputStream = dfs.create(new Path(file), true, buffSize, (short)1, blockSize);
        byte[] outBuffer = new byte[buffSize];
        for (int i = 0; i < buffSize; ++i) {
            outBuffer[i] = (byte)(i & 0xFF);
        }
        outputStream.write(outBuffer);
        outputStream.close();
        int numBlocks = 0;
        for (DatanodeStorageReport r : reports = nnRpc.getDatanodeStorageReport(HdfsConstants.DatanodeReportType.ALL)) {
            numBlocks += r.getDatanodeInfo().getNumBlocks();
        }
        Assert.assertEquals((long)1L, (long)numBlocks);
    }
}

