/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.ReconfigurationException;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.MiniDFSNNTopology;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockManager;
import org.apache.hadoop.test.LambdaTestUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestRefreshNamenodeReplicationConfig {
    private MiniDFSCluster cluster = null;
    private BlockManager bm;

    @Before
    public void setup() throws IOException {
        Configuration config = new Configuration();
        config.setInt("dfs.namenode.replication.max-streams", 8);
        config.setInt("dfs.namenode.replication.max-streams-hard-limit", 10);
        config.setInt("dfs.namenode.replication.work.multiplier.per.iteration", 12);
        config.setInt("dfs.namenode.reconstruction.pending.timeout-sec", 300);
        this.cluster = new MiniDFSCluster.Builder(config).nnTopology(MiniDFSNNTopology.simpleSingleNN(0, 0)).numDataNodes(0).build();
        this.cluster.waitActive();
        this.bm = this.cluster.getNameNode().getNamesystem().getBlockManager();
    }

    @After
    public void teardown() throws IOException {
        this.cluster.shutdown();
    }

    @Test(timeout=90000L)
    public void testParamsCanBeReconfigured() throws ReconfigurationException {
        Assert.assertEquals((long)8L, (long)this.bm.getMaxReplicationStreams());
        Assert.assertEquals((long)10L, (long)this.bm.getReplicationStreamsHardLimit());
        Assert.assertEquals((long)12L, (long)this.bm.getBlocksReplWorkMultiplier());
        Assert.assertEquals((long)300L, (long)this.bm.getReconstructionPendingTimeout());
        this.cluster.getNameNode().reconfigurePropertyImpl("dfs.namenode.replication.max-streams", "20");
        this.cluster.getNameNode().reconfigurePropertyImpl("dfs.namenode.replication.max-streams-hard-limit", "22");
        this.cluster.getNameNode().reconfigurePropertyImpl("dfs.namenode.replication.work.multiplier.per.iteration", "24");
        this.cluster.getNameNode().reconfigurePropertyImpl("dfs.namenode.reconstruction.pending.timeout-sec", "180");
        Assert.assertEquals((long)20L, (long)this.bm.getMaxReplicationStreams());
        Assert.assertEquals((long)22L, (long)this.bm.getReplicationStreamsHardLimit());
        Assert.assertEquals((long)24L, (long)this.bm.getBlocksReplWorkMultiplier());
        Assert.assertEquals((long)180L, (long)this.bm.getReconstructionPendingTimeout());
    }

    @Test(timeout=90000L)
    public void testReconfigureFailsWithInvalidValues() throws Exception {
        ReconfigurationException e;
        String[] keys;
        for (String key : keys = new String[]{"dfs.namenode.replication.max-streams", "dfs.namenode.replication.max-streams-hard-limit", "dfs.namenode.replication.work.multiplier.per.iteration", "dfs.namenode.reconstruction.pending.timeout-sec"}) {
            e = (ReconfigurationException)LambdaTestUtils.intercept(ReconfigurationException.class, () -> this.cluster.getNameNode().reconfigurePropertyImpl(key, "-20"));
            Assert.assertTrue((boolean)(e.getCause() instanceof IllegalArgumentException));
            Assert.assertEquals((Object)(key + " = '-20' is invalid. It should be a positive, non-zero integer value."), (Object)e.getCause().getMessage());
        }
        Assert.assertEquals((long)8L, (long)this.bm.getMaxReplicationStreams());
        Assert.assertEquals((long)10L, (long)this.bm.getReplicationStreamsHardLimit());
        Assert.assertEquals((long)12L, (long)this.bm.getBlocksReplWorkMultiplier());
        Assert.assertEquals((long)300L, (long)this.bm.getReconstructionPendingTimeout());
        for (String key : keys) {
            e = (ReconfigurationException)LambdaTestUtils.intercept(ReconfigurationException.class, () -> this.cluster.getNameNode().reconfigurePropertyImpl(key, "0"));
            Assert.assertTrue((boolean)(e.getCause() instanceof IllegalArgumentException));
            Assert.assertEquals((Object)(key + " = '0' is invalid. It should be a positive, non-zero integer value."), (Object)e.getCause().getMessage());
        }
        Assert.assertEquals((long)8L, (long)this.bm.getMaxReplicationStreams());
        Assert.assertEquals((long)10L, (long)this.bm.getReplicationStreamsHardLimit());
        Assert.assertEquals((long)12L, (long)this.bm.getBlocksReplWorkMultiplier());
        Assert.assertEquals((long)300L, (long)this.bm.getReconstructionPendingTimeout());
        for (String key : keys) {
            e = (ReconfigurationException)LambdaTestUtils.intercept(ReconfigurationException.class, () -> this.cluster.getNameNode().reconfigurePropertyImpl(key, "str"));
            Assert.assertTrue((boolean)(e.getCause() instanceof NumberFormatException));
        }
        Assert.assertEquals((long)8L, (long)this.bm.getMaxReplicationStreams());
        Assert.assertEquals((long)10L, (long)this.bm.getReplicationStreamsHardLimit());
        Assert.assertEquals((long)12L, (long)this.bm.getBlocksReplWorkMultiplier());
        Assert.assertEquals((long)300L, (long)this.bm.getReconstructionPendingTimeout());
    }
}

