/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.ipc.ProtocolSignature;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.ipc.Server;
import org.apache.hadoop.ipc.VersionedProtocol;
import org.apache.hadoop.mapred.JVMId;
import org.apache.hadoop.mapred.JobID;
import org.apache.hadoop.mapred.JvmContext;
import org.apache.hadoop.mapred.JvmTask;
import org.apache.hadoop.mapred.MapTaskCompletionEventsUpdate;
import org.apache.hadoop.mapred.SortedRanges;
import org.apache.hadoop.mapred.Task;
import org.apache.hadoop.mapred.TaskAttemptID;
import org.apache.hadoop.mapred.TaskCompletionEvent;
import org.apache.hadoop.mapred.TaskStatus;
import org.apache.hadoop.mapred.TaskUmbilicalProtocol;
import org.apache.hadoop.mapred.WrappedJvmID;
import org.apache.hadoop.mapreduce.Counters;
import org.apache.hadoop.mapreduce.TypeConverter;
import org.apache.hadoop.mapreduce.counters.AbstractCounters;
import org.apache.hadoop.mapreduce.security.token.JobTokenSecretManager;
import org.apache.hadoop.mapreduce.v2.api.records.TaskAttemptCompletionEvent;
import org.apache.hadoop.mapreduce.v2.api.records.TaskAttemptId;
import org.apache.hadoop.mapreduce.v2.api.records.TaskType;
import org.apache.hadoop.mapreduce.v2.app.AppContext;
import org.apache.hadoop.mapreduce.v2.app.TaskAttemptListener;
import org.apache.hadoop.mapreduce.v2.app.TaskHeartbeatHandler;
import org.apache.hadoop.mapreduce.v2.app.job.Job;
import org.apache.hadoop.mapreduce.v2.app.job.event.TaskAttemptDiagnosticsUpdateEvent;
import org.apache.hadoop.mapreduce.v2.app.job.event.TaskAttemptEvent;
import org.apache.hadoop.mapreduce.v2.app.job.event.TaskAttemptEventType;
import org.apache.hadoop.mapreduce.v2.app.job.event.TaskAttemptStatusUpdateEvent;
import org.apache.hadoop.mapreduce.v2.app.security.authorize.MRAMPolicyProvider;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.authorize.PolicyProvider;
import org.apache.hadoop.security.token.SecretManager;
import org.apache.hadoop.yarn.YarnException;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.service.CompositeService;
import org.apache.hadoop.yarn.service.Service;

public class TaskAttemptListenerImpl
extends CompositeService
implements TaskUmbilicalProtocol,
TaskAttemptListener {
    private static final JvmTask TASK_FOR_INVALID_JVM = new JvmTask(null, true);
    private static final Log LOG = LogFactory.getLog(TaskAttemptListenerImpl.class);
    private AppContext context;
    private Server server;
    protected TaskHeartbeatHandler taskHeartbeatHandler;
    private InetSocketAddress address;
    private ConcurrentMap<WrappedJvmID, Task> jvmIDToActiveAttemptMap = new ConcurrentHashMap<WrappedJvmID, Task>();
    private Set<WrappedJvmID> launchedJVMs = Collections.newSetFromMap(new ConcurrentHashMap());
    private JobTokenSecretManager jobTokenSecretManager = null;

    public TaskAttemptListenerImpl(AppContext context, JobTokenSecretManager jobTokenSecretManager) {
        super(TaskAttemptListenerImpl.class.getName());
        this.context = context;
        this.jobTokenSecretManager = jobTokenSecretManager;
    }

    public void init(Configuration conf) {
        this.registerHeartbeatHandler(conf);
        super.init(conf);
    }

    public void start() {
        this.startRpcServer();
        super.start();
    }

    protected void registerHeartbeatHandler(Configuration conf) {
        this.taskHeartbeatHandler = new TaskHeartbeatHandler(this.context.getEventHandler(), this.context.getClock(), conf.getInt("yarn.app.mapreduce.am.job.task.listener.thread-count", 30));
        this.addService((Service)this.taskHeartbeatHandler);
    }

    protected void startRpcServer() {
        Configuration conf = this.getConfig();
        try {
            this.server = RPC.getServer(TaskUmbilicalProtocol.class, (Object)this, (String)"0.0.0.0", (int)0, (int)conf.getInt("yarn.app.mapreduce.am.job.task.listener.thread-count", 30), (boolean)false, (Configuration)conf, (SecretManager)this.jobTokenSecretManager);
            if (conf.getBoolean("hadoop.security.authorization", false)) {
                this.refreshServiceAcls(conf, new MRAMPolicyProvider());
            }
            this.server.start();
            InetSocketAddress listenerAddress = this.server.getListenerAddress();
            listenerAddress.getAddress();
            this.address = NetUtils.createSocketAddr((String)(InetAddress.getLocalHost().getCanonicalHostName() + ":" + listenerAddress.getPort()));
        }
        catch (IOException e) {
            throw new YarnException((Throwable)e);
        }
    }

    void refreshServiceAcls(Configuration configuration, PolicyProvider policyProvider) {
        this.server.refreshServiceAcl(configuration, policyProvider);
    }

    public void stop() {
        this.stopRpcServer();
        super.stop();
    }

    protected void stopRpcServer() {
        this.server.stop();
    }

    @Override
    public InetSocketAddress getAddress() {
        return this.address;
    }

    public boolean canCommit(TaskAttemptID taskAttemptID) throws IOException {
        LOG.info((Object)("Commit go/no-go request from " + taskAttemptID.toString()));
        TaskAttemptId attemptID = TypeConverter.toYarn((TaskAttemptID)taskAttemptID);
        this.taskHeartbeatHandler.receivedPing(attemptID);
        Job job = this.context.getJob(attemptID.getTaskId().getJobId());
        org.apache.hadoop.mapreduce.v2.app.job.Task task = job.getTask(attemptID.getTaskId());
        return task.canCommit(attemptID);
    }

    public void commitPending(TaskAttemptID taskAttemptID, TaskStatus taskStatsu) throws IOException, InterruptedException {
        LOG.info((Object)("Commit-pending state update from " + taskAttemptID.toString()));
        TaskAttemptId attemptID = TypeConverter.toYarn((TaskAttemptID)taskAttemptID);
        this.taskHeartbeatHandler.receivedPing(attemptID);
        this.context.getEventHandler().handle((Event)new TaskAttemptEvent(attemptID, TaskAttemptEventType.TA_COMMIT_PENDING));
    }

    public void done(TaskAttemptID taskAttemptID) throws IOException {
        LOG.info((Object)("Done acknowledgement from " + taskAttemptID.toString()));
        TaskAttemptId attemptID = TypeConverter.toYarn((TaskAttemptID)taskAttemptID);
        this.taskHeartbeatHandler.receivedPing(attemptID);
        this.context.getEventHandler().handle((Event)new TaskAttemptEvent(attemptID, TaskAttemptEventType.TA_DONE));
    }

    public void fatalError(TaskAttemptID taskAttemptID, String msg) throws IOException {
        LOG.fatal((Object)("Task: " + taskAttemptID + " - exited : " + msg));
        this.reportDiagnosticInfo(taskAttemptID, "Error: " + msg);
        TaskAttemptId attemptID = TypeConverter.toYarn((TaskAttemptID)taskAttemptID);
        this.context.getEventHandler().handle((Event)new TaskAttemptEvent(attemptID, TaskAttemptEventType.TA_FAILMSG));
    }

    public void fsError(TaskAttemptID taskAttemptID, String message) throws IOException {
        LOG.fatal((Object)("Task: " + taskAttemptID + " - failed due to FSError: " + message));
        this.reportDiagnosticInfo(taskAttemptID, "FSError: " + message);
        TaskAttemptId attemptID = TypeConverter.toYarn((TaskAttemptID)taskAttemptID);
        this.context.getEventHandler().handle((Event)new TaskAttemptEvent(attemptID, TaskAttemptEventType.TA_FAILMSG));
    }

    public void shuffleError(TaskAttemptID taskAttemptID, String message) throws IOException {
    }

    public MapTaskCompletionEventsUpdate getMapCompletionEvents(JobID jobIdentifier, int fromEventId, int maxEvents, TaskAttemptID taskAttemptID) throws IOException {
        LOG.info((Object)("MapCompletionEvents request from " + taskAttemptID.toString() + ". fromEventID " + fromEventId + " maxEvents " + maxEvents));
        boolean shouldReset = false;
        TaskAttemptId attemptID = TypeConverter.toYarn((TaskAttemptID)taskAttemptID);
        TaskAttemptCompletionEvent[] events = this.context.getJob(attemptID.getTaskId().getJobId()).getTaskAttemptCompletionEvents(fromEventId, maxEvents);
        this.taskHeartbeatHandler.receivedPing(attemptID);
        ArrayList<TaskCompletionEvent> mapEvents = new ArrayList<TaskCompletionEvent>();
        for (TaskAttemptCompletionEvent event : events) {
            if (!TaskType.MAP.equals((Object)event.getAttemptId().getTaskId().getTaskType())) continue;
            mapEvents.add(TypeConverter.fromYarn((TaskAttemptCompletionEvent)event));
        }
        return new MapTaskCompletionEventsUpdate(mapEvents.toArray(new TaskCompletionEvent[0]), shouldReset);
    }

    public boolean ping(TaskAttemptID taskAttemptID) throws IOException {
        LOG.info((Object)("Ping from " + taskAttemptID.toString()));
        this.taskHeartbeatHandler.receivedPing(TypeConverter.toYarn((TaskAttemptID)taskAttemptID));
        return true;
    }

    public void reportDiagnosticInfo(TaskAttemptID taskAttemptID, String diagnosticInfo) throws IOException {
        LOG.info((Object)("Diagnostics report from " + taskAttemptID.toString() + ": " + diagnosticInfo));
        TaskAttemptId attemptID = TypeConverter.toYarn((TaskAttemptID)taskAttemptID);
        this.taskHeartbeatHandler.receivedPing(attemptID);
        this.context.getEventHandler().handle((Event)new TaskAttemptDiagnosticsUpdateEvent(attemptID, diagnosticInfo));
    }

    public boolean statusUpdate(TaskAttemptID taskAttemptID, TaskStatus taskStatus) throws IOException, InterruptedException {
        LOG.info((Object)("Status update from " + taskAttemptID.toString()));
        TaskAttemptId yarnAttemptID = TypeConverter.toYarn((TaskAttemptID)taskAttemptID);
        this.taskHeartbeatHandler.receivedPing(yarnAttemptID);
        TaskAttemptStatusUpdateEvent.TaskAttemptStatus taskAttemptStatus = new TaskAttemptStatusUpdateEvent.TaskAttemptStatus();
        taskAttemptStatus.id = yarnAttemptID;
        taskAttemptStatus.progress = taskStatus.getProgress();
        LOG.info((Object)("Progress of TaskAttempt " + taskAttemptID + " is : " + taskStatus.getProgress()));
        taskAttemptStatus.stateString = taskStatus.getStateString();
        taskAttemptStatus.outputSize = taskStatus.getOutputSize();
        taskAttemptStatus.phase = TypeConverter.toYarn((TaskStatus.Phase)taskStatus.getPhase());
        taskAttemptStatus.counters = new Counters((AbstractCounters)taskStatus.getCounters());
        if (taskStatus.getIsMap() && taskStatus.getMapFinishTime() != 0L) {
            taskAttemptStatus.mapFinishTime = taskStatus.getMapFinishTime();
        }
        if (!taskStatus.getIsMap() && taskStatus.getShuffleFinishTime() != 0L) {
            taskAttemptStatus.shuffleFinishTime = taskStatus.getShuffleFinishTime();
        }
        if (!taskStatus.getIsMap() && taskStatus.getSortFinishTime() != 0L) {
            taskAttemptStatus.sortFinishTime = taskStatus.getSortFinishTime();
        }
        if (taskStatus.getFetchFailedMaps() != null && taskStatus.getFetchFailedMaps().size() > 0) {
            taskAttemptStatus.fetchFailedMaps = new ArrayList<TaskAttemptId>();
            for (TaskAttemptID failedMapId : taskStatus.getFetchFailedMaps()) {
                taskAttemptStatus.fetchFailedMaps.add(TypeConverter.toYarn((TaskAttemptID)failedMapId));
            }
        }
        this.context.getEventHandler().handle((Event)new TaskAttemptStatusUpdateEvent(taskAttemptStatus.id, taskAttemptStatus));
        return true;
    }

    public long getProtocolVersion(String arg0, long arg1) throws IOException {
        return 19L;
    }

    public void reportNextRecordRange(TaskAttemptID taskAttemptID, SortedRanges.Range range) throws IOException {
        throw new IOException("Not yet implemented.");
    }

    public JvmTask getTask(JvmContext context) throws IOException {
        JVMId jvmId = context.jvmId;
        LOG.info((Object)("JVM with ID : " + jvmId + " asked for a task"));
        JvmTask jvmTask = null;
        WrappedJvmID wJvmID = new WrappedJvmID(jvmId.getJobId(), jvmId.isMap, jvmId.getId());
        if (!this.jvmIDToActiveAttemptMap.containsKey((Object)wJvmID)) {
            LOG.info((Object)("JVM with ID: " + jvmId + " is invalid and will be killed."));
            jvmTask = TASK_FOR_INVALID_JVM;
        } else if (!this.launchedJVMs.contains((Object)wJvmID)) {
            jvmTask = null;
            LOG.info((Object)("JVM with ID: " + jvmId + " asking for task before AM launch registered. Given null task"));
        } else {
            Task task = (Task)this.jvmIDToActiveAttemptMap.remove((Object)wJvmID);
            this.launchedJVMs.remove((Object)wJvmID);
            LOG.info((Object)("JVM with ID: " + jvmId + " given task: " + task.getTaskID()));
            jvmTask = new JvmTask(task, false);
        }
        return jvmTask;
    }

    @Override
    public void registerPendingTask(Task task, WrappedJvmID jvmID) {
        this.jvmIDToActiveAttemptMap.put(jvmID, task);
    }

    @Override
    public void registerLaunchedTask(TaskAttemptId attemptID, WrappedJvmID jvmId) {
        this.launchedJVMs.add(jvmId);
        this.taskHeartbeatHandler.register(attemptID);
    }

    @Override
    public void unregister(TaskAttemptId attemptID, WrappedJvmID jvmID) {
        this.launchedJVMs.remove((Object)jvmID);
        this.jvmIDToActiveAttemptMap.remove((Object)jvmID);
        this.taskHeartbeatHandler.unregister(attemptID);
    }

    public ProtocolSignature getProtocolSignature(String protocol, long clientVersion, int clientMethodsHash) throws IOException {
        return ProtocolSignature.getProtocolSignature((VersionedProtocol)this, (String)protocol, (long)clientVersion, (int)clientMethodsHash);
    }
}

