/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.v2.app;

import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.v2.api.records.TaskAttemptId;
import org.apache.hadoop.mapreduce.v2.app.job.event.TaskAttemptDiagnosticsUpdateEvent;
import org.apache.hadoop.mapreduce.v2.app.job.event.TaskAttemptEvent;
import org.apache.hadoop.mapreduce.v2.app.job.event.TaskAttemptEventType;
import org.apache.hadoop.yarn.Clock;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.event.EventHandler;
import org.apache.hadoop.yarn.service.AbstractService;

public class TaskHeartbeatHandler
extends AbstractService {
    private static final Log LOG = LogFactory.getLog(TaskHeartbeatHandler.class);
    private Thread lostTaskCheckerThread;
    private volatile boolean stopped;
    private int taskTimeOut = 300000;
    private int taskTimeOutCheckInterval = 30000;
    private final EventHandler eventHandler;
    private final Clock clock;
    private ConcurrentMap<TaskAttemptId, Long> runningAttempts;

    public TaskHeartbeatHandler(EventHandler eventHandler, Clock clock, int numThreads) {
        super("TaskHeartbeatHandler");
        this.eventHandler = eventHandler;
        this.clock = clock;
        this.runningAttempts = new ConcurrentHashMap<TaskAttemptId, Long>(16, 0.75f, numThreads);
    }

    public void init(Configuration conf) {
        super.init(conf);
        this.taskTimeOut = conf.getInt("mapreduce.task.timeout", 300000);
        this.taskTimeOutCheckInterval = conf.getInt("mapreduce.task.timeout.check-interval-ms", 30000);
    }

    public void start() {
        this.lostTaskCheckerThread = new Thread(new PingChecker());
        this.lostTaskCheckerThread.setName("TaskHeartbeatHandler PingChecker");
        this.lostTaskCheckerThread.start();
        super.start();
    }

    public void stop() {
        this.stopped = true;
        this.lostTaskCheckerThread.interrupt();
        super.stop();
    }

    public void receivedPing(TaskAttemptId attemptID) {
        this.runningAttempts.replace(attemptID, this.clock.getTime());
    }

    public void register(TaskAttemptId attemptID) {
        this.runningAttempts.put(attemptID, this.clock.getTime());
    }

    public void unregister(TaskAttemptId attemptID) {
        this.runningAttempts.remove(attemptID);
    }

    private class PingChecker
    implements Runnable {
        private PingChecker() {
        }

        @Override
        public void run() {
            while (!TaskHeartbeatHandler.this.stopped && !Thread.currentThread().isInterrupted()) {
                Iterator iterator = TaskHeartbeatHandler.this.runningAttempts.entrySet().iterator();
                long currentTime = TaskHeartbeatHandler.this.clock.getTime();
                while (iterator.hasNext()) {
                    Long taskTime;
                    Map.Entry entry = iterator.next();
                    if (currentTime <= (Long)entry.getValue() + (long)TaskHeartbeatHandler.this.taskTimeOut || (taskTime = (Long)TaskHeartbeatHandler.this.runningAttempts.get(entry.getKey())) == null || currentTime <= taskTime + (long)TaskHeartbeatHandler.this.taskTimeOut) continue;
                    iterator.remove();
                    TaskHeartbeatHandler.this.eventHandler.handle((Event)new TaskAttemptDiagnosticsUpdateEvent((TaskAttemptId)entry.getKey(), "AttemptID:" + ((TaskAttemptId)entry.getKey()).toString() + " Timed out after " + TaskHeartbeatHandler.this.taskTimeOut / 1000 + " secs"));
                    TaskHeartbeatHandler.this.eventHandler.handle((Event)new TaskAttemptEvent((TaskAttemptId)entry.getKey(), TaskAttemptEventType.TA_TIMED_OUT));
                }
                try {
                    Thread.sleep(TaskHeartbeatHandler.this.taskTimeOutCheckInterval);
                }
                catch (InterruptedException e) {
                    LOG.info((Object)"TaskHeartbeatHandler thread interrupted");
                    break;
                }
            }
        }
    }
}

