/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.v2.app.job.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.JobACLsManager;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.JobContextImpl;
import org.apache.hadoop.mapreduce.Counters;
import org.apache.hadoop.mapreduce.JobACL;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.JobID;
import org.apache.hadoop.mapreduce.JobStatus;
import org.apache.hadoop.mapreduce.OutputCommitter;
import org.apache.hadoop.mapreduce.TypeConverter;
import org.apache.hadoop.mapreduce.counters.AbstractCounters;
import org.apache.hadoop.mapreduce.jobhistory.HistoryEvent;
import org.apache.hadoop.mapreduce.jobhistory.JobFinishedEvent;
import org.apache.hadoop.mapreduce.jobhistory.JobHistoryEvent;
import org.apache.hadoop.mapreduce.jobhistory.JobHistoryParser;
import org.apache.hadoop.mapreduce.jobhistory.JobInfoChangeEvent;
import org.apache.hadoop.mapreduce.jobhistory.JobInitedEvent;
import org.apache.hadoop.mapreduce.jobhistory.JobSubmittedEvent;
import org.apache.hadoop.mapreduce.jobhistory.JobUnsuccessfulCompletionEvent;
import org.apache.hadoop.mapreduce.lib.chain.ChainMapper;
import org.apache.hadoop.mapreduce.lib.chain.ChainReducer;
import org.apache.hadoop.mapreduce.security.TokenCache;
import org.apache.hadoop.mapreduce.security.token.JobTokenIdentifier;
import org.apache.hadoop.mapreduce.security.token.JobTokenSecretManager;
import org.apache.hadoop.mapreduce.split.JobSplit;
import org.apache.hadoop.mapreduce.split.SplitMetaInfoReader;
import org.apache.hadoop.mapreduce.v2.api.records.AMInfo;
import org.apache.hadoop.mapreduce.v2.api.records.JobId;
import org.apache.hadoop.mapreduce.v2.api.records.JobReport;
import org.apache.hadoop.mapreduce.v2.api.records.JobState;
import org.apache.hadoop.mapreduce.v2.api.records.TaskAttemptCompletionEvent;
import org.apache.hadoop.mapreduce.v2.api.records.TaskAttemptCompletionEventStatus;
import org.apache.hadoop.mapreduce.v2.api.records.TaskAttemptId;
import org.apache.hadoop.mapreduce.v2.api.records.TaskId;
import org.apache.hadoop.mapreduce.v2.api.records.TaskState;
import org.apache.hadoop.mapreduce.v2.api.records.TaskType;
import org.apache.hadoop.mapreduce.v2.app.TaskAttemptListener;
import org.apache.hadoop.mapreduce.v2.app.job.Job;
import org.apache.hadoop.mapreduce.v2.app.job.Task;
import org.apache.hadoop.mapreduce.v2.app.job.event.JobCounterUpdateEvent;
import org.apache.hadoop.mapreduce.v2.app.job.event.JobDiagnosticsUpdateEvent;
import org.apache.hadoop.mapreduce.v2.app.job.event.JobEvent;
import org.apache.hadoop.mapreduce.v2.app.job.event.JobEventType;
import org.apache.hadoop.mapreduce.v2.app.job.event.JobFinishEvent;
import org.apache.hadoop.mapreduce.v2.app.job.event.JobTaskAttemptCompletedEvent;
import org.apache.hadoop.mapreduce.v2.app.job.event.JobTaskAttemptFetchFailureEvent;
import org.apache.hadoop.mapreduce.v2.app.job.event.JobTaskEvent;
import org.apache.hadoop.mapreduce.v2.app.job.event.TaskAttemptEvent;
import org.apache.hadoop.mapreduce.v2.app.job.event.TaskAttemptEventType;
import org.apache.hadoop.mapreduce.v2.app.job.event.TaskEvent;
import org.apache.hadoop.mapreduce.v2.app.job.event.TaskEventType;
import org.apache.hadoop.mapreduce.v2.app.job.impl.MapTaskImpl;
import org.apache.hadoop.mapreduce.v2.app.job.impl.ReduceTaskImpl;
import org.apache.hadoop.mapreduce.v2.app.metrics.MRAppMetrics;
import org.apache.hadoop.mapreduce.v2.util.MRApps;
import org.apache.hadoop.mapreduce.v2.util.MRBuilderUtils;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authorize.AccessControlList;
import org.apache.hadoop.security.token.SecretManager;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.yarn.Clock;
import org.apache.hadoop.yarn.YarnException;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.event.EventHandler;
import org.apache.hadoop.yarn.state.InvalidStateTransitonException;
import org.apache.hadoop.yarn.state.MultipleArcTransition;
import org.apache.hadoop.yarn.state.SingleArcTransition;
import org.apache.hadoop.yarn.state.StateMachine;
import org.apache.hadoop.yarn.state.StateMachineFactory;

public class JobImpl
implements Job,
EventHandler<JobEvent> {
    private static final TaskAttemptCompletionEvent[] EMPTY_TASK_ATTEMPT_COMPLETION_EVENTS = new TaskAttemptCompletionEvent[0];
    private static final Log LOG = LogFactory.getLog(JobImpl.class);
    private static final double MAX_ALLOWED_FETCH_FAILURES_FRACTION = 0.5;
    private static final int MAX_FETCH_FAILURES_NOTIFICATIONS = 3;
    private final ApplicationAttemptId applicationAttemptId;
    private final Clock clock;
    private final JobACLsManager aclsManager;
    private final String username;
    private final OutputCommitter committer;
    private final Map<JobACL, AccessControlList> jobACLs;
    private float setupWeight = 0.05f;
    private float cleanupWeight = 0.05f;
    private float mapWeight = 0.0f;
    private float reduceWeight = 0.0f;
    private final Map<TaskId, JobHistoryParser.TaskInfo> completedTasksFromPreviousRun;
    private final List<AMInfo> amInfos;
    private final Lock readLock;
    private final Lock writeLock;
    private final JobId jobId;
    private final String jobName;
    private final boolean newApiCommitter;
    private final JobID oldJobId;
    private final TaskAttemptListener taskAttemptListener;
    private final Object tasksSyncHandle = new Object();
    private final Set<TaskId> mapTasks = new LinkedHashSet<TaskId>();
    private final Set<TaskId> reduceTasks = new LinkedHashSet<TaskId>();
    private final EventHandler eventHandler;
    private final MRAppMetrics metrics;
    private final String userName;
    private final String queueName;
    private final long appSubmitTime;
    private boolean lazyTasksCopyNeeded = false;
    volatile Map<TaskId, Task> tasks = new LinkedHashMap<TaskId, Task>();
    private Counters jobCounters = new Counters();
    private Object fullCountersLock = new Object();
    private Counters fullCounters = null;
    private Counters finalMapCounters = null;
    private Counters finalReduceCounters = null;
    public JobConf conf;
    private FileSystem fs;
    private Path remoteJobSubmitDir;
    public Path remoteJobConfFile;
    private JobContext jobContext;
    private int allowedMapFailuresPercent = 0;
    private int allowedReduceFailuresPercent = 0;
    private List<TaskAttemptCompletionEvent> taskAttemptCompletionEvents;
    private final List<String> diagnostics = new ArrayList<String>();
    private final Map<TaskId, Integer> successAttemptCompletionEventNoMap = new HashMap<TaskId, Integer>();
    private final Map<TaskAttemptId, Integer> fetchFailuresMapping = new HashMap<TaskAttemptId, Integer>();
    private static final DiagnosticsUpdateTransition DIAGNOSTIC_UPDATE_TRANSITION = new DiagnosticsUpdateTransition();
    private static final InternalErrorTransition INTERNAL_ERROR_TRANSITION = new InternalErrorTransition();
    private static final TaskAttemptCompletedEventTransition TASK_ATTEMPT_COMPLETED_EVENT_TRANSITION = new TaskAttemptCompletedEventTransition();
    private static final CounterUpdateTransition COUNTER_UPDATE_TRANSITION = new CounterUpdateTransition();
    protected static final StateMachineFactory<JobImpl, JobState, JobEventType, JobEvent> stateMachineFactory = new StateMachineFactory((Enum)JobState.NEW).addTransition((Enum)JobState.NEW, (Enum)JobState.NEW, (Enum)JobEventType.JOB_DIAGNOSTIC_UPDATE, (SingleArcTransition)DIAGNOSTIC_UPDATE_TRANSITION).addTransition((Enum)JobState.NEW, (Enum)JobState.NEW, (Enum)JobEventType.JOB_COUNTER_UPDATE, (SingleArcTransition)COUNTER_UPDATE_TRANSITION).addTransition((Enum)JobState.NEW, EnumSet.of(JobState.INITED, JobState.FAILED), (Enum)JobEventType.JOB_INIT, (MultipleArcTransition)new InitTransition()).addTransition((Enum)JobState.NEW, (Enum)JobState.KILLED, (Enum)JobEventType.JOB_KILL, (SingleArcTransition)new KillNewJobTransition()).addTransition((Enum)JobState.NEW, (Enum)JobState.ERROR, (Enum)JobEventType.INTERNAL_ERROR, (SingleArcTransition)INTERNAL_ERROR_TRANSITION).addTransition((Enum)JobState.INITED, (Enum)JobState.INITED, (Enum)JobEventType.JOB_DIAGNOSTIC_UPDATE, (SingleArcTransition)DIAGNOSTIC_UPDATE_TRANSITION).addTransition((Enum)JobState.INITED, (Enum)JobState.INITED, (Enum)JobEventType.JOB_COUNTER_UPDATE, (SingleArcTransition)COUNTER_UPDATE_TRANSITION).addTransition((Enum)JobState.INITED, (Enum)JobState.RUNNING, (Enum)JobEventType.JOB_START, (SingleArcTransition)new StartTransition()).addTransition((Enum)JobState.INITED, (Enum)JobState.KILLED, (Enum)JobEventType.JOB_KILL, (SingleArcTransition)new KillInitedJobTransition()).addTransition((Enum)JobState.INITED, (Enum)JobState.ERROR, (Enum)JobEventType.INTERNAL_ERROR, (SingleArcTransition)INTERNAL_ERROR_TRANSITION).addTransition((Enum)JobState.RUNNING, (Enum)JobState.RUNNING, (Enum)JobEventType.JOB_TASK_ATTEMPT_COMPLETED, (SingleArcTransition)TASK_ATTEMPT_COMPLETED_EVENT_TRANSITION).addTransition((Enum)JobState.RUNNING, EnumSet.of(JobState.RUNNING, JobState.SUCCEEDED, JobState.FAILED), (Enum)JobEventType.JOB_TASK_COMPLETED, (MultipleArcTransition)new TaskCompletedTransition()).addTransition((Enum)JobState.RUNNING, EnumSet.of(JobState.RUNNING, JobState.SUCCEEDED, JobState.FAILED), (Enum)JobEventType.JOB_COMPLETED, (MultipleArcTransition)new JobNoTasksCompletedTransition()).addTransition((Enum)JobState.RUNNING, (Enum)JobState.KILL_WAIT, (Enum)JobEventType.JOB_KILL, (SingleArcTransition)new KillTasksTransition()).addTransition((Enum)JobState.RUNNING, (Enum)JobState.RUNNING, (Enum)JobEventType.JOB_MAP_TASK_RESCHEDULED, (SingleArcTransition)new MapTaskRescheduledTransition()).addTransition((Enum)JobState.RUNNING, (Enum)JobState.RUNNING, (Enum)JobEventType.JOB_DIAGNOSTIC_UPDATE, (SingleArcTransition)DIAGNOSTIC_UPDATE_TRANSITION).addTransition((Enum)JobState.RUNNING, (Enum)JobState.RUNNING, (Enum)JobEventType.JOB_COUNTER_UPDATE, (SingleArcTransition)COUNTER_UPDATE_TRANSITION).addTransition((Enum)JobState.RUNNING, (Enum)JobState.RUNNING, (Enum)JobEventType.JOB_TASK_ATTEMPT_FETCH_FAILURE, (SingleArcTransition)new TaskAttemptFetchFailureTransition()).addTransition((Enum)JobState.RUNNING, (Enum)JobState.ERROR, (Enum)JobEventType.INTERNAL_ERROR, (SingleArcTransition)INTERNAL_ERROR_TRANSITION).addTransition((Enum)JobState.KILL_WAIT, EnumSet.of(JobState.KILL_WAIT, JobState.KILLED), (Enum)JobEventType.JOB_TASK_COMPLETED, (MultipleArcTransition)new KillWaitTaskCompletedTransition()).addTransition((Enum)JobState.KILL_WAIT, (Enum)JobState.KILL_WAIT, (Enum)JobEventType.JOB_TASK_ATTEMPT_COMPLETED, (SingleArcTransition)TASK_ATTEMPT_COMPLETED_EVENT_TRANSITION).addTransition((Enum)JobState.KILL_WAIT, (Enum)JobState.KILL_WAIT, (Enum)JobEventType.JOB_DIAGNOSTIC_UPDATE, (SingleArcTransition)DIAGNOSTIC_UPDATE_TRANSITION).addTransition((Enum)JobState.KILL_WAIT, (Enum)JobState.KILL_WAIT, (Enum)JobEventType.JOB_COUNTER_UPDATE, (SingleArcTransition)COUNTER_UPDATE_TRANSITION).addTransition((Enum)JobState.KILL_WAIT, (Enum)JobState.ERROR, (Enum)JobEventType.INTERNAL_ERROR, (SingleArcTransition)INTERNAL_ERROR_TRANSITION).addTransition((Enum)JobState.KILL_WAIT, (Enum)JobState.KILL_WAIT, EnumSet.of(JobEventType.JOB_KILL, JobEventType.JOB_MAP_TASK_RESCHEDULED, JobEventType.JOB_TASK_ATTEMPT_FETCH_FAILURE)).addTransition((Enum)JobState.SUCCEEDED, (Enum)JobState.SUCCEEDED, (Enum)JobEventType.JOB_DIAGNOSTIC_UPDATE, (SingleArcTransition)DIAGNOSTIC_UPDATE_TRANSITION).addTransition((Enum)JobState.SUCCEEDED, (Enum)JobState.SUCCEEDED, (Enum)JobEventType.JOB_COUNTER_UPDATE, (SingleArcTransition)COUNTER_UPDATE_TRANSITION).addTransition((Enum)JobState.SUCCEEDED, (Enum)JobState.ERROR, (Enum)JobEventType.INTERNAL_ERROR, (SingleArcTransition)INTERNAL_ERROR_TRANSITION).addTransition((Enum)JobState.SUCCEEDED, (Enum)JobState.SUCCEEDED, EnumSet.of(JobEventType.JOB_KILL, JobEventType.JOB_TASK_ATTEMPT_FETCH_FAILURE)).addTransition((Enum)JobState.FAILED, (Enum)JobState.FAILED, (Enum)JobEventType.JOB_DIAGNOSTIC_UPDATE, (SingleArcTransition)DIAGNOSTIC_UPDATE_TRANSITION).addTransition((Enum)JobState.FAILED, (Enum)JobState.FAILED, (Enum)JobEventType.JOB_COUNTER_UPDATE, (SingleArcTransition)COUNTER_UPDATE_TRANSITION).addTransition((Enum)JobState.FAILED, (Enum)JobState.ERROR, (Enum)JobEventType.INTERNAL_ERROR, (SingleArcTransition)INTERNAL_ERROR_TRANSITION).addTransition((Enum)JobState.FAILED, (Enum)JobState.FAILED, EnumSet.of(JobEventType.JOB_KILL, JobEventType.JOB_TASK_ATTEMPT_FETCH_FAILURE)).addTransition((Enum)JobState.KILLED, (Enum)JobState.KILLED, (Enum)JobEventType.JOB_DIAGNOSTIC_UPDATE, (SingleArcTransition)DIAGNOSTIC_UPDATE_TRANSITION).addTransition((Enum)JobState.KILLED, (Enum)JobState.KILLED, (Enum)JobEventType.JOB_COUNTER_UPDATE, (SingleArcTransition)COUNTER_UPDATE_TRANSITION).addTransition((Enum)JobState.KILLED, (Enum)JobState.ERROR, (Enum)JobEventType.INTERNAL_ERROR, (SingleArcTransition)INTERNAL_ERROR_TRANSITION).addTransition((Enum)JobState.KILLED, (Enum)JobState.KILLED, EnumSet.of(JobEventType.JOB_KILL, JobEventType.JOB_TASK_ATTEMPT_FETCH_FAILURE)).addTransition((Enum)JobState.ERROR, (Enum)JobState.ERROR, EnumSet.of(JobEventType.JOB_INIT, new JobEventType[]{JobEventType.JOB_KILL, JobEventType.JOB_TASK_COMPLETED, JobEventType.JOB_TASK_ATTEMPT_COMPLETED, JobEventType.JOB_MAP_TASK_RESCHEDULED, JobEventType.JOB_DIAGNOSTIC_UPDATE, JobEventType.JOB_TASK_ATTEMPT_FETCH_FAILURE, JobEventType.INTERNAL_ERROR})).installTopology();
    private final StateMachine<JobState, JobEventType, JobEvent> stateMachine;
    private int numMapTasks;
    private int numReduceTasks;
    private int completedTaskCount = 0;
    private int succeededMapTaskCount = 0;
    private int succeededReduceTaskCount = 0;
    private int failedMapTaskCount = 0;
    private int failedReduceTaskCount = 0;
    private int killedMapTaskCount = 0;
    private int killedReduceTaskCount = 0;
    private long startTime;
    private long finishTime;
    private float setupProgress;
    private float mapProgress;
    private float reduceProgress;
    private float cleanupProgress;
    private boolean isUber = false;
    private Credentials fsTokens;
    private Token<JobTokenIdentifier> jobToken;
    private JobTokenSecretManager jobTokenSecretManager;

    public JobImpl(JobId jobId, ApplicationAttemptId applicationAttemptId, Configuration conf, EventHandler eventHandler, TaskAttemptListener taskAttemptListener, JobTokenSecretManager jobTokenSecretManager, Credentials fsTokenCredentials, Clock clock, Map<TaskId, JobHistoryParser.TaskInfo> completedTasksFromPreviousRun, MRAppMetrics metrics, OutputCommitter committer, boolean newApiCommitter, String userName, long appSubmitTime, List<AMInfo> amInfos) {
        this.applicationAttemptId = applicationAttemptId;
        this.jobId = jobId;
        this.jobName = conf.get("mapreduce.job.name", "<missing job name>");
        this.conf = new JobConf(conf);
        this.metrics = metrics;
        this.clock = clock;
        this.completedTasksFromPreviousRun = completedTasksFromPreviousRun;
        this.amInfos = amInfos;
        this.userName = userName;
        this.queueName = conf.get("mapreduce.job.queuename", "default");
        this.appSubmitTime = appSubmitTime;
        this.oldJobId = TypeConverter.fromYarn((JobId)jobId);
        this.newApiCommitter = newApiCommitter;
        this.taskAttemptListener = taskAttemptListener;
        this.eventHandler = eventHandler;
        ReentrantReadWriteLock readWriteLock = new ReentrantReadWriteLock();
        this.readLock = readWriteLock.readLock();
        this.writeLock = readWriteLock.writeLock();
        this.fsTokens = fsTokenCredentials;
        this.jobTokenSecretManager = jobTokenSecretManager;
        this.committer = committer;
        this.aclsManager = new JobACLsManager(conf);
        this.username = System.getProperty("user.name");
        this.jobACLs = this.aclsManager.constructJobACLs(conf);
        this.stateMachine = stateMachineFactory.make((Object)this);
    }

    protected StateMachine<JobState, JobEventType, JobEvent> getStateMachine() {
        return this.stateMachine;
    }

    @Override
    public JobId getID() {
        return this.jobId;
    }

    OutputCommitter getCommitter() {
        return this.committer;
    }

    EventHandler getEventHandler() {
        return this.eventHandler;
    }

    JobContext getJobContext() {
        return this.jobContext;
    }

    @Override
    public boolean checkAccess(UserGroupInformation callerUGI, JobACL jobOperation) {
        AccessControlList jobACL = this.jobACLs.get(jobOperation);
        return this.aclsManager.checkAccess(callerUGI, jobOperation, this.username, jobACL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Task getTask(TaskId taskID) {
        this.readLock.lock();
        try {
            Task task = this.tasks.get(taskID);
            return task;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getCompletedMaps() {
        this.readLock.lock();
        try {
            int n = this.succeededMapTaskCount + this.failedMapTaskCount + this.killedMapTaskCount;
            return n;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getCompletedReduces() {
        this.readLock.lock();
        try {
            int n = this.succeededReduceTaskCount + this.failedReduceTaskCount + this.killedReduceTaskCount;
            return n;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public boolean isUber() {
        return this.isUber;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Counters getAllCounters() {
        this.readLock.lock();
        try {
            JobState state = this.getState();
            if (state == JobState.ERROR || state == JobState.FAILED || state == JobState.KILLED || state == JobState.SUCCEEDED) {
                this.mayBeConstructFinalFullCounters();
                Counters counters = this.fullCounters;
                return counters;
            }
            Counters counters = new Counters();
            counters.incrAllCounters((AbstractCounters)this.jobCounters);
            Counters counters2 = JobImpl.incrTaskCounters(counters, this.tasks.values());
            return counters2;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public static Counters incrTaskCounters(Counters counters, Collection<Task> tasks) {
        for (Task task : tasks) {
            counters.incrAllCounters((AbstractCounters)task.getCounters());
        }
        return counters;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TaskAttemptCompletionEvent[] getTaskAttemptCompletionEvents(int fromEventId, int maxEvents) {
        TaskAttemptCompletionEvent[] events = EMPTY_TASK_ATTEMPT_COMPLETION_EVENTS;
        this.readLock.lock();
        try {
            if (this.taskAttemptCompletionEvents.size() > fromEventId) {
                int actualMax = Math.min(maxEvents, this.taskAttemptCompletionEvents.size() - fromEventId);
                events = this.taskAttemptCompletionEvents.subList(fromEventId, actualMax + fromEventId).toArray(events);
            }
            TaskAttemptCompletionEvent[] taskAttemptCompletionEventArray = events;
            return taskAttemptCompletionEventArray;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getDiagnostics() {
        this.readLock.lock();
        try {
            List<String> list = this.diagnostics;
            return list;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JobReport getReport() {
        this.readLock.lock();
        try {
            String jobFile;
            JobState state = this.getState();
            String string = jobFile = this.remoteJobConfFile == null ? "" : this.remoteJobConfFile.toString();
            if (this.getState() == JobState.NEW) {
                JobReport jobReport = MRBuilderUtils.newJobReport((JobId)this.jobId, (String)this.jobName, (String)this.username, (JobState)state, (long)this.appSubmitTime, (long)this.startTime, (long)this.finishTime, (float)this.setupProgress, (float)0.0f, (float)0.0f, (float)this.cleanupProgress, (String)jobFile, this.amInfos, (boolean)this.isUber);
                return jobReport;
            }
            this.computeProgress();
            JobReport jobReport = MRBuilderUtils.newJobReport((JobId)this.jobId, (String)this.jobName, (String)this.username, (JobState)state, (long)this.appSubmitTime, (long)this.startTime, (long)this.finishTime, (float)this.setupProgress, (float)this.mapProgress, (float)this.reduceProgress, (float)this.cleanupProgress, (String)jobFile, this.amInfos, (boolean)this.isUber);
            return jobReport;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public float getProgress() {
        this.readLock.lock();
        try {
            this.computeProgress();
            float f = this.setupProgress * this.setupWeight + this.cleanupProgress * this.cleanupWeight + this.mapProgress * this.mapWeight + this.reduceProgress * this.reduceWeight;
            return f;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void computeProgress() {
        this.readLock.lock();
        try {
            float mapProgress = 0.0f;
            float reduceProgress = 0.0f;
            for (Task task : this.tasks.values()) {
                if (task.getType() == TaskType.MAP) {
                    mapProgress += task.getProgress();
                    continue;
                }
                reduceProgress += task.getProgress();
            }
            if (this.numMapTasks != 0) {
                mapProgress /= (float)this.numMapTasks;
            }
            if (this.numReduceTasks != 0) {
                reduceProgress /= (float)this.numReduceTasks;
            }
            this.mapProgress = mapProgress;
            this.reduceProgress = reduceProgress;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<TaskId, Task> getTasks() {
        Object object = this.tasksSyncHandle;
        synchronized (object) {
            this.lazyTasksCopyNeeded = true;
            return Collections.unmodifiableMap(this.tasks);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<TaskId, Task> getTasks(TaskType taskType) {
        Map<TaskId, Task> localTasksCopy = this.tasks;
        HashMap<TaskId, Task> result = new HashMap<TaskId, Task>();
        Set<TaskId> tasksOfGivenType = null;
        this.readLock.lock();
        try {
            tasksOfGivenType = TaskType.MAP == taskType ? this.mapTasks : this.reduceTasks;
            for (TaskId taskID : tasksOfGivenType) {
                result.put(taskID, localTasksCopy.get(taskID));
            }
            HashMap<TaskId, Task> hashMap = result;
            return hashMap;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JobState getState() {
        this.readLock.lock();
        try {
            JobState jobState = (JobState)this.getStateMachine().getCurrentState();
            return jobState;
        }
        finally {
            this.readLock.unlock();
        }
    }

    protected void scheduleTasks(Set<TaskId> taskIDs) {
        for (TaskId taskID : taskIDs) {
            this.eventHandler.handle((Event)new TaskEvent(taskID, TaskEventType.T_SCHEDULE));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handle(JobEvent event) {
        LOG.debug((Object)("Processing " + event.getJobId() + " of type " + event.getType()));
        try {
            this.writeLock.lock();
            JobState oldState = this.getState();
            try {
                this.getStateMachine().doTransition(event.getType(), (Object)event);
            }
            catch (InvalidStateTransitonException e) {
                LOG.error((Object)"Can't handle this event at current state", (Throwable)e);
                this.addDiagnostic("Invalid event " + event.getType() + " on Job " + this.jobId);
                this.eventHandler.handle((Event)new JobEvent(this.jobId, JobEventType.INTERNAL_ERROR));
            }
            if (oldState != this.getState()) {
                LOG.info((Object)(this.jobId + "Job Transitioned from " + oldState + " to " + this.getState()));
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addTask(Task task) {
        Object object = this.tasksSyncHandle;
        synchronized (object) {
            if (this.lazyTasksCopyNeeded) {
                LinkedHashMap<TaskId, Task> newTasks = new LinkedHashMap<TaskId, Task>();
                newTasks.putAll(this.tasks);
                this.tasks = newTasks;
                this.lazyTasksCopyNeeded = false;
            }
        }
        this.tasks.put(task.getID(), task);
        if (task.getType() == TaskType.MAP) {
            this.mapTasks.add(task.getID());
        } else if (task.getType() == TaskType.REDUCE) {
            this.reduceTasks.add(task.getID());
        }
        this.metrics.waitingTask(task);
    }

    void setFinishTime() {
        this.finishTime = this.clock.getTime();
    }

    void logJobHistoryFinishedEvent() {
        this.setFinishTime();
        JobFinishedEvent jfe = JobImpl.createJobFinishedEvent(this);
        LOG.info((Object)"Calling handler for JobFinishedEvent ");
        this.getEventHandler().handle((Event)new JobHistoryEvent(this.jobId, (HistoryEvent)jfe));
    }

    protected FileSystem getFileSystem(Configuration conf) throws IOException {
        return FileSystem.get((Configuration)conf);
    }

    static JobState checkJobCompleteSuccess(JobImpl job) {
        if (job.completedTaskCount == job.tasks.size()) {
            try {
                job.getCommitter().commitJob(job.getJobContext());
            }
            catch (IOException e) {
                LOG.warn((Object)"Could not do commit for Job", (Throwable)e);
            }
            job.logJobHistoryFinishedEvent();
            return job.finished(JobState.SUCCEEDED);
        }
        return null;
    }

    JobState finished(JobState finalState) {
        if (this.getState() == JobState.RUNNING) {
            this.metrics.endRunningJob(this);
        }
        if (this.finishTime == 0L) {
            this.setFinishTime();
        }
        this.eventHandler.handle((Event)new JobFinishEvent(this.jobId));
        switch (finalState) {
            case KILLED: {
                this.metrics.killedJob(this);
                break;
            }
            case FAILED: {
                this.metrics.failedJob(this);
                break;
            }
            case SUCCEEDED: {
                this.metrics.completedJob(this);
            }
        }
        return finalState;
    }

    @Override
    public String getUserName() {
        return this.userName;
    }

    @Override
    public String getQueueName() {
        return this.queueName;
    }

    @Override
    public Path getConfFile() {
        return this.remoteJobConfFile;
    }

    @Override
    public String getName() {
        return this.jobName;
    }

    @Override
    public int getTotalMaps() {
        return this.mapTasks.size();
    }

    @Override
    public int getTotalReduces() {
        return this.reduceTasks.size();
    }

    @Override
    public Map<JobACL, AccessControlList> getJobACLs() {
        return Collections.unmodifiableMap(this.jobACLs);
    }

    @Override
    public List<AMInfo> getAMInfos() {
        return this.amInfos;
    }

    private void makeUberDecision(long dataInputLength) {
        int sysMaxMaps = this.conf.getInt("mapreduce.job.ubertask.maxmaps", 9);
        int sysMaxReduces = 1;
        long sysMaxBytes = this.conf.getLong("mapreduce.job.ubertask.maxbytes", this.fs.getDefaultBlockSize());
        long sysMemSizeForUberSlot = this.conf.getInt("yarn.app.mapreduce.am.resource.mb", 2048);
        boolean uberEnabled = this.conf.getBoolean("mapreduce.job.ubertask.enable", false);
        boolean smallNumMapTasks = this.numMapTasks <= sysMaxMaps;
        boolean smallNumReduceTasks = this.numReduceTasks <= sysMaxReduces;
        boolean smallInput = dataInputLength <= sysMaxBytes;
        boolean smallMemory = Math.max(this.conf.getLong("mapreduce.map.memory.mb", 0L), this.conf.getLong("mapreduce.reduce.memory.mb", 0L)) <= sysMemSizeForUberSlot || sysMemSizeForUberSlot == -1L;
        boolean notChainJob = !this.isChainJob((Configuration)this.conf);
        boolean bl = this.isUber = uberEnabled && smallNumMapTasks && smallNumReduceTasks && smallInput && smallMemory && notChainJob;
        if (this.isUber) {
            LOG.info((Object)("Uberizing job " + this.jobId + ": " + this.numMapTasks + "m+" + this.numReduceTasks + "r tasks (" + dataInputLength + " input bytes) will run sequentially on single node."));
            this.conf.setFloat("mapreduce.job.reduce.slowstart.completedmaps", 1.0f);
            this.conf.setInt("mapreduce.map.maxattempts", 1);
            this.conf.setInt("mapreduce.reduce.maxattempts", 1);
            this.conf.setBoolean("mapreduce.map.speculative", false);
            this.conf.setBoolean("mapreduce.reduce.speculative", false);
        } else {
            StringBuilder msg = new StringBuilder();
            msg.append("Not uberizing ").append(this.jobId).append(" because:");
            if (!uberEnabled) {
                msg.append(" not enabled;");
            }
            if (!smallNumMapTasks) {
                msg.append(" too many maps;");
            }
            if (!smallNumReduceTasks) {
                msg.append(" too many reduces;");
            }
            if (!smallInput) {
                msg.append(" too much input;");
            }
            if (!smallMemory) {
                msg.append(" too much RAM;");
            }
            if (!notChainJob) {
                msg.append(" chainjob");
            }
            LOG.info((Object)msg.toString());
        }
    }

    private boolean isChainJob(Configuration conf) {
        boolean isChainJob = false;
        try {
            Class<?> mapClass;
            String mapClassName = conf.get("mapreduce.job.map.class");
            if (mapClassName != null && ChainMapper.class.isAssignableFrom(mapClass = Class.forName(mapClassName))) {
                isChainJob = true;
            }
        }
        catch (ClassNotFoundException cnfe) {
            // empty catch block
        }
        try {
            Class<?> reduceClass;
            String reduceClassName = conf.get("mapreduce.job.reduce.class");
            if (reduceClassName != null && ChainReducer.class.isAssignableFrom(reduceClass = Class.forName(reduceClassName))) {
                isChainJob = true;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return isChainJob;
    }

    private void abortJob(JobStatus.State finalState) {
        try {
            this.committer.abortJob(this.jobContext, finalState);
        }
        catch (IOException e) {
            LOG.warn((Object)"Could not abortJob", (Throwable)e);
        }
        if (this.finishTime == 0L) {
            this.setFinishTime();
        }
        this.cleanupProgress = 1.0f;
        JobUnsuccessfulCompletionEvent unsuccessfulJobEvent = new JobUnsuccessfulCompletionEvent(this.oldJobId, this.finishTime, this.succeededMapTaskCount, this.succeededReduceTaskCount, finalState.toString());
        this.eventHandler.handle((Event)new JobHistoryEvent(this.jobId, (HistoryEvent)unsuccessfulJobEvent));
    }

    private static JobFinishedEvent createJobFinishedEvent(JobImpl job) {
        job.mayBeConstructFinalFullCounters();
        JobFinishedEvent jfe = new JobFinishedEvent(job.oldJobId, job.finishTime, job.succeededMapTaskCount, job.succeededReduceTaskCount, job.failedMapTaskCount, job.failedReduceTaskCount, job.finalMapCounters, job.finalReduceCounters, job.fullCounters);
        return jfe;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void mayBeConstructFinalFullCounters() {
        Object object = this.fullCountersLock;
        synchronized (object) {
            if (this.fullCounters != null) {
                return;
            }
            this.constructFinalFullcounters();
        }
    }

    @InterfaceAudience.Private
    public void constructFinalFullcounters() {
        this.fullCounters = new Counters();
        this.finalMapCounters = new Counters();
        this.finalReduceCounters = new Counters();
        this.fullCounters.incrAllCounters((AbstractCounters)this.jobCounters);
        for (Task t : this.tasks.values()) {
            Counters counters = t.getCounters();
            switch (t.getType()) {
                case MAP: {
                    this.finalMapCounters.incrAllCounters((AbstractCounters)counters);
                    break;
                }
                case REDUCE: {
                    this.finalReduceCounters.incrAllCounters((AbstractCounters)counters);
                }
            }
            this.fullCounters.incrAllCounters((AbstractCounters)counters);
        }
    }

    private void addDiagnostic(String diag) {
        this.diagnostics.add(diag);
    }

    private static class InternalErrorTransition
    implements SingleArcTransition<JobImpl, JobEvent> {
        private InternalErrorTransition() {
        }

        public void transition(JobImpl job, JobEvent event) {
            job.setFinishTime();
            JobUnsuccessfulCompletionEvent failedEvent = new JobUnsuccessfulCompletionEvent(job.oldJobId, job.finishTime, 0, 0, JobState.ERROR.toString());
            job.eventHandler.handle((Event)new JobHistoryEvent(job.jobId, (HistoryEvent)failedEvent));
            job.finished(JobState.ERROR);
        }
    }

    private static class CounterUpdateTransition
    implements SingleArcTransition<JobImpl, JobEvent> {
        private CounterUpdateTransition() {
        }

        public void transition(JobImpl job, JobEvent event) {
            JobCounterUpdateEvent jce = (JobCounterUpdateEvent)event;
            for (JobCounterUpdateEvent.CounterIncrementalUpdate ci : jce.getCounterUpdates()) {
                job.jobCounters.findCounter(ci.getCounterKey()).increment(ci.getIncrementValue());
            }
        }
    }

    private static class DiagnosticsUpdateTransition
    implements SingleArcTransition<JobImpl, JobEvent> {
        private DiagnosticsUpdateTransition() {
        }

        public void transition(JobImpl job, JobEvent event) {
            job.addDiagnostic(((JobDiagnosticsUpdateEvent)event).getDiagnosticUpdate());
        }
    }

    private static class KillWaitTaskCompletedTransition
    extends TaskCompletedTransition {
        private KillWaitTaskCompletedTransition() {
        }

        @Override
        protected JobState checkJobForCompletion(JobImpl job) {
            if (job.completedTaskCount == job.tasks.size()) {
                job.setFinishTime();
                job.abortJob(JobStatus.State.KILLED);
                return job.finished(JobState.KILLED);
            }
            return job.getState();
        }
    }

    private static class MapTaskRescheduledTransition
    implements SingleArcTransition<JobImpl, JobEvent> {
        private MapTaskRescheduledTransition() {
        }

        public void transition(JobImpl job, JobEvent event) {
            job.completedTaskCount--;
            job.succeededMapTaskCount--;
        }
    }

    static class JobNoTasksCompletedTransition
    implements MultipleArcTransition<JobImpl, JobEvent, JobState> {
        JobNoTasksCompletedTransition() {
        }

        public JobState transition(JobImpl job, JobEvent event) {
            JobState jobCompleteSuccess = JobImpl.checkJobCompleteSuccess(job);
            if (jobCompleteSuccess != null) {
                return jobCompleteSuccess;
            }
            return job.getState();
        }
    }

    private static class TaskCompletedTransition
    implements MultipleArcTransition<JobImpl, JobEvent, JobState> {
        private TaskCompletedTransition() {
        }

        public JobState transition(JobImpl job, JobEvent event) {
            job.completedTaskCount++;
            LOG.info((Object)("Num completed Tasks: " + job.completedTaskCount));
            JobTaskEvent taskEvent = (JobTaskEvent)event;
            Task task = job.tasks.get(taskEvent.getTaskID());
            if (taskEvent.getState() == TaskState.SUCCEEDED) {
                this.taskSucceeded(job, task);
            } else if (taskEvent.getState() == TaskState.FAILED) {
                this.taskFailed(job, task);
            } else if (taskEvent.getState() == TaskState.KILLED) {
                this.taskKilled(job, task);
            }
            return this.checkJobForCompletion(job);
        }

        protected JobState checkJobForCompletion(JobImpl job) {
            if (job.failedMapTaskCount * 100 > job.allowedMapFailuresPercent * job.numMapTasks || job.failedReduceTaskCount * 100 > job.allowedReduceFailuresPercent * job.numReduceTasks) {
                job.setFinishTime();
                String diagnosticMsg = "Job failed as tasks failed. failedMaps:" + job.failedMapTaskCount + " failedReduces:" + job.failedReduceTaskCount;
                LOG.info((Object)diagnosticMsg);
                job.addDiagnostic(diagnosticMsg);
                job.abortJob(JobStatus.State.FAILED);
                return job.finished(JobState.FAILED);
            }
            JobState jobCompleteSuccess = JobImpl.checkJobCompleteSuccess(job);
            if (jobCompleteSuccess != null) {
                return jobCompleteSuccess;
            }
            return job.getState();
        }

        private void taskSucceeded(JobImpl job, Task task) {
            if (task.getType() == TaskType.MAP) {
                job.succeededMapTaskCount++;
            } else {
                job.succeededReduceTaskCount++;
            }
            job.metrics.completedTask(task);
        }

        private void taskFailed(JobImpl job, Task task) {
            if (task.getType() == TaskType.MAP) {
                job.failedMapTaskCount++;
            } else if (task.getType() == TaskType.REDUCE) {
                job.failedReduceTaskCount++;
            }
            job.addDiagnostic("Task failed " + task.getID());
            job.metrics.failedTask(task);
        }

        private void taskKilled(JobImpl job, Task task) {
            if (task.getType() == TaskType.MAP) {
                job.killedMapTaskCount++;
            } else if (task.getType() == TaskType.REDUCE) {
                job.killedReduceTaskCount++;
            }
            job.metrics.killedTask(task);
        }
    }

    private static class TaskAttemptFetchFailureTransition
    implements SingleArcTransition<JobImpl, JobEvent> {
        private TaskAttemptFetchFailureTransition() {
        }

        public void transition(JobImpl job, JobEvent event) {
            JobTaskAttemptFetchFailureEvent fetchfailureEvent = (JobTaskAttemptFetchFailureEvent)event;
            for (TaskAttemptId mapId : fetchfailureEvent.getMaps()) {
                boolean isMapFaulty;
                Integer fetchFailures = (Integer)job.fetchFailuresMapping.get(mapId);
                fetchFailures = fetchFailures == null ? 1 : fetchFailures + 1;
                job.fetchFailuresMapping.put(mapId, fetchFailures);
                int runningReduceTasks = 0;
                for (TaskId taskId : job.reduceTasks) {
                    if (!TaskState.RUNNING.equals((Object)job.tasks.get(taskId).getState())) continue;
                    ++runningReduceTasks;
                }
                float failureRate = (float)fetchFailures.intValue() / (float)runningReduceTasks;
                boolean bl = isMapFaulty = (double)failureRate >= 0.5;
                if (fetchFailures < 3 || !isMapFaulty) continue;
                LOG.info((Object)("Too many fetch-failures for output of task attempt: " + mapId + " ... raising fetch failure to map"));
                job.eventHandler.handle((Event)new TaskAttemptEvent(mapId, TaskAttemptEventType.TA_TOO_MANY_FETCH_FAILURE));
                job.fetchFailuresMapping.remove(mapId);
            }
        }
    }

    private static class TaskAttemptCompletedEventTransition
    implements SingleArcTransition<JobImpl, JobEvent> {
        private TaskAttemptCompletedEventTransition() {
        }

        public void transition(JobImpl job, JobEvent event) {
            TaskAttemptCompletionEvent tce = ((JobTaskAttemptCompletedEvent)event).getCompletionEvent();
            tce.setEventId(job.taskAttemptCompletionEvents.size());
            job.taskAttemptCompletionEvents.add(tce);
            Object successEventNo = job.successAttemptCompletionEventNoMap.remove(tce.getAttemptId().getTaskId());
            if (successEventNo != null) {
                TaskAttemptCompletionEvent successEvent = (TaskAttemptCompletionEvent)job.taskAttemptCompletionEvents.get((Integer)successEventNo);
                successEvent.setStatus(TaskAttemptCompletionEventStatus.OBSOLETE);
            }
            if (TaskAttemptCompletionEventStatus.SUCCEEDED.equals((Object)tce.getStatus())) {
                job.successAttemptCompletionEventNoMap.put(tce.getAttemptId().getTaskId(), tce.getEventId());
            }
        }
    }

    private static class KillTasksTransition
    implements SingleArcTransition<JobImpl, JobEvent> {
        private KillTasksTransition() {
        }

        public void transition(JobImpl job, JobEvent event) {
            job.addDiagnostic("Job received Kill while in RUNNING state.");
            for (Task task : job.tasks.values()) {
                job.eventHandler.handle((Event)new TaskEvent(task.getID(), TaskEventType.T_KILL));
            }
            job.metrics.endRunningJob(job);
        }
    }

    private static class KillInitedJobTransition
    implements SingleArcTransition<JobImpl, JobEvent> {
        private KillInitedJobTransition() {
        }

        public void transition(JobImpl job, JobEvent event) {
            job.abortJob(JobStatus.State.KILLED);
            job.addDiagnostic("Job received Kill in INITED state.");
            job.finished(JobState.KILLED);
        }
    }

    private static class KillNewJobTransition
    implements SingleArcTransition<JobImpl, JobEvent> {
        private KillNewJobTransition() {
        }

        public void transition(JobImpl job, JobEvent event) {
            job.setFinishTime();
            JobUnsuccessfulCompletionEvent failedEvent = new JobUnsuccessfulCompletionEvent(job.oldJobId, job.finishTime, 0, 0, JobState.KILLED.toString());
            job.eventHandler.handle((Event)new JobHistoryEvent(job.jobId, (HistoryEvent)failedEvent));
            job.finished(JobState.KILLED);
        }
    }

    public static class StartTransition
    implements SingleArcTransition<JobImpl, JobEvent> {
        public void transition(JobImpl job, JobEvent event) {
            job.startTime = job.clock.getTime();
            job.scheduleTasks(job.mapTasks);
            job.scheduleTasks(job.reduceTasks);
            JobInitedEvent jie = new JobInitedEvent(job.oldJobId, job.startTime, job.numMapTasks, job.numReduceTasks, job.getState().toString(), job.isUber());
            job.eventHandler.handle((Event)new JobHistoryEvent(job.jobId, (HistoryEvent)jie));
            JobInfoChangeEvent jice = new JobInfoChangeEvent(job.oldJobId, job.appSubmitTime, job.startTime);
            job.eventHandler.handle((Event)new JobHistoryEvent(job.jobId, (HistoryEvent)jice));
            job.metrics.runningJob(job);
            if (job.numReduceTasks == 0 && job.numMapTasks == 0) {
                job.eventHandler.handle((Event)new JobEvent(job.jobId, JobEventType.JOB_COMPLETED));
            }
        }
    }

    public static class InitTransition
    implements MultipleArcTransition<JobImpl, JobEvent, JobState> {
        public JobState transition(JobImpl job, JobEvent event) {
            job.metrics.submittedJob(job);
            job.metrics.preparingJob(job);
            try {
                this.setup(job);
                job.fs = job.getFileSystem((Configuration)job.conf);
                JobSubmittedEvent jse = new JobSubmittedEvent(job.oldJobId, job.conf.get("mapreduce.job.name", "test"), job.conf.get("mapreduce.job.user.name", "mapred"), job.appSubmitTime, job.remoteJobConfFile.toString(), job.jobACLs, job.queueName);
                job.eventHandler.handle((Event)new JobHistoryEvent(job.jobId, (HistoryEvent)jse));
                JobSplit.TaskSplitMetaInfo[] taskSplitMetaInfo = this.createSplits(job, job.jobId);
                job.numMapTasks = taskSplitMetaInfo.length;
                job.numReduceTasks = job.conf.getInt("mapreduce.job.reduces", 0);
                if (job.numMapTasks == 0 && job.numReduceTasks == 0) {
                    job.addDiagnostic("No of maps and reduces are 0 " + job.jobId);
                } else if (job.numMapTasks == 0) {
                    job.reduceWeight = 0.9f;
                } else if (job.numReduceTasks == 0) {
                    job.mapWeight = 0.9f;
                } else {
                    job.mapWeight = (job.reduceWeight = 0.45f);
                }
                this.checkTaskLimits();
                if (job.newApiCommitter) {
                    job.jobContext = (JobContext)new org.apache.hadoop.mapreduce.task.JobContextImpl((Configuration)job.conf, job.oldJobId);
                } else {
                    job.jobContext = (JobContext)new JobContextImpl(job.conf, job.oldJobId);
                }
                long inputLength = 0L;
                for (int i = 0; i < job.numMapTasks; ++i) {
                    inputLength += taskSplitMetaInfo[i].getInputDataLength();
                }
                job.makeUberDecision(inputLength);
                job.taskAttemptCompletionEvents = new ArrayList(job.numMapTasks + job.numReduceTasks + 10);
                job.allowedMapFailuresPercent = job.conf.getInt("mapreduce.map.failures.maxpercent", 0);
                job.allowedReduceFailuresPercent = job.conf.getInt("mapreduce.reduce.failures.maxpercent", 0);
                job.committer.setupJob(job.jobContext);
                job.setupProgress = 1.0f;
                this.createMapTasks(job, inputLength, taskSplitMetaInfo);
                this.createReduceTasks(job);
                job.metrics.endPreparingJob(job);
                return JobState.INITED;
            }
            catch (IOException e) {
                LOG.warn((Object)"Job init failed", (Throwable)e);
                job.addDiagnostic("Job init failed : " + StringUtils.stringifyException((Throwable)e));
                job.abortJob(JobStatus.State.FAILED);
                job.metrics.endPreparingJob(job);
                return job.finished(JobState.FAILED);
            }
        }

        protected void setup(JobImpl job) throws IOException {
            String oldJobIDString = job.oldJobId.toString();
            String user = UserGroupInformation.getCurrentUser().getShortUserName();
            Path path = MRApps.getStagingAreaDir((Configuration)job.conf, (String)user);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("startJobs: parent=" + path + " child=" + oldJobIDString));
            }
            job.remoteJobSubmitDir = FileSystem.get((Configuration)job.conf).makeQualified(new Path(path, oldJobIDString));
            job.remoteJobConfFile = new Path(job.remoteJobSubmitDir, "job.xml");
            JobTokenIdentifier identifier = new JobTokenIdentifier(new Text(oldJobIDString));
            job.jobToken = new Token((TokenIdentifier)identifier, (SecretManager)job.jobTokenSecretManager);
            job.jobToken.setService(identifier.getJobId());
            job.jobTokenSecretManager.addTokenForJob(oldJobIDString, job.jobToken);
            LOG.info((Object)("Adding job token for " + oldJobIDString + " to jobTokenSecretManager"));
            Credentials tokenStorage = new Credentials();
            TokenCache.setJobToken((Token)job.jobToken, (Credentials)tokenStorage);
            if (UserGroupInformation.isSecurityEnabled()) {
                tokenStorage.addAll(job.fsTokens);
            }
        }

        private void createMapTasks(JobImpl job, long inputLength, JobSplit.TaskSplitMetaInfo[] splits) {
            for (int i = 0; i < job.numMapTasks; ++i) {
                MapTaskImpl task = new MapTaskImpl(job.jobId, i, job.eventHandler, job.remoteJobConfFile, job.conf, splits[i], job.taskAttemptListener, job.committer, (Token<JobTokenIdentifier>)job.jobToken, (Collection<Token<? extends TokenIdentifier>>)job.fsTokens.getAllTokens(), job.clock, (Map<TaskId, JobHistoryParser.TaskInfo>)job.completedTasksFromPreviousRun, job.applicationAttemptId.getAttemptId(), job.metrics);
                job.addTask(task);
            }
            LOG.info((Object)("Input size for job " + job.jobId + " = " + inputLength + ". Number of splits = " + splits.length));
        }

        private void createReduceTasks(JobImpl job) {
            for (int i = 0; i < job.numReduceTasks; ++i) {
                ReduceTaskImpl task = new ReduceTaskImpl(job.jobId, i, job.eventHandler, job.remoteJobConfFile, job.conf, job.numMapTasks, job.taskAttemptListener, job.committer, (Token<JobTokenIdentifier>)job.jobToken, (Collection<Token<? extends TokenIdentifier>>)job.fsTokens.getAllTokens(), job.clock, (Map<TaskId, JobHistoryParser.TaskInfo>)job.completedTasksFromPreviousRun, job.applicationAttemptId.getAttemptId(), job.metrics);
                job.addTask(task);
            }
            LOG.info((Object)("Number of reduces for job " + job.jobId + " = " + job.numReduceTasks));
        }

        protected JobSplit.TaskSplitMetaInfo[] createSplits(JobImpl job, JobId jobId) {
            JobSplit.TaskSplitMetaInfo[] allTaskSplitMetaInfo;
            try {
                allTaskSplitMetaInfo = SplitMetaInfoReader.readSplitMetaInfo((JobID)job.oldJobId, (FileSystem)job.fs, (Configuration)job.conf, (Path)job.remoteJobSubmitDir);
            }
            catch (IOException e) {
                throw new YarnException((Throwable)e);
            }
            return allTaskSplitMetaInfo;
        }

        private void checkTaskLimits() {
        }
    }
}

