/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.v2.app.job.impl;

import java.util.Collection;
import java.util.Map;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.ReduceTaskAttemptImpl;
import org.apache.hadoop.mapreduce.OutputCommitter;
import org.apache.hadoop.mapreduce.jobhistory.JobHistoryParser;
import org.apache.hadoop.mapreduce.security.token.JobTokenIdentifier;
import org.apache.hadoop.mapreduce.v2.api.records.JobId;
import org.apache.hadoop.mapreduce.v2.api.records.TaskId;
import org.apache.hadoop.mapreduce.v2.api.records.TaskType;
import org.apache.hadoop.mapreduce.v2.app.TaskAttemptListener;
import org.apache.hadoop.mapreduce.v2.app.job.impl.TaskAttemptImpl;
import org.apache.hadoop.mapreduce.v2.app.job.impl.TaskImpl;
import org.apache.hadoop.mapreduce.v2.app.metrics.MRAppMetrics;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.apache.hadoop.yarn.Clock;
import org.apache.hadoop.yarn.event.EventHandler;

public class ReduceTaskImpl
extends TaskImpl {
    private final int numMapTasks;

    public ReduceTaskImpl(JobId jobId, int partition, EventHandler eventHandler, Path jobFile, JobConf conf, int numMapTasks, TaskAttemptListener taskAttemptListener, OutputCommitter committer, Token<JobTokenIdentifier> jobToken, Collection<Token<? extends TokenIdentifier>> fsTokens, Clock clock, Map<TaskId, JobHistoryParser.TaskInfo> completedTasksFromPreviousRun, int startCount, MRAppMetrics metrics) {
        super(jobId, TaskType.REDUCE, partition, eventHandler, jobFile, conf, taskAttemptListener, committer, jobToken, fsTokens, clock, completedTasksFromPreviousRun, startCount, metrics);
        this.numMapTasks = numMapTasks;
    }

    @Override
    protected int getMaxAttempts() {
        return this.conf.getInt("mapreduce.reduce.maxattempts", 4);
    }

    @Override
    protected TaskAttemptImpl createAttempt() {
        return new ReduceTaskAttemptImpl(this.getID(), this.nextAttemptNumber, this.eventHandler, this.jobFile, this.partition, this.numMapTasks, this.conf, this.taskAttemptListener, this.committer, (Token<JobTokenIdentifier>)this.jobToken, (Collection<Token<? extends TokenIdentifier>>)this.fsTokens, this.clock);
    }

    @Override
    public TaskType getType() {
        return TaskType.REDUCE;
    }
}

