/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.v2.app.metrics;

import org.apache.hadoop.mapreduce.v2.app.job.Job;
import org.apache.hadoop.mapreduce.v2.app.job.Task;
import org.apache.hadoop.metrics2.MetricsSystem;
import org.apache.hadoop.metrics2.annotation.Metric;
import org.apache.hadoop.metrics2.annotation.Metrics;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import org.apache.hadoop.metrics2.lib.MutableCounterInt;
import org.apache.hadoop.metrics2.lib.MutableGaugeInt;
import org.apache.hadoop.metrics2.source.JvmMetrics;

@Metrics(about="MR App Metrics", context="mapred")
public class MRAppMetrics {
    @Metric
    MutableCounterInt jobsSubmitted;
    @Metric
    MutableCounterInt jobsCompleted;
    @Metric
    MutableCounterInt jobsFailed;
    @Metric
    MutableCounterInt jobsKilled;
    @Metric
    MutableGaugeInt jobsPreparing;
    @Metric
    MutableGaugeInt jobsRunning;
    @Metric
    MutableCounterInt mapsLaunched;
    @Metric
    MutableCounterInt mapsCompleted;
    @Metric
    MutableCounterInt mapsFailed;
    @Metric
    MutableCounterInt mapsKilled;
    @Metric
    MutableGaugeInt mapsRunning;
    @Metric
    MutableGaugeInt mapsWaiting;
    @Metric
    MutableCounterInt reducesLaunched;
    @Metric
    MutableCounterInt reducesCompleted;
    @Metric
    MutableCounterInt reducesFailed;
    @Metric
    MutableCounterInt reducesKilled;
    @Metric
    MutableGaugeInt reducesRunning;
    @Metric
    MutableGaugeInt reducesWaiting;

    public static MRAppMetrics create() {
        return MRAppMetrics.create(DefaultMetricsSystem.instance());
    }

    public static MRAppMetrics create(MetricsSystem ms) {
        JvmMetrics.create((String)"MRAppMaster", null, (MetricsSystem)ms);
        return (MRAppMetrics)ms.register((Object)new MRAppMetrics());
    }

    public void submittedJob(Job job) {
        this.jobsSubmitted.incr();
    }

    public void completedJob(Job job) {
        this.jobsCompleted.incr();
    }

    public void failedJob(Job job) {
        this.jobsFailed.incr();
    }

    public void killedJob(Job job) {
        this.jobsKilled.incr();
    }

    public void preparingJob(Job job) {
        this.jobsPreparing.incr();
    }

    public void endPreparingJob(Job job) {
        this.jobsPreparing.decr();
    }

    public void runningJob(Job job) {
        this.jobsRunning.incr();
    }

    public void endRunningJob(Job job) {
        this.jobsRunning.decr();
    }

    public void launchedTask(Task task) {
        switch (task.getType()) {
            case MAP: {
                this.mapsLaunched.incr();
                break;
            }
            case REDUCE: {
                this.reducesLaunched.incr();
            }
        }
        this.endWaitingTask(task);
    }

    public void completedTask(Task task) {
        switch (task.getType()) {
            case MAP: {
                this.mapsCompleted.incr();
                break;
            }
            case REDUCE: {
                this.reducesCompleted.incr();
            }
        }
    }

    public void failedTask(Task task) {
        switch (task.getType()) {
            case MAP: {
                this.mapsFailed.incr();
                break;
            }
            case REDUCE: {
                this.reducesFailed.incr();
            }
        }
    }

    public void killedTask(Task task) {
        switch (task.getType()) {
            case MAP: {
                this.mapsKilled.incr();
                break;
            }
            case REDUCE: {
                this.reducesKilled.incr();
            }
        }
    }

    public void runningTask(Task task) {
        switch (task.getType()) {
            case MAP: {
                this.mapsRunning.incr();
                break;
            }
            case REDUCE: {
                this.reducesRunning.incr();
            }
        }
    }

    public void endRunningTask(Task task) {
        switch (task.getType()) {
            case MAP: {
                this.mapsRunning.decr();
                break;
            }
            case REDUCE: {
                this.reducesRunning.decr();
            }
        }
    }

    public void waitingTask(Task task) {
        switch (task.getType()) {
            case MAP: {
                this.mapsWaiting.incr();
                break;
            }
            case REDUCE: {
                this.reducesWaiting.incr();
            }
        }
    }

    public void endWaitingTask(Task task) {
        switch (task.getType()) {
            case MAP: {
                this.mapsWaiting.decr();
                break;
            }
            case REDUCE: {
                this.reducesWaiting.decr();
            }
        }
    }
}

