/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.v2.app.launcher;

import java.net.InetSocketAddress;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapred.ShuffleHandler;
import org.apache.hadoop.mapreduce.v2.api.records.JobId;
import org.apache.hadoop.mapreduce.v2.api.records.TaskAttemptId;
import org.apache.hadoop.mapreduce.v2.api.records.TaskId;
import org.apache.hadoop.mapreduce.v2.api.records.TaskType;
import org.apache.hadoop.mapreduce.v2.app.AppContext;
import org.apache.hadoop.mapreduce.v2.app.launcher.ContainerLauncher;
import org.apache.hadoop.mapreduce.v2.app.launcher.ContainerLauncherEvent;
import org.apache.hadoop.mapreduce.v2.app.launcher.ContainerRemoteLaunchEvent;
import org.apache.hadoop.mapreduce.v2.app.launcher.TestContainerLauncherImpl;
import org.apache.hadoop.mapreduce.v2.util.MRBuilderUtils;
import org.apache.hadoop.yarn.api.ContainerManager;
import org.apache.hadoop.yarn.api.protocolrecords.StartContainerRequest;
import org.apache.hadoop.yarn.api.protocolrecords.StartContainerResponse;
import org.apache.hadoop.yarn.api.protocolrecords.StopContainerRequest;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.event.EventHandler;
import org.apache.hadoop.yarn.factories.RecordFactory;
import org.apache.hadoop.yarn.factory.providers.RecordFactoryProvider;
import org.apache.hadoop.yarn.ipc.YarnRPC;
import org.apache.hadoop.yarn.util.BuilderUtils;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

/*
 * Exception performing whole class analysis ignored.
 */
public class TestContainerLauncherImpl {
    static final Log LOG = LogFactory.getLog(TestContainerLauncherImpl.class);
    private static final RecordFactory recordFactory = RecordFactoryProvider.getRecordFactory(null);

    public static ContainerId makeContainerId(long ts, int appId, int attemptId, int id) {
        return BuilderUtils.newContainerId((ApplicationAttemptId)BuilderUtils.newApplicationAttemptId((ApplicationId)BuilderUtils.newApplicationId((long)ts, (int)appId), (int)attemptId), (int)id);
    }

    public static TaskAttemptId makeTaskAttemptId(long ts, int appId, int taskId, TaskType taskType, int id) {
        ApplicationId aID = BuilderUtils.newApplicationId((long)ts, (int)appId);
        JobId jID = MRBuilderUtils.newJobId((ApplicationId)aID, (int)id);
        TaskId tID = MRBuilderUtils.newTaskId((JobId)jID, (int)taskId, (TaskType)taskType);
        return MRBuilderUtils.newTaskAttemptId((TaskId)tID, (int)id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testHandle() throws Exception {
        LOG.info((Object)"STARTING testHandle");
        YarnRPC mockRpc = (YarnRPC)Mockito.mock(YarnRPC.class);
        AppContext mockContext = (AppContext)Mockito.mock(AppContext.class);
        EventHandler mockEventHandler = (EventHandler)Mockito.mock(EventHandler.class);
        Mockito.when((Object)mockContext.getEventHandler()).thenReturn((Object)mockEventHandler);
        ContainerManager mockCM = (ContainerManager)Mockito.mock(ContainerManager.class);
        Mockito.when((Object)mockRpc.getProxy((Class)Matchers.eq(ContainerManager.class), (InetSocketAddress)Matchers.any(InetSocketAddress.class), (Configuration)Matchers.any(Configuration.class))).thenReturn((Object)mockCM);
        ContainerLauncherImplUnderTest ut = new ContainerLauncherImplUnderTest(mockContext, mockRpc);
        Configuration conf = new Configuration();
        ut.init(conf);
        ut.start();
        try {
            ContainerId contId = TestContainerLauncherImpl.makeContainerId((long)0L, (int)0, (int)0, (int)1);
            TaskAttemptId taskAttemptId = TestContainerLauncherImpl.makeTaskAttemptId((long)0L, (int)0, (int)0, (TaskType)TaskType.MAP, (int)0);
            String cmAddress = "127.0.0.1:8000";
            StartContainerResponse startResp = (StartContainerResponse)recordFactory.newRecordInstance(StartContainerResponse.class);
            startResp.setServiceResponse("mapreduce.shuffle", ShuffleHandler.serializeMetaData((int)80));
            LOG.info((Object)"inserting launch event");
            ContainerRemoteLaunchEvent mockLaunchEvent = (ContainerRemoteLaunchEvent)Mockito.mock(ContainerRemoteLaunchEvent.class);
            Mockito.when((Object)mockLaunchEvent.getType()).thenReturn((Object)ContainerLauncher.EventType.CONTAINER_REMOTE_LAUNCH);
            Mockito.when((Object)mockLaunchEvent.getContainerID()).thenReturn((Object)contId);
            Mockito.when((Object)mockLaunchEvent.getTaskAttemptID()).thenReturn((Object)taskAttemptId);
            Mockito.when((Object)mockLaunchEvent.getContainerMgrAddress()).thenReturn((Object)cmAddress);
            Mockito.when((Object)mockCM.startContainer((StartContainerRequest)Matchers.any(StartContainerRequest.class))).thenReturn((Object)startResp);
            ut.handle((ContainerLauncherEvent)mockLaunchEvent);
            ut.waitForPoolToIdle();
            ((ContainerManager)Mockito.verify((Object)mockCM)).startContainer((StartContainerRequest)Matchers.any(StartContainerRequest.class));
            LOG.info((Object)"inserting cleanup event");
            ContainerLauncherEvent mockCleanupEvent = (ContainerLauncherEvent)Mockito.mock(ContainerLauncherEvent.class);
            Mockito.when((Object)mockCleanupEvent.getType()).thenReturn((Object)ContainerLauncher.EventType.CONTAINER_REMOTE_CLEANUP);
            Mockito.when((Object)mockCleanupEvent.getContainerID()).thenReturn((Object)contId);
            Mockito.when((Object)mockCleanupEvent.getTaskAttemptID()).thenReturn((Object)taskAttemptId);
            Mockito.when((Object)mockCleanupEvent.getContainerMgrAddress()).thenReturn((Object)cmAddress);
            ut.handle(mockCleanupEvent);
            ut.waitForPoolToIdle();
            ((ContainerManager)Mockito.verify((Object)mockCM)).stopContainer((StopContainerRequest)Matchers.any(StopContainerRequest.class));
        }
        finally {
            ut.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testOutOfOrder() throws Exception {
        LOG.info((Object)"STARTING testOutOfOrder");
        YarnRPC mockRpc = (YarnRPC)Mockito.mock(YarnRPC.class);
        AppContext mockContext = (AppContext)Mockito.mock(AppContext.class);
        EventHandler mockEventHandler = (EventHandler)Mockito.mock(EventHandler.class);
        Mockito.when((Object)mockContext.getEventHandler()).thenReturn((Object)mockEventHandler);
        ContainerManager mockCM = (ContainerManager)Mockito.mock(ContainerManager.class);
        Mockito.when((Object)mockRpc.getProxy((Class)Matchers.eq(ContainerManager.class), (InetSocketAddress)Matchers.any(InetSocketAddress.class), (Configuration)Matchers.any(Configuration.class))).thenReturn((Object)mockCM);
        ContainerLauncherImplUnderTest ut = new ContainerLauncherImplUnderTest(mockContext, mockRpc);
        Configuration conf = new Configuration();
        ut.init(conf);
        ut.start();
        try {
            ContainerId contId = TestContainerLauncherImpl.makeContainerId((long)0L, (int)0, (int)0, (int)1);
            TaskAttemptId taskAttemptId = TestContainerLauncherImpl.makeTaskAttemptId((long)0L, (int)0, (int)0, (TaskType)TaskType.MAP, (int)0);
            String cmAddress = "127.0.0.1:8000";
            StartContainerResponse startResp = (StartContainerResponse)recordFactory.newRecordInstance(StartContainerResponse.class);
            startResp.setServiceResponse("mapreduce.shuffle", ShuffleHandler.serializeMetaData((int)80));
            LOG.info((Object)"inserting cleanup event");
            ContainerLauncherEvent mockCleanupEvent = (ContainerLauncherEvent)Mockito.mock(ContainerLauncherEvent.class);
            Mockito.when((Object)mockCleanupEvent.getType()).thenReturn((Object)ContainerLauncher.EventType.CONTAINER_REMOTE_CLEANUP);
            Mockito.when((Object)mockCleanupEvent.getContainerID()).thenReturn((Object)contId);
            Mockito.when((Object)mockCleanupEvent.getTaskAttemptID()).thenReturn((Object)taskAttemptId);
            Mockito.when((Object)mockCleanupEvent.getContainerMgrAddress()).thenReturn((Object)cmAddress);
            ut.handle(mockCleanupEvent);
            ut.waitForPoolToIdle();
            ((ContainerManager)Mockito.verify((Object)mockCM, (VerificationMode)Mockito.never())).stopContainer((StopContainerRequest)Matchers.any(StopContainerRequest.class));
            LOG.info((Object)"inserting launch event");
            ContainerRemoteLaunchEvent mockLaunchEvent = (ContainerRemoteLaunchEvent)Mockito.mock(ContainerRemoteLaunchEvent.class);
            Mockito.when((Object)mockLaunchEvent.getType()).thenReturn((Object)ContainerLauncher.EventType.CONTAINER_REMOTE_LAUNCH);
            Mockito.when((Object)mockLaunchEvent.getContainerID()).thenReturn((Object)contId);
            Mockito.when((Object)mockLaunchEvent.getTaskAttemptID()).thenReturn((Object)taskAttemptId);
            Mockito.when((Object)mockLaunchEvent.getContainerMgrAddress()).thenReturn((Object)cmAddress);
            Mockito.when((Object)mockCM.startContainer((StartContainerRequest)Matchers.any(StartContainerRequest.class))).thenReturn((Object)startResp);
            ut.handle((ContainerLauncherEvent)mockLaunchEvent);
            ut.waitForPoolToIdle();
            ((ContainerManager)Mockito.verify((Object)mockCM, (VerificationMode)Mockito.never())).startContainer((StartContainerRequest)Matchers.any(StartContainerRequest.class));
        }
        finally {
            ut.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMyShutdown() throws Exception {
        LOG.info((Object)"in test Shutdown");
        YarnRPC mockRpc = (YarnRPC)Mockito.mock(YarnRPC.class);
        AppContext mockContext = (AppContext)Mockito.mock(AppContext.class);
        EventHandler mockEventHandler = (EventHandler)Mockito.mock(EventHandler.class);
        Mockito.when((Object)mockContext.getEventHandler()).thenReturn((Object)mockEventHandler);
        ContainerManager mockCM = (ContainerManager)Mockito.mock(ContainerManager.class);
        Mockito.when((Object)mockRpc.getProxy((Class)Matchers.eq(ContainerManager.class), (InetSocketAddress)Matchers.any(InetSocketAddress.class), (Configuration)Matchers.any(Configuration.class))).thenReturn((Object)mockCM);
        ContainerLauncherImplUnderTest ut = new ContainerLauncherImplUnderTest(mockContext, mockRpc);
        Configuration conf = new Configuration();
        ut.init(conf);
        ut.start();
        try {
            ContainerId contId = TestContainerLauncherImpl.makeContainerId((long)0L, (int)0, (int)0, (int)1);
            TaskAttemptId taskAttemptId = TestContainerLauncherImpl.makeTaskAttemptId((long)0L, (int)0, (int)0, (TaskType)TaskType.MAP, (int)0);
            String cmAddress = "127.0.0.1:8000";
            StartContainerResponse startResp = (StartContainerResponse)recordFactory.newRecordInstance(StartContainerResponse.class);
            startResp.setServiceResponse("mapreduce.shuffle", ShuffleHandler.serializeMetaData((int)80));
            LOG.info((Object)"inserting launch event");
            ContainerRemoteLaunchEvent mockLaunchEvent = (ContainerRemoteLaunchEvent)Mockito.mock(ContainerRemoteLaunchEvent.class);
            Mockito.when((Object)mockLaunchEvent.getType()).thenReturn((Object)ContainerLauncher.EventType.CONTAINER_REMOTE_LAUNCH);
            Mockito.when((Object)mockLaunchEvent.getContainerID()).thenReturn((Object)contId);
            Mockito.when((Object)mockLaunchEvent.getTaskAttemptID()).thenReturn((Object)taskAttemptId);
            Mockito.when((Object)mockLaunchEvent.getContainerMgrAddress()).thenReturn((Object)cmAddress);
            Mockito.when((Object)mockCM.startContainer((StartContainerRequest)Matchers.any(StartContainerRequest.class))).thenReturn((Object)startResp);
            ut.handle((ContainerLauncherEvent)mockLaunchEvent);
            ut.waitForPoolToIdle();
            ((ContainerManager)Mockito.verify((Object)mockCM)).startContainer((StartContainerRequest)Matchers.any(StartContainerRequest.class));
        }
        finally {
            ut.stop();
            ((ContainerManager)Mockito.verify((Object)mockCM)).stopContainer((StopContainerRequest)Matchers.any(StopContainerRequest.class));
        }
    }
}

