/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.v2.app;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import junit.framework.Assert;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.v2.api.records.JobId;
import org.apache.hadoop.mapreduce.v2.api.records.JobState;
import org.apache.hadoop.mapreduce.v2.api.records.TaskAttemptId;
import org.apache.hadoop.mapreduce.v2.api.records.TaskId;
import org.apache.hadoop.mapreduce.v2.api.records.TaskState;
import org.apache.hadoop.mapreduce.v2.api.records.TaskType;
import org.apache.hadoop.mapreduce.v2.app.MRApp;
import org.apache.hadoop.mapreduce.v2.app.TestRMContainerAllocator;
import org.apache.hadoop.mapreduce.v2.app.job.Job;
import org.apache.hadoop.mapreduce.v2.app.job.Task;
import org.apache.hadoop.mapreduce.v2.app.job.TaskAttempt;
import org.apache.hadoop.mapreduce.v2.app.job.TaskAttemptStateInternal;
import org.apache.hadoop.mapreduce.v2.app.job.event.TaskAttemptContainerAssignedEvent;
import org.apache.hadoop.mapreduce.v2.app.job.event.TaskAttemptEvent;
import org.apache.hadoop.mapreduce.v2.app.job.event.TaskAttemptEventType;
import org.apache.hadoop.mapreduce.v2.app.job.impl.TaskAttemptImpl;
import org.apache.hadoop.mapreduce.v2.app.rm.ContainerFailedEvent;
import org.apache.hadoop.mapreduce.v2.app.rm.ContainerRequestEvent;
import org.apache.hadoop.mapreduce.v2.app.rm.RMContainerAllocator;
import org.apache.hadoop.mapreduce.v2.util.MRBuilderUtils;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ContainerState;
import org.apache.hadoop.yarn.api.records.ContainerStatus;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.event.DrainDispatcher;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.factories.RecordFactory;
import org.apache.hadoop.yarn.factory.providers.RecordFactoryProvider;
import org.apache.hadoop.yarn.server.resourcemanager.MockNM;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMApp;
import org.apache.hadoop.yarn.util.BuilderUtils;
import org.junit.After;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class TestRMContainerAllocator {
    static final Log LOG = LogFactory.getLog(TestRMContainerAllocator.class);
    static final RecordFactory recordFactory = RecordFactoryProvider.getRecordFactory(null);

    @After
    public void tearDown() {
        DefaultMetricsSystem.shutdown();
    }

    @Test
    public void testSimple() throws Exception {
        LOG.info((Object)"Running testSimple");
        Configuration conf = new Configuration();
        MyResourceManager rm = new MyResourceManager(conf);
        rm.start();
        DrainDispatcher dispatcher = (DrainDispatcher)rm.getRMContext().getDispatcher();
        RMApp app = rm.submitApp(1024);
        dispatcher.await();
        MockNM amNodeManager = rm.registerNode("amNM:1234", 2048);
        amNodeManager.nodeHeartbeat(true);
        dispatcher.await();
        ApplicationAttemptId appAttemptId = app.getCurrentAppAttempt().getAppAttemptId();
        rm.sendAMLaunched(appAttemptId);
        dispatcher.await();
        JobId jobId = MRBuilderUtils.newJobId((ApplicationId)appAttemptId.getApplicationId(), (int)0);
        Job mockJob = (Job)Mockito.mock(Job.class);
        Mockito.when((Object)mockJob.getReport()).thenReturn((Object)MRBuilderUtils.newJobReport((JobId)jobId, (String)"job", (String)"user", (JobState)JobState.RUNNING, (long)0L, (long)0L, (long)0L, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (String)"jobfile", null, (boolean)false, (String)""));
        MyContainerAllocator allocator = new MyContainerAllocator(rm, conf, appAttemptId, mockJob);
        MockNM nodeManager1 = rm.registerNode("h1:1234", 10240);
        MockNM nodeManager2 = rm.registerNode("h2:1234", 10240);
        MockNM nodeManager3 = rm.registerNode("h3:1234", 10240);
        dispatcher.await();
        ContainerRequestEvent event1 = this.createReq(jobId, 1, 1024, new String[]{"h1"});
        allocator.sendRequest(event1);
        ContainerRequestEvent event2 = this.createReq(jobId, 2, 1024, new String[]{"h2"});
        allocator.sendRequest(event2);
        List assigned = allocator.schedule();
        dispatcher.await();
        Assert.assertEquals((String)"No of assignments must be 0", (int)0, (int)assigned.size());
        ContainerRequestEvent event3 = this.createReq(jobId, 3, 1024, new String[]{"h3"});
        allocator.sendRequest(event3);
        assigned = allocator.schedule();
        dispatcher.await();
        Assert.assertEquals((String)"No of assignments must be 0", (int)0, (int)assigned.size());
        nodeManager1.nodeHeartbeat(true);
        nodeManager2.nodeHeartbeat(true);
        nodeManager3.nodeHeartbeat(true);
        dispatcher.await();
        assigned = allocator.schedule();
        dispatcher.await();
        this.checkAssignments(new ContainerRequestEvent[]{event1, event2, event3}, assigned, false);
    }

    @Test
    public void testResource() throws Exception {
        LOG.info((Object)"Running testResource");
        Configuration conf = new Configuration();
        MyResourceManager rm = new MyResourceManager(conf);
        rm.start();
        DrainDispatcher dispatcher = (DrainDispatcher)rm.getRMContext().getDispatcher();
        RMApp app = rm.submitApp(1024);
        dispatcher.await();
        MockNM amNodeManager = rm.registerNode("amNM:1234", 2048);
        amNodeManager.nodeHeartbeat(true);
        dispatcher.await();
        ApplicationAttemptId appAttemptId = app.getCurrentAppAttempt().getAppAttemptId();
        rm.sendAMLaunched(appAttemptId);
        dispatcher.await();
        JobId jobId = MRBuilderUtils.newJobId((ApplicationId)appAttemptId.getApplicationId(), (int)0);
        Job mockJob = (Job)Mockito.mock(Job.class);
        Mockito.when((Object)mockJob.getReport()).thenReturn((Object)MRBuilderUtils.newJobReport((JobId)jobId, (String)"job", (String)"user", (JobState)JobState.RUNNING, (long)0L, (long)0L, (long)0L, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (String)"jobfile", null, (boolean)false, (String)""));
        MyContainerAllocator allocator = new MyContainerAllocator(rm, conf, appAttemptId, mockJob);
        MockNM nodeManager1 = rm.registerNode("h1:1234", 10240);
        MockNM nodeManager2 = rm.registerNode("h2:1234", 10240);
        MockNM nodeManager3 = rm.registerNode("h3:1234", 10240);
        dispatcher.await();
        ContainerRequestEvent event1 = this.createReq(jobId, 1, 1024, new String[]{"h1"});
        allocator.sendRequest(event1);
        ContainerRequestEvent event2 = this.createReq(jobId, 2, 2048, new String[]{"h2"});
        allocator.sendRequest(event2);
        List assigned = allocator.schedule();
        dispatcher.await();
        Assert.assertEquals((String)"No of assignments must be 0", (int)0, (int)assigned.size());
        nodeManager1.nodeHeartbeat(true);
        nodeManager2.nodeHeartbeat(true);
        nodeManager3.nodeHeartbeat(true);
        dispatcher.await();
        assigned = allocator.schedule();
        dispatcher.await();
        this.checkAssignments(new ContainerRequestEvent[]{event1, event2}, assigned, false);
    }

    @Test
    public void testMapReduceScheduling() throws Exception {
        LOG.info((Object)"Running testMapReduceScheduling");
        Configuration conf = new Configuration();
        MyResourceManager rm = new MyResourceManager(conf);
        rm.start();
        DrainDispatcher dispatcher = (DrainDispatcher)rm.getRMContext().getDispatcher();
        RMApp app = rm.submitApp(1024);
        dispatcher.await();
        MockNM amNodeManager = rm.registerNode("amNM:1234", 2048);
        amNodeManager.nodeHeartbeat(true);
        dispatcher.await();
        ApplicationAttemptId appAttemptId = app.getCurrentAppAttempt().getAppAttemptId();
        rm.sendAMLaunched(appAttemptId);
        dispatcher.await();
        JobId jobId = MRBuilderUtils.newJobId((ApplicationId)appAttemptId.getApplicationId(), (int)0);
        Job mockJob = (Job)Mockito.mock(Job.class);
        Mockito.when((Object)mockJob.getReport()).thenReturn((Object)MRBuilderUtils.newJobReport((JobId)jobId, (String)"job", (String)"user", (JobState)JobState.RUNNING, (long)0L, (long)0L, (long)0L, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (String)"jobfile", null, (boolean)false, (String)""));
        MyContainerAllocator allocator = new MyContainerAllocator(rm, conf, appAttemptId, mockJob);
        MockNM nodeManager1 = rm.registerNode("h1:1234", 1024);
        MockNM nodeManager2 = rm.registerNode("h2:1234", 10240);
        MockNM nodeManager3 = rm.registerNode("h3:1234", 10240);
        dispatcher.await();
        ContainerRequestEvent event1 = this.createReq(jobId, 1, 2048, new String[]{"h1", "h2"}, true, false);
        allocator.sendRequest(event1);
        ContainerRequestEvent event2 = this.createReq(jobId, 2, 3000, new String[]{"h1"}, false, true);
        allocator.sendRequest(event2);
        ContainerRequestEvent event3 = this.createReq(jobId, 3, 2048, new String[]{"h3"}, false, false);
        allocator.sendRequest(event3);
        List assigned = allocator.schedule();
        dispatcher.await();
        Assert.assertEquals((String)"No of assignments must be 0", (int)0, (int)assigned.size());
        nodeManager1.nodeHeartbeat(true);
        nodeManager2.nodeHeartbeat(true);
        nodeManager3.nodeHeartbeat(true);
        dispatcher.await();
        assigned = allocator.schedule();
        dispatcher.await();
        this.checkAssignments(new ContainerRequestEvent[]{event1, event3}, assigned, false);
        for (TaskAttemptContainerAssignedEvent assig : assigned) {
            Assert.assertFalse((String)"Assigned count not correct", (boolean)"h1".equals(assig.getContainer().getNodeId().getHost()));
        }
    }

    @Test
    public void testReportedAppProgress() throws Exception {
        LOG.info((Object)"Running testReportedAppProgress");
        Configuration conf = new Configuration();
        MyResourceManager rm = new MyResourceManager(conf);
        rm.start();
        DrainDispatcher rmDispatcher = (DrainDispatcher)rm.getRMContext().getDispatcher();
        RMApp rmApp = rm.submitApp(1024);
        rmDispatcher.await();
        MockNM amNodeManager = rm.registerNode("amNM:1234", 21504);
        amNodeManager.nodeHeartbeat(true);
        rmDispatcher.await();
        ApplicationAttemptId appAttemptId = rmApp.getCurrentAppAttempt().getAppAttemptId();
        rm.sendAMLaunched(appAttemptId);
        rmDispatcher.await();
        1 mrApp = new /* Unavailable Anonymous Inner Class!! */;
        Assert.assertEquals((double)0.0, (double)rmApp.getProgress(), (double)0.0);
        mrApp.submit(conf);
        Job job = (Job)mrApp.getContext().getAllJobs().entrySet().iterator().next().getValue();
        DrainDispatcher amDispatcher = (DrainDispatcher)mrApp.getDispatcher();
        MyContainerAllocator allocator = (MyContainerAllocator)mrApp.getContainerAllocator();
        mrApp.waitForState(job, JobState.RUNNING);
        amDispatcher.await();
        for (Task t : job.getTasks().values()) {
            if (t.getType() != TaskType.MAP) continue;
            mrApp.waitForInternalState((TaskAttemptImpl)t.getAttempts().values().iterator().next(), TaskAttemptStateInternal.UNASSIGNED);
        }
        amDispatcher.await();
        allocator.schedule();
        rmDispatcher.await();
        amNodeManager.nodeHeartbeat(true);
        rmDispatcher.await();
        allocator.schedule();
        rmDispatcher.await();
        for (Task t : job.getTasks().values()) {
            if (t.getType() != TaskType.MAP) continue;
            mrApp.waitForState(t, TaskState.RUNNING);
        }
        allocator.schedule();
        rmDispatcher.await();
        Assert.assertEquals((float)0.05f, (float)job.getProgress(), (float)0.001f);
        Assert.assertEquals((float)0.05f, (float)rmApp.getProgress(), (float)0.001f);
        Iterator it = job.getTasks().values().iterator();
        this.finishNextNTasks(rmDispatcher, amNodeManager, (MRApp)mrApp, it, 1);
        allocator.schedule();
        rmDispatcher.await();
        Assert.assertEquals((float)0.095f, (float)job.getProgress(), (float)0.001f);
        Assert.assertEquals((float)0.095f, (float)rmApp.getProgress(), (float)0.001f);
        this.finishNextNTasks(rmDispatcher, amNodeManager, (MRApp)mrApp, it, 7);
        allocator.schedule();
        rmDispatcher.await();
        Assert.assertEquals((float)0.41f, (float)job.getProgress(), (float)0.001f);
        Assert.assertEquals((float)0.41f, (float)rmApp.getProgress(), (float)0.001f);
        this.finishNextNTasks(rmDispatcher, amNodeManager, (MRApp)mrApp, it, 2);
        allocator.schedule();
        rmDispatcher.await();
        amNodeManager.nodeHeartbeat(true);
        rmDispatcher.await();
        allocator.schedule();
        rmDispatcher.await();
        for (Task t : job.getTasks().values()) {
            if (t.getType() != TaskType.REDUCE) continue;
            mrApp.waitForState(t, TaskState.RUNNING);
        }
        this.finishNextNTasks(rmDispatcher, amNodeManager, (MRApp)mrApp, it, 2);
        allocator.schedule();
        rmDispatcher.await();
        Assert.assertEquals((float)0.59f, (float)job.getProgress(), (float)0.001f);
        Assert.assertEquals((float)0.59f, (float)rmApp.getProgress(), (float)0.001f);
        this.finishNextNTasks(rmDispatcher, amNodeManager, (MRApp)mrApp, it, 8);
        allocator.schedule();
        rmDispatcher.await();
        Assert.assertEquals((float)0.95f, (float)job.getProgress(), (float)0.001f);
        Assert.assertEquals((float)0.95f, (float)rmApp.getProgress(), (float)0.001f);
    }

    private void finishNextNTasks(DrainDispatcher rmDispatcher, MockNM node, MRApp mrApp, Iterator<Task> it, int nextN) throws Exception {
        for (int i = 0; i < nextN; ++i) {
            Task task = it.next();
            this.finishTask(rmDispatcher, node, mrApp, task);
        }
    }

    private void finishTask(DrainDispatcher rmDispatcher, MockNM node, MRApp mrApp, Task task) throws Exception {
        TaskAttempt attempt = (TaskAttempt)task.getAttempts().values().iterator().next();
        ArrayList<ContainerStatus> contStatus = new ArrayList<ContainerStatus>(1);
        contStatus.add(BuilderUtils.newContainerStatus((ContainerId)attempt.getAssignedContainerID(), (ContainerState)ContainerState.COMPLETE, (String)"", (int)0));
        HashMap<ApplicationId, ArrayList<ContainerStatus>> statusUpdate = new HashMap<ApplicationId, ArrayList<ContainerStatus>>(1);
        statusUpdate.put(mrApp.getAppID(), contStatus);
        node.nodeHeartbeat(statusUpdate, true);
        rmDispatcher.await();
        mrApp.getContext().getEventHandler().handle((Event)new TaskAttemptEvent(attempt.getID(), TaskAttemptEventType.TA_DONE));
        mrApp.waitForState(task, TaskState.SUCCEEDED);
    }

    @Test
    public void testReportedAppProgressWithOnlyMaps() throws Exception {
        LOG.info((Object)"Running testReportedAppProgressWithOnlyMaps");
        Configuration conf = new Configuration();
        MyResourceManager rm = new MyResourceManager(conf);
        rm.start();
        DrainDispatcher rmDispatcher = (DrainDispatcher)rm.getRMContext().getDispatcher();
        RMApp rmApp = rm.submitApp(1024);
        rmDispatcher.await();
        MockNM amNodeManager = rm.registerNode("amNM:1234", 11264);
        amNodeManager.nodeHeartbeat(true);
        rmDispatcher.await();
        ApplicationAttemptId appAttemptId = rmApp.getCurrentAppAttempt().getAppAttemptId();
        rm.sendAMLaunched(appAttemptId);
        rmDispatcher.await();
        2 mrApp = new /* Unavailable Anonymous Inner Class!! */;
        Assert.assertEquals((double)0.0, (double)rmApp.getProgress(), (double)0.0);
        mrApp.submit(conf);
        Job job = (Job)mrApp.getContext().getAllJobs().entrySet().iterator().next().getValue();
        DrainDispatcher amDispatcher = (DrainDispatcher)mrApp.getDispatcher();
        MyContainerAllocator allocator = (MyContainerAllocator)mrApp.getContainerAllocator();
        mrApp.waitForState(job, JobState.RUNNING);
        amDispatcher.await();
        for (Task t : job.getTasks().values()) {
            mrApp.waitForInternalState((TaskAttemptImpl)t.getAttempts().values().iterator().next(), TaskAttemptStateInternal.UNASSIGNED);
        }
        amDispatcher.await();
        allocator.schedule();
        rmDispatcher.await();
        amNodeManager.nodeHeartbeat(true);
        rmDispatcher.await();
        allocator.schedule();
        rmDispatcher.await();
        for (Task t : job.getTasks().values()) {
            mrApp.waitForState(t, TaskState.RUNNING);
        }
        allocator.schedule();
        rmDispatcher.await();
        Assert.assertEquals((float)0.05f, (float)job.getProgress(), (float)0.001f);
        Assert.assertEquals((float)0.05f, (float)rmApp.getProgress(), (float)0.001f);
        Iterator it = job.getTasks().values().iterator();
        this.finishNextNTasks(rmDispatcher, amNodeManager, (MRApp)mrApp, it, 1);
        allocator.schedule();
        rmDispatcher.await();
        Assert.assertEquals((float)0.14f, (float)job.getProgress(), (float)0.001f);
        Assert.assertEquals((float)0.14f, (float)rmApp.getProgress(), (float)0.001f);
        this.finishNextNTasks(rmDispatcher, amNodeManager, (MRApp)mrApp, it, 5);
        allocator.schedule();
        rmDispatcher.await();
        Assert.assertEquals((float)0.59f, (float)job.getProgress(), (float)0.001f);
        Assert.assertEquals((float)0.59f, (float)rmApp.getProgress(), (float)0.001f);
        this.finishNextNTasks(rmDispatcher, amNodeManager, (MRApp)mrApp, it, 4);
        allocator.schedule();
        rmDispatcher.await();
        Assert.assertEquals((float)0.95f, (float)job.getProgress(), (float)0.001f);
        Assert.assertEquals((float)0.95f, (float)rmApp.getProgress(), (float)0.001f);
    }

    @Test
    public void testBlackListedNodes() throws Exception {
        LOG.info((Object)"Running testBlackListedNodes");
        Configuration conf = new Configuration();
        conf.setBoolean("yarn.app.mapreduce.am.job.node-blacklisting.enable", true);
        conf.setInt("mapreduce.job.maxtaskfailures.per.tracker", 1);
        conf.setInt("yarn.app.mapreduce.am.job.node-blacklisting.ignore-threshold-node-percent", -1);
        MyResourceManager rm = new MyResourceManager(conf);
        rm.start();
        DrainDispatcher dispatcher = (DrainDispatcher)rm.getRMContext().getDispatcher();
        RMApp app = rm.submitApp(1024);
        dispatcher.await();
        MockNM amNodeManager = rm.registerNode("amNM:1234", 2048);
        amNodeManager.nodeHeartbeat(true);
        dispatcher.await();
        ApplicationAttemptId appAttemptId = app.getCurrentAppAttempt().getAppAttemptId();
        rm.sendAMLaunched(appAttemptId);
        dispatcher.await();
        JobId jobId = MRBuilderUtils.newJobId((ApplicationId)appAttemptId.getApplicationId(), (int)0);
        Job mockJob = (Job)Mockito.mock(Job.class);
        Mockito.when((Object)mockJob.getReport()).thenReturn((Object)MRBuilderUtils.newJobReport((JobId)jobId, (String)"job", (String)"user", (JobState)JobState.RUNNING, (long)0L, (long)0L, (long)0L, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (String)"jobfile", null, (boolean)false, (String)""));
        MyContainerAllocator allocator = new MyContainerAllocator(rm, conf, appAttemptId, mockJob);
        MockNM nodeManager1 = rm.registerNode("h1:1234", 10240);
        MockNM nodeManager2 = rm.registerNode("h2:1234", 10240);
        MockNM nodeManager3 = rm.registerNode("h3:1234", 10240);
        dispatcher.await();
        ContainerRequestEvent event1 = this.createReq(jobId, 1, 1024, new String[]{"h1"});
        allocator.sendRequest(event1);
        ContainerRequestEvent event2 = this.createReq(jobId, 2, 1024, new String[]{"h2"});
        allocator.sendRequest(event2);
        ContainerRequestEvent event3 = this.createReq(jobId, 3, 1024, new String[]{"h3"});
        allocator.sendRequest(event3);
        List assigned = allocator.schedule();
        dispatcher.await();
        Assert.assertEquals((String)"No of assignments must be 0", (int)0, (int)assigned.size());
        ContainerFailedEvent f1 = this.createFailEvent(jobId, 1, "h1", false);
        allocator.sendFailure(f1);
        ContainerFailedEvent f2 = this.createFailEvent(jobId, 1, "h2", false);
        allocator.sendFailure(f2);
        nodeManager1.nodeHeartbeat(true);
        nodeManager2.nodeHeartbeat(true);
        dispatcher.await();
        assigned = allocator.schedule();
        dispatcher.await();
        Assert.assertEquals((String)"No of assignments must be 0", (int)0, (int)assigned.size());
        nodeManager1.nodeHeartbeat(false);
        nodeManager2.nodeHeartbeat(false);
        dispatcher.await();
        assigned = allocator.schedule();
        dispatcher.await();
        Assert.assertEquals((String)"No of assignments must be 0", (int)0, (int)assigned.size());
        nodeManager3.nodeHeartbeat(true);
        dispatcher.await();
        assigned = allocator.schedule();
        dispatcher.await();
        Assert.assertTrue((String)"No of assignments must be 3", (assigned.size() == 3 ? 1 : 0) != 0);
        for (TaskAttemptContainerAssignedEvent assig : assigned) {
            Assert.assertTrue((String)"Assigned container host not correct", (boolean)"h3".equals(assig.getContainer().getNodeId().getHost()));
        }
    }

    @Test
    public void testIgnoreBlacklisting() throws Exception {
        LOG.info((Object)"Running testIgnoreBlacklisting");
        Configuration conf = new Configuration();
        conf.setBoolean("yarn.app.mapreduce.am.job.node-blacklisting.enable", true);
        conf.setInt("mapreduce.job.maxtaskfailures.per.tracker", 1);
        conf.setInt("yarn.app.mapreduce.am.job.node-blacklisting.ignore-threshold-node-percent", 33);
        MyResourceManager rm = new MyResourceManager(conf);
        rm.start();
        DrainDispatcher dispatcher = (DrainDispatcher)rm.getRMContext().getDispatcher();
        RMApp app = rm.submitApp(1024);
        dispatcher.await();
        MockNM[] nodeManagers = new MockNM[10];
        int nmNum = 0;
        List assigned = null;
        nodeManagers[nmNum] = this.registerNodeManager(nmNum++, rm, dispatcher);
        nodeManagers[0].nodeHeartbeat(true);
        dispatcher.await();
        ApplicationAttemptId appAttemptId = app.getCurrentAppAttempt().getAppAttemptId();
        rm.sendAMLaunched(appAttemptId);
        dispatcher.await();
        JobId jobId = MRBuilderUtils.newJobId((ApplicationId)appAttemptId.getApplicationId(), (int)0);
        Job mockJob = (Job)Mockito.mock(Job.class);
        Mockito.when((Object)mockJob.getReport()).thenReturn((Object)MRBuilderUtils.newJobReport((JobId)jobId, (String)"job", (String)"user", (JobState)JobState.RUNNING, (long)0L, (long)0L, (long)0L, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (String)"jobfile", null, (boolean)false, (String)""));
        MyContainerAllocator allocator = new MyContainerAllocator(rm, conf, appAttemptId, mockJob);
        assigned = this.getContainerOnHost(jobId, 1, 1024, new String[]{"h1"}, nodeManagers[0], dispatcher, allocator);
        Assert.assertEquals((String)"No of assignments must be 1", (int)1, (int)assigned.size());
        LOG.info((Object)"Failing container _1 on H1 (Node should be blacklisted and ignore blacklisting enabled");
        ContainerFailedEvent f1 = this.createFailEvent(jobId, 1, "h1", false);
        allocator.sendFailure(f1);
        assigned = this.getContainerOnHost(jobId, 2, 1024, new String[]{"h1"}, nodeManagers[0], dispatcher, allocator);
        Assert.assertEquals((String)"No of assignments must be 1", (int)1, (int)assigned.size());
        nodeManagers[nmNum] = this.registerNodeManager(nmNum++, rm, dispatcher);
        assigned = this.getContainerOnHost(jobId, 3, 1024, new String[]{"h2"}, nodeManagers[1], dispatcher, allocator);
        Assert.assertEquals((String)"No of assignments must be 1", (int)1, (int)assigned.size());
        nodeManagers[nmNum] = this.registerNodeManager(nmNum++, rm, dispatcher);
        assigned = this.getContainerOnHost(jobId, 4, 1024, new String[]{"h3"}, nodeManagers[2], dispatcher, allocator);
        Assert.assertEquals((String)"No of assignments must be 1", (int)1, (int)assigned.size());
        assigned = this.getContainerOnHost(jobId, 5, 1024, new String[]{"h1"}, nodeManagers[0], dispatcher, allocator);
        Assert.assertEquals((String)"No of assignments must be 1", (int)1, (int)assigned.size());
        nodeManagers[nmNum] = this.registerNodeManager(nmNum++, rm, dispatcher);
        assigned = this.getContainerOnHost(jobId, 6, 1024, new String[]{"h4"}, nodeManagers[3], dispatcher, allocator);
        Assert.assertEquals((String)"No of assignments must be 1", (int)1, (int)assigned.size());
        assigned = this.getContainerOnHost(jobId, 7, 1024, new String[]{"h1"}, nodeManagers[0], dispatcher, allocator);
        Assert.assertEquals((String)"No of assignments must be 0", (int)0, (int)assigned.size());
        ContainerFailedEvent f2 = this.createFailEvent(jobId, 3, "h2", false);
        allocator.sendFailure(f2);
        assigned = this.getContainerOnHost(jobId, 8, 1024, new String[]{"h1"}, nodeManagers[0], dispatcher, allocator);
        Assert.assertEquals((String)"No of assignments must be 2", (int)2, (int)assigned.size());
        assigned = this.getContainerOnHost(jobId, 9, 1024, new String[]{"h2"}, nodeManagers[1], dispatcher, allocator);
        Assert.assertEquals((String)"No of assignments must be 1", (int)1, (int)assigned.size());
        ContainerFailedEvent f3 = this.createFailEvent(jobId, 4, "h3", false);
        allocator.sendFailure(f3);
        nodeManagers[nmNum] = this.registerNodeManager(nmNum++, rm, dispatcher);
        assigned = this.getContainerOnHost(jobId, 10, 1024, new String[]{"h3"}, nodeManagers[2], dispatcher, allocator);
        Assert.assertEquals((String)"No of assignments must be 1", (int)1, (int)assigned.size());
        for (int i = 0; i < 5; ++i) {
            nodeManagers[nmNum] = this.registerNodeManager(nmNum++, rm, dispatcher);
            assigned = this.getContainerOnHost(jobId, 11 + i, 1024, new String[]{String.valueOf(5 + i)}, nodeManagers[4 + i], dispatcher, allocator);
            Assert.assertEquals((String)"No of assignments must be 1", (int)1, (int)assigned.size());
        }
        assigned = this.getContainerOnHost(jobId, 20, 1024, new String[]{"h3"}, nodeManagers[2], dispatcher, allocator);
        Assert.assertEquals((String)"No of assignments must be 0", (int)0, (int)assigned.size());
    }

    private MockNM registerNodeManager(int i, MyResourceManager rm, DrainDispatcher dispatcher) throws Exception {
        MockNM nm = rm.registerNode("h" + (i + 1) + ":1234", 10240);
        dispatcher.await();
        return nm;
    }

    private List<TaskAttemptContainerAssignedEvent> getContainerOnHost(JobId jobId, int taskAttemptId, int memory, String[] hosts, MockNM mockNM, DrainDispatcher dispatcher, MyContainerAllocator allocator) throws Exception {
        ContainerRequestEvent reqEvent = this.createReq(jobId, taskAttemptId, memory, hosts);
        allocator.sendRequest(reqEvent);
        List assigned = allocator.schedule();
        dispatcher.await();
        Assert.assertEquals((String)"No of assignments must be 0", (int)0, (int)assigned.size());
        mockNM.nodeHeartbeat(true);
        dispatcher.await();
        assigned = allocator.schedule();
        dispatcher.await();
        return assigned;
    }

    @Test
    public void testBlackListedNodesWithSchedulingToThatNode() throws Exception {
        LOG.info((Object)"Running testBlackListedNodesWithSchedulingToThatNode");
        Configuration conf = new Configuration();
        conf.setBoolean("yarn.app.mapreduce.am.job.node-blacklisting.enable", true);
        conf.setInt("mapreduce.job.maxtaskfailures.per.tracker", 1);
        conf.setInt("yarn.app.mapreduce.am.job.node-blacklisting.ignore-threshold-node-percent", -1);
        MyResourceManager rm = new MyResourceManager(conf);
        rm.start();
        DrainDispatcher dispatcher = (DrainDispatcher)rm.getRMContext().getDispatcher();
        RMApp app = rm.submitApp(1024);
        dispatcher.await();
        MockNM amNodeManager = rm.registerNode("amNM:1234", 2048);
        amNodeManager.nodeHeartbeat(true);
        dispatcher.await();
        ApplicationAttemptId appAttemptId = app.getCurrentAppAttempt().getAppAttemptId();
        rm.sendAMLaunched(appAttemptId);
        dispatcher.await();
        JobId jobId = MRBuilderUtils.newJobId((ApplicationId)appAttemptId.getApplicationId(), (int)0);
        Job mockJob = (Job)Mockito.mock(Job.class);
        Mockito.when((Object)mockJob.getReport()).thenReturn((Object)MRBuilderUtils.newJobReport((JobId)jobId, (String)"job", (String)"user", (JobState)JobState.RUNNING, (long)0L, (long)0L, (long)0L, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (String)"jobfile", null, (boolean)false, (String)""));
        MyContainerAllocator allocator = new MyContainerAllocator(rm, conf, appAttemptId, mockJob);
        MockNM nodeManager1 = rm.registerNode("h1:1234", 10240);
        MockNM nodeManager3 = rm.registerNode("h3:1234", 10240);
        dispatcher.await();
        LOG.info((Object)"Requesting 1 Containers _1 on H1");
        ContainerRequestEvent event1 = this.createReq(jobId, 1, 1024, new String[]{"h1"});
        allocator.sendRequest(event1);
        LOG.info((Object)"RM Heartbeat (to send the container requests)");
        List assigned = allocator.schedule();
        dispatcher.await();
        Assert.assertEquals((String)"No of assignments must be 0", (int)0, (int)assigned.size());
        LOG.info((Object)"h1 Heartbeat (To actually schedule the containers)");
        nodeManager1.nodeHeartbeat(true);
        dispatcher.await();
        LOG.info((Object)"RM Heartbeat (To process the scheduled containers)");
        assigned = allocator.schedule();
        dispatcher.await();
        Assert.assertEquals((String)"No of assignments must be 1", (int)1, (int)assigned.size());
        LOG.info((Object)"Failing container _1 on H1 (should blacklist the node)");
        ContainerFailedEvent f1 = this.createFailEvent(jobId, 1, "h1", false);
        allocator.sendFailure(f1);
        ContainerRequestEvent event1f = this.createReq(jobId, 1, 1024, new String[]{"h1"}, true, false);
        allocator.sendRequest(event1f);
        assigned = allocator.schedule();
        dispatcher.await();
        Assert.assertEquals((String)"No of assignments must be 0", (int)0, (int)assigned.size());
        ContainerRequestEvent event3 = this.createReq(jobId, 3, 1024, new String[]{"h1", "h3"});
        allocator.sendRequest(event3);
        LOG.info((Object)"h1 Heartbeat (To actually schedule the containers)");
        nodeManager1.nodeHeartbeat(true);
        dispatcher.await();
        LOG.info((Object)"RM Heartbeat (To process the scheduled containers)");
        assigned = allocator.schedule();
        dispatcher.await();
        Assert.assertEquals((String)"No of assignments must be 0", (int)0, (int)assigned.size());
        LOG.info((Object)"RM Heartbeat (To process the re-scheduled containers)");
        assigned = allocator.schedule();
        dispatcher.await();
        Assert.assertEquals((String)"No of assignments must be 0", (int)0, (int)assigned.size());
        LOG.info((Object)"h3 Heartbeat (To re-schedule the containers)");
        nodeManager3.nodeHeartbeat(true);
        dispatcher.await();
        LOG.info((Object)"RM Heartbeat (To process the re-scheduled containers for H3)");
        assigned = allocator.schedule();
        dispatcher.await();
        for (TaskAttemptContainerAssignedEvent assig : assigned) {
            LOG.info((Object)(assig.getTaskAttemptID() + " assgined to " + assig.getContainer().getId() + " with priority " + assig.getContainer().getPriority()));
        }
        Assert.assertEquals((String)"No of assignments must be 2", (int)2, (int)assigned.size());
        for (TaskAttemptContainerAssignedEvent assig : assigned) {
            Assert.assertEquals((String)("Assigned container " + assig.getContainer().getId() + " host not correct"), (String)"h3", (String)assig.getContainer().getNodeId().getHost());
        }
    }

    private ContainerRequestEvent createReq(JobId jobId, int taskAttemptId, int memory, String[] hosts) {
        return this.createReq(jobId, taskAttemptId, memory, hosts, false, false);
    }

    private ContainerRequestEvent createReq(JobId jobId, int taskAttemptId, int memory, String[] hosts, boolean earlierFailedAttempt, boolean reduce) {
        TaskId taskId = reduce ? MRBuilderUtils.newTaskId((JobId)jobId, (int)0, (TaskType)TaskType.REDUCE) : MRBuilderUtils.newTaskId((JobId)jobId, (int)0, (TaskType)TaskType.MAP);
        TaskAttemptId attemptId = MRBuilderUtils.newTaskAttemptId((TaskId)taskId, (int)taskAttemptId);
        Resource containerNeed = BuilderUtils.newResource((int)memory);
        if (earlierFailedAttempt) {
            return ContainerRequestEvent.createContainerRequestEventForFailedContainer((TaskAttemptId)attemptId, (Resource)containerNeed);
        }
        return new ContainerRequestEvent(attemptId, containerNeed, hosts, new String[]{"/default-rack"});
    }

    private ContainerFailedEvent createFailEvent(JobId jobId, int taskAttemptId, String host, boolean reduce) {
        TaskId taskId = reduce ? MRBuilderUtils.newTaskId((JobId)jobId, (int)0, (TaskType)TaskType.REDUCE) : MRBuilderUtils.newTaskId((JobId)jobId, (int)0, (TaskType)TaskType.MAP);
        TaskAttemptId attemptId = MRBuilderUtils.newTaskAttemptId((TaskId)taskId, (int)taskAttemptId);
        return new ContainerFailedEvent(attemptId, host);
    }

    private void checkAssignments(ContainerRequestEvent[] requests, List<TaskAttemptContainerAssignedEvent> assignments, boolean checkHostMatch) {
        Assert.assertNotNull((String)"Container not assigned", assignments);
        Assert.assertEquals((String)"Assigned count not correct", (int)requests.length, (int)assignments.size());
        HashSet<ContainerId> containerIds = new HashSet<ContainerId>();
        for (TaskAttemptContainerAssignedEvent assigned : assignments) {
            containerIds.add(assigned.getContainer().getId());
        }
        Assert.assertEquals((String)"Assigned containers must be different", (int)assignments.size(), (int)containerIds.size());
        for (ContainerRequestEvent req : requests) {
            TaskAttemptContainerAssignedEvent assigned = null;
            for (TaskAttemptContainerAssignedEvent ass : assignments) {
                if (!ass.getTaskAttemptID().equals((Object)req.getAttemptID())) continue;
                assigned = ass;
                break;
            }
            this.checkAssignment(req, assigned, checkHostMatch);
        }
    }

    private void checkAssignment(ContainerRequestEvent request, TaskAttemptContainerAssignedEvent assigned, boolean checkHostMatch) {
        Assert.assertNotNull((String)("Nothing assigned to attempt " + request.getAttemptID()), (Object)assigned);
        Assert.assertEquals((String)"assigned to wrong attempt", (Object)request.getAttemptID(), (Object)assigned.getTaskAttemptID());
        if (checkHostMatch) {
            Assert.assertTrue((String)"Not assigned to requested host", (boolean)Arrays.asList(request.getHosts()).contains(assigned.getContainer().getNodeId().toString()));
        }
    }

    @Test
    public void testReduceScheduling() throws Exception {
        int totalMaps = 10;
        int succeededMaps = 1;
        int scheduledMaps = 10;
        int scheduledReduces = 0;
        int assignedMaps = 2;
        int assignedReduces = 0;
        int mapResourceReqt = 1024;
        int reduceResourceReqt = 2048;
        int numPendingReduces = 4;
        float maxReduceRampupLimit = 0.5f;
        float reduceSlowStart = 0.2f;
        RMContainerAllocator allocator = (RMContainerAllocator)Mockito.mock(RMContainerAllocator.class);
        ((RMContainerAllocator)Mockito.doCallRealMethod().when((Object)allocator)).scheduleReduces(Matchers.anyInt(), Matchers.anyInt(), Matchers.anyInt(), Matchers.anyInt(), Matchers.anyInt(), Matchers.anyInt(), Matchers.anyInt(), Matchers.anyInt(), Matchers.anyInt(), Matchers.anyFloat(), Matchers.anyFloat());
        allocator.scheduleReduces(totalMaps, succeededMaps, scheduledMaps, scheduledReduces, assignedMaps, assignedReduces, mapResourceReqt, reduceResourceReqt, numPendingReduces, maxReduceRampupLimit, reduceSlowStart);
        ((RMContainerAllocator)Mockito.verify((Object)allocator, (VerificationMode)Mockito.never())).setIsReduceStarted(true);
        allocator.scheduleReduces(totalMaps, succeededMaps, 0, scheduledReduces, totalMaps - succeededMaps, assignedReduces, mapResourceReqt, reduceResourceReqt, numPendingReduces, maxReduceRampupLimit, reduceSlowStart);
        ((RMContainerAllocator)Mockito.verify((Object)allocator, (VerificationMode)Mockito.never())).setIsReduceStarted(true);
        ((RMContainerAllocator)Mockito.verify((Object)allocator, (VerificationMode)Mockito.never())).scheduleAllReduces();
        succeededMaps = 3;
        allocator.scheduleReduces(totalMaps, succeededMaps, scheduledMaps, scheduledReduces, assignedMaps, assignedReduces, mapResourceReqt, reduceResourceReqt, numPendingReduces, maxReduceRampupLimit, reduceSlowStart);
        ((RMContainerAllocator)Mockito.verify((Object)allocator, (VerificationMode)Mockito.times((int)1))).setIsReduceStarted(true);
        ((RMContainerAllocator)Mockito.doReturn((Object)102400).when((Object)allocator)).getMemLimit();
        allocator.scheduleReduces(totalMaps, succeededMaps, scheduledMaps, scheduledReduces, assignedMaps, assignedReduces, mapResourceReqt, reduceResourceReqt, numPendingReduces, maxReduceRampupLimit, reduceSlowStart);
        ((RMContainerAllocator)Mockito.verify((Object)allocator)).rampUpReduces(Matchers.anyInt());
        ((RMContainerAllocator)Mockito.verify((Object)allocator, (VerificationMode)Mockito.never())).rampDownReduces(Matchers.anyInt());
        scheduledReduces = 3;
        ((RMContainerAllocator)Mockito.doReturn((Object)10240).when((Object)allocator)).getMemLimit();
        allocator.scheduleReduces(totalMaps, succeededMaps, scheduledMaps, scheduledReduces, assignedMaps, assignedReduces, mapResourceReqt, reduceResourceReqt, numPendingReduces, maxReduceRampupLimit, reduceSlowStart);
        ((RMContainerAllocator)Mockito.verify((Object)allocator)).rampDownReduces(Matchers.anyInt());
    }

    @Test
    public void testCompletedTasksRecalculateSchedule() throws Exception {
        LOG.info((Object)"Running testCompletedTasksRecalculateSchedule");
        Configuration conf = new Configuration();
        MyResourceManager rm = new MyResourceManager(conf);
        rm.start();
        DrainDispatcher dispatcher = (DrainDispatcher)rm.getRMContext().getDispatcher();
        RMApp app = rm.submitApp(1024);
        dispatcher.await();
        ApplicationAttemptId appAttemptId = app.getCurrentAppAttempt().getAppAttemptId();
        JobId jobId = MRBuilderUtils.newJobId((ApplicationId)appAttemptId.getApplicationId(), (int)0);
        Job job = (Job)Mockito.mock(Job.class);
        Mockito.when((Object)job.getReport()).thenReturn((Object)MRBuilderUtils.newJobReport((JobId)jobId, (String)"job", (String)"user", (JobState)JobState.RUNNING, (long)0L, (long)0L, (long)0L, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (String)"jobfile", null, (boolean)false, (String)""));
        ((Job)Mockito.doReturn((Object)10).when((Object)job)).getTotalMaps();
        ((Job)Mockito.doReturn((Object)10).when((Object)job)).getTotalReduces();
        ((Job)Mockito.doReturn((Object)0).when((Object)job)).getCompletedMaps();
        RecalculateContainerAllocator allocator = new RecalculateContainerAllocator(rm, conf, appAttemptId, job);
        allocator.schedule();
        allocator.recalculatedReduceSchedule = false;
        allocator.schedule();
        Assert.assertFalse((String)"Unexpected recalculate of reduce schedule", (boolean)allocator.recalculatedReduceSchedule);
        ((Job)Mockito.doReturn((Object)1).when((Object)job)).getCompletedMaps();
        allocator.schedule();
        Assert.assertTrue((String)"Expected recalculate of reduce schedule", (boolean)allocator.recalculatedReduceSchedule);
    }

    public static void main(String[] args) throws Exception {
        TestRMContainerAllocator t = new TestRMContainerAllocator();
        t.testSimple();
        t.testResource();
        t.testMapReduceScheduling();
        t.testReportedAppProgress();
        t.testReportedAppProgressWithOnlyMaps();
        t.testBlackListedNodes();
        t.testCompletedTasksRecalculateSchedule();
    }
}

