/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.v2.app;

import java.io.IOException;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.v2.api.records.JobId;
import org.apache.hadoop.mapreduce.v2.api.records.JobState;
import org.apache.hadoop.mapreduce.v2.app.MRAppMaster;
import org.apache.hadoop.mapreduce.v2.app.TestStagingCleanup;
import org.apache.hadoop.mapreduce.v2.app.job.Job;
import org.apache.hadoop.mapreduce.v2.app.job.impl.JobImpl;
import org.apache.hadoop.mapreduce.v2.app.rm.ContainerAllocator;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.factories.RecordFactory;
import org.apache.hadoop.yarn.factory.providers.RecordFactoryProvider;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class TestStagingCleanup
extends TestCase {
    private Configuration conf = new Configuration();
    private FileSystem fs;
    private String stagingJobDir = "tmpJobDir";
    private Path stagingJobPath = new Path(this.stagingJobDir);
    private static final RecordFactory recordFactory = RecordFactoryProvider.getRecordFactory(null);

    @Test
    public void testDeletionofStaging() throws IOException {
        this.conf.set("mapreduce.job.dir", this.stagingJobDir);
        this.fs = (FileSystem)Mockito.mock(FileSystem.class);
        Mockito.when((Object)this.fs.delete((Path)Matchers.any(Path.class), Matchers.anyBoolean())).thenReturn((Object)true);
        ApplicationAttemptId attemptId = (ApplicationAttemptId)recordFactory.newRecordInstance(ApplicationAttemptId.class);
        attemptId.setAttemptId(0);
        ApplicationId appId = (ApplicationId)recordFactory.newRecordInstance(ApplicationId.class);
        appId.setClusterTimestamp(System.currentTimeMillis());
        appId.setId(0);
        attemptId.setApplicationId(appId);
        JobId jobid = (JobId)recordFactory.newRecordInstance(JobId.class);
        jobid.setAppId(appId);
        TestMRApp appMaster = new TestMRApp(this, attemptId);
        appMaster.init(this.conf);
        appMaster.shutDownJob();
        ((FileSystem)Mockito.verify((Object)this.fs)).delete(this.stagingJobPath, true);
    }

    @Test
    public void testDeletionofStagingOnKill() throws IOException {
        this.conf.set("mapreduce.job.dir", this.stagingJobDir);
        this.conf.setInt("yarn.resourcemanager.am.max-retries", 4);
        this.fs = (FileSystem)Mockito.mock(FileSystem.class);
        Mockito.when((Object)this.fs.delete((Path)Matchers.any(Path.class), Matchers.anyBoolean())).thenReturn((Object)true);
        ApplicationAttemptId attemptId = (ApplicationAttemptId)recordFactory.newRecordInstance(ApplicationAttemptId.class);
        attemptId.setAttemptId(0);
        ApplicationId appId = (ApplicationId)recordFactory.newRecordInstance(ApplicationId.class);
        appId.setClusterTimestamp(System.currentTimeMillis());
        appId.setId(0);
        attemptId.setApplicationId(appId);
        JobId jobid = (JobId)recordFactory.newRecordInstance(JobId.class);
        jobid.setAppId(appId);
        ContainerAllocator mockAlloc = (ContainerAllocator)Mockito.mock(ContainerAllocator.class);
        TestMRApp appMaster = new TestMRApp(this, attemptId, mockAlloc);
        appMaster.init(this.conf);
        MRAppMaster.MRAppMasterShutdownHook hook = new MRAppMaster.MRAppMasterShutdownHook((MRAppMaster)appMaster);
        hook.run();
        ((FileSystem)Mockito.verify((Object)this.fs, (VerificationMode)Mockito.times((int)0))).delete(this.stagingJobPath, true);
    }

    @Test
    public void testDeletionofStagingOnKillLastTry() throws IOException {
        this.conf.set("mapreduce.job.dir", this.stagingJobDir);
        this.conf.setInt("yarn.resourcemanager.am.max-retries", 1);
        this.fs = (FileSystem)Mockito.mock(FileSystem.class);
        Mockito.when((Object)this.fs.delete((Path)Matchers.any(Path.class), Matchers.anyBoolean())).thenReturn((Object)true);
        ApplicationAttemptId attemptId = (ApplicationAttemptId)recordFactory.newRecordInstance(ApplicationAttemptId.class);
        attemptId.setAttemptId(1);
        ApplicationId appId = (ApplicationId)recordFactory.newRecordInstance(ApplicationId.class);
        appId.setClusterTimestamp(System.currentTimeMillis());
        appId.setId(0);
        attemptId.setApplicationId(appId);
        JobId jobid = (JobId)recordFactory.newRecordInstance(JobId.class);
        jobid.setAppId(appId);
        ContainerAllocator mockAlloc = (ContainerAllocator)Mockito.mock(ContainerAllocator.class);
        TestMRApp appMaster = new TestMRApp(this, attemptId, mockAlloc);
        appMaster.init(this.conf);
        MRAppMaster.MRAppMasterShutdownHook hook = new MRAppMaster.MRAppMasterShutdownHook((MRAppMaster)appMaster);
        hook.run();
        ((FileSystem)Mockito.verify((Object)this.fs)).delete(this.stagingJobPath, true);
    }

    @Test
    public void testStagingCleanupOrder() throws Exception {
        MRAppTestCleanup app = new MRAppTestCleanup(this, 1, 1, true, this.getClass().getName(), true);
        JobImpl job = (JobImpl)app.submit(new Configuration());
        app.waitForState((Job)job, JobState.SUCCEEDED);
        app.verifyCompleted();
        for (int waitTime = 20000; waitTime > 0 && !app.cleanedBeforeContainerAllocatorStopped; waitTime -= 100) {
            Thread.sleep(100L);
        }
        Assert.assertTrue((String)"Staging directory not cleaned before notifying RM", (boolean)app.cleanedBeforeContainerAllocatorStopped);
    }

    static /* synthetic */ FileSystem access$000(TestStagingCleanup x0) {
        return x0.fs;
    }

    static /* synthetic */ Configuration access$100(TestStagingCleanup x0) {
        return x0.conf;
    }
}

