/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.v2.app.job.impl;

import com.google.common.annotations.VisibleForTesting;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.DataOutputBuffer;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.JobID;
import org.apache.hadoop.mapred.MapReduceChildJVM;
import org.apache.hadoop.mapred.ShuffleHandler;
import org.apache.hadoop.mapred.Task;
import org.apache.hadoop.mapred.WrappedJvmID;
import org.apache.hadoop.mapred.WrappedProgressSplitsBlock;
import org.apache.hadoop.mapreduce.Counter;
import org.apache.hadoop.mapreduce.Counters;
import org.apache.hadoop.mapreduce.ID;
import org.apache.hadoop.mapreduce.JobCounter;
import org.apache.hadoop.mapreduce.OutputCommitter;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.hadoop.mapreduce.TaskCounter;
import org.apache.hadoop.mapreduce.TypeConverter;
import org.apache.hadoop.mapreduce.jobhistory.HistoryEvent;
import org.apache.hadoop.mapreduce.jobhistory.JobHistoryEvent;
import org.apache.hadoop.mapreduce.jobhistory.MapAttemptFinishedEvent;
import org.apache.hadoop.mapreduce.jobhistory.ReduceAttemptFinishedEvent;
import org.apache.hadoop.mapreduce.jobhistory.TaskAttemptUnsuccessfulCompletionEvent;
import org.apache.hadoop.mapreduce.security.TokenCache;
import org.apache.hadoop.mapreduce.security.token.JobTokenIdentifier;
import org.apache.hadoop.mapreduce.v2.api.records.JobId;
import org.apache.hadoop.mapreduce.v2.api.records.Phase;
import org.apache.hadoop.mapreduce.v2.api.records.TaskAttemptId;
import org.apache.hadoop.mapreduce.v2.api.records.TaskAttemptReport;
import org.apache.hadoop.mapreduce.v2.api.records.TaskAttemptState;
import org.apache.hadoop.mapreduce.v2.api.records.TaskId;
import org.apache.hadoop.mapreduce.v2.api.records.TaskType;
import org.apache.hadoop.mapreduce.v2.app.AppContext;
import org.apache.hadoop.mapreduce.v2.app.TaskAttemptListener;
import org.apache.hadoop.mapreduce.v2.app.job.TaskAttempt;
import org.apache.hadoop.mapreduce.v2.app.job.TaskAttemptStateInternal;
import org.apache.hadoop.mapreduce.v2.app.job.event.JobCounterUpdateEvent;
import org.apache.hadoop.mapreduce.v2.app.job.event.JobDiagnosticsUpdateEvent;
import org.apache.hadoop.mapreduce.v2.app.job.event.JobEvent;
import org.apache.hadoop.mapreduce.v2.app.job.event.JobEventType;
import org.apache.hadoop.mapreduce.v2.app.job.event.TaskAttemptEvent;
import org.apache.hadoop.mapreduce.v2.app.job.event.TaskAttemptEventType;
import org.apache.hadoop.mapreduce.v2.app.job.event.TaskAttemptStatusUpdateEvent;
import org.apache.hadoop.mapreduce.v2.app.job.impl.TaskAttemptImpl;
import org.apache.hadoop.mapreduce.v2.util.MRApps;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.yarn.Clock;
import org.apache.hadoop.yarn.YarnException;
import org.apache.hadoop.yarn.api.ApplicationConstants;
import org.apache.hadoop.yarn.api.records.ApplicationAccessType;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ContainerLaunchContext;
import org.apache.hadoop.yarn.api.records.ContainerToken;
import org.apache.hadoop.yarn.api.records.LocalResource;
import org.apache.hadoop.yarn.api.records.LocalResourceType;
import org.apache.hadoop.yarn.api.records.LocalResourceVisibility;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.URL;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.event.EventHandler;
import org.apache.hadoop.yarn.factories.RecordFactory;
import org.apache.hadoop.yarn.factory.providers.RecordFactoryProvider;
import org.apache.hadoop.yarn.state.InvalidStateTransitonException;
import org.apache.hadoop.yarn.state.SingleArcTransition;
import org.apache.hadoop.yarn.state.StateMachine;
import org.apache.hadoop.yarn.state.StateMachineFactory;
import org.apache.hadoop.yarn.util.Apps;
import org.apache.hadoop.yarn.util.BuilderUtils;
import org.apache.hadoop.yarn.util.ConverterUtils;
import org.apache.hadoop.yarn.util.RackResolver;

/*
 * Exception performing whole class analysis ignored.
 */
public abstract class TaskAttemptImpl
implements TaskAttempt,
EventHandler<TaskAttemptEvent> {
    static final Counters EMPTY_COUNTERS = new Counters();
    private static final Log LOG = LogFactory.getLog(TaskAttemptImpl.class);
    private static final long MEMORY_SPLITS_RESOLUTION = 1024L;
    private static final RecordFactory recordFactory = RecordFactoryProvider.getRecordFactory(null);
    protected final JobConf conf;
    protected final Path jobFile;
    protected final int partition;
    protected EventHandler eventHandler;
    private final TaskAttemptId attemptId;
    private final Clock clock;
    private final JobID oldJobId;
    private final TaskAttemptListener taskAttemptListener;
    private final OutputCommitter committer;
    private final Resource resourceCapability;
    private final String[] dataLocalHosts;
    private final List<String> diagnostics = new ArrayList();
    private final Lock readLock;
    private final Lock writeLock;
    private final AppContext appContext;
    private Credentials credentials;
    private Token<JobTokenIdentifier> jobToken;
    private static AtomicBoolean initialClasspathFlag = new AtomicBoolean();
    private static String initialClasspath = null;
    private static Object commonContainerSpecLock = new Object();
    private static ContainerLaunchContext commonContainerSpec = null;
    private static final Object classpathLock = new Object();
    private long launchTime;
    private long finishTime;
    private WrappedProgressSplitsBlock progressSplitBlock;
    private int shufflePort = -1;
    private String trackerName;
    private int httpPort;
    private static final CleanupContainerTransition CLEANUP_CONTAINER_TRANSITION = new CleanupContainerTransition(null);
    private static final DiagnosticInformationUpdater DIAGNOSTIC_INFORMATION_UPDATE_TRANSITION = new DiagnosticInformationUpdater(null);
    private static final StateMachineFactory<TaskAttemptImpl, TaskAttemptStateInternal, TaskAttemptEventType, TaskAttemptEvent> stateMachineFactory = new StateMachineFactory((Enum)TaskAttemptStateInternal.NEW).addTransition((Enum)TaskAttemptStateInternal.NEW, (Enum)TaskAttemptStateInternal.UNASSIGNED, (Enum)TaskAttemptEventType.TA_SCHEDULE, (SingleArcTransition)new RequestContainerTransition(false)).addTransition((Enum)TaskAttemptStateInternal.NEW, (Enum)TaskAttemptStateInternal.UNASSIGNED, (Enum)TaskAttemptEventType.TA_RESCHEDULE, (SingleArcTransition)new RequestContainerTransition(true)).addTransition((Enum)TaskAttemptStateInternal.NEW, (Enum)TaskAttemptStateInternal.KILLED, (Enum)TaskAttemptEventType.TA_KILL, (SingleArcTransition)new KilledTransition(null)).addTransition((Enum)TaskAttemptStateInternal.NEW, (Enum)TaskAttemptStateInternal.FAILED, (Enum)TaskAttemptEventType.TA_FAILMSG, (SingleArcTransition)new FailedTransition(null)).addTransition((Enum)TaskAttemptStateInternal.UNASSIGNED, (Enum)TaskAttemptStateInternal.ASSIGNED, (Enum)TaskAttemptEventType.TA_ASSIGNED, (SingleArcTransition)new ContainerAssignedTransition(null)).addTransition((Enum)TaskAttemptStateInternal.UNASSIGNED, (Enum)TaskAttemptStateInternal.KILLED, (Enum)TaskAttemptEventType.TA_KILL, (SingleArcTransition)new DeallocateContainerTransition(TaskAttemptStateInternal.KILLED, true)).addTransition((Enum)TaskAttemptStateInternal.UNASSIGNED, (Enum)TaskAttemptStateInternal.FAILED, (Enum)TaskAttemptEventType.TA_FAILMSG, (SingleArcTransition)new DeallocateContainerTransition(TaskAttemptStateInternal.FAILED, true)).addTransition((Enum)TaskAttemptStateInternal.ASSIGNED, (Enum)TaskAttemptStateInternal.RUNNING, (Enum)TaskAttemptEventType.TA_CONTAINER_LAUNCHED, (SingleArcTransition)new LaunchedContainerTransition(null)).addTransition((Enum)TaskAttemptStateInternal.ASSIGNED, (Enum)TaskAttemptStateInternal.ASSIGNED, (Enum)TaskAttemptEventType.TA_DIAGNOSTICS_UPDATE, (SingleArcTransition)DIAGNOSTIC_INFORMATION_UPDATE_TRANSITION).addTransition((Enum)TaskAttemptStateInternal.ASSIGNED, (Enum)TaskAttemptStateInternal.FAILED, (Enum)TaskAttemptEventType.TA_CONTAINER_LAUNCH_FAILED, (SingleArcTransition)new DeallocateContainerTransition(TaskAttemptStateInternal.FAILED, false)).addTransition((Enum)TaskAttemptStateInternal.ASSIGNED, (Enum)TaskAttemptStateInternal.FAIL_CONTAINER_CLEANUP, (Enum)TaskAttemptEventType.TA_CONTAINER_COMPLETED, (SingleArcTransition)CLEANUP_CONTAINER_TRANSITION).addTransition((Enum)TaskAttemptStateInternal.ASSIGNED, (Enum)TaskAttemptStateInternal.KILL_CONTAINER_CLEANUP, (Enum)TaskAttemptEventType.TA_KILL, (SingleArcTransition)CLEANUP_CONTAINER_TRANSITION).addTransition((Enum)TaskAttemptStateInternal.ASSIGNED, (Enum)TaskAttemptStateInternal.FAIL_CONTAINER_CLEANUP, (Enum)TaskAttemptEventType.TA_FAILMSG, (SingleArcTransition)CLEANUP_CONTAINER_TRANSITION).addTransition((Enum)TaskAttemptStateInternal.RUNNING, (Enum)TaskAttemptStateInternal.RUNNING, (Enum)TaskAttemptEventType.TA_UPDATE, (SingleArcTransition)new StatusUpdater(null)).addTransition((Enum)TaskAttemptStateInternal.RUNNING, (Enum)TaskAttemptStateInternal.RUNNING, (Enum)TaskAttemptEventType.TA_DIAGNOSTICS_UPDATE, (SingleArcTransition)DIAGNOSTIC_INFORMATION_UPDATE_TRANSITION).addTransition((Enum)TaskAttemptStateInternal.RUNNING, (Enum)TaskAttemptStateInternal.SUCCESS_CONTAINER_CLEANUP, (Enum)TaskAttemptEventType.TA_DONE, (SingleArcTransition)CLEANUP_CONTAINER_TRANSITION).addTransition((Enum)TaskAttemptStateInternal.RUNNING, (Enum)TaskAttemptStateInternal.COMMIT_PENDING, (Enum)TaskAttemptEventType.TA_COMMIT_PENDING, (SingleArcTransition)new CommitPendingTransition(null)).addTransition((Enum)TaskAttemptStateInternal.RUNNING, (Enum)TaskAttemptStateInternal.FAIL_CONTAINER_CLEANUP, (Enum)TaskAttemptEventType.TA_FAILMSG, (SingleArcTransition)CLEANUP_CONTAINER_TRANSITION).addTransition((Enum)TaskAttemptStateInternal.RUNNING, (Enum)TaskAttemptStateInternal.FAIL_CONTAINER_CLEANUP, (Enum)TaskAttemptEventType.TA_CONTAINER_COMPLETED, (SingleArcTransition)CLEANUP_CONTAINER_TRANSITION).addTransition((Enum)TaskAttemptStateInternal.RUNNING, (Enum)TaskAttemptStateInternal.FAIL_CONTAINER_CLEANUP, (Enum)TaskAttemptEventType.TA_TIMED_OUT, (SingleArcTransition)CLEANUP_CONTAINER_TRANSITION).addTransition((Enum)TaskAttemptStateInternal.RUNNING, (Enum)TaskAttemptStateInternal.KILLED, (Enum)TaskAttemptEventType.TA_CONTAINER_CLEANED, (SingleArcTransition)new KilledTransition(null)).addTransition((Enum)TaskAttemptStateInternal.RUNNING, (Enum)TaskAttemptStateInternal.KILL_CONTAINER_CLEANUP, (Enum)TaskAttemptEventType.TA_KILL, (SingleArcTransition)CLEANUP_CONTAINER_TRANSITION).addTransition((Enum)TaskAttemptStateInternal.COMMIT_PENDING, (Enum)TaskAttemptStateInternal.COMMIT_PENDING, (Enum)TaskAttemptEventType.TA_UPDATE, (SingleArcTransition)new StatusUpdater(null)).addTransition((Enum)TaskAttemptStateInternal.COMMIT_PENDING, (Enum)TaskAttemptStateInternal.COMMIT_PENDING, (Enum)TaskAttemptEventType.TA_DIAGNOSTICS_UPDATE, (SingleArcTransition)DIAGNOSTIC_INFORMATION_UPDATE_TRANSITION).addTransition((Enum)TaskAttemptStateInternal.COMMIT_PENDING, (Enum)TaskAttemptStateInternal.SUCCESS_CONTAINER_CLEANUP, (Enum)TaskAttemptEventType.TA_DONE, (SingleArcTransition)CLEANUP_CONTAINER_TRANSITION).addTransition((Enum)TaskAttemptStateInternal.COMMIT_PENDING, (Enum)TaskAttemptStateInternal.KILL_CONTAINER_CLEANUP, (Enum)TaskAttemptEventType.TA_KILL, (SingleArcTransition)CLEANUP_CONTAINER_TRANSITION).addTransition((Enum)TaskAttemptStateInternal.COMMIT_PENDING, (Enum)TaskAttemptStateInternal.KILLED, (Enum)TaskAttemptEventType.TA_CONTAINER_CLEANED, (SingleArcTransition)new KilledTransition(null)).addTransition((Enum)TaskAttemptStateInternal.COMMIT_PENDING, (Enum)TaskAttemptStateInternal.FAIL_CONTAINER_CLEANUP, (Enum)TaskAttemptEventType.TA_FAILMSG, (SingleArcTransition)CLEANUP_CONTAINER_TRANSITION).addTransition((Enum)TaskAttemptStateInternal.COMMIT_PENDING, (Enum)TaskAttemptStateInternal.FAIL_CONTAINER_CLEANUP, (Enum)TaskAttemptEventType.TA_CONTAINER_COMPLETED, (SingleArcTransition)CLEANUP_CONTAINER_TRANSITION).addTransition((Enum)TaskAttemptStateInternal.COMMIT_PENDING, (Enum)TaskAttemptStateInternal.FAIL_CONTAINER_CLEANUP, (Enum)TaskAttemptEventType.TA_TIMED_OUT, (SingleArcTransition)CLEANUP_CONTAINER_TRANSITION).addTransition((Enum)TaskAttemptStateInternal.SUCCESS_CONTAINER_CLEANUP, (Enum)TaskAttemptStateInternal.SUCCEEDED, (Enum)TaskAttemptEventType.TA_CONTAINER_CLEANED, (SingleArcTransition)new SucceededTransition(null)).addTransition((Enum)TaskAttemptStateInternal.SUCCESS_CONTAINER_CLEANUP, (Enum)TaskAttemptStateInternal.SUCCESS_CONTAINER_CLEANUP, (Enum)TaskAttemptEventType.TA_DIAGNOSTICS_UPDATE, (SingleArcTransition)DIAGNOSTIC_INFORMATION_UPDATE_TRANSITION).addTransition((Enum)TaskAttemptStateInternal.SUCCESS_CONTAINER_CLEANUP, (Enum)TaskAttemptStateInternal.SUCCESS_CONTAINER_CLEANUP, EnumSet.of(TaskAttemptEventType.TA_KILL, TaskAttemptEventType.TA_FAILMSG, TaskAttemptEventType.TA_TIMED_OUT, TaskAttemptEventType.TA_CONTAINER_COMPLETED)).addTransition((Enum)TaskAttemptStateInternal.FAIL_CONTAINER_CLEANUP, (Enum)TaskAttemptStateInternal.FAIL_TASK_CLEANUP, (Enum)TaskAttemptEventType.TA_CONTAINER_CLEANED, (SingleArcTransition)new TaskCleanupTransition(null)).addTransition((Enum)TaskAttemptStateInternal.FAIL_CONTAINER_CLEANUP, (Enum)TaskAttemptStateInternal.FAIL_CONTAINER_CLEANUP, (Enum)TaskAttemptEventType.TA_DIAGNOSTICS_UPDATE, (SingleArcTransition)DIAGNOSTIC_INFORMATION_UPDATE_TRANSITION).addTransition((Enum)TaskAttemptStateInternal.FAIL_CONTAINER_CLEANUP, (Enum)TaskAttemptStateInternal.FAIL_CONTAINER_CLEANUP, EnumSet.of(TaskAttemptEventType.TA_KILL, new TaskAttemptEventType[]{TaskAttemptEventType.TA_CONTAINER_COMPLETED, TaskAttemptEventType.TA_UPDATE, TaskAttemptEventType.TA_COMMIT_PENDING, TaskAttemptEventType.TA_CONTAINER_LAUNCHED, TaskAttemptEventType.TA_CONTAINER_LAUNCH_FAILED, TaskAttemptEventType.TA_DONE, TaskAttemptEventType.TA_FAILMSG, TaskAttemptEventType.TA_TIMED_OUT})).addTransition((Enum)TaskAttemptStateInternal.KILL_CONTAINER_CLEANUP, (Enum)TaskAttemptStateInternal.KILL_TASK_CLEANUP, (Enum)TaskAttemptEventType.TA_CONTAINER_CLEANED, (SingleArcTransition)new TaskCleanupTransition(null)).addTransition((Enum)TaskAttemptStateInternal.KILL_CONTAINER_CLEANUP, (Enum)TaskAttemptStateInternal.KILL_CONTAINER_CLEANUP, (Enum)TaskAttemptEventType.TA_DIAGNOSTICS_UPDATE, (SingleArcTransition)DIAGNOSTIC_INFORMATION_UPDATE_TRANSITION).addTransition((Enum)TaskAttemptStateInternal.KILL_CONTAINER_CLEANUP, (Enum)TaskAttemptStateInternal.KILL_CONTAINER_CLEANUP, EnumSet.of(TaskAttemptEventType.TA_KILL, new TaskAttemptEventType[]{TaskAttemptEventType.TA_CONTAINER_COMPLETED, TaskAttemptEventType.TA_UPDATE, TaskAttemptEventType.TA_COMMIT_PENDING, TaskAttemptEventType.TA_CONTAINER_LAUNCHED, TaskAttemptEventType.TA_CONTAINER_LAUNCH_FAILED, TaskAttemptEventType.TA_DONE, TaskAttemptEventType.TA_FAILMSG, TaskAttemptEventType.TA_TIMED_OUT})).addTransition((Enum)TaskAttemptStateInternal.FAIL_TASK_CLEANUP, (Enum)TaskAttemptStateInternal.FAILED, (Enum)TaskAttemptEventType.TA_CLEANUP_DONE, (SingleArcTransition)new FailedTransition(null)).addTransition((Enum)TaskAttemptStateInternal.FAIL_TASK_CLEANUP, (Enum)TaskAttemptStateInternal.FAIL_TASK_CLEANUP, (Enum)TaskAttemptEventType.TA_DIAGNOSTICS_UPDATE, (SingleArcTransition)DIAGNOSTIC_INFORMATION_UPDATE_TRANSITION).addTransition((Enum)TaskAttemptStateInternal.FAIL_TASK_CLEANUP, (Enum)TaskAttemptStateInternal.FAIL_TASK_CLEANUP, EnumSet.of(TaskAttemptEventType.TA_KILL, new TaskAttemptEventType[]{TaskAttemptEventType.TA_CONTAINER_COMPLETED, TaskAttemptEventType.TA_UPDATE, TaskAttemptEventType.TA_COMMIT_PENDING, TaskAttemptEventType.TA_DONE, TaskAttemptEventType.TA_FAILMSG, TaskAttemptEventType.TA_CONTAINER_CLEANED, TaskAttemptEventType.TA_CONTAINER_LAUNCHED, TaskAttemptEventType.TA_CONTAINER_LAUNCH_FAILED})).addTransition((Enum)TaskAttemptStateInternal.KILL_TASK_CLEANUP, (Enum)TaskAttemptStateInternal.KILLED, (Enum)TaskAttemptEventType.TA_CLEANUP_DONE, (SingleArcTransition)new KilledTransition(null)).addTransition((Enum)TaskAttemptStateInternal.KILL_TASK_CLEANUP, (Enum)TaskAttemptStateInternal.KILL_TASK_CLEANUP, (Enum)TaskAttemptEventType.TA_DIAGNOSTICS_UPDATE, (SingleArcTransition)DIAGNOSTIC_INFORMATION_UPDATE_TRANSITION).addTransition((Enum)TaskAttemptStateInternal.KILL_TASK_CLEANUP, (Enum)TaskAttemptStateInternal.KILL_TASK_CLEANUP, EnumSet.of(TaskAttemptEventType.TA_KILL, new TaskAttemptEventType[]{TaskAttemptEventType.TA_CONTAINER_COMPLETED, TaskAttemptEventType.TA_UPDATE, TaskAttemptEventType.TA_COMMIT_PENDING, TaskAttemptEventType.TA_DONE, TaskAttemptEventType.TA_FAILMSG, TaskAttemptEventType.TA_CONTAINER_CLEANED, TaskAttemptEventType.TA_CONTAINER_LAUNCHED, TaskAttemptEventType.TA_CONTAINER_LAUNCH_FAILED})).addTransition((Enum)TaskAttemptStateInternal.SUCCEEDED, (Enum)TaskAttemptStateInternal.FAILED, (Enum)TaskAttemptEventType.TA_TOO_MANY_FETCH_FAILURE, (SingleArcTransition)new TooManyFetchFailureTransition(null)).addTransition((Enum)TaskAttemptStateInternal.SUCCEEDED, (Enum)TaskAttemptStateInternal.SUCCEEDED, (Enum)TaskAttemptEventType.TA_DIAGNOSTICS_UPDATE, (SingleArcTransition)DIAGNOSTIC_INFORMATION_UPDATE_TRANSITION).addTransition((Enum)TaskAttemptStateInternal.SUCCEEDED, (Enum)TaskAttemptStateInternal.SUCCEEDED, EnumSet.of(TaskAttemptEventType.TA_KILL, TaskAttemptEventType.TA_FAILMSG, TaskAttemptEventType.TA_CONTAINER_CLEANED, TaskAttemptEventType.TA_CONTAINER_COMPLETED)).addTransition((Enum)TaskAttemptStateInternal.FAILED, (Enum)TaskAttemptStateInternal.FAILED, (Enum)TaskAttemptEventType.TA_DIAGNOSTICS_UPDATE, (SingleArcTransition)DIAGNOSTIC_INFORMATION_UPDATE_TRANSITION).addTransition((Enum)TaskAttemptStateInternal.FAILED, (Enum)TaskAttemptStateInternal.FAILED, EnumSet.of(TaskAttemptEventType.TA_KILL, new TaskAttemptEventType[]{TaskAttemptEventType.TA_ASSIGNED, TaskAttemptEventType.TA_CONTAINER_COMPLETED, TaskAttemptEventType.TA_UPDATE, TaskAttemptEventType.TA_CONTAINER_LAUNCHED, TaskAttemptEventType.TA_CONTAINER_LAUNCH_FAILED, TaskAttemptEventType.TA_CONTAINER_CLEANED, TaskAttemptEventType.TA_COMMIT_PENDING, TaskAttemptEventType.TA_DONE, TaskAttemptEventType.TA_FAILMSG, TaskAttemptEventType.TA_TOO_MANY_FETCH_FAILURE})).addTransition((Enum)TaskAttemptStateInternal.KILLED, (Enum)TaskAttemptStateInternal.KILLED, (Enum)TaskAttemptEventType.TA_DIAGNOSTICS_UPDATE, (SingleArcTransition)DIAGNOSTIC_INFORMATION_UPDATE_TRANSITION).addTransition((Enum)TaskAttemptStateInternal.KILLED, (Enum)TaskAttemptStateInternal.KILLED, EnumSet.of(TaskAttemptEventType.TA_KILL, new TaskAttemptEventType[]{TaskAttemptEventType.TA_ASSIGNED, TaskAttemptEventType.TA_CONTAINER_COMPLETED, TaskAttemptEventType.TA_UPDATE, TaskAttemptEventType.TA_CONTAINER_LAUNCHED, TaskAttemptEventType.TA_CONTAINER_LAUNCH_FAILED, TaskAttemptEventType.TA_CONTAINER_CLEANED, TaskAttemptEventType.TA_COMMIT_PENDING, TaskAttemptEventType.TA_DONE, TaskAttemptEventType.TA_FAILMSG})).installTopology();
    private final StateMachine<TaskAttemptStateInternal, TaskAttemptEventType, TaskAttemptEvent> stateMachine;
    private ContainerId containerID;
    private NodeId containerNodeId;
    private String containerMgrAddress;
    private String nodeHttpAddress;
    private String nodeRackName;
    private WrappedJvmID jvmID;
    private ContainerToken containerToken;
    private Resource assignedCapability;
    private Task remoteTask;
    private TaskAttemptStatusUpdateEvent.TaskAttemptStatus reportedStatus;
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private static final Pattern ipPattern = Pattern.compile("\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}");

    public TaskAttemptImpl(TaskId taskId, int i, EventHandler eventHandler, TaskAttemptListener taskAttemptListener, Path jobFile, int partition, JobConf conf, String[] dataLocalHosts, OutputCommitter committer, Token<JobTokenIdentifier> jobToken, Credentials credentials, Clock clock, AppContext appContext) {
        this.oldJobId = TypeConverter.fromYarn((JobId)taskId.getJobId());
        this.conf = conf;
        this.clock = clock;
        this.attemptId = (TaskAttemptId)recordFactory.newRecordInstance(TaskAttemptId.class);
        this.attemptId.setTaskId(taskId);
        this.attemptId.setId(i);
        this.taskAttemptListener = taskAttemptListener;
        this.appContext = appContext;
        this.reportedStatus = new TaskAttemptStatusUpdateEvent.TaskAttemptStatus();
        this.initTaskAttemptStatus(this.reportedStatus);
        ReentrantReadWriteLock readWriteLock = new ReentrantReadWriteLock();
        this.readLock = readWriteLock.readLock();
        this.writeLock = readWriteLock.writeLock();
        this.credentials = credentials;
        this.jobToken = jobToken;
        this.eventHandler = eventHandler;
        this.committer = committer;
        this.jobFile = jobFile;
        this.partition = partition;
        this.resourceCapability = (Resource)recordFactory.newRecordInstance(Resource.class);
        this.resourceCapability.setMemory(this.getMemoryRequired((Configuration)conf, taskId.getTaskType()));
        this.dataLocalHosts = dataLocalHosts;
        RackResolver.init((Configuration)conf);
        this.stateMachine = stateMachineFactory.make((Object)this);
    }

    private int getMemoryRequired(Configuration conf, TaskType taskType) {
        int memory = 1024;
        if (taskType == TaskType.MAP) {
            memory = conf.getInt("mapreduce.map.memory.mb", 1024);
        } else if (taskType == TaskType.REDUCE) {
            memory = conf.getInt("mapreduce.reduce.memory.mb", 1024);
        }
        return memory;
    }

    private static LocalResource createLocalResource(FileSystem fc, Path file, LocalResourceType type, LocalResourceVisibility visibility) throws IOException {
        FileStatus fstat = fc.getFileStatus(file);
        URL resourceURL = ConverterUtils.getYarnUrlFromPath((Path)fc.resolvePath(fstat.getPath()));
        long resourceSize = fstat.getLen();
        long resourceModificationTime = fstat.getModificationTime();
        return BuilderUtils.newLocalResource((URL)resourceURL, (LocalResourceType)type, (LocalResourceVisibility)visibility, (long)resourceSize, (long)resourceModificationTime);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getInitialClasspath(Configuration conf) throws IOException {
        Object object = classpathLock;
        synchronized (object) {
            if (initialClasspathFlag.get()) {
                return initialClasspath;
            }
            HashMap env = new HashMap();
            MRApps.setClasspath(env, (Configuration)conf);
            initialClasspath = (String)env.get(ApplicationConstants.Environment.CLASSPATH.name());
            initialClasspathFlag.set(true);
            return initialClasspath;
        }
    }

    private static ContainerLaunchContext createCommonContainerLaunchContext(Map<ApplicationAccessType, String> applicationACLs, Configuration conf, Token<JobTokenIdentifier> jobToken, JobID oldJobId, Credentials credentials) {
        HashMap<String, LocalResource> localResources = new HashMap<String, LocalResource>();
        HashMap<String, String> environment = new HashMap<String, String>();
        HashMap<String, ByteBuffer> serviceData = new HashMap<String, ByteBuffer>();
        ByteBuffer taskCredentialsBuffer = ByteBuffer.wrap(new byte[0]);
        try {
            FileSystem remoteFS = FileSystem.get((Configuration)conf);
            String jobJar = conf.get("mapreduce.job.jar");
            if (jobJar != null) {
                Path remoteJobJar = new Path(jobJar).makeQualified(remoteFS.getUri(), remoteFS.getWorkingDirectory());
                LocalResource rc = TaskAttemptImpl.createLocalResource((FileSystem)remoteFS, (Path)remoteJobJar, (LocalResourceType)LocalResourceType.PATTERN, (LocalResourceVisibility)LocalResourceVisibility.APPLICATION);
                String pattern = conf.getPattern("mapreduce.job.jar.unpack.pattern", JobConf.UNPACK_JAR_PATTERN_DEFAULT).pattern();
                rc.setPattern(pattern);
                localResources.put("job.jar", rc);
                LOG.info((Object)("The job-jar file on the remote FS is " + remoteJobJar.toUri().toASCIIString()));
            } else {
                LOG.info((Object)"Job jar is not present. Not adding any jar to the list of resources.");
            }
            Path path = MRApps.getStagingAreaDir((Configuration)conf, (String)UserGroupInformation.getCurrentUser().getShortUserName());
            Path remoteJobSubmitDir = new Path(path, oldJobId.toString());
            Path remoteJobConfPath = new Path(remoteJobSubmitDir, "job.xml");
            localResources.put("job.xml", TaskAttemptImpl.createLocalResource((FileSystem)remoteFS, (Path)remoteJobConfPath, (LocalResourceType)LocalResourceType.FILE, (LocalResourceVisibility)LocalResourceVisibility.APPLICATION));
            LOG.info((Object)("The job-conf file on the remote FS is " + remoteJobConfPath.toUri().toASCIIString()));
            MRApps.setupDistributedCache((Configuration)conf, localResources);
            LOG.info((Object)("Adding #" + credentials.numberOfTokens() + " tokens and #" + credentials.numberOfSecretKeys() + " secret keys for NM use for launching container"));
            Credentials taskCredentials = new Credentials(credentials);
            TokenCache.setJobToken(jobToken, (Credentials)taskCredentials);
            DataOutputBuffer containerTokens_dob = new DataOutputBuffer();
            LOG.info((Object)("Size of containertokens_dob is " + taskCredentials.numberOfTokens()));
            taskCredentials.writeTokenStorageToStream((DataOutputStream)containerTokens_dob);
            taskCredentialsBuffer = ByteBuffer.wrap(containerTokens_dob.getData(), 0, containerTokens_dob.getLength());
            LOG.info((Object)"Putting shuffle token in serviceData");
            serviceData.put("mapreduce.shuffle", ShuffleHandler.serializeServiceData(jobToken));
            Apps.addToEnvironment(environment, (String)ApplicationConstants.Environment.CLASSPATH.name(), (String)TaskAttemptImpl.getInitialClasspath((Configuration)conf));
        }
        catch (IOException e) {
            throw new YarnException((Throwable)e);
        }
        environment.put(ApplicationConstants.Environment.SHELL.name(), conf.get("mapreduce.admin.user.shell", "/bin/bash"));
        Apps.addToEnvironment(environment, (String)ApplicationConstants.Environment.LD_LIBRARY_PATH.name(), (String)ApplicationConstants.Environment.PWD.$());
        Apps.setEnvFromInputString(environment, (String)conf.get("mapreduce.admin.user.env", "LD_LIBRARY_PATH=$HADOOP_COMMON_HOME/lib/native"));
        ContainerLaunchContext container = BuilderUtils.newContainerLaunchContext(null, (String)conf.get("mapreduce.job.user.name"), null, localResources, environment, null, serviceData, (ByteBuffer)taskCredentialsBuffer, applicationACLs);
        return container;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static ContainerLaunchContext createContainerLaunchContext(Map<ApplicationAccessType, String> applicationACLs, ContainerId containerID, Configuration conf, Token<JobTokenIdentifier> jobToken, Task remoteTask, JobID oldJobId, Resource assignedCapability, WrappedJvmID jvmID, TaskAttemptListener taskAttemptListener, Credentials credentials) {
        Object object = commonContainerSpecLock;
        synchronized (object) {
            if (commonContainerSpec == null) {
                commonContainerSpec = TaskAttemptImpl.createCommonContainerLaunchContext(applicationACLs, (Configuration)conf, jobToken, (JobID)oldJobId, (Credentials)credentials);
            }
        }
        Map env = commonContainerSpec.getEnvironment();
        HashMap myEnv = new HashMap(env.size());
        myEnv.putAll(env);
        MapReduceChildJVM.setVMEnv(myEnv, (Task)remoteTask);
        List commands = MapReduceChildJVM.getVMCommand((InetSocketAddress)taskAttemptListener.getAddress(), (Task)remoteTask, (ID)jvmID);
        HashMap myServiceData = new HashMap();
        for (Map.Entry entry : commonContainerSpec.getServiceData().entrySet()) {
            myServiceData.put(entry.getKey(), ((ByteBuffer)entry.getValue()).duplicate());
        }
        ContainerLaunchContext container = BuilderUtils.newContainerLaunchContext((ContainerId)containerID, (String)commonContainerSpec.getUser(), (Resource)assignedCapability, (Map)commonContainerSpec.getLocalResources(), myEnv, (List)commands, myServiceData, (ByteBuffer)commonContainerSpec.getContainerTokens().duplicate(), applicationACLs);
        return container;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ContainerId getAssignedContainerID() {
        this.readLock.lock();
        try {
            ContainerId containerId = this.containerID;
            return containerId;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getAssignedContainerMgrAddress() {
        this.readLock.lock();
        try {
            String string = this.containerMgrAddress;
            return string;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getLaunchTime() {
        this.readLock.lock();
        try {
            long l = this.launchTime;
            return l;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getFinishTime() {
        this.readLock.lock();
        try {
            long l = this.finishTime;
            return l;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getShuffleFinishTime() {
        this.readLock.lock();
        try {
            long l = this.reportedStatus.shuffleFinishTime;
            return l;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getSortFinishTime() {
        this.readLock.lock();
        try {
            long l = this.reportedStatus.sortFinishTime;
            return l;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getShufflePort() {
        this.readLock.lock();
        try {
            int n = this.shufflePort;
            return n;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getNodeHttpAddress() {
        this.readLock.lock();
        try {
            String string = this.nodeHttpAddress;
            return string;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getNodeRackName() {
        this.readLock.lock();
        try {
            String string = this.nodeRackName;
            return string;
        }
        finally {
            this.readLock.unlock();
        }
    }

    protected abstract Task createRemoteTask();

    public TaskAttemptId getID() {
        return this.attemptId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isFinished() {
        this.readLock.lock();
        try {
            boolean bl = this.getInternalState() == TaskAttemptStateInternal.SUCCEEDED || this.getInternalState() == TaskAttemptStateInternal.FAILED || this.getInternalState() == TaskAttemptStateInternal.KILLED;
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TaskAttemptReport getReport() {
        TaskAttemptReport result = (TaskAttemptReport)recordFactory.newRecordInstance(TaskAttemptReport.class);
        this.readLock.lock();
        try {
            result.setTaskAttemptId(this.attemptId);
            result.setTaskAttemptState(this.getState());
            result.setProgress(this.reportedStatus.progress);
            result.setStartTime(this.launchTime);
            result.setFinishTime(this.finishTime);
            result.setShuffleFinishTime(this.reportedStatus.shuffleFinishTime);
            result.setDiagnosticInfo(StringUtils.join((CharSequence)LINE_SEPARATOR, (Iterable)this.getDiagnostics()));
            result.setPhase(this.reportedStatus.phase);
            result.setStateString(this.reportedStatus.stateString);
            result.setCounters(TypeConverter.toYarn((Counters)this.getCounters()));
            result.setContainerId(this.getAssignedContainerID());
            result.setNodeManagerHost(this.trackerName);
            result.setNodeManagerHttpPort(this.httpPort);
            if (this.containerNodeId != null) {
                result.setNodeManagerPort(this.containerNodeId.getPort());
            }
            TaskAttemptReport taskAttemptReport = result;
            return taskAttemptReport;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getDiagnostics() {
        ArrayList<String> result = new ArrayList<String>();
        this.readLock.lock();
        try {
            result.addAll(this.diagnostics);
            ArrayList<String> arrayList = result;
            return arrayList;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Counters getCounters() {
        this.readLock.lock();
        try {
            Counters counters = this.reportedStatus.counters;
            if (counters == null) {
                counters = EMPTY_COUNTERS;
            }
            Counters counters2 = counters;
            return counters2;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public float getProgress() {
        this.readLock.lock();
        try {
            float f = this.reportedStatus.progress;
            return f;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TaskAttemptState getState() {
        this.readLock.lock();
        try {
            TaskAttemptState taskAttemptState = TaskAttemptImpl.getExternalState((TaskAttemptStateInternal)((TaskAttemptStateInternal)this.stateMachine.getCurrentState()));
            return taskAttemptState;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handle(TaskAttemptEvent event) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Processing " + event.getTaskAttemptID() + " of type " + event.getType()));
        }
        this.writeLock.lock();
        try {
            TaskAttemptStateInternal oldState = this.getInternalState();
            try {
                this.stateMachine.doTransition(event.getType(), (Object)event);
            }
            catch (InvalidStateTransitonException e) {
                LOG.error((Object)("Can't handle this event at current state for " + this.attemptId), (Throwable)e);
                this.eventHandler.handle((Event)new JobDiagnosticsUpdateEvent(this.attemptId.getTaskId().getJobId(), "Invalid event " + event.getType() + " on TaskAttempt " + this.attemptId));
                this.eventHandler.handle((Event)new JobEvent(this.attemptId.getTaskId().getJobId(), JobEventType.INTERNAL_ERROR));
            }
            if (oldState != this.getInternalState()) {
                LOG.info((Object)(this.attemptId + " TaskAttempt Transitioned from " + oldState + " to " + this.getInternalState()));
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    public TaskAttemptStateInternal getInternalState() {
        this.readLock.lock();
        try {
            TaskAttemptStateInternal taskAttemptStateInternal = (TaskAttemptStateInternal)this.stateMachine.getCurrentState();
            return taskAttemptStateInternal;
        }
        finally {
            this.readLock.unlock();
        }
    }

    private static TaskAttemptState getExternalState(TaskAttemptStateInternal smState) {
        switch (1.$SwitchMap$org$apache$hadoop$mapreduce$v2$app$job$TaskAttemptStateInternal[smState.ordinal()]) {
            case 1: 
            case 2: {
                return TaskAttemptState.STARTING;
            }
            case 3: {
                return TaskAttemptState.COMMIT_PENDING;
            }
            case 4: {
                return TaskAttemptState.FAILED;
            }
            case 5: {
                return TaskAttemptState.KILLED;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                return TaskAttemptState.RUNNING;
            }
            case 12: {
                return TaskAttemptState.NEW;
            }
            case 13: {
                return TaskAttemptState.SUCCEEDED;
            }
        }
        throw new YarnException("Attempt to convert invalid stateMachineTaskAttemptState to externalTaskAttemptState: " + smState);
    }

    private void setFinishTime() {
        if (this.launchTime != 0L) {
            this.finishTime = this.clock.getTime();
        }
    }

    private static long computeSlotMillis(TaskAttemptImpl taskAttempt) {
        TaskType taskType = taskAttempt.getID().getTaskId().getTaskType();
        int slotMemoryReq = taskAttempt.getMemoryRequired((Configuration)taskAttempt.conf, taskType);
        int minSlotMemSize = taskAttempt.appContext.getClusterInfo().getMinContainerCapability().getMemory();
        int simSlotsRequired = minSlotMemSize == 0 ? 0 : (int)Math.ceil((float)slotMemoryReq / (float)minSlotMemSize);
        long slotMillisIncrement = (long)simSlotsRequired * (taskAttempt.getFinishTime() - taskAttempt.getLaunchTime());
        return slotMillisIncrement;
    }

    private static JobCounterUpdateEvent createJobCounterUpdateEventTAFailed(TaskAttemptImpl taskAttempt) {
        TaskType taskType = taskAttempt.getID().getTaskId().getTaskType();
        JobCounterUpdateEvent jce = new JobCounterUpdateEvent(taskAttempt.getID().getTaskId().getJobId());
        long slotMillisIncrement = TaskAttemptImpl.computeSlotMillis((TaskAttemptImpl)taskAttempt);
        if (taskType == TaskType.MAP) {
            jce.addCounterUpdate((Enum)JobCounter.NUM_FAILED_MAPS, 1L);
            jce.addCounterUpdate((Enum)JobCounter.SLOTS_MILLIS_MAPS, slotMillisIncrement);
        } else {
            jce.addCounterUpdate((Enum)JobCounter.NUM_FAILED_REDUCES, 1L);
            jce.addCounterUpdate((Enum)JobCounter.SLOTS_MILLIS_REDUCES, slotMillisIncrement);
        }
        return jce;
    }

    private static JobCounterUpdateEvent createJobCounterUpdateEventTAKilled(TaskAttemptImpl taskAttempt) {
        TaskType taskType = taskAttempt.getID().getTaskId().getTaskType();
        JobCounterUpdateEvent jce = new JobCounterUpdateEvent(taskAttempt.getID().getTaskId().getJobId());
        long slotMillisIncrement = TaskAttemptImpl.computeSlotMillis((TaskAttemptImpl)taskAttempt);
        if (taskType == TaskType.MAP) {
            jce.addCounterUpdate((Enum)JobCounter.NUM_KILLED_MAPS, 1L);
            jce.addCounterUpdate((Enum)JobCounter.SLOTS_MILLIS_MAPS, slotMillisIncrement);
        } else {
            jce.addCounterUpdate((Enum)JobCounter.NUM_KILLED_REDUCES, 1L);
            jce.addCounterUpdate((Enum)JobCounter.SLOTS_MILLIS_REDUCES, slotMillisIncrement);
        }
        return jce;
    }

    private static TaskAttemptUnsuccessfulCompletionEvent createTaskAttemptUnsuccessfulCompletionEvent(TaskAttemptImpl taskAttempt, TaskAttemptStateInternal attemptState) {
        TaskAttemptUnsuccessfulCompletionEvent tauce = new TaskAttemptUnsuccessfulCompletionEvent((TaskAttemptID)TypeConverter.fromYarn((TaskAttemptId)taskAttempt.attemptId), TypeConverter.fromYarn((TaskType)taskAttempt.attemptId.getTaskId().getTaskType()), attemptState.toString(), taskAttempt.finishTime, taskAttempt.containerNodeId == null ? "UNKNOWN" : taskAttempt.containerNodeId.getHost(), taskAttempt.containerNodeId == null ? -1 : taskAttempt.containerNodeId.getPort(), taskAttempt.nodeRackName == null ? "UNKNOWN" : taskAttempt.nodeRackName, StringUtils.join((CharSequence)LINE_SEPARATOR, (Iterable)taskAttempt.getDiagnostics()), taskAttempt.getProgressSplitBlock().burst());
        return tauce;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private WrappedProgressSplitsBlock getProgressSplitBlock() {
        this.readLock.lock();
        try {
            if (this.progressSplitBlock == null) {
                this.progressSplitBlock = new WrappedProgressSplitsBlock(this.conf.getInt("yarn.app.mapreduce.am.num-progress-splits", 12));
            }
            WrappedProgressSplitsBlock wrappedProgressSplitsBlock = this.progressSplitBlock;
            return wrappedProgressSplitsBlock;
        }
        finally {
            this.readLock.unlock();
        }
    }

    private void updateProgressSplits() {
        double newProgress = this.reportedStatus.progress;
        newProgress = Math.max(Math.min(newProgress, 1.0), 0.0);
        Counters counters = this.reportedStatus.counters;
        if (counters == null) {
            return;
        }
        WrappedProgressSplitsBlock splitsBlock = this.getProgressSplitBlock();
        if (splitsBlock != null) {
            Counter physicalBytes;
            Counter virtualBytes;
            Counter cpuCounter;
            long now = this.clock.getTime();
            long start = this.getLaunchTime();
            if (start != 0L && now - start <= Integer.MAX_VALUE) {
                splitsBlock.getProgressWallclockTime().extend(newProgress, (int)(now - start));
            }
            if ((cpuCounter = counters.findCounter((Enum)TaskCounter.CPU_MILLISECONDS)) != null && cpuCounter.getValue() <= Integer.MAX_VALUE) {
                splitsBlock.getProgressCPUTime().extend(newProgress, (int)cpuCounter.getValue());
            }
            if ((virtualBytes = counters.findCounter((Enum)TaskCounter.VIRTUAL_MEMORY_BYTES)) != null) {
                splitsBlock.getProgressVirtualMemoryKbytes().extend(newProgress, (int)(virtualBytes.getValue() / 1024L));
            }
            if ((physicalBytes = counters.findCounter((Enum)TaskCounter.PHYSICAL_MEMORY_BYTES)) != null) {
                splitsBlock.getProgressPhysicalMemoryKbytes().extend(newProgress, (int)(physicalBytes.getValue() / 1024L));
            }
        }
    }

    protected String[] resolveHosts(String[] src) {
        String[] result = new String[src.length];
        for (int i = 0; i < src.length; ++i) {
            result[i] = this.isIP(src[i]) ? this.resolveHost(src[i]) : src[i];
        }
        return result;
    }

    protected String resolveHost(String src) {
        String result = src;
        try {
            InetAddress addr = InetAddress.getByName(src);
            result = addr.getHostName();
        }
        catch (UnknownHostException e) {
            LOG.warn((Object)("Failed to resolve address: " + src + ". Continuing to use the same."));
        }
        return result;
    }

    protected boolean isIP(String src) {
        return ipPattern.matcher(src).matches();
    }

    private void logAttemptFinishedEvent(TaskAttemptStateInternal state) {
        if (this.getLaunchTime() == 0L) {
            return;
        }
        if (this.attemptId.getTaskId().getTaskType() == TaskType.MAP) {
            MapAttemptFinishedEvent mfe = new MapAttemptFinishedEvent((TaskAttemptID)TypeConverter.fromYarn((TaskAttemptId)this.attemptId), TypeConverter.fromYarn((TaskType)this.attemptId.getTaskId().getTaskType()), state.toString(), this.reportedStatus.mapFinishTime, this.finishTime, this.containerNodeId == null ? "UNKNOWN" : this.containerNodeId.getHost(), this.containerNodeId == null ? -1 : this.containerNodeId.getPort(), this.nodeRackName == null ? "UNKNOWN" : this.nodeRackName, this.reportedStatus.stateString, this.getCounters(), this.getProgressSplitBlock().burst());
            this.eventHandler.handle((Event)new JobHistoryEvent(this.attemptId.getTaskId().getJobId(), (HistoryEvent)mfe));
        } else {
            ReduceAttemptFinishedEvent rfe = new ReduceAttemptFinishedEvent((TaskAttemptID)TypeConverter.fromYarn((TaskAttemptId)this.attemptId), TypeConverter.fromYarn((TaskType)this.attemptId.getTaskId().getTaskType()), state.toString(), this.reportedStatus.shuffleFinishTime, this.reportedStatus.sortFinishTime, this.finishTime, this.containerNodeId == null ? "UNKNOWN" : this.containerNodeId.getHost(), this.containerNodeId == null ? -1 : this.containerNodeId.getPort(), this.nodeRackName == null ? "UNKNOWN" : this.nodeRackName, this.reportedStatus.stateString, this.getCounters(), this.getProgressSplitBlock().burst());
            this.eventHandler.handle((Event)new JobHistoryEvent(this.attemptId.getTaskId().getJobId(), (HistoryEvent)rfe));
        }
    }

    private void addDiagnosticInfo(String diag) {
        if (diag != null && !diag.equals("")) {
            this.diagnostics.add(diag);
        }
    }

    private void initTaskAttemptStatus(TaskAttemptStatusUpdateEvent.TaskAttemptStatus result) {
        Counters counters;
        result.progress = 0.0f;
        result.phase = Phase.STARTING;
        result.stateString = "NEW";
        result.taskState = TaskAttemptState.NEW;
        result.counters = counters = EMPTY_COUNTERS;
    }

    static /* synthetic */ TaskAttemptId access$1100(TaskAttemptImpl x0) {
        return x0.attemptId;
    }

    static /* synthetic */ Resource access$1200(TaskAttemptImpl x0) {
        return x0.resourceCapability;
    }

    static /* synthetic */ String[] access$1300(TaskAttemptImpl x0) {
        return x0.dataLocalHosts;
    }

    static /* synthetic */ ContainerId access$1402(TaskAttemptImpl x0, ContainerId x1) {
        x0.containerID = x1;
        return x0.containerID;
    }

    static /* synthetic */ NodeId access$1502(TaskAttemptImpl x0, NodeId x1) {
        x0.containerNodeId = x1;
        return x0.containerNodeId;
    }

    static /* synthetic */ String access$1602(TaskAttemptImpl x0, String x1) {
        x0.containerMgrAddress = x1;
        return x0.containerMgrAddress;
    }

    static /* synthetic */ NodeId access$1500(TaskAttemptImpl x0) {
        return x0.containerNodeId;
    }

    static /* synthetic */ String access$1702(TaskAttemptImpl x0, String x1) {
        x0.nodeHttpAddress = x1;
        return x0.nodeHttpAddress;
    }

    static /* synthetic */ String access$1802(TaskAttemptImpl x0, String x1) {
        x0.nodeRackName = x1;
        return x0.nodeRackName;
    }

    static /* synthetic */ ContainerToken access$1902(TaskAttemptImpl x0, ContainerToken x1) {
        x0.containerToken = x1;
        return x0.containerToken;
    }

    static /* synthetic */ Resource access$2002(TaskAttemptImpl x0, Resource x1) {
        x0.assignedCapability = x1;
        return x0.assignedCapability;
    }

    static /* synthetic */ Task access$2102(TaskAttemptImpl x0, Task x1) {
        x0.remoteTask = x1;
        return x0.remoteTask;
    }

    static /* synthetic */ WrappedJvmID access$2202(TaskAttemptImpl x0, WrappedJvmID x1) {
        x0.jvmID = x1;
        return x0.jvmID;
    }

    static /* synthetic */ Task access$2100(TaskAttemptImpl x0) {
        return x0.remoteTask;
    }

    static /* synthetic */ ContainerId access$1400(TaskAttemptImpl x0) {
        return x0.containerID;
    }

    static /* synthetic */ WrappedJvmID access$2200(TaskAttemptImpl x0) {
        return x0.jvmID;
    }

    static /* synthetic */ TaskAttemptListener access$2300(TaskAttemptImpl x0) {
        return x0.taskAttemptListener;
    }

    static /* synthetic */ Token access$2400(TaskAttemptImpl x0) {
        return x0.jobToken;
    }

    static /* synthetic */ JobID access$2500(TaskAttemptImpl x0) {
        return x0.oldJobId;
    }

    static /* synthetic */ Resource access$2000(TaskAttemptImpl x0) {
        return x0.assignedCapability;
    }

    static /* synthetic */ Credentials access$2600(TaskAttemptImpl x0) {
        return x0.credentials;
    }

    static /* synthetic */ String access$1600(TaskAttemptImpl x0) {
        return x0.containerMgrAddress;
    }

    static /* synthetic */ ContainerToken access$1900(TaskAttemptImpl x0) {
        return x0.containerToken;
    }

    static /* synthetic */ void access$2700(TaskAttemptImpl x0) {
        x0.setFinishTime();
    }

    static /* synthetic */ TaskAttemptUnsuccessfulCompletionEvent access$2800(TaskAttemptImpl x0, TaskAttemptStateInternal x1) {
        return TaskAttemptImpl.createTaskAttemptUnsuccessfulCompletionEvent((TaskAttemptImpl)x0, (TaskAttemptStateInternal)x1);
    }

    static /* synthetic */ JobCounterUpdateEvent access$2900(TaskAttemptImpl x0) {
        return TaskAttemptImpl.createJobCounterUpdateEventTAFailed((TaskAttemptImpl)x0);
    }

    static /* synthetic */ JobCounterUpdateEvent access$3000(TaskAttemptImpl x0) {
        return TaskAttemptImpl.createJobCounterUpdateEventTAKilled((TaskAttemptImpl)x0);
    }

    static /* synthetic */ Log access$3100() {
        return LOG;
    }

    static /* synthetic */ long access$3202(TaskAttemptImpl x0, long x1) {
        x0.launchTime = x1;
        return x0.launchTime;
    }

    static /* synthetic */ Clock access$3300(TaskAttemptImpl x0) {
        return x0.clock;
    }

    static /* synthetic */ int access$3402(TaskAttemptImpl x0, int x1) {
        x0.shufflePort = x1;
        return x0.shufflePort;
    }

    static /* synthetic */ String access$1700(TaskAttemptImpl x0) {
        return x0.nodeHttpAddress;
    }

    static /* synthetic */ String access$3502(TaskAttemptImpl x0, String x1) {
        x0.trackerName = x1;
        return x0.trackerName;
    }

    static /* synthetic */ int access$3602(TaskAttemptImpl x0, int x1) {
        x0.httpPort = x1;
        return x0.httpPort;
    }

    static /* synthetic */ long access$3200(TaskAttemptImpl x0) {
        return x0.launchTime;
    }

    static /* synthetic */ int access$3400(TaskAttemptImpl x0) {
        return x0.shufflePort;
    }

    static /* synthetic */ OutputCommitter access$3700(TaskAttemptImpl x0) {
        return x0.committer;
    }

    static /* synthetic */ long access$3800(TaskAttemptImpl x0) {
        return TaskAttemptImpl.computeSlotMillis((TaskAttemptImpl)x0);
    }

    static /* synthetic */ void access$3900(TaskAttemptImpl x0, TaskAttemptStateInternal x1) {
        x0.logAttemptFinishedEvent(x1);
    }

    static /* synthetic */ TaskAttemptStatusUpdateEvent.TaskAttemptStatus access$4000(TaskAttemptImpl x0) {
        return x0.reportedStatus;
    }

    static /* synthetic */ void access$4100(TaskAttemptImpl x0, String x1) {
        x0.addDiagnosticInfo(x1);
    }

    static /* synthetic */ void access$4200(TaskAttemptImpl x0) {
        x0.updateProgressSplits();
    }

    static /* synthetic */ TaskAttemptStatusUpdateEvent.TaskAttemptStatus access$4002(TaskAttemptImpl x0, TaskAttemptStatusUpdateEvent.TaskAttemptStatus x1) {
        x0.reportedStatus = x1;
        return x0.reportedStatus;
    }
}

