/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.v2.app.job.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapreduce.OutputCommitter;
import org.apache.hadoop.mapreduce.jobhistory.JobHistoryParser;
import org.apache.hadoop.mapreduce.security.token.JobTokenIdentifier;
import org.apache.hadoop.mapreduce.split.JobSplit;
import org.apache.hadoop.mapreduce.v2.api.records.JobId;
import org.apache.hadoop.mapreduce.v2.api.records.TaskAttemptId;
import org.apache.hadoop.mapreduce.v2.api.records.TaskAttemptState;
import org.apache.hadoop.mapreduce.v2.api.records.TaskId;
import org.apache.hadoop.mapreduce.v2.api.records.TaskState;
import org.apache.hadoop.mapreduce.v2.api.records.TaskType;
import org.apache.hadoop.mapreduce.v2.app.AppContext;
import org.apache.hadoop.mapreduce.v2.app.TaskAttemptListener;
import org.apache.hadoop.mapreduce.v2.app.job.TaskStateInternal;
import org.apache.hadoop.mapreduce.v2.app.job.event.TaskEvent;
import org.apache.hadoop.mapreduce.v2.app.job.event.TaskEventType;
import org.apache.hadoop.mapreduce.v2.app.job.event.TaskTAttemptEvent;
import org.apache.hadoop.mapreduce.v2.app.job.impl.TaskImpl;
import org.apache.hadoop.mapreduce.v2.app.job.impl.TestTaskImpl;
import org.apache.hadoop.mapreduce.v2.app.metrics.MRAppMetrics;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.yarn.Clock;
import org.apache.hadoop.yarn.SystemClock;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.server.resourcemanager.resourcetracker.InlineDispatcher;
import org.apache.hadoop.yarn.util.Records;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class TestTaskImpl {
    private static final Log LOG = LogFactory.getLog(TestTaskImpl.class);
    private JobConf conf;
    private TaskAttemptListener taskAttemptListener;
    private OutputCommitter committer;
    private Token<JobTokenIdentifier> jobToken;
    private JobId jobId;
    private Path remoteJobConfFile;
    private Credentials credentials;
    private Clock clock;
    private Map<TaskId, JobHistoryParser.TaskInfo> completedTasksFromPreviousRun;
    private MRAppMetrics metrics;
    private TaskImpl mockTask;
    private ApplicationId appId;
    private JobSplit.TaskSplitMetaInfo taskSplitMetaInfo;
    private String[] dataLocations = new String[0];
    private final TaskType taskType = TaskType.MAP;
    private AppContext appContext;
    private int startCount = 0;
    private int taskCounter = 0;
    private final int partition = 1;
    private InlineDispatcher dispatcher;
    private List<MockTaskAttemptImpl> taskAttempts;

    @Before
    public void setup() {
        this.dispatcher = new InlineDispatcher();
        ++this.startCount;
        this.conf = new JobConf();
        this.taskAttemptListener = (TaskAttemptListener)Mockito.mock(TaskAttemptListener.class);
        this.committer = (OutputCommitter)Mockito.mock(OutputCommitter.class);
        this.jobToken = (Token)Mockito.mock(Token.class);
        this.remoteJobConfFile = (Path)Mockito.mock(Path.class);
        this.credentials = null;
        this.clock = new SystemClock();
        this.metrics = (MRAppMetrics)Mockito.mock(MRAppMetrics.class);
        this.dataLocations = new String[1];
        this.appId = (ApplicationId)Records.newRecord(ApplicationId.class);
        this.appId.setClusterTimestamp(System.currentTimeMillis());
        this.appId.setId(1);
        this.jobId = (JobId)Records.newRecord(JobId.class);
        this.jobId.setId(1);
        this.jobId.setAppId(this.appId);
        this.appContext = (AppContext)Mockito.mock(AppContext.class);
        this.taskSplitMetaInfo = (JobSplit.TaskSplitMetaInfo)Mockito.mock(JobSplit.TaskSplitMetaInfo.class);
        Mockito.when((Object)this.taskSplitMetaInfo.getLocations()).thenReturn((Object)this.dataLocations);
        this.taskAttempts = new ArrayList();
        this.mockTask = new MockTaskImpl(this, this.jobId, 1, this.dispatcher.getEventHandler(), this.remoteJobConfFile, this.conf, this.taskAttemptListener, this.committer, this.jobToken, this.credentials, this.clock, this.completedTasksFromPreviousRun, this.startCount, this.metrics, this.appContext);
    }

    @After
    public void teardown() {
        this.taskAttempts.clear();
    }

    private TaskId getNewTaskID() {
        TaskId taskId = (TaskId)Records.newRecord(TaskId.class);
        taskId.setId(++this.taskCounter);
        taskId.setJobId(this.jobId);
        taskId.setTaskType(this.mockTask.getType());
        return taskId;
    }

    private void scheduleTaskAttempt(TaskId taskId) {
        this.mockTask.handle(new TaskEvent(taskId, TaskEventType.T_SCHEDULE));
        this.assertTaskScheduledState();
    }

    private void killTask(TaskId taskId) {
        this.mockTask.handle(new TaskEvent(taskId, TaskEventType.T_KILL));
        this.assertTaskKillWaitState();
    }

    private void killScheduledTaskAttempt(TaskAttemptId attemptId) {
        this.mockTask.handle((TaskEvent)new TaskTAttemptEvent(attemptId, TaskEventType.T_ATTEMPT_KILLED));
        this.assertTaskScheduledState();
    }

    private void launchTaskAttempt(TaskAttemptId attemptId) {
        this.mockTask.handle((TaskEvent)new TaskTAttemptEvent(attemptId, TaskEventType.T_ATTEMPT_LAUNCHED));
        this.assertTaskRunningState();
    }

    private void commitTaskAttempt(TaskAttemptId attemptId) {
        this.mockTask.handle((TaskEvent)new TaskTAttemptEvent(attemptId, TaskEventType.T_ATTEMPT_COMMIT_PENDING));
        this.assertTaskRunningState();
    }

    private MockTaskAttemptImpl getLastAttempt() {
        return (MockTaskAttemptImpl)this.taskAttempts.get(this.taskAttempts.size() - 1);
    }

    private void updateLastAttemptProgress(float p) {
        this.getLastAttempt().setProgress(p);
    }

    private void updateLastAttemptState(TaskAttemptState s) {
        this.getLastAttempt().setState(s);
    }

    private void killRunningTaskAttempt(TaskAttemptId attemptId) {
        this.mockTask.handle((TaskEvent)new TaskTAttemptEvent(attemptId, TaskEventType.T_ATTEMPT_KILLED));
        this.assertTaskRunningState();
    }

    private void failRunningTaskAttempt(TaskAttemptId attemptId) {
        this.mockTask.handle((TaskEvent)new TaskTAttemptEvent(attemptId, TaskEventType.T_ATTEMPT_FAILED));
        this.assertTaskRunningState();
    }

    private void assertTaskNewState() {
        Assert.assertEquals((Object)TaskState.NEW, (Object)this.mockTask.getState());
    }

    private void assertTaskScheduledState() {
        Assert.assertEquals((Object)TaskState.SCHEDULED, (Object)this.mockTask.getState());
    }

    private void assertTaskRunningState() {
        Assert.assertEquals((Object)TaskState.RUNNING, (Object)this.mockTask.getState());
    }

    private void assertTaskKillWaitState() {
        Assert.assertEquals((Object)TaskStateInternal.KILL_WAIT, (Object)this.mockTask.getInternalState());
    }

    private void assertTaskSucceededState() {
        Assert.assertEquals((Object)TaskState.SUCCEEDED, (Object)this.mockTask.getState());
    }

    @Test
    public void testInit() {
        LOG.info((Object)"--- START: testInit ---");
        this.assertTaskNewState();
        assert (this.taskAttempts.size() == 0);
    }

    @Test
    public void testScheduleTask() {
        LOG.info((Object)"--- START: testScheduleTask ---");
        TaskId taskId = this.getNewTaskID();
        this.scheduleTaskAttempt(taskId);
    }

    @Test
    public void testKillScheduledTask() {
        LOG.info((Object)"--- START: testKillScheduledTask ---");
        TaskId taskId = this.getNewTaskID();
        this.scheduleTaskAttempt(taskId);
        this.killTask(taskId);
    }

    @Test
    public void testKillScheduledTaskAttempt() {
        LOG.info((Object)"--- START: testKillScheduledTaskAttempt ---");
        TaskId taskId = this.getNewTaskID();
        this.scheduleTaskAttempt(taskId);
        this.killScheduledTaskAttempt(this.getLastAttempt().getAttemptId());
    }

    @Test
    public void testLaunchTaskAttempt() {
        LOG.info((Object)"--- START: testLaunchTaskAttempt ---");
        TaskId taskId = this.getNewTaskID();
        this.scheduleTaskAttempt(taskId);
        this.launchTaskAttempt(this.getLastAttempt().getAttemptId());
    }

    @Test
    public void testKillRunningTaskAttempt() {
        LOG.info((Object)"--- START: testKillRunningTaskAttempt ---");
        TaskId taskId = this.getNewTaskID();
        this.scheduleTaskAttempt(taskId);
        this.launchTaskAttempt(this.getLastAttempt().getAttemptId());
        this.killRunningTaskAttempt(this.getLastAttempt().getAttemptId());
    }

    @Test
    public void testKillSuccessfulTask() {
        LOG.info((Object)"--- START: testKillSuccesfulTask ---");
        TaskId taskId = this.getNewTaskID();
        this.scheduleTaskAttempt(taskId);
        this.launchTaskAttempt(this.getLastAttempt().getAttemptId());
        this.commitTaskAttempt(this.getLastAttempt().getAttemptId());
        this.mockTask.handle((TaskEvent)new TaskTAttemptEvent(this.getLastAttempt().getAttemptId(), TaskEventType.T_ATTEMPT_SUCCEEDED));
        this.assertTaskSucceededState();
        this.mockTask.handle(new TaskEvent(taskId, TaskEventType.T_KILL));
        this.assertTaskSucceededState();
    }

    @Test
    public void testTaskProgress() {
        LOG.info((Object)"--- START: testTaskProgress ---");
        TaskId taskId = this.getNewTaskID();
        this.scheduleTaskAttempt(taskId);
        float progress = 0.0f;
        assert (this.mockTask.getProgress() == progress);
        this.launchTaskAttempt(this.getLastAttempt().getAttemptId());
        progress = 50.0f;
        this.updateLastAttemptProgress(progress);
        assert (this.mockTask.getProgress() == progress);
        progress = 100.0f;
        this.updateLastAttemptProgress(progress);
        assert (this.mockTask.getProgress() == progress);
        progress = 0.0f;
        this.updateLastAttemptState(TaskAttemptState.KILLED);
        assert (this.mockTask.getProgress() == progress);
        this.killRunningTaskAttempt(this.getLastAttempt().getAttemptId());
        assert (this.taskAttempts.size() == 2);
        assert (this.mockTask.getProgress() == 0.0f);
        this.launchTaskAttempt(this.getLastAttempt().getAttemptId());
        progress = 50.0f;
        this.updateLastAttemptProgress(progress);
        assert (this.mockTask.getProgress() == progress);
    }

    @Test
    public void testFailureDuringTaskAttemptCommit() {
        TaskId taskId = this.getNewTaskID();
        this.scheduleTaskAttempt(taskId);
        this.launchTaskAttempt(this.getLastAttempt().getAttemptId());
        this.updateLastAttemptState(TaskAttemptState.COMMIT_PENDING);
        this.commitTaskAttempt(this.getLastAttempt().getAttemptId());
        this.updateLastAttemptState(TaskAttemptState.FAILED);
        this.failRunningTaskAttempt(this.getLastAttempt().getAttemptId());
        Assert.assertEquals((long)2L, (long)this.taskAttempts.size());
        this.updateLastAttemptState(TaskAttemptState.SUCCEEDED);
        this.commitTaskAttempt(this.getLastAttempt().getAttemptId());
        this.mockTask.handle((TaskEvent)new TaskTAttemptEvent(this.getLastAttempt().getAttemptId(), TaskEventType.T_ATTEMPT_SUCCEEDED));
        Assert.assertFalse((String)"First attempt should not commit", (boolean)this.mockTask.canCommit(((MockTaskAttemptImpl)this.taskAttempts.get(0)).getAttemptId()));
        Assert.assertTrue((String)"Second attempt should commit", (boolean)this.mockTask.canCommit(this.getLastAttempt().getAttemptId()));
        this.assertTaskSucceededState();
    }

    private void runSpeculativeTaskAttemptSucceeds(TaskEventType firstAttemptFinishEvent) {
        TaskId taskId = this.getNewTaskID();
        this.scheduleTaskAttempt(taskId);
        this.launchTaskAttempt(this.getLastAttempt().getAttemptId());
        this.updateLastAttemptState(TaskAttemptState.RUNNING);
        this.mockTask.handle((TaskEvent)new TaskTAttemptEvent(this.getLastAttempt().getAttemptId(), TaskEventType.T_ADD_SPEC_ATTEMPT));
        this.launchTaskAttempt(this.getLastAttempt().getAttemptId());
        this.commitTaskAttempt(this.getLastAttempt().getAttemptId());
        this.mockTask.handle((TaskEvent)new TaskTAttemptEvent(this.getLastAttempt().getAttemptId(), TaskEventType.T_ATTEMPT_SUCCEEDED));
        this.assertTaskSucceededState();
        this.mockTask.handle((TaskEvent)new TaskTAttemptEvent(((MockTaskAttemptImpl)this.taskAttempts.get(0)).getAttemptId(), firstAttemptFinishEvent));
        this.assertTaskSucceededState();
    }

    @Test
    public void testSpeculativeTaskAttemptSucceedsEvenIfFirstFails() {
        this.runSpeculativeTaskAttemptSucceeds(TaskEventType.T_ATTEMPT_FAILED);
    }

    @Test
    public void testMultipleTaskAttemptsSucceed() {
        this.runSpeculativeTaskAttemptSucceeds(TaskEventType.T_ATTEMPT_SUCCEEDED);
    }

    @Test
    public void testCommitAfterSucceeds() {
        this.runSpeculativeTaskAttemptSucceeds(TaskEventType.T_ATTEMPT_COMMIT_PENDING);
    }

    @Test
    public void testSpeculativeMapFetchFailure() {
        this.runSpeculativeTaskAttemptSucceeds(TaskEventType.T_ATTEMPT_KILLED);
        Assert.assertEquals((long)2L, (long)this.taskAttempts.size());
        this.mockTask.handle((TaskEvent)new TaskTAttemptEvent(((MockTaskAttemptImpl)this.taskAttempts.get(1)).getAttemptId(), TaskEventType.T_ATTEMPT_FAILED));
        this.assertTaskScheduledState();
        Assert.assertEquals((long)3L, (long)this.taskAttempts.size());
    }

    @Test
    public void testSpeculativeMapMultipleSucceedFetchFailure() {
        this.runSpeculativeTaskAttemptSucceeds(TaskEventType.T_ATTEMPT_SUCCEEDED);
        Assert.assertEquals((long)2L, (long)this.taskAttempts.size());
        this.mockTask.handle((TaskEvent)new TaskTAttemptEvent(((MockTaskAttemptImpl)this.taskAttempts.get(1)).getAttemptId(), TaskEventType.T_ATTEMPT_FAILED));
        this.assertTaskScheduledState();
        Assert.assertEquals((long)3L, (long)this.taskAttempts.size());
    }

    @Test
    public void testSpeculativeMapFailedFetchFailure() {
        this.runSpeculativeTaskAttemptSucceeds(TaskEventType.T_ATTEMPT_FAILED);
        Assert.assertEquals((long)2L, (long)this.taskAttempts.size());
        this.mockTask.handle((TaskEvent)new TaskTAttemptEvent(((MockTaskAttemptImpl)this.taskAttempts.get(1)).getAttemptId(), TaskEventType.T_ATTEMPT_FAILED));
        this.assertTaskScheduledState();
        Assert.assertEquals((long)3L, (long)this.taskAttempts.size());
    }

    static /* synthetic */ TaskType access$000(TestTaskImpl x0) {
        return x0.taskType;
    }

    static /* synthetic */ Path access$100(TestTaskImpl x0) {
        return x0.remoteJobConfFile;
    }

    static /* synthetic */ List access$200(TestTaskImpl x0) {
        return x0.taskAttempts;
    }

    static /* synthetic */ String[] access$300(TestTaskImpl x0) {
        return x0.dataLocations;
    }
}

