/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.v2.app.recover;

import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileContext;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.OutputCommitter;
import org.apache.hadoop.mapreduce.TaskID;
import org.apache.hadoop.mapreduce.TypeConverter;
import org.apache.hadoop.mapreduce.jobhistory.JobHistoryParser;
import org.apache.hadoop.mapreduce.v2.api.records.AMInfo;
import org.apache.hadoop.mapreduce.v2.api.records.TaskAttemptId;
import org.apache.hadoop.mapreduce.v2.api.records.TaskId;
import org.apache.hadoop.mapreduce.v2.api.records.TaskState;
import org.apache.hadoop.mapreduce.v2.app.ControlledClock;
import org.apache.hadoop.mapreduce.v2.app.job.event.TaskEvent;
import org.apache.hadoop.mapreduce.v2.app.recover.Recovery;
import org.apache.hadoop.mapreduce.v2.app.recover.RecoveryService;
import org.apache.hadoop.mapreduce.v2.jobhistory.JobHistoryUtils;
import org.apache.hadoop.mapreduce.v2.util.MRBuilderUtils;
import org.apache.hadoop.yarn.Clock;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.event.Dispatcher;
import org.apache.hadoop.yarn.service.CompositeService;
import org.apache.hadoop.yarn.service.Service;

/*
 * Exception performing whole class analysis ignored.
 */
public class RecoveryService
extends CompositeService
implements Recovery {
    private static final Log LOG = LogFactory.getLog(RecoveryService.class);
    private final ApplicationAttemptId applicationAttemptId;
    private final OutputCommitter committer;
    private final Dispatcher dispatcher;
    private final ControlledClock clock;
    private JobHistoryParser.JobInfo jobInfo = null;
    private final Map<TaskId, JobHistoryParser.TaskInfo> completedTasks = new HashMap();
    private final List<TaskEvent> pendingTaskScheduleEvents = new ArrayList();
    private volatile boolean recoveryMode = false;

    public RecoveryService(ApplicationAttemptId applicationAttemptId, Clock clock, OutputCommitter committer) {
        super("RecoveringDispatcher");
        this.applicationAttemptId = applicationAttemptId;
        this.committer = committer;
        this.dispatcher = this.createRecoveryDispatcher();
        this.clock = new ControlledClock(clock);
        this.addService((Service)this.dispatcher);
    }

    public void init(Configuration conf) {
        super.init(conf);
        try {
            this.parse();
        }
        catch (Exception e) {
            LOG.warn((Object)e);
            LOG.warn((Object)"Could not parse the old history file. Aborting recovery. Starting afresh.", (Throwable)e);
        }
        if (this.completedTasks.size() > 0) {
            this.recoveryMode = true;
            LOG.info((Object)("SETTING THE RECOVERY MODE TO TRUE. NO OF COMPLETED TASKS TO RECOVER " + this.completedTasks.size()));
            LOG.info((Object)("Job launch time " + this.jobInfo.getLaunchTime()));
            this.clock.setTime(this.jobInfo.getLaunchTime());
        }
    }

    public Dispatcher getDispatcher() {
        return this.dispatcher;
    }

    public Clock getClock() {
        return this.clock;
    }

    public Map<TaskId, JobHistoryParser.TaskInfo> getCompletedTasks() {
        return this.completedTasks;
    }

    public List<AMInfo> getAMInfos() {
        if (this.jobInfo == null || this.jobInfo.getAMInfos() == null) {
            return new LinkedList<AMInfo>();
        }
        LinkedList<AMInfo> amInfos = new LinkedList<AMInfo>();
        for (JobHistoryParser.AMInfo jhAmInfo : this.jobInfo.getAMInfos()) {
            AMInfo amInfo = MRBuilderUtils.newAMInfo((ApplicationAttemptId)jhAmInfo.getAppAttemptId(), (long)jhAmInfo.getStartTime(), (ContainerId)jhAmInfo.getContainerId(), (String)jhAmInfo.getNodeManagerHost(), (int)jhAmInfo.getNodeManagerPort(), (int)jhAmInfo.getNodeManagerHttpPort());
            amInfos.add(amInfo);
        }
        return amInfos;
    }

    private void parse() throws IOException {
        FSDataInputStream in = RecoveryService.getPreviousJobHistoryFileStream((Configuration)this.getConfig(), (ApplicationAttemptId)this.applicationAttemptId);
        JobHistoryParser parser = new JobHistoryParser(in);
        this.jobInfo = parser.parse();
        IOException parseException = parser.getParseException();
        if (parseException != null) {
            LOG.info((Object)"Got an error parsing job-history file, ignoring incomplete events.", (Throwable)parseException);
        }
        Map taskInfos = this.jobInfo.getAllTasks();
        for (JobHistoryParser.TaskInfo taskInfo : taskInfos.values()) {
            if (!TaskState.SUCCEEDED.toString().equals(taskInfo.getTaskStatus())) continue;
            this.completedTasks.put(TypeConverter.toYarn((TaskID)taskInfo.getTaskId()), taskInfo);
            LOG.info((Object)("Read from history task " + TypeConverter.toYarn((TaskID)taskInfo.getTaskId())));
        }
        LOG.info((Object)("Read completed tasks from history " + this.completedTasks.size()));
    }

    public static FSDataInputStream getPreviousJobHistoryFileStream(Configuration conf, ApplicationAttemptId applicationAttemptId) throws IOException {
        FSDataInputStream in = null;
        Path historyFile = null;
        String jobName = TypeConverter.fromYarn((ApplicationId)applicationAttemptId.getApplicationId()).toString();
        String jobhistoryDir = JobHistoryUtils.getConfiguredHistoryStagingDirPrefix((Configuration)conf);
        Path histDirPath = FileContext.getFileContext((Configuration)conf).makeQualified(new Path(jobhistoryDir));
        FileContext fc = FileContext.getFileContext((URI)histDirPath.toUri(), (Configuration)conf);
        historyFile = fc.makeQualified(JobHistoryUtils.getStagingJobHistoryFile((Path)histDirPath, (String)jobName, (int)(applicationAttemptId.getAttemptId() - 1)));
        LOG.info((Object)("History file is at " + historyFile));
        in = fc.open(historyFile);
        return in;
    }

    protected Dispatcher createRecoveryDispatcher() {
        return new RecoveryDispatcher(this);
    }

    private JobHistoryParser.TaskAttemptInfo getTaskAttemptInfo(TaskAttemptId id) {
        JobHistoryParser.TaskInfo taskInfo = (JobHistoryParser.TaskInfo)this.completedTasks.get(id.getTaskId());
        return (JobHistoryParser.TaskAttemptInfo)taskInfo.getAllTaskAttempts().get(TypeConverter.fromYarn((TaskAttemptId)id));
    }

    static /* synthetic */ boolean access$000(RecoveryService x0) {
        return x0.recoveryMode;
    }

    static /* synthetic */ JobHistoryParser.TaskAttemptInfo access$100(RecoveryService x0, TaskAttemptId x1) {
        return x0.getTaskAttemptInfo(x1);
    }

    static /* synthetic */ Log access$200() {
        return LOG;
    }

    static /* synthetic */ ControlledClock access$300(RecoveryService x0) {
        return x0.clock;
    }

    static /* synthetic */ Map access$400(RecoveryService x0) {
        return x0.completedTasks;
    }

    static /* synthetic */ boolean access$002(RecoveryService x0, boolean x1) {
        x0.recoveryMode = x1;
        return x0.recoveryMode;
    }

    static /* synthetic */ List access$500(RecoveryService x0) {
        return x0.pendingTaskScheduleEvents;
    }

    static /* synthetic */ OutputCommitter access$600(RecoveryService x0) {
        return x0.committer;
    }
}

