/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.v2.app.taskclean;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.mapreduce.v2.app.AppContext;
import org.apache.hadoop.mapreduce.v2.app.job.event.TaskAttemptEvent;
import org.apache.hadoop.mapreduce.v2.app.job.event.TaskAttemptEventType;
import org.apache.hadoop.mapreduce.v2.app.taskclean.TaskCleaner;
import org.apache.hadoop.mapreduce.v2.app.taskclean.TaskCleanupEvent;
import org.apache.hadoop.yarn.YarnException;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.service.AbstractService;

public class TaskCleanerImpl
extends AbstractService
implements TaskCleaner {
    private static final Log LOG = LogFactory.getLog(TaskCleanerImpl.class);
    private final AppContext context;
    private ThreadPoolExecutor launcherPool;
    private Thread eventHandlingThread;
    private BlockingQueue<TaskCleanupEvent> eventQueue = new LinkedBlockingQueue<TaskCleanupEvent>();
    private final AtomicBoolean stopped;

    public TaskCleanerImpl(AppContext context) {
        super("TaskCleaner");
        this.context = context;
        this.stopped = new AtomicBoolean(false);
    }

    public void start() {
        ThreadFactory tf = new ThreadFactoryBuilder().setNameFormat("TaskCleaner #%d").build();
        this.launcherPool = new ThreadPoolExecutor(5, 5, 1L, TimeUnit.HOURS, new LinkedBlockingQueue<Runnable>(), tf);
        this.eventHandlingThread = new Thread(new Runnable(){

            @Override
            public void run() {
                TaskCleanupEvent event = null;
                while (!TaskCleanerImpl.this.stopped.get() && !Thread.currentThread().isInterrupted()) {
                    try {
                        event = (TaskCleanupEvent)((Object)TaskCleanerImpl.this.eventQueue.take());
                    }
                    catch (InterruptedException e) {
                        if (!TaskCleanerImpl.this.stopped.get()) {
                            LOG.error((Object)("Returning, interrupted : " + e));
                        }
                        return;
                    }
                    TaskCleanerImpl.this.launcherPool.execute(new EventProcessor(event));
                }
            }
        });
        this.eventHandlingThread.setName("TaskCleaner Event Handler");
        this.eventHandlingThread.start();
        super.start();
    }

    public void stop() {
        if (this.stopped.getAndSet(true)) {
            return;
        }
        this.eventHandlingThread.interrupt();
        this.launcherPool.shutdown();
        super.stop();
    }

    public void handle(TaskCleanupEvent event) {
        try {
            this.eventQueue.put(event);
        }
        catch (InterruptedException e) {
            throw new YarnException((Throwable)e);
        }
    }

    private class EventProcessor
    implements Runnable {
        private TaskCleanupEvent event;

        EventProcessor(TaskCleanupEvent event) {
            this.event = event;
        }

        @Override
        public void run() {
            LOG.info((Object)("Processing the event " + this.event.toString()));
            try {
                this.event.getCommitter().abortTask(this.event.getAttemptContext());
            }
            catch (Exception e) {
                LOG.warn((Object)("Task cleanup failed for attempt " + this.event.getAttemptID()), (Throwable)e);
            }
            TaskCleanerImpl.this.context.getEventHandler().handle((Event)new TaskAttemptEvent(this.event.getAttemptID(), TaskAttemptEventType.TA_CLEANUP_DONE));
        }
    }
}

