/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.v2.app.job.impl;

import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapreduce.Counters;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.hadoop.mapreduce.TaskID;
import org.apache.hadoop.mapreduce.TypeConverter;
import org.apache.hadoop.mapreduce.jobhistory.HistoryEvent;
import org.apache.hadoop.mapreduce.jobhistory.JobHistoryEvent;
import org.apache.hadoop.mapreduce.jobhistory.JobHistoryParser;
import org.apache.hadoop.mapreduce.jobhistory.TaskFailedEvent;
import org.apache.hadoop.mapreduce.jobhistory.TaskFinishedEvent;
import org.apache.hadoop.mapreduce.jobhistory.TaskStartedEvent;
import org.apache.hadoop.mapreduce.security.token.JobTokenIdentifier;
import org.apache.hadoop.mapreduce.v2.api.records.JobId;
import org.apache.hadoop.mapreduce.v2.api.records.TaskAttemptCompletionEvent;
import org.apache.hadoop.mapreduce.v2.api.records.TaskAttemptCompletionEventStatus;
import org.apache.hadoop.mapreduce.v2.api.records.TaskAttemptId;
import org.apache.hadoop.mapreduce.v2.api.records.TaskAttemptState;
import org.apache.hadoop.mapreduce.v2.api.records.TaskId;
import org.apache.hadoop.mapreduce.v2.api.records.TaskReport;
import org.apache.hadoop.mapreduce.v2.api.records.TaskState;
import org.apache.hadoop.mapreduce.v2.api.records.TaskType;
import org.apache.hadoop.mapreduce.v2.app.AppContext;
import org.apache.hadoop.mapreduce.v2.app.TaskAttemptListener;
import org.apache.hadoop.mapreduce.v2.app.job.Task;
import org.apache.hadoop.mapreduce.v2.app.job.TaskAttempt;
import org.apache.hadoop.mapreduce.v2.app.job.TaskStateInternal;
import org.apache.hadoop.mapreduce.v2.app.job.event.JobDiagnosticsUpdateEvent;
import org.apache.hadoop.mapreduce.v2.app.job.event.JobEvent;
import org.apache.hadoop.mapreduce.v2.app.job.event.JobEventType;
import org.apache.hadoop.mapreduce.v2.app.job.event.JobMapTaskRescheduledEvent;
import org.apache.hadoop.mapreduce.v2.app.job.event.JobTaskAttemptCompletedEvent;
import org.apache.hadoop.mapreduce.v2.app.job.event.JobTaskEvent;
import org.apache.hadoop.mapreduce.v2.app.job.event.TaskAttemptEvent;
import org.apache.hadoop.mapreduce.v2.app.job.event.TaskAttemptEventType;
import org.apache.hadoop.mapreduce.v2.app.job.event.TaskEvent;
import org.apache.hadoop.mapreduce.v2.app.job.event.TaskEventType;
import org.apache.hadoop.mapreduce.v2.app.job.event.TaskTAttemptEvent;
import org.apache.hadoop.mapreduce.v2.app.job.impl.TaskAttemptImpl;
import org.apache.hadoop.mapreduce.v2.app.metrics.MRAppMetrics;
import org.apache.hadoop.mapreduce.v2.app.rm.ContainerFailedEvent;
import org.apache.hadoop.mapreduce.v2.util.MRBuilderUtils;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.util.StringInterner;
import org.apache.hadoop.yarn.Clock;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.event.EventHandler;
import org.apache.hadoop.yarn.factories.RecordFactory;
import org.apache.hadoop.yarn.factory.providers.RecordFactoryProvider;
import org.apache.hadoop.yarn.state.InvalidStateTransitonException;
import org.apache.hadoop.yarn.state.MultipleArcTransition;
import org.apache.hadoop.yarn.state.SingleArcTransition;
import org.apache.hadoop.yarn.state.StateMachine;
import org.apache.hadoop.yarn.state.StateMachineFactory;

public abstract class TaskImpl
implements Task,
EventHandler<TaskEvent> {
    private static final Log LOG = LogFactory.getLog(TaskImpl.class);
    protected final JobConf conf;
    protected final Path jobFile;
    protected final int partition;
    protected final TaskAttemptListener taskAttemptListener;
    protected final EventHandler eventHandler;
    private final TaskId taskId;
    private Map<TaskAttemptId, TaskAttempt> attempts;
    private final int maxAttempts;
    protected final Clock clock;
    private final Lock readLock;
    private final Lock writeLock;
    private final MRAppMetrics metrics;
    protected final AppContext appContext;
    private long scheduledTime;
    private final RecordFactory recordFactory = RecordFactoryProvider.getRecordFactory(null);
    protected Credentials credentials;
    protected Token<JobTokenIdentifier> jobToken;
    private TaskAttemptId commitAttempt;
    private TaskAttemptId successfulAttempt;
    private final Set<TaskAttemptId> failedAttempts;
    private final Set<TaskAttemptId> finishedAttempts;
    private final Set<TaskAttemptId> inProgressAttempts;
    private boolean historyTaskStartGenerated = false;
    private static final SingleArcTransition<TaskImpl, TaskEvent> ATTEMPT_KILLED_TRANSITION = new AttemptKilledTransition();
    private static final SingleArcTransition<TaskImpl, TaskEvent> KILL_TRANSITION = new KillTransition();
    private static final StateMachineFactory<TaskImpl, TaskStateInternal, TaskEventType, TaskEvent> stateMachineFactory = new StateMachineFactory((Enum)TaskStateInternal.NEW).addTransition((Enum)TaskStateInternal.NEW, (Enum)TaskStateInternal.SCHEDULED, (Enum)TaskEventType.T_SCHEDULE, (SingleArcTransition)new InitialScheduleTransition()).addTransition((Enum)TaskStateInternal.NEW, (Enum)TaskStateInternal.KILLED, (Enum)TaskEventType.T_KILL, (SingleArcTransition)new KillNewTransition()).addTransition((Enum)TaskStateInternal.SCHEDULED, (Enum)TaskStateInternal.RUNNING, (Enum)TaskEventType.T_ATTEMPT_LAUNCHED, (SingleArcTransition)new LaunchTransition()).addTransition((Enum)TaskStateInternal.SCHEDULED, (Enum)TaskStateInternal.KILL_WAIT, (Enum)TaskEventType.T_KILL, KILL_TRANSITION).addTransition((Enum)TaskStateInternal.SCHEDULED, (Enum)TaskStateInternal.SCHEDULED, (Enum)TaskEventType.T_ATTEMPT_KILLED, ATTEMPT_KILLED_TRANSITION).addTransition((Enum)TaskStateInternal.SCHEDULED, EnumSet.of(TaskStateInternal.SCHEDULED, TaskStateInternal.FAILED), (Enum)TaskEventType.T_ATTEMPT_FAILED, (MultipleArcTransition)new AttemptFailedTransition()).addTransition((Enum)TaskStateInternal.RUNNING, (Enum)TaskStateInternal.RUNNING, (Enum)TaskEventType.T_ATTEMPT_LAUNCHED).addTransition((Enum)TaskStateInternal.RUNNING, (Enum)TaskStateInternal.RUNNING, (Enum)TaskEventType.T_ATTEMPT_COMMIT_PENDING, (SingleArcTransition)new AttemptCommitPendingTransition()).addTransition((Enum)TaskStateInternal.RUNNING, (Enum)TaskStateInternal.RUNNING, (Enum)TaskEventType.T_ADD_SPEC_ATTEMPT, (SingleArcTransition)new RedundantScheduleTransition()).addTransition((Enum)TaskStateInternal.RUNNING, (Enum)TaskStateInternal.SUCCEEDED, (Enum)TaskEventType.T_ATTEMPT_SUCCEEDED, (SingleArcTransition)new AttemptSucceededTransition()).addTransition((Enum)TaskStateInternal.RUNNING, (Enum)TaskStateInternal.RUNNING, (Enum)TaskEventType.T_ATTEMPT_KILLED, ATTEMPT_KILLED_TRANSITION).addTransition((Enum)TaskStateInternal.RUNNING, EnumSet.of(TaskStateInternal.RUNNING, TaskStateInternal.FAILED), (Enum)TaskEventType.T_ATTEMPT_FAILED, (MultipleArcTransition)new AttemptFailedTransition()).addTransition((Enum)TaskStateInternal.RUNNING, (Enum)TaskStateInternal.KILL_WAIT, (Enum)TaskEventType.T_KILL, KILL_TRANSITION).addTransition((Enum)TaskStateInternal.KILL_WAIT, EnumSet.of(TaskStateInternal.KILL_WAIT, TaskStateInternal.KILLED), (Enum)TaskEventType.T_ATTEMPT_KILLED, (MultipleArcTransition)new KillWaitAttemptKilledTransition()).addTransition((Enum)TaskStateInternal.KILL_WAIT, EnumSet.of(TaskStateInternal.KILL_WAIT, TaskStateInternal.KILLED), (Enum)TaskEventType.T_ATTEMPT_SUCCEEDED, (MultipleArcTransition)new KillWaitAttemptSucceededTransition()).addTransition((Enum)TaskStateInternal.KILL_WAIT, EnumSet.of(TaskStateInternal.KILL_WAIT, TaskStateInternal.KILLED), (Enum)TaskEventType.T_ATTEMPT_FAILED, (MultipleArcTransition)new KillWaitAttemptFailedTransition()).addTransition((Enum)TaskStateInternal.KILL_WAIT, (Enum)TaskStateInternal.KILL_WAIT, EnumSet.of(TaskEventType.T_KILL, TaskEventType.T_ATTEMPT_LAUNCHED, TaskEventType.T_ATTEMPT_COMMIT_PENDING, TaskEventType.T_ADD_SPEC_ATTEMPT)).addTransition((Enum)TaskStateInternal.SUCCEEDED, EnumSet.of(TaskStateInternal.SCHEDULED, TaskStateInternal.SUCCEEDED, TaskStateInternal.FAILED), (Enum)TaskEventType.T_ATTEMPT_FAILED, (MultipleArcTransition)new MapRetroactiveFailureTransition()).addTransition((Enum)TaskStateInternal.SUCCEEDED, (Enum)TaskStateInternal.SUCCEEDED, EnumSet.of(TaskEventType.T_ATTEMPT_KILLED, TaskEventType.T_ATTEMPT_SUCCEEDED), (SingleArcTransition)new AttemptCompletedAtSucceededTransition()).addTransition((Enum)TaskStateInternal.SUCCEEDED, (Enum)TaskStateInternal.SUCCEEDED, EnumSet.of(TaskEventType.T_KILL, TaskEventType.T_ADD_SPEC_ATTEMPT, TaskEventType.T_ATTEMPT_COMMIT_PENDING, TaskEventType.T_ATTEMPT_LAUNCHED)).addTransition((Enum)TaskStateInternal.FAILED, (Enum)TaskStateInternal.FAILED, EnumSet.of(TaskEventType.T_KILL, new TaskEventType[]{TaskEventType.T_ADD_SPEC_ATTEMPT, TaskEventType.T_ATTEMPT_COMMIT_PENDING, TaskEventType.T_ATTEMPT_FAILED, TaskEventType.T_ATTEMPT_KILLED, TaskEventType.T_ATTEMPT_LAUNCHED, TaskEventType.T_ATTEMPT_SUCCEEDED})).addTransition((Enum)TaskStateInternal.KILLED, (Enum)TaskStateInternal.KILLED, EnumSet.of(TaskEventType.T_KILL, TaskEventType.T_ADD_SPEC_ATTEMPT)).installTopology();
    private final StateMachine<TaskStateInternal, TaskEventType, TaskEvent> stateMachine;
    protected int nextAttemptNumber = 0;
    private List<JobHistoryParser.TaskAttemptInfo> taskAttemptsFromPreviousGeneration = new ArrayList<JobHistoryParser.TaskAttemptInfo>();
    private static final RecoverdAttemptsComparator RECOVERED_ATTEMPTS_COMPARATOR = new RecoverdAttemptsComparator();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TaskState getState() {
        this.readLock.lock();
        try {
            TaskState taskState = TaskImpl.getExternalState(this.getInternalState());
            return taskState;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public TaskImpl(JobId jobId, TaskType taskType, int partition, EventHandler eventHandler, Path remoteJobConfFile, JobConf conf, TaskAttemptListener taskAttemptListener, Token<JobTokenIdentifier> jobToken, Credentials credentials, Clock clock, Map<TaskId, JobHistoryParser.TaskInfo> completedTasksFromPreviousRun, int startCount, MRAppMetrics metrics, AppContext appContext) {
        this.conf = conf;
        this.clock = clock;
        this.jobFile = remoteJobConfFile;
        ReentrantReadWriteLock readWriteLock = new ReentrantReadWriteLock();
        this.readLock = readWriteLock.readLock();
        this.writeLock = readWriteLock.writeLock();
        this.attempts = Collections.emptyMap();
        this.finishedAttempts = new HashSet<TaskAttemptId>(2);
        this.failedAttempts = new HashSet<TaskAttemptId>(2);
        this.inProgressAttempts = new HashSet<TaskAttemptId>(2);
        this.maxAttempts = this.getMaxAttempts();
        this.taskId = MRBuilderUtils.newTaskId((JobId)jobId, (int)partition, (TaskType)taskType);
        this.partition = partition;
        this.taskAttemptListener = taskAttemptListener;
        this.eventHandler = eventHandler;
        this.credentials = credentials;
        this.jobToken = jobToken;
        this.metrics = metrics;
        this.appContext = appContext;
        if (completedTasksFromPreviousRun != null && completedTasksFromPreviousRun.containsKey(this.taskId)) {
            LOG.info((Object)("Task is from previous run " + this.taskId));
            JobHistoryParser.TaskInfo taskInfo = completedTasksFromPreviousRun.get(this.taskId);
            Map allAttempts = taskInfo.getAllTaskAttempts();
            this.taskAttemptsFromPreviousGeneration = new ArrayList<JobHistoryParser.TaskAttemptInfo>();
            this.taskAttemptsFromPreviousGeneration.addAll(allAttempts.values());
            Collections.sort(this.taskAttemptsFromPreviousGeneration, RECOVERED_ATTEMPTS_COMPARATOR);
        }
        this.nextAttemptNumber = this.taskAttemptsFromPreviousGeneration.isEmpty() ? (startCount - 1) * 1000 : this.taskAttemptsFromPreviousGeneration.remove(0).getAttemptId().getId();
        this.stateMachine = stateMachineFactory.make((Object)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<TaskAttemptId, TaskAttempt> getAttempts() {
        this.readLock.lock();
        try {
            if (this.attempts.size() <= 1) {
                Map<TaskAttemptId, TaskAttempt> map = this.attempts;
                return map;
            }
            LinkedHashMap<TaskAttemptId, TaskAttempt> result = new LinkedHashMap<TaskAttemptId, TaskAttempt>();
            result.putAll(this.attempts);
            LinkedHashMap<TaskAttemptId, TaskAttempt> linkedHashMap = result;
            return linkedHashMap;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TaskAttempt getAttempt(TaskAttemptId attemptID) {
        this.readLock.lock();
        try {
            TaskAttempt taskAttempt = this.attempts.get(attemptID);
            return taskAttempt;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public TaskId getID() {
        return this.taskId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isFinished() {
        this.readLock.lock();
        try {
            boolean bl = this.getInternalState() == TaskStateInternal.SUCCEEDED || this.getInternalState() == TaskStateInternal.FAILED || this.getInternalState() == TaskStateInternal.KILLED;
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TaskReport getReport() {
        TaskReport report = (TaskReport)this.recordFactory.newRecordInstance(TaskReport.class);
        this.readLock.lock();
        try {
            report.setTaskId(this.taskId);
            report.setStartTime(this.getLaunchTime());
            report.setFinishTime(this.getFinishTime());
            report.setTaskState(this.getState());
            report.setProgress(this.getProgress());
            for (TaskAttempt attempt : this.attempts.values()) {
                if (!TaskAttemptState.RUNNING.equals((Object)attempt.getState())) continue;
                report.addRunningAttempt(attempt.getID());
            }
            report.setSuccessfulAttempt(this.successfulAttempt);
            for (TaskAttempt att : this.attempts.values()) {
                String prefix = "AttemptID:" + att.getID() + " Info:";
                for (String cs : att.getDiagnostics()) {
                    report.addDiagnostics(prefix + cs);
                }
            }
            report.setCounters(TypeConverter.toYarn((Counters)this.getCounters()));
            TaskReport taskReport = report;
            return taskReport;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Counters getCounters() {
        Counters counters = null;
        this.readLock.lock();
        try {
            TaskAttempt bestAttempt = this.selectBestAttempt();
            counters = bestAttempt != null ? bestAttempt.getCounters() : TaskAttemptImpl.EMPTY_COUNTERS;
            Counters counters2 = counters;
            return counters2;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public float getProgress() {
        this.readLock.lock();
        try {
            TaskAttempt bestAttempt = this.selectBestAttempt();
            if (bestAttempt == null) {
                float f = 0.0f;
                return f;
            }
            float f = bestAttempt.getProgress();
            return f;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    public TaskStateInternal getInternalState() {
        this.readLock.lock();
        try {
            TaskStateInternal taskStateInternal = (TaskStateInternal)this.stateMachine.getCurrentState();
            return taskStateInternal;
        }
        finally {
            this.readLock.unlock();
        }
    }

    private static TaskState getExternalState(TaskStateInternal smState) {
        if (smState == TaskStateInternal.KILL_WAIT) {
            return TaskState.KILLED;
        }
        return TaskState.valueOf((String)smState.name());
    }

    private long getLaunchTime() {
        long taskLaunchTime = 0L;
        boolean launchTimeSet = false;
        for (TaskAttempt at : this.attempts.values()) {
            long attemptLaunchTime = at.getLaunchTime();
            if (attemptLaunchTime != 0L && !launchTimeSet) {
                launchTimeSet = true;
                taskLaunchTime = attemptLaunchTime;
                continue;
            }
            if (attemptLaunchTime == 0L || taskLaunchTime <= attemptLaunchTime) continue;
            taskLaunchTime = attemptLaunchTime;
        }
        if (!launchTimeSet) {
            return this.scheduledTime;
        }
        return taskLaunchTime;
    }

    private long getFinishTime() {
        if (!this.isFinished()) {
            return 0L;
        }
        long finishTime = 0L;
        for (TaskAttempt at : this.attempts.values()) {
            if (finishTime >= at.getFinishTime()) continue;
            finishTime = at.getFinishTime();
        }
        return finishTime;
    }

    private long getFinishTime(TaskAttemptId taId) {
        if (taId == null) {
            return this.clock.getTime();
        }
        long finishTime = 0L;
        for (TaskAttempt at : this.attempts.values()) {
            if (!at.getID().equals((Object)taId)) continue;
            return at.getFinishTime();
        }
        return finishTime;
    }

    private TaskStateInternal finished(TaskStateInternal finalState) {
        if (this.getInternalState() == TaskStateInternal.RUNNING) {
            this.metrics.endRunningTask(this);
        }
        return finalState;
    }

    private TaskAttempt selectBestAttempt() {
        float progress = 0.0f;
        TaskAttempt result = null;
        block3: for (TaskAttempt at : this.attempts.values()) {
            float attemptProgress;
            switch (at.getState()) {
                case FAILED: 
                case KILLED: {
                    continue block3;
                }
            }
            if (result == null) {
                result = at;
            }
            if (!((attemptProgress = at.getProgress()) > progress)) continue;
            result = at;
            progress = attemptProgress;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean canCommit(TaskAttemptId taskAttemptID) {
        this.readLock.lock();
        boolean canCommit = false;
        try {
            if (this.commitAttempt != null) {
                canCommit = taskAttemptID.equals((Object)this.commitAttempt);
                LOG.info((Object)("Result of canCommit for " + taskAttemptID + ":" + canCommit));
            }
        }
        finally {
            this.readLock.unlock();
        }
        return canCommit;
    }

    protected abstract TaskAttemptImpl createAttempt();

    protected abstract int getMaxAttempts();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected TaskAttempt getSuccessfulAttempt() {
        this.readLock.lock();
        try {
            if (null == this.successfulAttempt) {
                TaskAttempt taskAttempt = null;
                return taskAttempt;
            }
            TaskAttempt taskAttempt = this.attempts.get(this.successfulAttempt);
            return taskAttempt;
        }
        finally {
            this.readLock.unlock();
        }
    }

    private void addAndScheduleAttempt() {
        TaskAttemptImpl attempt = this.createAttempt();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Created attempt " + attempt.getID()));
        }
        switch (this.attempts.size()) {
            case 0: {
                this.attempts = Collections.singletonMap(attempt.getID(), attempt);
                break;
            }
            case 1: {
                LinkedHashMap<TaskAttemptId, TaskAttempt> newAttempts = new LinkedHashMap<TaskAttemptId, TaskAttempt>(this.maxAttempts);
                newAttempts.putAll(this.attempts);
                this.attempts = newAttempts;
                this.attempts.put(attempt.getID(), attempt);
                break;
            }
            default: {
                this.attempts.put(attempt.getID(), attempt);
            }
        }
        this.nextAttemptNumber = this.taskAttemptsFromPreviousGeneration.isEmpty() ? ++this.nextAttemptNumber : this.taskAttemptsFromPreviousGeneration.remove(0).getAttemptId().getId();
        this.inProgressAttempts.add(attempt.getID());
        if (this.failedAttempts.size() > 0) {
            this.eventHandler.handle((Event)new TaskAttemptEvent(attempt.getID(), TaskAttemptEventType.TA_RESCHEDULE));
        } else {
            this.eventHandler.handle((Event)new TaskAttemptEvent(attempt.getID(), TaskAttemptEventType.TA_SCHEDULE));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handle(TaskEvent event) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Processing " + event.getTaskID() + " of type " + event.getType()));
        }
        try {
            this.writeLock.lock();
            TaskStateInternal oldState = this.getInternalState();
            try {
                this.stateMachine.doTransition(event.getType(), (Object)event);
            }
            catch (InvalidStateTransitonException e) {
                LOG.error((Object)("Can't handle this event at current state for " + this.taskId), (Throwable)e);
                this.internalError((TaskEventType)event.getType());
            }
            if (oldState != this.getInternalState()) {
                LOG.info((Object)(this.taskId + " Task Transitioned from " + (Object)((Object)oldState) + " to " + (Object)((Object)this.getInternalState())));
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    protected void internalError(TaskEventType type) {
        LOG.error((Object)("Invalid event " + (Object)((Object)type) + " on Task " + this.taskId));
        this.eventHandler.handle((Event)new JobDiagnosticsUpdateEvent(this.taskId.getJobId(), "Invalid event " + (Object)((Object)type) + " on Task " + this.taskId));
        this.eventHandler.handle((Event)new JobEvent(this.taskId.getJobId(), JobEventType.INTERNAL_ERROR));
    }

    private void handleTaskAttemptCompletion(TaskAttemptId attemptId, TaskAttemptCompletionEventStatus status) {
        TaskAttempt attempt = this.attempts.get(attemptId);
        if (attempt.getNodeHttpAddress() != null) {
            TaskAttemptCompletionEvent tce = (TaskAttemptCompletionEvent)this.recordFactory.newRecordInstance(TaskAttemptCompletionEvent.class);
            tce.setEventId(-1);
            tce.setMapOutputServerAddress(StringInterner.weakIntern((String)("http://" + attempt.getNodeHttpAddress().split(":")[0] + ":" + attempt.getShufflePort())));
            tce.setStatus(status);
            tce.setAttemptId(attempt.getID());
            int runTime = 0;
            if (attempt.getFinishTime() != 0L && attempt.getLaunchTime() != 0L) {
                runTime = (int)(attempt.getFinishTime() - attempt.getLaunchTime());
            }
            tce.setAttemptRunTime(runTime);
            this.eventHandler.handle((Event)new JobTaskAttemptCompletedEvent(tce));
        }
    }

    private static TaskFinishedEvent createTaskFinishedEvent(TaskImpl task, TaskStateInternal taskState) {
        TaskFinishedEvent tfe = new TaskFinishedEvent((TaskID)TypeConverter.fromYarn((TaskId)task.taskId), (TaskAttemptID)TypeConverter.fromYarn((TaskAttemptId)task.successfulAttempt), task.getFinishTime(task.successfulAttempt), TypeConverter.fromYarn((TaskType)task.taskId.getTaskType()), taskState.toString(), task.getCounters());
        return tfe;
    }

    private static TaskFailedEvent createTaskFailedEvent(TaskImpl task, List<String> diag, TaskStateInternal taskState, TaskAttemptId taId) {
        StringBuilder errorSb = new StringBuilder();
        if (diag != null) {
            for (String d : diag) {
                errorSb.append(", ").append(d);
            }
        }
        TaskFailedEvent taskFailedEvent = new TaskFailedEvent((TaskID)TypeConverter.fromYarn((TaskId)task.taskId), task.getFinishTime(taId), TypeConverter.fromYarn((TaskType)task.getType()), errorSb.toString(), taskState.toString(), (TaskAttemptID)(taId == null ? null : TypeConverter.fromYarn((TaskAttemptId)taId)));
        return taskFailedEvent;
    }

    private static void unSucceed(TaskImpl task) {
        task.commitAttempt = null;
        task.successfulAttempt = null;
    }

    protected String getSplitsAsString() {
        return "";
    }

    private void killUnfinishedAttempt(TaskAttempt attempt, String logMsg) {
        if (attempt != null && !attempt.isFinished()) {
            this.eventHandler.handle((Event)new TaskAttemptEvent(attempt.getID(), TaskAttemptEventType.TA_KILL));
        }
    }

    static class LaunchTransition
    implements SingleArcTransition<TaskImpl, TaskEvent> {
        LaunchTransition() {
        }

        public void transition(TaskImpl task, TaskEvent event) {
            task.metrics.launchedTask(task);
            task.metrics.runningTask(task);
        }
    }

    private static class KillTransition
    implements SingleArcTransition<TaskImpl, TaskEvent> {
        private KillTransition() {
        }

        public void transition(TaskImpl task, TaskEvent event) {
            for (TaskAttempt attempt : task.attempts.values()) {
                task.killUnfinishedAttempt(attempt, "Task KILL is received. Killing attempt!");
            }
            task.inProgressAttempts.clear();
        }
    }

    private static class KillNewTransition
    implements SingleArcTransition<TaskImpl, TaskEvent> {
        private KillNewTransition() {
        }

        public void transition(TaskImpl task, TaskEvent event) {
            if (task.historyTaskStartGenerated) {
                TaskFailedEvent taskFailedEvent = TaskImpl.createTaskFailedEvent(task, null, TaskStateInternal.KILLED, null);
                task.eventHandler.handle((Event)new JobHistoryEvent(task.taskId.getJobId(), (HistoryEvent)taskFailedEvent));
            } else {
                LOG.debug((Object)("Not generating HistoryFinish event since start event not generated for task: " + task.getID()));
            }
            task.eventHandler.handle((Event)new JobTaskEvent(task.taskId, TaskState.KILLED));
            task.metrics.endWaitingTask(task);
        }
    }

    private static class AttemptCompletedAtSucceededTransition
    implements SingleArcTransition<TaskImpl, TaskEvent> {
        private AttemptCompletedAtSucceededTransition() {
        }

        public void transition(TaskImpl task, TaskEvent event) {
            TaskTAttemptEvent castEvent = (TaskTAttemptEvent)event;
            task.finishedAttempts.add(castEvent.getTaskAttemptID());
            task.inProgressAttempts.remove(castEvent.getTaskAttemptID());
        }
    }

    private static class MapRetroactiveFailureTransition
    extends AttemptFailedTransition {
        private MapRetroactiveFailureTransition() {
        }

        @Override
        public TaskStateInternal transition(TaskImpl task, TaskEvent event) {
            TaskTAttemptEvent castEvent = (TaskTAttemptEvent)event;
            if (task.getInternalState() == TaskStateInternal.SUCCEEDED && !castEvent.getTaskAttemptID().equals((Object)task.successfulAttempt)) {
                task.finishedAttempts.add(castEvent.getTaskAttemptID());
                task.inProgressAttempts.remove(castEvent.getTaskAttemptID());
                return TaskStateInternal.SUCCEEDED;
            }
            if (!TaskType.MAP.equals((Object)task.getType())) {
                LOG.error((Object)("Unexpected event for REDUCE task " + event.getType()));
                task.internalError((TaskEventType)event.getType());
            }
            task.eventHandler.handle((Event)new JobMapTaskRescheduledEvent(task.taskId));
            TaskImpl.unSucceed(task);
            task.inProgressAttempts.add(castEvent.getTaskAttemptID());
            return super.transition(task, event);
        }

        @Override
        protected TaskStateInternal getDefaultState(TaskImpl task) {
            return TaskStateInternal.SCHEDULED;
        }
    }

    private static class AttemptFailedTransition
    implements MultipleArcTransition<TaskImpl, TaskEvent, TaskStateInternal> {
        private AttemptFailedTransition() {
        }

        public TaskStateInternal transition(TaskImpl task, TaskEvent event) {
            TaskAttempt attempt;
            TaskTAttemptEvent castEvent = (TaskTAttemptEvent)event;
            TaskAttemptId taskAttemptId = castEvent.getTaskAttemptID();
            task.failedAttempts.add(taskAttemptId);
            if (taskAttemptId.equals((Object)task.commitAttempt)) {
                task.commitAttempt = null;
            }
            if ((attempt = (TaskAttempt)task.attempts.get(taskAttemptId)).getAssignedContainerMgrAddress() != null) {
                task.eventHandler.handle((Event)new ContainerFailedEvent(attempt.getID(), attempt.getAssignedContainerMgrAddress()));
            }
            task.finishedAttempts.add(taskAttemptId);
            if (task.failedAttempts.size() < task.maxAttempts) {
                task.handleTaskAttemptCompletion(taskAttemptId, TaskAttemptCompletionEventStatus.FAILED);
                task.inProgressAttempts.remove(taskAttemptId);
                if (task.inProgressAttempts.size() == 0 && task.successfulAttempt == null) {
                    task.addAndScheduleAttempt();
                }
            } else {
                task.handleTaskAttemptCompletion(taskAttemptId, TaskAttemptCompletionEventStatus.TIPFAILED);
                for (TaskAttempt taskAttempt : task.attempts.values()) {
                    task.killUnfinishedAttempt(taskAttempt, "Task has failed. Killing attempt!");
                }
                task.inProgressAttempts.clear();
                if (task.historyTaskStartGenerated) {
                    TaskFailedEvent taskFailedEvent = TaskImpl.createTaskFailedEvent(task, attempt.getDiagnostics(), TaskStateInternal.FAILED, taskAttemptId);
                    task.eventHandler.handle((Event)new JobHistoryEvent(task.taskId.getJobId(), (HistoryEvent)taskFailedEvent));
                } else {
                    LOG.debug((Object)("Not generating HistoryFinish event since start event not generated for task: " + task.getID()));
                }
                task.eventHandler.handle((Event)new JobTaskEvent(task.taskId, TaskState.FAILED));
                return task.finished(TaskStateInternal.FAILED);
            }
            return this.getDefaultState(task);
        }

        protected TaskStateInternal getDefaultState(TaskImpl task) {
            return task.getInternalState();
        }
    }

    private static class KillWaitAttemptFailedTransition
    extends KillWaitAttemptKilledTransition {
        public KillWaitAttemptFailedTransition() {
            super(TaskAttemptCompletionEventStatus.FAILED);
        }
    }

    private static class KillWaitAttemptSucceededTransition
    extends KillWaitAttemptKilledTransition {
        public KillWaitAttemptSucceededTransition() {
            super(TaskAttemptCompletionEventStatus.SUCCEEDED);
        }
    }

    private static class KillWaitAttemptKilledTransition
    implements MultipleArcTransition<TaskImpl, TaskEvent, TaskStateInternal> {
        protected TaskStateInternal finalState = TaskStateInternal.KILLED;
        protected final TaskAttemptCompletionEventStatus taCompletionEventStatus;

        public KillWaitAttemptKilledTransition() {
            this(TaskAttemptCompletionEventStatus.KILLED);
        }

        public KillWaitAttemptKilledTransition(TaskAttemptCompletionEventStatus taCompletionEventStatus) {
            this.taCompletionEventStatus = taCompletionEventStatus;
        }

        public TaskStateInternal transition(TaskImpl task, TaskEvent event) {
            TaskAttemptId taskAttemptId = ((TaskTAttemptEvent)event).getTaskAttemptID();
            task.handleTaskAttemptCompletion(taskAttemptId, this.taCompletionEventStatus);
            task.finishedAttempts.add(taskAttemptId);
            if (task.finishedAttempts.size() == task.attempts.size()) {
                if (task.historyTaskStartGenerated) {
                    TaskFailedEvent taskFailedEvent = TaskImpl.createTaskFailedEvent(task, null, this.finalState, null);
                    task.eventHandler.handle((Event)new JobHistoryEvent(task.taskId.getJobId(), (HistoryEvent)taskFailedEvent));
                } else {
                    LOG.debug((Object)("Not generating HistoryFinish event since start event not generated for task: " + task.getID()));
                }
                task.eventHandler.handle((Event)new JobTaskEvent(task.taskId, TaskImpl.getExternalState(this.finalState)));
                return this.finalState;
            }
            return task.getInternalState();
        }
    }

    private static class AttemptKilledTransition
    implements SingleArcTransition<TaskImpl, TaskEvent> {
        private AttemptKilledTransition() {
        }

        public void transition(TaskImpl task, TaskEvent event) {
            TaskAttemptId taskAttemptId = ((TaskTAttemptEvent)event).getTaskAttemptID();
            task.handleTaskAttemptCompletion(taskAttemptId, TaskAttemptCompletionEventStatus.KILLED);
            task.finishedAttempts.add(taskAttemptId);
            task.inProgressAttempts.remove(taskAttemptId);
            if (task.successfulAttempt == null) {
                task.addAndScheduleAttempt();
            }
        }
    }

    private static class AttemptSucceededTransition
    implements SingleArcTransition<TaskImpl, TaskEvent> {
        private AttemptSucceededTransition() {
        }

        public void transition(TaskImpl task, TaskEvent event) {
            TaskTAttemptEvent taskTAttemptEvent = (TaskTAttemptEvent)event;
            TaskAttemptId taskAttemptId = taskTAttemptEvent.getTaskAttemptID();
            task.handleTaskAttemptCompletion(taskAttemptId, TaskAttemptCompletionEventStatus.SUCCEEDED);
            task.finishedAttempts.add(taskAttemptId);
            task.inProgressAttempts.remove(taskAttemptId);
            task.successfulAttempt = taskAttemptId;
            task.eventHandler.handle((Event)new JobTaskEvent(task.taskId, TaskState.SUCCEEDED));
            LOG.info((Object)("Task succeeded with attempt " + task.successfulAttempt));
            if (task.historyTaskStartGenerated) {
                TaskFinishedEvent tfe = TaskImpl.createTaskFinishedEvent(task, TaskStateInternal.SUCCEEDED);
                task.eventHandler.handle((Event)new JobHistoryEvent(task.taskId.getJobId(), (HistoryEvent)tfe));
            }
            for (TaskAttempt attempt : task.attempts.values()) {
                if (attempt.getID() == task.successfulAttempt || attempt.isFinished()) continue;
                LOG.info((Object)("Issuing kill to other attempt " + attempt.getID()));
                task.eventHandler.handle((Event)new TaskAttemptEvent(attempt.getID(), TaskAttemptEventType.TA_KILL));
            }
            task.finished(TaskStateInternal.SUCCEEDED);
        }
    }

    private static class AttemptCommitPendingTransition
    implements SingleArcTransition<TaskImpl, TaskEvent> {
        private AttemptCommitPendingTransition() {
        }

        public void transition(TaskImpl task, TaskEvent event) {
            TaskTAttemptEvent ev = (TaskTAttemptEvent)event;
            TaskAttemptId attemptID = ev.getTaskAttemptID();
            if (task.commitAttempt == null) {
                task.commitAttempt = attemptID;
                LOG.info((Object)(attemptID + " given a go for committing the task output."));
            } else {
                LOG.info((Object)(task.commitAttempt + " already given a go for committing the task output, so killing " + attemptID));
                task.eventHandler.handle((Event)new TaskAttemptEvent(attemptID, TaskAttemptEventType.TA_KILL));
            }
        }
    }

    private static class RedundantScheduleTransition
    implements SingleArcTransition<TaskImpl, TaskEvent> {
        private RedundantScheduleTransition() {
        }

        public void transition(TaskImpl task, TaskEvent event) {
            LOG.info((Object)("Scheduling a redundant attempt for task " + task.taskId));
            task.addAndScheduleAttempt();
        }
    }

    private static class InitialScheduleTransition
    implements SingleArcTransition<TaskImpl, TaskEvent> {
        private InitialScheduleTransition() {
        }

        public void transition(TaskImpl task, TaskEvent event) {
            task.addAndScheduleAttempt();
            task.scheduledTime = task.clock.getTime();
            TaskStartedEvent tse = new TaskStartedEvent((TaskID)TypeConverter.fromYarn((TaskId)task.taskId), task.getLaunchTime(), TypeConverter.fromYarn((TaskType)task.taskId.getTaskType()), task.getSplitsAsString());
            task.eventHandler.handle((Event)new JobHistoryEvent(task.taskId.getJobId(), (HistoryEvent)tse));
            task.historyTaskStartGenerated = true;
        }
    }

    private static final class RecoverdAttemptsComparator
    implements Comparator<JobHistoryParser.TaskAttemptInfo> {
        private RecoverdAttemptsComparator() {
        }

        @Override
        public int compare(JobHistoryParser.TaskAttemptInfo attempt1, JobHistoryParser.TaskAttemptInfo attempt2) {
            long diff = attempt1.getStartTime() - attempt2.getStartTime();
            return diff == 0L ? 0 : (diff < 0L ? -1 : 1);
        }
    }
}

