/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.v2.app;

import java.io.IOException;
import junit.framework.Assert;
import org.apache.hadoop.mapreduce.v2.app.MRAppMaster;
import org.apache.hadoop.mapreduce.v2.app.MRAppMasterTest;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.util.ConverterUtils;
import org.junit.Test;

public class TestMRAppMaster {
    @Test
    public void testMRAppMasterForDifferentUser() throws IOException, InterruptedException {
        String applicationAttemptIdStr = "appattempt_1317529182569_0004_000001";
        String containerIdStr = "container_1317529182569_0004_000001_1";
        String stagingDir = "/tmp/staging";
        String userName = "TestAppMasterUser";
        ApplicationAttemptId applicationAttemptId = ConverterUtils.toApplicationAttemptId((String)applicationAttemptIdStr);
        ContainerId containerId = ConverterUtils.toContainerId((String)containerIdStr);
        MRAppMasterTest appMaster = new MRAppMasterTest(applicationAttemptId, containerId, "host", -1, -1, System.currentTimeMillis());
        YarnConfiguration conf = new YarnConfiguration();
        conf.set("yarn.app.mapreduce.am.staging-dir", stagingDir);
        MRAppMaster.initAndStartAppMaster((MRAppMaster)appMaster, (YarnConfiguration)conf, (String)userName);
        Assert.assertEquals((String)(stagingDir + "/" + userName + "/" + ".staging"), (String)appMaster.stagingDirPath.toString());
    }
}

