/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.v2.app.webapp;

import com.google.inject.Inject;
import java.util.Collection;
import org.apache.hadoop.mapreduce.v2.app.job.TaskAttempt;
import org.apache.hadoop.mapreduce.v2.app.webapp.App;
import org.apache.hadoop.mapreduce.v2.app.webapp.AppView;
import org.apache.hadoop.mapreduce.v2.app.webapp.dao.TaskAttemptInfo;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.util.StringHelper;
import org.apache.hadoop.yarn.util.Times;
import org.apache.hadoop.yarn.webapp.SubView;
import org.apache.hadoop.yarn.webapp.hamlet.Hamlet;
import org.apache.hadoop.yarn.webapp.view.HtmlBlock;
import org.apache.hadoop.yarn.webapp.view.HtmlPage;
import org.apache.hadoop.yarn.webapp.view.JQueryUI;

public class TaskPage
extends AppView {
    @Override
    protected void preHead(Hamlet.HTML<HtmlPage._> html) {
        this.commonPreHead(html);
        html.meta_http("refresh", "10");
        this.set(JQueryUI.initID((String)"ui.accordion", (String)"nav"), "{autoHeight:false, active:3}");
        this.set("ui.dataTables.id", "attempts");
        this.set(JQueryUI.initID((String)"ui.dataTables", (String)"attempts"), this.attemptsTableInit());
        this.setTableStyles(html, "attempts", new String[0]);
    }

    @Override
    protected Class<? extends SubView> content() {
        return AttemptsBlock.class;
    }

    private String attemptsTableInit() {
        return JQueryUI.tableInit().append(", aaSorting: [[0, 'asc']]").append("}").toString();
    }

    static class AttemptsBlock
    extends HtmlBlock {
        final App app;

        @Inject
        AttemptsBlock(App ctx) {
            this.app = ctx;
        }

        protected void render(HtmlBlock.Block html) {
            if (!this.isValidRequest()) {
                html.h2(this.$("title"));
                return;
            }
            Hamlet.TBODY tbody = ((Hamlet.TABLE)((Hamlet.THEAD)html.table("#attempts").thead().tr().th(".id", "Attempt").th(".progress", "Progress").th(".state", "State").th(".node", "Node").th(".logs", "Logs").th(".tsh", "Started").th(".tsh", "Finished").th(".tsh", "Elapsed").th(".note", "Note")._())._()).tbody();
            for (TaskAttempt attempt : this.getTaskAttempts()) {
                TaskAttemptInfo ta = new TaskAttemptInfo(attempt, true);
                String taid = ta.getId();
                String progress = StringHelper.percent((double)(ta.getProgress() / 100.0f));
                ContainerId containerId = ta.getAssignedContainerId();
                String nodeHttpAddr = ta.getNode();
                long startTime = ta.getStartTime();
                long finishTime = ta.getFinishTime();
                long elapsed = ta.getElapsedTime();
                String diag = ta.getNote() == null ? "" : ta.getNote();
                Hamlet.TR row = tbody.tr();
                Hamlet.TD nodeTd = row.td(".id", taid).td(".progress", progress).td(".state", ta.getState()).td();
                if (nodeHttpAddr == null) {
                    nodeTd._(new Object[]{"N/A"});
                } else {
                    nodeTd.a(".nodelink", this.url(new String[]{"http://", nodeHttpAddr}), nodeHttpAddr);
                }
                nodeTd._();
                if (containerId != null) {
                    String containerIdStr = ta.getAssignedContainerIdStr();
                    row.td().a(".logslink", this.url(new String[]{"http://", nodeHttpAddr, "node", "containerlogs", containerIdStr, this.app.getJob().getUserName()}), "logs")._();
                } else {
                    row.td()._(new Object[]{"N/A"})._();
                }
                row.td(".ts", Times.format((long)startTime)).td(".ts", Times.format((long)finishTime)).td(".dt", StringUtils.formatTime((long)elapsed)).td(".note", diag)._();
            }
            ((Hamlet.TABLE)tbody._())._();
        }

        protected boolean isValidRequest() {
            return this.app.getTask() != null;
        }

        protected Collection<TaskAttempt> getTaskAttempts() {
            return this.app.getTask().getAttempts().values();
        }
    }
}

