/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.v2.app.webapp;

import com.google.inject.Injector;
import com.google.inject.Module;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.mapreduce.v2.api.records.JobId;
import org.apache.hadoop.mapreduce.v2.api.records.TaskId;
import org.apache.hadoop.mapreduce.v2.api.records.TaskType;
import org.apache.hadoop.mapreduce.v2.app.AppContext;
import org.apache.hadoop.mapreduce.v2.app.job.Job;
import org.apache.hadoop.mapreduce.v2.app.job.Task;
import org.apache.hadoop.mapreduce.v2.app.job.TaskAttempt;
import org.apache.hadoop.mapreduce.v2.app.webapp.AMWebApp;
import org.apache.hadoop.mapreduce.v2.app.webapp.AppController;
import org.apache.hadoop.mapreduce.v2.app.webapp.AppView;
import org.apache.hadoop.mapreduce.v2.app.webapp.CountersPage;
import org.apache.hadoop.mapreduce.v2.app.webapp.JobConfPage;
import org.apache.hadoop.mapreduce.v2.app.webapp.JobPage;
import org.apache.hadoop.mapreduce.v2.app.webapp.SingleCounterPage;
import org.apache.hadoop.mapreduce.v2.app.webapp.TaskPage;
import org.apache.hadoop.mapreduce.v2.app.webapp.TasksPage;
import org.apache.hadoop.mapreduce.v2.app.webapp.TestAMWebApp;
import org.apache.hadoop.mapreduce.v2.util.MRApps;
import org.apache.hadoop.yarn.webapp.WebApp;
import org.apache.hadoop.yarn.webapp.WebApps;
import org.apache.hadoop.yarn.webapp.test.WebAppTests;
import org.junit.Assert;
import org.junit.Test;

/*
 * Exception performing whole class analysis ignored.
 */
public class TestAMWebApp {
    @Test
    public void testAppControllerIndex() {
        TestAppContext ctx = new TestAppContext();
        Injector injector = WebAppTests.createMockInjector(AppContext.class, (Object)ctx, (Module[])new Module[0]);
        AppController controller = (AppController)injector.getInstance(AppController.class);
        controller.index();
        Assert.assertEquals((Object)ctx.appID.toString(), (Object)controller.get("app.id", ""));
    }

    @Test
    public void testAppView() {
        WebAppTests.testPage(AppView.class, AppContext.class, (Object)new TestAppContext(), (Module[])new Module[0]);
    }

    @Test
    public void testJobView() {
        TestAppContext appContext = new TestAppContext();
        Map params = TestAMWebApp.getJobParams((AppContext)appContext);
        WebAppTests.testPage(JobPage.class, AppContext.class, (Object)appContext, (Map)params, (Module[])new Module[0]);
    }

    @Test
    public void testTasksView() {
        TestAppContext appContext = new TestAppContext();
        Map params = TestAMWebApp.getTaskParams((AppContext)appContext);
        WebAppTests.testPage(TasksPage.class, AppContext.class, (Object)appContext, (Map)params, (Module[])new Module[0]);
    }

    @Test
    public void testTaskView() {
        TestAppContext appContext = new TestAppContext();
        Map params = TestAMWebApp.getTaskParams((AppContext)appContext);
        WebAppTests.testPage(TaskPage.class, AppContext.class, (Object)appContext, (Map)params, (Module[])new Module[0]);
    }

    public static Map<String, String> getJobParams(AppContext appContext) {
        JobId jobId = (JobId)appContext.getAllJobs().entrySet().iterator().next().getKey();
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("job.id", MRApps.toString((JobId)jobId));
        return params;
    }

    public static Map<String, String> getTaskParams(AppContext appContext) {
        JobId jobId = (JobId)appContext.getAllJobs().entrySet().iterator().next().getKey();
        Map.Entry e = appContext.getJob(jobId).getTasks().entrySet().iterator().next();
        ((Task)e.getValue()).getType();
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("job.id", MRApps.toString((JobId)jobId));
        params.put("task.id", MRApps.toString((TaskId)((TaskId)e.getKey())));
        params.put("task.type", MRApps.taskSymbol((TaskType)((Task)e.getValue()).getType()));
        return params;
    }

    @Test
    public void testConfView() {
        WebAppTests.testPage(JobConfPage.class, AppContext.class, (Object)new TestAppContext(), (Module[])new Module[0]);
    }

    @Test
    public void testCountersView() {
        TestAppContext appContext = new TestAppContext();
        Map params = TestAMWebApp.getJobParams((AppContext)appContext);
        WebAppTests.testPage(CountersPage.class, AppContext.class, (Object)appContext, (Map)params, (Module[])new Module[0]);
    }

    @Test
    public void testSingleCounterView() {
        TestAppContext appContext = new TestAppContext();
        Map params = TestAMWebApp.getJobParams((AppContext)appContext);
        params.put("counter.group", "org.apache.hadoop.mapreduce.FileSystemCounter");
        params.put("counter.name", "HDFS_WRITE_OPS");
        WebAppTests.testPage(SingleCounterPage.class, AppContext.class, (Object)appContext, (Map)params, (Module[])new Module[0]);
    }

    @Test
    public void testTaskCountersView() {
        TestAppContext appContext = new TestAppContext();
        Map params = TestAMWebApp.getTaskParams((AppContext)appContext);
        WebAppTests.testPage(CountersPage.class, AppContext.class, (Object)appContext, (Map)params, (Module[])new Module[0]);
    }

    @Test
    public void testSingleTaskCounterView() {
        TestAppContext appContext = new TestAppContext(0, 1, 1, 2);
        Map params = TestAMWebApp.getTaskParams((AppContext)appContext);
        params.put("counter.group", "org.apache.hadoop.mapreduce.FileSystemCounter");
        params.put("counter.name", "HDFS_WRITE_OPS");
        TaskId taskID = MRApps.toTaskID((String)((String)params.get("task.id")));
        Job job = appContext.getJob(taskID.getJobId());
        Task task = job.getTask(taskID);
        TaskAttempt attempt = (TaskAttempt)task.getAttempts().values().iterator().next();
        attempt.getReport().setCounters(null);
        WebAppTests.testPage(SingleCounterPage.class, AppContext.class, (Object)appContext, (Map)params, (Module[])new Module[0]);
    }

    public static void main(String[] args) {
        WebApps.$for((String)"yarn", AppContext.class, (Object)new TestAppContext(0, 8, 88, 4)).at(58888).inDevMode().start((WebApp)new AMWebApp()).joinThread();
    }
}

