/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.v2.app.job.impl;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.DataOutputBuffer;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.JobID;
import org.apache.hadoop.mapred.MapReduceChildJVM;
import org.apache.hadoop.mapred.ShuffleHandler;
import org.apache.hadoop.mapred.Task;
import org.apache.hadoop.mapred.TaskAttemptContextImpl;
import org.apache.hadoop.mapred.WrappedJvmID;
import org.apache.hadoop.mapred.WrappedProgressSplitsBlock;
import org.apache.hadoop.mapreduce.Counter;
import org.apache.hadoop.mapreduce.Counters;
import org.apache.hadoop.mapreduce.ID;
import org.apache.hadoop.mapreduce.JobCounter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.hadoop.mapreduce.TaskCounter;
import org.apache.hadoop.mapreduce.TypeConverter;
import org.apache.hadoop.mapreduce.jobhistory.HistoryEvent;
import org.apache.hadoop.mapreduce.jobhistory.JobHistoryEvent;
import org.apache.hadoop.mapreduce.jobhistory.MapAttemptFinishedEvent;
import org.apache.hadoop.mapreduce.jobhistory.ReduceAttemptFinishedEvent;
import org.apache.hadoop.mapreduce.jobhistory.TaskAttemptStartedEvent;
import org.apache.hadoop.mapreduce.jobhistory.TaskAttemptUnsuccessfulCompletionEvent;
import org.apache.hadoop.mapreduce.security.TokenCache;
import org.apache.hadoop.mapreduce.security.token.JobTokenIdentifier;
import org.apache.hadoop.mapreduce.v2.api.records.Avataar;
import org.apache.hadoop.mapreduce.v2.api.records.JobId;
import org.apache.hadoop.mapreduce.v2.api.records.Locality;
import org.apache.hadoop.mapreduce.v2.api.records.Phase;
import org.apache.hadoop.mapreduce.v2.api.records.TaskAttemptId;
import org.apache.hadoop.mapreduce.v2.api.records.TaskAttemptReport;
import org.apache.hadoop.mapreduce.v2.api.records.TaskAttemptState;
import org.apache.hadoop.mapreduce.v2.api.records.TaskId;
import org.apache.hadoop.mapreduce.v2.api.records.TaskType;
import org.apache.hadoop.mapreduce.v2.app.AppContext;
import org.apache.hadoop.mapreduce.v2.app.TaskAttemptListener;
import org.apache.hadoop.mapreduce.v2.app.commit.CommitterTaskAbortEvent;
import org.apache.hadoop.mapreduce.v2.app.job.TaskAttempt;
import org.apache.hadoop.mapreduce.v2.app.job.TaskAttemptStateInternal;
import org.apache.hadoop.mapreduce.v2.app.job.event.JobCounterUpdateEvent;
import org.apache.hadoop.mapreduce.v2.app.job.event.JobDiagnosticsUpdateEvent;
import org.apache.hadoop.mapreduce.v2.app.job.event.JobEvent;
import org.apache.hadoop.mapreduce.v2.app.job.event.JobEventType;
import org.apache.hadoop.mapreduce.v2.app.job.event.JobTaskAttemptFetchFailureEvent;
import org.apache.hadoop.mapreduce.v2.app.job.event.TaskAttemptContainerAssignedEvent;
import org.apache.hadoop.mapreduce.v2.app.job.event.TaskAttemptContainerLaunchedEvent;
import org.apache.hadoop.mapreduce.v2.app.job.event.TaskAttemptDiagnosticsUpdateEvent;
import org.apache.hadoop.mapreduce.v2.app.job.event.TaskAttemptEvent;
import org.apache.hadoop.mapreduce.v2.app.job.event.TaskAttemptEventType;
import org.apache.hadoop.mapreduce.v2.app.job.event.TaskAttemptKillEvent;
import org.apache.hadoop.mapreduce.v2.app.job.event.TaskAttemptStatusUpdateEvent;
import org.apache.hadoop.mapreduce.v2.app.job.event.TaskEventType;
import org.apache.hadoop.mapreduce.v2.app.job.event.TaskTAttemptEvent;
import org.apache.hadoop.mapreduce.v2.app.launcher.ContainerLauncher;
import org.apache.hadoop.mapreduce.v2.app.launcher.ContainerLauncherEvent;
import org.apache.hadoop.mapreduce.v2.app.launcher.ContainerRemoteLaunchEvent;
import org.apache.hadoop.mapreduce.v2.app.rm.ContainerAllocator;
import org.apache.hadoop.mapreduce.v2.app.rm.ContainerAllocatorEvent;
import org.apache.hadoop.mapreduce.v2.app.rm.ContainerRequestEvent;
import org.apache.hadoop.mapreduce.v2.app.speculate.SpeculatorEvent;
import org.apache.hadoop.mapreduce.v2.util.MRApps;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.util.StringInterner;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.yarn.Clock;
import org.apache.hadoop.yarn.YarnException;
import org.apache.hadoop.yarn.api.ApplicationConstants;
import org.apache.hadoop.yarn.api.records.ApplicationAccessType;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ContainerLaunchContext;
import org.apache.hadoop.yarn.api.records.ContainerToken;
import org.apache.hadoop.yarn.api.records.LocalResource;
import org.apache.hadoop.yarn.api.records.LocalResourceType;
import org.apache.hadoop.yarn.api.records.LocalResourceVisibility;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.URL;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.event.EventHandler;
import org.apache.hadoop.yarn.factories.RecordFactory;
import org.apache.hadoop.yarn.factory.providers.RecordFactoryProvider;
import org.apache.hadoop.yarn.state.InvalidStateTransitonException;
import org.apache.hadoop.yarn.state.MultipleArcTransition;
import org.apache.hadoop.yarn.state.SingleArcTransition;
import org.apache.hadoop.yarn.state.StateMachine;
import org.apache.hadoop.yarn.state.StateMachineFactory;
import org.apache.hadoop.yarn.util.Apps;
import org.apache.hadoop.yarn.util.BuilderUtils;
import org.apache.hadoop.yarn.util.ConverterUtils;
import org.apache.hadoop.yarn.util.RackResolver;

public abstract class TaskAttemptImpl
implements TaskAttempt,
EventHandler<TaskAttemptEvent> {
    static final Counters EMPTY_COUNTERS = new Counters();
    private static final Log LOG = LogFactory.getLog(TaskAttemptImpl.class);
    private static final long MEMORY_SPLITS_RESOLUTION = 1024L;
    private static final RecordFactory recordFactory = RecordFactoryProvider.getRecordFactory(null);
    protected final JobConf conf;
    protected final Path jobFile;
    protected final int partition;
    protected EventHandler eventHandler;
    private final TaskAttemptId attemptId;
    private final Clock clock;
    private final JobID oldJobId;
    private final TaskAttemptListener taskAttemptListener;
    private final Resource resourceCapability;
    protected Set<String> dataLocalHosts;
    protected Set<String> dataLocalRacks;
    private final List<String> diagnostics = new ArrayList<String>();
    private final Lock readLock;
    private final Lock writeLock;
    private final AppContext appContext;
    private Credentials credentials;
    private Token<JobTokenIdentifier> jobToken;
    private static AtomicBoolean initialClasspathFlag = new AtomicBoolean();
    private static String initialClasspath = null;
    private static String initialAppClasspath = null;
    private static Object commonContainerSpecLock = new Object();
    private static ContainerLaunchContext commonContainerSpec = null;
    private static final Object classpathLock = new Object();
    private long launchTime;
    private long finishTime;
    private WrappedProgressSplitsBlock progressSplitBlock;
    private int shufflePort = -1;
    private String trackerName;
    private int httpPort;
    private Locality locality;
    private Avataar avataar;
    private static final CleanupContainerTransition CLEANUP_CONTAINER_TRANSITION = new CleanupContainerTransition();
    private static final DiagnosticInformationUpdater DIAGNOSTIC_INFORMATION_UPDATE_TRANSITION = new DiagnosticInformationUpdater();
    private static final StateMachineFactory<TaskAttemptImpl, TaskAttemptStateInternal, TaskAttemptEventType, TaskAttemptEvent> stateMachineFactory = new StateMachineFactory((Enum)TaskAttemptStateInternal.NEW).addTransition((Enum)TaskAttemptStateInternal.NEW, (Enum)TaskAttemptStateInternal.UNASSIGNED, (Enum)TaskAttemptEventType.TA_SCHEDULE, (SingleArcTransition)new RequestContainerTransition(false)).addTransition((Enum)TaskAttemptStateInternal.NEW, (Enum)TaskAttemptStateInternal.UNASSIGNED, (Enum)TaskAttemptEventType.TA_RESCHEDULE, (SingleArcTransition)new RequestContainerTransition(true)).addTransition((Enum)TaskAttemptStateInternal.NEW, (Enum)TaskAttemptStateInternal.KILLED, (Enum)TaskAttemptEventType.TA_KILL, (SingleArcTransition)new KilledTransition()).addTransition((Enum)TaskAttemptStateInternal.NEW, (Enum)TaskAttemptStateInternal.FAILED, (Enum)TaskAttemptEventType.TA_FAILMSG, (SingleArcTransition)new FailedTransition()).addTransition((Enum)TaskAttemptStateInternal.NEW, (Enum)TaskAttemptStateInternal.NEW, (Enum)TaskAttemptEventType.TA_DIAGNOSTICS_UPDATE, (SingleArcTransition)DIAGNOSTIC_INFORMATION_UPDATE_TRANSITION).addTransition((Enum)TaskAttemptStateInternal.UNASSIGNED, (Enum)TaskAttemptStateInternal.ASSIGNED, (Enum)TaskAttemptEventType.TA_ASSIGNED, (SingleArcTransition)new ContainerAssignedTransition()).addTransition((Enum)TaskAttemptStateInternal.UNASSIGNED, (Enum)TaskAttemptStateInternal.KILLED, (Enum)TaskAttemptEventType.TA_KILL, (SingleArcTransition)new DeallocateContainerTransition(TaskAttemptStateInternal.KILLED, true)).addTransition((Enum)TaskAttemptStateInternal.UNASSIGNED, (Enum)TaskAttemptStateInternal.FAILED, (Enum)TaskAttemptEventType.TA_FAILMSG, (SingleArcTransition)new DeallocateContainerTransition(TaskAttemptStateInternal.FAILED, true)).addTransition((Enum)TaskAttemptStateInternal.UNASSIGNED, (Enum)TaskAttemptStateInternal.UNASSIGNED, (Enum)TaskAttemptEventType.TA_DIAGNOSTICS_UPDATE, (SingleArcTransition)DIAGNOSTIC_INFORMATION_UPDATE_TRANSITION).addTransition((Enum)TaskAttemptStateInternal.ASSIGNED, (Enum)TaskAttemptStateInternal.RUNNING, (Enum)TaskAttemptEventType.TA_CONTAINER_LAUNCHED, (SingleArcTransition)new LaunchedContainerTransition()).addTransition((Enum)TaskAttemptStateInternal.ASSIGNED, (Enum)TaskAttemptStateInternal.ASSIGNED, (Enum)TaskAttemptEventType.TA_DIAGNOSTICS_UPDATE, (SingleArcTransition)DIAGNOSTIC_INFORMATION_UPDATE_TRANSITION).addTransition((Enum)TaskAttemptStateInternal.ASSIGNED, (Enum)TaskAttemptStateInternal.FAILED, (Enum)TaskAttemptEventType.TA_CONTAINER_LAUNCH_FAILED, (SingleArcTransition)new DeallocateContainerTransition(TaskAttemptStateInternal.FAILED, false)).addTransition((Enum)TaskAttemptStateInternal.ASSIGNED, (Enum)TaskAttemptStateInternal.FAIL_CONTAINER_CLEANUP, (Enum)TaskAttemptEventType.TA_CONTAINER_COMPLETED, (SingleArcTransition)CLEANUP_CONTAINER_TRANSITION).addTransition((Enum)TaskAttemptStateInternal.ASSIGNED, (Enum)TaskAttemptStateInternal.KILL_CONTAINER_CLEANUP, (Enum)TaskAttemptEventType.TA_KILL, (SingleArcTransition)CLEANUP_CONTAINER_TRANSITION).addTransition((Enum)TaskAttemptStateInternal.ASSIGNED, (Enum)TaskAttemptStateInternal.FAIL_CONTAINER_CLEANUP, (Enum)TaskAttemptEventType.TA_FAILMSG, (SingleArcTransition)CLEANUP_CONTAINER_TRANSITION).addTransition((Enum)TaskAttemptStateInternal.RUNNING, (Enum)TaskAttemptStateInternal.RUNNING, (Enum)TaskAttemptEventType.TA_UPDATE, (SingleArcTransition)new StatusUpdater()).addTransition((Enum)TaskAttemptStateInternal.RUNNING, (Enum)TaskAttemptStateInternal.RUNNING, (Enum)TaskAttemptEventType.TA_DIAGNOSTICS_UPDATE, (SingleArcTransition)DIAGNOSTIC_INFORMATION_UPDATE_TRANSITION).addTransition((Enum)TaskAttemptStateInternal.RUNNING, (Enum)TaskAttemptStateInternal.SUCCESS_CONTAINER_CLEANUP, (Enum)TaskAttemptEventType.TA_DONE, (SingleArcTransition)CLEANUP_CONTAINER_TRANSITION).addTransition((Enum)TaskAttemptStateInternal.RUNNING, (Enum)TaskAttemptStateInternal.COMMIT_PENDING, (Enum)TaskAttemptEventType.TA_COMMIT_PENDING, (SingleArcTransition)new CommitPendingTransition()).addTransition((Enum)TaskAttemptStateInternal.RUNNING, (Enum)TaskAttemptStateInternal.FAIL_CONTAINER_CLEANUP, (Enum)TaskAttemptEventType.TA_FAILMSG, (SingleArcTransition)CLEANUP_CONTAINER_TRANSITION).addTransition((Enum)TaskAttemptStateInternal.RUNNING, (Enum)TaskAttemptStateInternal.FAIL_CONTAINER_CLEANUP, (Enum)TaskAttemptEventType.TA_CONTAINER_COMPLETED, (SingleArcTransition)CLEANUP_CONTAINER_TRANSITION).addTransition((Enum)TaskAttemptStateInternal.RUNNING, (Enum)TaskAttemptStateInternal.FAIL_CONTAINER_CLEANUP, (Enum)TaskAttemptEventType.TA_TIMED_OUT, (SingleArcTransition)CLEANUP_CONTAINER_TRANSITION).addTransition((Enum)TaskAttemptStateInternal.RUNNING, (Enum)TaskAttemptStateInternal.KILLED, (Enum)TaskAttemptEventType.TA_CONTAINER_CLEANED, (SingleArcTransition)new KilledTransition()).addTransition((Enum)TaskAttemptStateInternal.RUNNING, (Enum)TaskAttemptStateInternal.KILL_CONTAINER_CLEANUP, (Enum)TaskAttemptEventType.TA_KILL, (SingleArcTransition)CLEANUP_CONTAINER_TRANSITION).addTransition((Enum)TaskAttemptStateInternal.COMMIT_PENDING, (Enum)TaskAttemptStateInternal.COMMIT_PENDING, (Enum)TaskAttemptEventType.TA_UPDATE, (SingleArcTransition)new StatusUpdater()).addTransition((Enum)TaskAttemptStateInternal.COMMIT_PENDING, (Enum)TaskAttemptStateInternal.COMMIT_PENDING, (Enum)TaskAttemptEventType.TA_DIAGNOSTICS_UPDATE, (SingleArcTransition)DIAGNOSTIC_INFORMATION_UPDATE_TRANSITION).addTransition((Enum)TaskAttemptStateInternal.COMMIT_PENDING, (Enum)TaskAttemptStateInternal.SUCCESS_CONTAINER_CLEANUP, (Enum)TaskAttemptEventType.TA_DONE, (SingleArcTransition)CLEANUP_CONTAINER_TRANSITION).addTransition((Enum)TaskAttemptStateInternal.COMMIT_PENDING, (Enum)TaskAttemptStateInternal.KILL_CONTAINER_CLEANUP, (Enum)TaskAttemptEventType.TA_KILL, (SingleArcTransition)CLEANUP_CONTAINER_TRANSITION).addTransition((Enum)TaskAttemptStateInternal.COMMIT_PENDING, (Enum)TaskAttemptStateInternal.KILLED, (Enum)TaskAttemptEventType.TA_CONTAINER_CLEANED, (SingleArcTransition)new KilledTransition()).addTransition((Enum)TaskAttemptStateInternal.COMMIT_PENDING, (Enum)TaskAttemptStateInternal.FAIL_CONTAINER_CLEANUP, (Enum)TaskAttemptEventType.TA_FAILMSG, (SingleArcTransition)CLEANUP_CONTAINER_TRANSITION).addTransition((Enum)TaskAttemptStateInternal.COMMIT_PENDING, (Enum)TaskAttemptStateInternal.FAIL_CONTAINER_CLEANUP, (Enum)TaskAttemptEventType.TA_CONTAINER_COMPLETED, (SingleArcTransition)CLEANUP_CONTAINER_TRANSITION).addTransition((Enum)TaskAttemptStateInternal.COMMIT_PENDING, (Enum)TaskAttemptStateInternal.FAIL_CONTAINER_CLEANUP, (Enum)TaskAttemptEventType.TA_TIMED_OUT, (SingleArcTransition)CLEANUP_CONTAINER_TRANSITION).addTransition((Enum)TaskAttemptStateInternal.SUCCESS_CONTAINER_CLEANUP, (Enum)TaskAttemptStateInternal.SUCCEEDED, (Enum)TaskAttemptEventType.TA_CONTAINER_CLEANED, (SingleArcTransition)new SucceededTransition()).addTransition((Enum)TaskAttemptStateInternal.SUCCESS_CONTAINER_CLEANUP, (Enum)TaskAttemptStateInternal.SUCCESS_CONTAINER_CLEANUP, (Enum)TaskAttemptEventType.TA_DIAGNOSTICS_UPDATE, (SingleArcTransition)DIAGNOSTIC_INFORMATION_UPDATE_TRANSITION).addTransition((Enum)TaskAttemptStateInternal.SUCCESS_CONTAINER_CLEANUP, (Enum)TaskAttemptStateInternal.SUCCESS_CONTAINER_CLEANUP, EnumSet.of(TaskAttemptEventType.TA_KILL, TaskAttemptEventType.TA_FAILMSG, TaskAttemptEventType.TA_TIMED_OUT, TaskAttemptEventType.TA_CONTAINER_COMPLETED)).addTransition((Enum)TaskAttemptStateInternal.FAIL_CONTAINER_CLEANUP, (Enum)TaskAttemptStateInternal.FAIL_TASK_CLEANUP, (Enum)TaskAttemptEventType.TA_CONTAINER_CLEANED, (SingleArcTransition)new TaskCleanupTransition()).addTransition((Enum)TaskAttemptStateInternal.FAIL_CONTAINER_CLEANUP, (Enum)TaskAttemptStateInternal.FAIL_CONTAINER_CLEANUP, (Enum)TaskAttemptEventType.TA_DIAGNOSTICS_UPDATE, (SingleArcTransition)DIAGNOSTIC_INFORMATION_UPDATE_TRANSITION).addTransition((Enum)TaskAttemptStateInternal.FAIL_CONTAINER_CLEANUP, (Enum)TaskAttemptStateInternal.FAIL_CONTAINER_CLEANUP, EnumSet.of(TaskAttemptEventType.TA_KILL, new TaskAttemptEventType[]{TaskAttemptEventType.TA_CONTAINER_COMPLETED, TaskAttemptEventType.TA_UPDATE, TaskAttemptEventType.TA_COMMIT_PENDING, TaskAttemptEventType.TA_CONTAINER_LAUNCHED, TaskAttemptEventType.TA_CONTAINER_LAUNCH_FAILED, TaskAttemptEventType.TA_DONE, TaskAttemptEventType.TA_FAILMSG, TaskAttemptEventType.TA_TIMED_OUT})).addTransition((Enum)TaskAttemptStateInternal.KILL_CONTAINER_CLEANUP, (Enum)TaskAttemptStateInternal.KILL_TASK_CLEANUP, (Enum)TaskAttemptEventType.TA_CONTAINER_CLEANED, (SingleArcTransition)new TaskCleanupTransition()).addTransition((Enum)TaskAttemptStateInternal.KILL_CONTAINER_CLEANUP, (Enum)TaskAttemptStateInternal.KILL_CONTAINER_CLEANUP, (Enum)TaskAttemptEventType.TA_DIAGNOSTICS_UPDATE, (SingleArcTransition)DIAGNOSTIC_INFORMATION_UPDATE_TRANSITION).addTransition((Enum)TaskAttemptStateInternal.KILL_CONTAINER_CLEANUP, (Enum)TaskAttemptStateInternal.KILL_CONTAINER_CLEANUP, EnumSet.of(TaskAttemptEventType.TA_KILL, new TaskAttemptEventType[]{TaskAttemptEventType.TA_CONTAINER_COMPLETED, TaskAttemptEventType.TA_UPDATE, TaskAttemptEventType.TA_COMMIT_PENDING, TaskAttemptEventType.TA_CONTAINER_LAUNCHED, TaskAttemptEventType.TA_CONTAINER_LAUNCH_FAILED, TaskAttemptEventType.TA_DONE, TaskAttemptEventType.TA_FAILMSG, TaskAttemptEventType.TA_TIMED_OUT})).addTransition((Enum)TaskAttemptStateInternal.FAIL_TASK_CLEANUP, (Enum)TaskAttemptStateInternal.FAILED, (Enum)TaskAttemptEventType.TA_CLEANUP_DONE, (SingleArcTransition)new FailedTransition()).addTransition((Enum)TaskAttemptStateInternal.FAIL_TASK_CLEANUP, (Enum)TaskAttemptStateInternal.FAIL_TASK_CLEANUP, (Enum)TaskAttemptEventType.TA_DIAGNOSTICS_UPDATE, (SingleArcTransition)DIAGNOSTIC_INFORMATION_UPDATE_TRANSITION).addTransition((Enum)TaskAttemptStateInternal.FAIL_TASK_CLEANUP, (Enum)TaskAttemptStateInternal.FAIL_TASK_CLEANUP, EnumSet.of(TaskAttemptEventType.TA_KILL, new TaskAttemptEventType[]{TaskAttemptEventType.TA_CONTAINER_COMPLETED, TaskAttemptEventType.TA_UPDATE, TaskAttemptEventType.TA_COMMIT_PENDING, TaskAttemptEventType.TA_DONE, TaskAttemptEventType.TA_FAILMSG, TaskAttemptEventType.TA_CONTAINER_CLEANED, TaskAttemptEventType.TA_CONTAINER_LAUNCHED, TaskAttemptEventType.TA_CONTAINER_LAUNCH_FAILED})).addTransition((Enum)TaskAttemptStateInternal.KILL_TASK_CLEANUP, (Enum)TaskAttemptStateInternal.KILLED, (Enum)TaskAttemptEventType.TA_CLEANUP_DONE, (SingleArcTransition)new KilledTransition()).addTransition((Enum)TaskAttemptStateInternal.KILL_TASK_CLEANUP, (Enum)TaskAttemptStateInternal.KILL_TASK_CLEANUP, (Enum)TaskAttemptEventType.TA_DIAGNOSTICS_UPDATE, (SingleArcTransition)DIAGNOSTIC_INFORMATION_UPDATE_TRANSITION).addTransition((Enum)TaskAttemptStateInternal.KILL_TASK_CLEANUP, (Enum)TaskAttemptStateInternal.KILL_TASK_CLEANUP, EnumSet.of(TaskAttemptEventType.TA_KILL, new TaskAttemptEventType[]{TaskAttemptEventType.TA_CONTAINER_COMPLETED, TaskAttemptEventType.TA_UPDATE, TaskAttemptEventType.TA_COMMIT_PENDING, TaskAttemptEventType.TA_DONE, TaskAttemptEventType.TA_FAILMSG, TaskAttemptEventType.TA_CONTAINER_CLEANED, TaskAttemptEventType.TA_CONTAINER_LAUNCHED, TaskAttemptEventType.TA_CONTAINER_LAUNCH_FAILED})).addTransition((Enum)TaskAttemptStateInternal.SUCCEEDED, (Enum)TaskAttemptStateInternal.FAILED, (Enum)TaskAttemptEventType.TA_TOO_MANY_FETCH_FAILURE, (SingleArcTransition)new TooManyFetchFailureTransition()).addTransition((Enum)TaskAttemptStateInternal.SUCCEEDED, EnumSet.of(TaskAttemptStateInternal.SUCCEEDED, TaskAttemptStateInternal.KILLED), (Enum)TaskAttemptEventType.TA_KILL, (MultipleArcTransition)new KilledAfterSuccessTransition()).addTransition((Enum)TaskAttemptStateInternal.SUCCEEDED, (Enum)TaskAttemptStateInternal.SUCCEEDED, (Enum)TaskAttemptEventType.TA_DIAGNOSTICS_UPDATE, (SingleArcTransition)DIAGNOSTIC_INFORMATION_UPDATE_TRANSITION).addTransition((Enum)TaskAttemptStateInternal.SUCCEEDED, (Enum)TaskAttemptStateInternal.SUCCEEDED, EnumSet.of(TaskAttemptEventType.TA_FAILMSG, TaskAttemptEventType.TA_CONTAINER_CLEANED, TaskAttemptEventType.TA_CONTAINER_COMPLETED)).addTransition((Enum)TaskAttemptStateInternal.FAILED, (Enum)TaskAttemptStateInternal.FAILED, (Enum)TaskAttemptEventType.TA_DIAGNOSTICS_UPDATE, (SingleArcTransition)DIAGNOSTIC_INFORMATION_UPDATE_TRANSITION).addTransition((Enum)TaskAttemptStateInternal.FAILED, (Enum)TaskAttemptStateInternal.FAILED, EnumSet.of(TaskAttemptEventType.TA_KILL, new TaskAttemptEventType[]{TaskAttemptEventType.TA_ASSIGNED, TaskAttemptEventType.TA_CONTAINER_COMPLETED, TaskAttemptEventType.TA_UPDATE, TaskAttemptEventType.TA_CONTAINER_LAUNCHED, TaskAttemptEventType.TA_CONTAINER_LAUNCH_FAILED, TaskAttemptEventType.TA_CONTAINER_CLEANED, TaskAttemptEventType.TA_COMMIT_PENDING, TaskAttemptEventType.TA_DONE, TaskAttemptEventType.TA_FAILMSG, TaskAttemptEventType.TA_TOO_MANY_FETCH_FAILURE})).addTransition((Enum)TaskAttemptStateInternal.KILLED, (Enum)TaskAttemptStateInternal.KILLED, (Enum)TaskAttemptEventType.TA_DIAGNOSTICS_UPDATE, (SingleArcTransition)DIAGNOSTIC_INFORMATION_UPDATE_TRANSITION).addTransition((Enum)TaskAttemptStateInternal.KILLED, (Enum)TaskAttemptStateInternal.KILLED, EnumSet.of(TaskAttemptEventType.TA_KILL, new TaskAttemptEventType[]{TaskAttemptEventType.TA_ASSIGNED, TaskAttemptEventType.TA_CONTAINER_COMPLETED, TaskAttemptEventType.TA_UPDATE, TaskAttemptEventType.TA_CONTAINER_LAUNCHED, TaskAttemptEventType.TA_CONTAINER_LAUNCH_FAILED, TaskAttemptEventType.TA_CONTAINER_CLEANED, TaskAttemptEventType.TA_COMMIT_PENDING, TaskAttemptEventType.TA_DONE, TaskAttemptEventType.TA_FAILMSG})).installTopology();
    private final StateMachine<TaskAttemptStateInternal, TaskAttemptEventType, TaskAttemptEvent> stateMachine;
    private ContainerId containerID;
    private NodeId containerNodeId;
    private String containerMgrAddress;
    private String nodeHttpAddress;
    private String nodeRackName;
    private WrappedJvmID jvmID;
    private ContainerToken containerToken;
    private Resource assignedCapability;
    private Task remoteTask;
    private TaskAttemptStatusUpdateEvent.TaskAttemptStatus reportedStatus;
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private static final Pattern ipPattern = Pattern.compile("\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}");

    public TaskAttemptImpl(TaskId taskId, int i, EventHandler eventHandler, TaskAttemptListener taskAttemptListener, Path jobFile, int partition, JobConf conf, String[] dataLocalHosts, Token<JobTokenIdentifier> jobToken, Credentials credentials, Clock clock, AppContext appContext) {
        this.oldJobId = TypeConverter.fromYarn((JobId)taskId.getJobId());
        this.conf = conf;
        this.clock = clock;
        this.attemptId = (TaskAttemptId)recordFactory.newRecordInstance(TaskAttemptId.class);
        this.attemptId.setTaskId(taskId);
        this.attemptId.setId(i);
        this.taskAttemptListener = taskAttemptListener;
        this.appContext = appContext;
        this.reportedStatus = new TaskAttemptStatusUpdateEvent.TaskAttemptStatus();
        this.initTaskAttemptStatus(this.reportedStatus);
        ReentrantReadWriteLock readWriteLock = new ReentrantReadWriteLock();
        this.readLock = readWriteLock.readLock();
        this.writeLock = readWriteLock.writeLock();
        this.credentials = credentials;
        this.jobToken = jobToken;
        this.eventHandler = eventHandler;
        this.jobFile = jobFile;
        this.partition = partition;
        this.resourceCapability = (Resource)recordFactory.newRecordInstance(Resource.class);
        this.resourceCapability.setMemory(this.getMemoryRequired((Configuration)conf, taskId.getTaskType()));
        this.resourceCapability.setVirtualCores(this.getCpuRequired((Configuration)conf, taskId.getTaskType()));
        this.dataLocalHosts = this.resolveHosts(dataLocalHosts);
        RackResolver.init((Configuration)conf);
        this.dataLocalRacks = new HashSet<String>();
        for (String host : this.dataLocalHosts) {
            this.dataLocalRacks.add(RackResolver.resolve((String)host).getNetworkLocation());
        }
        this.locality = Locality.OFF_SWITCH;
        this.avataar = Avataar.VIRGIN;
        this.stateMachine = stateMachineFactory.make((Object)this);
    }

    private int getMemoryRequired(Configuration conf, TaskType taskType) {
        int memory = 1024;
        if (taskType == TaskType.MAP) {
            memory = conf.getInt("mapreduce.map.memory.mb", 1024);
        } else if (taskType == TaskType.REDUCE) {
            memory = conf.getInt("mapreduce.reduce.memory.mb", 1024);
        }
        return memory;
    }

    private int getCpuRequired(Configuration conf, TaskType taskType) {
        int vcores = 1;
        if (taskType == TaskType.MAP) {
            vcores = conf.getInt("mapreduce.map.cpu.vcores", 1);
        } else if (taskType == TaskType.REDUCE) {
            vcores = conf.getInt("mapreduce.reduce.cpu.vcores", 1);
        }
        return vcores;
    }

    private static LocalResource createLocalResource(FileSystem fc, Path file, LocalResourceType type, LocalResourceVisibility visibility) throws IOException {
        FileStatus fstat = fc.getFileStatus(file);
        URL resourceURL = ConverterUtils.getYarnUrlFromPath((Path)fc.resolvePath(fstat.getPath()));
        long resourceSize = fstat.getLen();
        long resourceModificationTime = fstat.getModificationTime();
        return BuilderUtils.newLocalResource((URL)resourceURL, (LocalResourceType)type, (LocalResourceVisibility)visibility, (long)resourceSize, (long)resourceModificationTime);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getInitialClasspath(Configuration conf) throws IOException {
        Object object = classpathLock;
        synchronized (object) {
            if (initialClasspathFlag.get()) {
                return initialClasspath;
            }
            HashMap env = new HashMap();
            MRApps.setClasspath(env, (Configuration)conf);
            initialClasspath = (String)env.get(ApplicationConstants.Environment.CLASSPATH.name());
            initialAppClasspath = (String)env.get(ApplicationConstants.Environment.APP_CLASSPATH.name());
            initialClasspathFlag.set(true);
            return initialClasspath;
        }
    }

    private static ContainerLaunchContext createCommonContainerLaunchContext(Map<ApplicationAccessType, String> applicationACLs, Configuration conf, Token<JobTokenIdentifier> jobToken, JobID oldJobId, Credentials credentials) {
        HashMap<String, LocalResource> localResources = new HashMap<String, LocalResource>();
        HashMap<String, String> environment = new HashMap<String, String>();
        HashMap<String, ByteBuffer> serviceData = new HashMap<String, ByteBuffer>();
        ByteBuffer taskCredentialsBuffer = ByteBuffer.wrap(new byte[0]);
        try {
            FileSystem remoteFS = FileSystem.get((Configuration)conf);
            String jobJar = conf.get("mapreduce.job.jar");
            if (jobJar != null) {
                Path remoteJobJar = new Path(jobJar).makeQualified(remoteFS.getUri(), remoteFS.getWorkingDirectory());
                LocalResource rc = TaskAttemptImpl.createLocalResource(remoteFS, remoteJobJar, LocalResourceType.PATTERN, LocalResourceVisibility.APPLICATION);
                String pattern = conf.getPattern("mapreduce.job.jar.unpack.pattern", JobConf.UNPACK_JAR_PATTERN_DEFAULT).pattern();
                rc.setPattern(pattern);
                localResources.put("job.jar", rc);
                LOG.info((Object)("The job-jar file on the remote FS is " + remoteJobJar.toUri().toASCIIString()));
            } else {
                LOG.info((Object)"Job jar is not present. Not adding any jar to the list of resources.");
            }
            Path path = MRApps.getStagingAreaDir((Configuration)conf, (String)UserGroupInformation.getCurrentUser().getShortUserName());
            Path remoteJobSubmitDir = new Path(path, oldJobId.toString());
            Path remoteJobConfPath = new Path(remoteJobSubmitDir, "job.xml");
            localResources.put("job.xml", TaskAttemptImpl.createLocalResource(remoteFS, remoteJobConfPath, LocalResourceType.FILE, LocalResourceVisibility.APPLICATION));
            LOG.info((Object)("The job-conf file on the remote FS is " + remoteJobConfPath.toUri().toASCIIString()));
            MRApps.setupDistributedCache((Configuration)conf, localResources);
            LOG.info((Object)("Adding #" + credentials.numberOfTokens() + " tokens and #" + credentials.numberOfSecretKeys() + " secret keys for NM use for launching container"));
            Credentials taskCredentials = new Credentials(credentials);
            TokenCache.setJobToken(jobToken, (Credentials)taskCredentials);
            DataOutputBuffer containerTokens_dob = new DataOutputBuffer();
            LOG.info((Object)("Size of containertokens_dob is " + taskCredentials.numberOfTokens()));
            taskCredentials.writeTokenStorageToStream((DataOutputStream)containerTokens_dob);
            taskCredentialsBuffer = ByteBuffer.wrap(containerTokens_dob.getData(), 0, containerTokens_dob.getLength());
            LOG.info((Object)"Putting shuffle token in serviceData");
            serviceData.put("mapreduce.shuffle", ShuffleHandler.serializeServiceData(jobToken));
            Apps.addToEnvironment(environment, (String)ApplicationConstants.Environment.CLASSPATH.name(), (String)TaskAttemptImpl.getInitialClasspath(conf));
            if (initialAppClasspath != null) {
                Apps.addToEnvironment(environment, (String)ApplicationConstants.Environment.APP_CLASSPATH.name(), (String)initialAppClasspath);
            }
        }
        catch (IOException e) {
            throw new YarnException((Throwable)e);
        }
        environment.put(ApplicationConstants.Environment.SHELL.name(), conf.get("mapreduce.admin.user.shell", "/bin/bash"));
        Apps.addToEnvironment(environment, (String)ApplicationConstants.Environment.LD_LIBRARY_PATH.name(), (String)ApplicationConstants.Environment.PWD.$());
        Apps.setEnvFromInputString(environment, (String)conf.get("mapreduce.admin.user.env", "LD_LIBRARY_PATH=$HADOOP_COMMON_HOME/lib/native"));
        ContainerLaunchContext container = BuilderUtils.newContainerLaunchContext(null, (String)conf.get("mapreduce.job.user.name"), null, localResources, environment, null, serviceData, (ByteBuffer)taskCredentialsBuffer, applicationACLs);
        return container;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static ContainerLaunchContext createContainerLaunchContext(Map<ApplicationAccessType, String> applicationACLs, ContainerId containerID, Configuration conf, Token<JobTokenIdentifier> jobToken, Task remoteTask, JobID oldJobId, Resource assignedCapability, WrappedJvmID jvmID, TaskAttemptListener taskAttemptListener, Credentials credentials) {
        Object object = commonContainerSpecLock;
        synchronized (object) {
            if (commonContainerSpec == null) {
                commonContainerSpec = TaskAttemptImpl.createCommonContainerLaunchContext(applicationACLs, conf, jobToken, oldJobId, credentials);
            }
        }
        Map env = commonContainerSpec.getEnvironment();
        HashMap<String, String> myEnv = new HashMap<String, String>(env.size());
        myEnv.putAll(env);
        MapReduceChildJVM.setVMEnv(myEnv, remoteTask);
        List<String> commands = MapReduceChildJVM.getVMCommand(taskAttemptListener.getAddress(), remoteTask, (ID)jvmID);
        HashMap myServiceData = new HashMap();
        for (Map.Entry entry : commonContainerSpec.getServiceData().entrySet()) {
            myServiceData.put(entry.getKey(), ((ByteBuffer)entry.getValue()).duplicate());
        }
        ContainerLaunchContext container = BuilderUtils.newContainerLaunchContext((ContainerId)containerID, (String)commonContainerSpec.getUser(), (Resource)assignedCapability, (Map)commonContainerSpec.getLocalResources(), myEnv, commands, myServiceData, (ByteBuffer)commonContainerSpec.getContainerTokens().duplicate(), applicationACLs);
        return container;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ContainerId getAssignedContainerID() {
        this.readLock.lock();
        try {
            ContainerId containerId = this.containerID;
            return containerId;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getAssignedContainerMgrAddress() {
        this.readLock.lock();
        try {
            String string = this.containerMgrAddress;
            return string;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getLaunchTime() {
        this.readLock.lock();
        try {
            long l = this.launchTime;
            return l;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getFinishTime() {
        this.readLock.lock();
        try {
            long l = this.finishTime;
            return l;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getShuffleFinishTime() {
        this.readLock.lock();
        try {
            long l = this.reportedStatus.shuffleFinishTime;
            return l;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getSortFinishTime() {
        this.readLock.lock();
        try {
            long l = this.reportedStatus.sortFinishTime;
            return l;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getShufflePort() {
        this.readLock.lock();
        try {
            int n = this.shufflePort;
            return n;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NodeId getNodeId() {
        this.readLock.lock();
        try {
            NodeId nodeId = this.containerNodeId;
            return nodeId;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getNodeHttpAddress() {
        this.readLock.lock();
        try {
            String string = this.nodeHttpAddress;
            return string;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getNodeRackName() {
        this.readLock.lock();
        try {
            String string = this.nodeRackName;
            return string;
        }
        finally {
            this.readLock.unlock();
        }
    }

    protected abstract Task createRemoteTask();

    @Override
    public TaskAttemptId getID() {
        return this.attemptId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isFinished() {
        this.readLock.lock();
        try {
            boolean bl = this.getInternalState() == TaskAttemptStateInternal.SUCCEEDED || this.getInternalState() == TaskAttemptStateInternal.FAILED || this.getInternalState() == TaskAttemptStateInternal.KILLED;
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TaskAttemptReport getReport() {
        TaskAttemptReport result = (TaskAttemptReport)recordFactory.newRecordInstance(TaskAttemptReport.class);
        this.readLock.lock();
        try {
            result.setTaskAttemptId(this.attemptId);
            result.setTaskAttemptState(this.getState());
            result.setProgress(this.reportedStatus.progress);
            result.setStartTime(this.launchTime);
            result.setFinishTime(this.finishTime);
            result.setShuffleFinishTime(this.reportedStatus.shuffleFinishTime);
            result.setDiagnosticInfo(StringUtils.join((CharSequence)LINE_SEPARATOR, this.getDiagnostics()));
            result.setPhase(this.reportedStatus.phase);
            result.setStateString(this.reportedStatus.stateString);
            result.setCounters(TypeConverter.toYarn((Counters)this.getCounters()));
            result.setContainerId(this.getAssignedContainerID());
            result.setNodeManagerHost(this.trackerName);
            result.setNodeManagerHttpPort(this.httpPort);
            if (this.containerNodeId != null) {
                result.setNodeManagerPort(this.containerNodeId.getPort());
            }
            TaskAttemptReport taskAttemptReport = result;
            return taskAttemptReport;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getDiagnostics() {
        ArrayList<String> result = new ArrayList<String>();
        this.readLock.lock();
        try {
            result.addAll(this.diagnostics);
            ArrayList<String> arrayList = result;
            return arrayList;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Counters getCounters() {
        this.readLock.lock();
        try {
            Counters counters = this.reportedStatus.counters;
            if (counters == null) {
                counters = EMPTY_COUNTERS;
            }
            Counters counters2 = counters;
            return counters2;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public float getProgress() {
        this.readLock.lock();
        try {
            float f = this.reportedStatus.progress;
            return f;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TaskAttemptState getState() {
        this.readLock.lock();
        try {
            TaskAttemptState taskAttemptState = TaskAttemptImpl.getExternalState((TaskAttemptStateInternal)this.stateMachine.getCurrentState());
            return taskAttemptState;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handle(TaskAttemptEvent event) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Processing " + event.getTaskAttemptID() + " of type " + event.getType()));
        }
        this.writeLock.lock();
        try {
            TaskAttemptStateInternal oldState = this.getInternalState();
            try {
                this.stateMachine.doTransition(event.getType(), (Object)event);
            }
            catch (InvalidStateTransitonException e) {
                LOG.error((Object)("Can't handle this event at current state for " + this.attemptId), (Throwable)e);
                this.eventHandler.handle((Event)new JobDiagnosticsUpdateEvent(this.attemptId.getTaskId().getJobId(), "Invalid event " + event.getType() + " on TaskAttempt " + this.attemptId));
                this.eventHandler.handle((Event)new JobEvent(this.attemptId.getTaskId().getJobId(), JobEventType.INTERNAL_ERROR));
            }
            if (oldState != this.getInternalState()) {
                LOG.info((Object)(this.attemptId + " TaskAttempt Transitioned from " + (Object)((Object)oldState) + " to " + (Object)((Object)this.getInternalState())));
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    public TaskAttemptStateInternal getInternalState() {
        this.readLock.lock();
        try {
            TaskAttemptStateInternal taskAttemptStateInternal = (TaskAttemptStateInternal)this.stateMachine.getCurrentState();
            return taskAttemptStateInternal;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public Locality getLocality() {
        return this.locality;
    }

    public void setLocality(Locality locality) {
        this.locality = locality;
    }

    public Avataar getAvataar() {
        return this.avataar;
    }

    public void setAvataar(Avataar avataar) {
        this.avataar = avataar;
    }

    private static TaskAttemptState getExternalState(TaskAttemptStateInternal smState) {
        switch (smState) {
            case ASSIGNED: 
            case UNASSIGNED: {
                return TaskAttemptState.STARTING;
            }
            case COMMIT_PENDING: {
                return TaskAttemptState.COMMIT_PENDING;
            }
            case FAILED: {
                return TaskAttemptState.FAILED;
            }
            case KILLED: {
                return TaskAttemptState.KILLED;
            }
            case FAIL_CONTAINER_CLEANUP: 
            case FAIL_TASK_CLEANUP: 
            case KILL_CONTAINER_CLEANUP: 
            case KILL_TASK_CLEANUP: 
            case SUCCESS_CONTAINER_CLEANUP: 
            case RUNNING: {
                return TaskAttemptState.RUNNING;
            }
            case NEW: {
                return TaskAttemptState.NEW;
            }
            case SUCCEEDED: {
                return TaskAttemptState.SUCCEEDED;
            }
        }
        throw new YarnException("Attempt to convert invalid stateMachineTaskAttemptState to externalTaskAttemptState: " + (Object)((Object)smState));
    }

    private void setFinishTime() {
        if (this.launchTime != 0L) {
            this.finishTime = this.clock.getTime();
        }
    }

    private static long computeSlotMillis(TaskAttemptImpl taskAttempt) {
        TaskType taskType = taskAttempt.getID().getTaskId().getTaskType();
        int slotMemoryReq = taskAttempt.getMemoryRequired((Configuration)taskAttempt.conf, taskType);
        int minSlotMemSize = taskAttempt.appContext.getClusterInfo().getMinContainerCapability().getMemory();
        int simSlotsRequired = minSlotMemSize == 0 ? 0 : (int)Math.ceil((float)slotMemoryReq / (float)minSlotMemSize);
        long slotMillisIncrement = (long)simSlotsRequired * (taskAttempt.getFinishTime() - taskAttempt.getLaunchTime());
        return slotMillisIncrement;
    }

    private static JobCounterUpdateEvent createJobCounterUpdateEventTAFailed(TaskAttemptImpl taskAttempt, boolean taskAlreadyCompleted) {
        TaskType taskType = taskAttempt.getID().getTaskId().getTaskType();
        JobCounterUpdateEvent jce = new JobCounterUpdateEvent(taskAttempt.getID().getTaskId().getJobId());
        long slotMillisIncrement = TaskAttemptImpl.computeSlotMillis(taskAttempt);
        if (taskType == TaskType.MAP) {
            jce.addCounterUpdate((Enum<?>)JobCounter.NUM_FAILED_MAPS, 1L);
            if (!taskAlreadyCompleted) {
                jce.addCounterUpdate((Enum<?>)JobCounter.SLOTS_MILLIS_MAPS, slotMillisIncrement);
            }
        } else {
            jce.addCounterUpdate((Enum<?>)JobCounter.NUM_FAILED_REDUCES, 1L);
            if (!taskAlreadyCompleted) {
                jce.addCounterUpdate((Enum<?>)JobCounter.SLOTS_MILLIS_REDUCES, slotMillisIncrement);
            }
        }
        return jce;
    }

    private static JobCounterUpdateEvent createJobCounterUpdateEventTAKilled(TaskAttemptImpl taskAttempt, boolean taskAlreadyCompleted) {
        TaskType taskType = taskAttempt.getID().getTaskId().getTaskType();
        JobCounterUpdateEvent jce = new JobCounterUpdateEvent(taskAttempt.getID().getTaskId().getJobId());
        long slotMillisIncrement = TaskAttemptImpl.computeSlotMillis(taskAttempt);
        if (taskType == TaskType.MAP) {
            jce.addCounterUpdate((Enum<?>)JobCounter.NUM_KILLED_MAPS, 1L);
            if (!taskAlreadyCompleted) {
                jce.addCounterUpdate((Enum<?>)JobCounter.SLOTS_MILLIS_MAPS, slotMillisIncrement);
            }
        } else {
            jce.addCounterUpdate((Enum<?>)JobCounter.NUM_KILLED_REDUCES, 1L);
            if (!taskAlreadyCompleted) {
                jce.addCounterUpdate((Enum<?>)JobCounter.SLOTS_MILLIS_REDUCES, slotMillisIncrement);
            }
        }
        return jce;
    }

    private static TaskAttemptUnsuccessfulCompletionEvent createTaskAttemptUnsuccessfulCompletionEvent(TaskAttemptImpl taskAttempt, TaskAttemptStateInternal attemptState) {
        TaskAttemptUnsuccessfulCompletionEvent tauce = new TaskAttemptUnsuccessfulCompletionEvent((TaskAttemptID)TypeConverter.fromYarn((TaskAttemptId)taskAttempt.attemptId), TypeConverter.fromYarn((TaskType)taskAttempt.attemptId.getTaskId().getTaskType()), attemptState.toString(), taskAttempt.finishTime, taskAttempt.containerNodeId == null ? "UNKNOWN" : taskAttempt.containerNodeId.getHost(), taskAttempt.containerNodeId == null ? -1 : taskAttempt.containerNodeId.getPort(), taskAttempt.nodeRackName == null ? "UNKNOWN" : taskAttempt.nodeRackName, StringUtils.join((CharSequence)LINE_SEPARATOR, taskAttempt.getDiagnostics()), taskAttempt.getProgressSplitBlock().burst());
        return tauce;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private WrappedProgressSplitsBlock getProgressSplitBlock() {
        this.readLock.lock();
        try {
            if (this.progressSplitBlock == null) {
                this.progressSplitBlock = new WrappedProgressSplitsBlock(this.conf.getInt("yarn.app.mapreduce.am.num-progress-splits", 12));
            }
            WrappedProgressSplitsBlock wrappedProgressSplitsBlock = this.progressSplitBlock;
            return wrappedProgressSplitsBlock;
        }
        finally {
            this.readLock.unlock();
        }
    }

    private void updateProgressSplits() {
        double newProgress = this.reportedStatus.progress;
        newProgress = Math.max(Math.min(newProgress, 1.0), 0.0);
        Counters counters = this.reportedStatus.counters;
        if (counters == null) {
            return;
        }
        WrappedProgressSplitsBlock splitsBlock = this.getProgressSplitBlock();
        if (splitsBlock != null) {
            Counter physicalBytes;
            Counter virtualBytes;
            Counter cpuCounter;
            long now = this.clock.getTime();
            long start = this.getLaunchTime();
            if (start != 0L && now - start <= Integer.MAX_VALUE) {
                splitsBlock.getProgressWallclockTime().extend(newProgress, (int)(now - start));
            }
            if ((cpuCounter = counters.findCounter((Enum)TaskCounter.CPU_MILLISECONDS)) != null && cpuCounter.getValue() <= Integer.MAX_VALUE) {
                splitsBlock.getProgressCPUTime().extend(newProgress, (int)cpuCounter.getValue());
            }
            if ((virtualBytes = counters.findCounter((Enum)TaskCounter.VIRTUAL_MEMORY_BYTES)) != null) {
                splitsBlock.getProgressVirtualMemoryKbytes().extend(newProgress, (int)(virtualBytes.getValue() / 1024L));
            }
            if ((physicalBytes = counters.findCounter((Enum)TaskCounter.PHYSICAL_MEMORY_BYTES)) != null) {
                splitsBlock.getProgressPhysicalMemoryKbytes().extend(newProgress, (int)(physicalBytes.getValue() / 1024L));
            }
        }
    }

    protected Set<String> resolveHosts(String[] src) {
        HashSet<String> result = new HashSet<String>();
        if (src != null) {
            for (int i = 0; i < src.length; ++i) {
                if (src[i] == null) continue;
                if (this.isIP(src[i])) {
                    result.add(this.resolveHost(src[i]));
                    continue;
                }
                result.add(src[i]);
            }
        }
        return result;
    }

    protected String resolveHost(String src) {
        String result = src;
        try {
            InetAddress addr = InetAddress.getByName(src);
            result = addr.getHostName();
        }
        catch (UnknownHostException e) {
            LOG.warn((Object)("Failed to resolve address: " + src + ". Continuing to use the same."));
        }
        return result;
    }

    protected boolean isIP(String src) {
        return ipPattern.matcher(src).matches();
    }

    private void logAttemptFinishedEvent(TaskAttemptStateInternal state) {
        if (this.getLaunchTime() == 0L) {
            return;
        }
        if (this.attemptId.getTaskId().getTaskType() == TaskType.MAP) {
            MapAttemptFinishedEvent mfe = new MapAttemptFinishedEvent((TaskAttemptID)TypeConverter.fromYarn((TaskAttemptId)this.attemptId), TypeConverter.fromYarn((TaskType)this.attemptId.getTaskId().getTaskType()), state.toString(), this.reportedStatus.mapFinishTime, this.finishTime, this.containerNodeId == null ? "UNKNOWN" : this.containerNodeId.getHost(), this.containerNodeId == null ? -1 : this.containerNodeId.getPort(), this.nodeRackName == null ? "UNKNOWN" : this.nodeRackName, this.reportedStatus.stateString, this.getCounters(), this.getProgressSplitBlock().burst());
            this.eventHandler.handle((Event)new JobHistoryEvent(this.attemptId.getTaskId().getJobId(), (HistoryEvent)mfe));
        } else {
            ReduceAttemptFinishedEvent rfe = new ReduceAttemptFinishedEvent((TaskAttemptID)TypeConverter.fromYarn((TaskAttemptId)this.attemptId), TypeConverter.fromYarn((TaskType)this.attemptId.getTaskId().getTaskType()), state.toString(), this.reportedStatus.shuffleFinishTime, this.reportedStatus.sortFinishTime, this.finishTime, this.containerNodeId == null ? "UNKNOWN" : this.containerNodeId.getHost(), this.containerNodeId == null ? -1 : this.containerNodeId.getPort(), this.nodeRackName == null ? "UNKNOWN" : this.nodeRackName, this.reportedStatus.stateString, this.getCounters(), this.getProgressSplitBlock().burst());
            this.eventHandler.handle((Event)new JobHistoryEvent(this.attemptId.getTaskId().getJobId(), (HistoryEvent)rfe));
        }
    }

    private void addDiagnosticInfo(String diag) {
        if (diag != null && !diag.equals("")) {
            this.diagnostics.add(diag);
        }
    }

    private void initTaskAttemptStatus(TaskAttemptStatusUpdateEvent.TaskAttemptStatus result) {
        Counters counters;
        result.progress = 0.0f;
        result.phase = Phase.STARTING;
        result.stateString = "NEW";
        result.taskState = TaskAttemptState.NEW;
        result.counters = counters = EMPTY_COUNTERS;
    }

    private static class DiagnosticInformationUpdater
    implements SingleArcTransition<TaskAttemptImpl, TaskAttemptEvent> {
        private DiagnosticInformationUpdater() {
        }

        public void transition(TaskAttemptImpl taskAttempt, TaskAttemptEvent event) {
            TaskAttemptDiagnosticsUpdateEvent diagEvent = (TaskAttemptDiagnosticsUpdateEvent)event;
            LOG.info((Object)("Diagnostics report from " + taskAttempt.attemptId + ": " + diagEvent.getDiagnosticInfo()));
            taskAttempt.addDiagnosticInfo(diagEvent.getDiagnosticInfo());
        }
    }

    private static class StatusUpdater
    implements SingleArcTransition<TaskAttemptImpl, TaskAttemptEvent> {
        private StatusUpdater() {
        }

        public void transition(TaskAttemptImpl taskAttempt, TaskAttemptEvent event) {
            TaskAttemptStatusUpdateEvent.TaskAttemptStatus newReportedStatus = ((TaskAttemptStatusUpdateEvent)event).getReportedTaskAttemptStatus();
            taskAttempt.reportedStatus = newReportedStatus;
            ((TaskAttemptImpl)taskAttempt).reportedStatus.taskState = taskAttempt.getState();
            taskAttempt.eventHandler.handle((Event)new SpeculatorEvent(taskAttempt.reportedStatus, taskAttempt.clock.getTime()));
            taskAttempt.updateProgressSplits();
            if (((TaskAttemptImpl)taskAttempt).reportedStatus.fetchFailedMaps != null && ((TaskAttemptImpl)taskAttempt).reportedStatus.fetchFailedMaps.size() > 0) {
                taskAttempt.eventHandler.handle((Event)new JobTaskAttemptFetchFailureEvent(taskAttempt.attemptId, ((TaskAttemptImpl)taskAttempt).reportedStatus.fetchFailedMaps));
            }
        }
    }

    private static class CleanupContainerTransition
    implements SingleArcTransition<TaskAttemptImpl, TaskAttemptEvent> {
        private CleanupContainerTransition() {
        }

        public void transition(TaskAttemptImpl taskAttempt, TaskAttemptEvent event) {
            taskAttempt.taskAttemptListener.unregister(taskAttempt.attemptId, taskAttempt.jvmID);
            ((TaskAttemptImpl)taskAttempt).reportedStatus.progress = 1.0f;
            taskAttempt.updateProgressSplits();
            taskAttempt.eventHandler.handle((Event)new ContainerLauncherEvent(taskAttempt.attemptId, taskAttempt.containerID, taskAttempt.containerMgrAddress, taskAttempt.containerToken, ContainerLauncher.EventType.CONTAINER_REMOTE_CLEANUP));
        }
    }

    private static class KilledTransition
    implements SingleArcTransition<TaskAttemptImpl, TaskAttemptEvent> {
        private KilledTransition() {
        }

        public void transition(TaskAttemptImpl taskAttempt, TaskAttemptEvent event) {
            taskAttempt.setFinishTime();
            if (taskAttempt.getLaunchTime() != 0L) {
                taskAttempt.eventHandler.handle((Event)TaskAttemptImpl.createJobCounterUpdateEventTAKilled(taskAttempt, false));
                TaskAttemptUnsuccessfulCompletionEvent tauce = TaskAttemptImpl.createTaskAttemptUnsuccessfulCompletionEvent(taskAttempt, TaskAttemptStateInternal.KILLED);
                taskAttempt.eventHandler.handle((Event)new JobHistoryEvent(taskAttempt.attemptId.getTaskId().getJobId(), (HistoryEvent)tauce));
            } else {
                LOG.debug((Object)("Not generating HistoryFinish event since start event not generated for taskAttempt: " + taskAttempt.getID()));
            }
            taskAttempt.eventHandler.handle((Event)new TaskTAttemptEvent(taskAttempt.attemptId, TaskEventType.T_ATTEMPT_KILLED));
        }
    }

    private static class KilledAfterSuccessTransition
    implements MultipleArcTransition<TaskAttemptImpl, TaskAttemptEvent, TaskAttemptStateInternal> {
        private KilledAfterSuccessTransition() {
        }

        public TaskAttemptStateInternal transition(TaskAttemptImpl taskAttempt, TaskAttemptEvent event) {
            if (taskAttempt.getID().getTaskId().getTaskType() == TaskType.REDUCE) {
                LOG.info((Object)("Ignoring killed event for successful reduce task attempt" + taskAttempt.getID().toString()));
                return TaskAttemptStateInternal.SUCCEEDED;
            }
            if (event instanceof TaskAttemptKillEvent) {
                TaskAttemptKillEvent msgEvent = (TaskAttemptKillEvent)event;
                taskAttempt.addDiagnosticInfo(msgEvent.getMessage());
            }
            assert (taskAttempt.getFinishTime() != 0L);
            assert (taskAttempt.getLaunchTime() != 0L);
            taskAttempt.eventHandler.handle((Event)TaskAttemptImpl.createJobCounterUpdateEventTAKilled(taskAttempt, true));
            TaskAttemptUnsuccessfulCompletionEvent tauce = TaskAttemptImpl.createTaskAttemptUnsuccessfulCompletionEvent(taskAttempt, TaskAttemptStateInternal.KILLED);
            taskAttempt.eventHandler.handle((Event)new JobHistoryEvent(taskAttempt.attemptId.getTaskId().getJobId(), (HistoryEvent)tauce));
            taskAttempt.eventHandler.handle((Event)new TaskTAttemptEvent(taskAttempt.attemptId, TaskEventType.T_ATTEMPT_KILLED));
            return TaskAttemptStateInternal.KILLED;
        }
    }

    private static class TooManyFetchFailureTransition
    implements SingleArcTransition<TaskAttemptImpl, TaskAttemptEvent> {
        private TooManyFetchFailureTransition() {
        }

        public void transition(TaskAttemptImpl taskAttempt, TaskAttemptEvent event) {
            Preconditions.checkArgument((taskAttempt.getID().getTaskId().getTaskType() == TaskType.MAP ? 1 : 0) != 0);
            taskAttempt.addDiagnosticInfo("Too Many fetch failures.Failing the attempt");
            taskAttempt.setFinishTime();
            if (taskAttempt.getLaunchTime() != 0L) {
                taskAttempt.eventHandler.handle((Event)TaskAttemptImpl.createJobCounterUpdateEventTAFailed(taskAttempt, true));
                TaskAttemptUnsuccessfulCompletionEvent tauce = TaskAttemptImpl.createTaskAttemptUnsuccessfulCompletionEvent(taskAttempt, TaskAttemptStateInternal.FAILED);
                taskAttempt.eventHandler.handle((Event)new JobHistoryEvent(taskAttempt.attemptId.getTaskId().getJobId(), (HistoryEvent)tauce));
            } else {
                LOG.debug((Object)("Not generating HistoryFinish event since start event not generated for taskAttempt: " + taskAttempt.getID()));
            }
            taskAttempt.eventHandler.handle((Event)new TaskTAttemptEvent(taskAttempt.attemptId, TaskEventType.T_ATTEMPT_FAILED));
        }
    }

    private static class FailedTransition
    implements SingleArcTransition<TaskAttemptImpl, TaskAttemptEvent> {
        private FailedTransition() {
        }

        public void transition(TaskAttemptImpl taskAttempt, TaskAttemptEvent event) {
            taskAttempt.setFinishTime();
            if (taskAttempt.getLaunchTime() != 0L) {
                taskAttempt.eventHandler.handle((Event)TaskAttemptImpl.createJobCounterUpdateEventTAFailed(taskAttempt, false));
                TaskAttemptUnsuccessfulCompletionEvent tauce = TaskAttemptImpl.createTaskAttemptUnsuccessfulCompletionEvent(taskAttempt, TaskAttemptStateInternal.FAILED);
                taskAttempt.eventHandler.handle((Event)new JobHistoryEvent(taskAttempt.attemptId.getTaskId().getJobId(), (HistoryEvent)tauce));
            } else {
                LOG.debug((Object)("Not generating HistoryFinish event since start event not generated for taskAttempt: " + taskAttempt.getID()));
            }
            taskAttempt.eventHandler.handle((Event)new TaskTAttemptEvent(taskAttempt.attemptId, TaskEventType.T_ATTEMPT_FAILED));
        }
    }

    private static class SucceededTransition
    implements SingleArcTransition<TaskAttemptImpl, TaskAttemptEvent> {
        private SucceededTransition() {
        }

        public void transition(TaskAttemptImpl taskAttempt, TaskAttemptEvent event) {
            taskAttempt.setFinishTime();
            long slotMillis = TaskAttemptImpl.computeSlotMillis(taskAttempt);
            TaskId taskId = taskAttempt.attemptId.getTaskId();
            JobCounterUpdateEvent jce = new JobCounterUpdateEvent(taskId.getJobId());
            jce.addCounterUpdate((Enum<?>)(taskId.getTaskType() == TaskType.MAP ? JobCounter.SLOTS_MILLIS_MAPS : JobCounter.SLOTS_MILLIS_REDUCES), slotMillis);
            taskAttempt.eventHandler.handle((Event)jce);
            taskAttempt.logAttemptFinishedEvent(TaskAttemptStateInternal.SUCCEEDED);
            taskAttempt.eventHandler.handle((Event)new TaskTAttemptEvent(taskAttempt.attemptId, TaskEventType.T_ATTEMPT_SUCCEEDED));
            taskAttempt.eventHandler.handle((Event)new SpeculatorEvent(taskAttempt.reportedStatus, taskAttempt.clock.getTime()));
        }
    }

    private static class TaskCleanupTransition
    implements SingleArcTransition<TaskAttemptImpl, TaskAttemptEvent> {
        private TaskCleanupTransition() {
        }

        public void transition(TaskAttemptImpl taskAttempt, TaskAttemptEvent event) {
            TaskAttemptContextImpl taskContext = new TaskAttemptContextImpl(taskAttempt.conf, TypeConverter.fromYarn((TaskAttemptId)taskAttempt.attemptId));
            taskAttempt.eventHandler.handle((Event)new CommitterTaskAbortEvent(taskAttempt.attemptId, (TaskAttemptContext)taskContext));
        }
    }

    private static class CommitPendingTransition
    implements SingleArcTransition<TaskAttemptImpl, TaskAttemptEvent> {
        private CommitPendingTransition() {
        }

        public void transition(TaskAttemptImpl taskAttempt, TaskAttemptEvent event) {
            taskAttempt.eventHandler.handle((Event)new TaskTAttemptEvent(taskAttempt.attemptId, TaskEventType.T_ATTEMPT_COMMIT_PENDING));
        }
    }

    private static class LaunchedContainerTransition
    implements SingleArcTransition<TaskAttemptImpl, TaskAttemptEvent> {
        private LaunchedContainerTransition() {
        }

        public void transition(TaskAttemptImpl taskAttempt, TaskAttemptEvent evnt) {
            TaskAttemptContainerLaunchedEvent event = (TaskAttemptContainerLaunchedEvent)evnt;
            taskAttempt.launchTime = taskAttempt.clock.getTime();
            taskAttempt.shufflePort = event.getShufflePort();
            taskAttempt.taskAttemptListener.registerLaunchedTask(taskAttempt.attemptId, taskAttempt.jvmID);
            InetSocketAddress nodeHttpInetAddr = NetUtils.createSocketAddr((String)taskAttempt.nodeHttpAddress);
            taskAttempt.trackerName = nodeHttpInetAddr.getHostName();
            taskAttempt.httpPort = nodeHttpInetAddr.getPort();
            JobCounterUpdateEvent jce = new JobCounterUpdateEvent(taskAttempt.attemptId.getTaskId().getJobId());
            jce.addCounterUpdate((Enum<?>)(taskAttempt.attemptId.getTaskId().getTaskType() == TaskType.MAP ? JobCounter.TOTAL_LAUNCHED_MAPS : JobCounter.TOTAL_LAUNCHED_REDUCES), 1L);
            taskAttempt.eventHandler.handle((Event)jce);
            LOG.info((Object)("TaskAttempt: [" + taskAttempt.attemptId + "] using containerId: [" + taskAttempt.containerID + " on NM: [" + taskAttempt.containerMgrAddress + "]"));
            TaskAttemptStartedEvent tase = new TaskAttemptStartedEvent((TaskAttemptID)TypeConverter.fromYarn((TaskAttemptId)taskAttempt.attemptId), TypeConverter.fromYarn((TaskType)taskAttempt.attemptId.getTaskId().getTaskType()), taskAttempt.launchTime, nodeHttpInetAddr.getHostName(), nodeHttpInetAddr.getPort(), taskAttempt.shufflePort, taskAttempt.containerID, taskAttempt.locality.toString(), taskAttempt.avataar.toString());
            taskAttempt.eventHandler.handle((Event)new JobHistoryEvent(taskAttempt.attemptId.getTaskId().getJobId(), (HistoryEvent)tase));
            taskAttempt.eventHandler.handle((Event)new SpeculatorEvent(taskAttempt.attemptId, true, taskAttempt.clock.getTime()));
            taskAttempt.remoteTask = null;
            taskAttempt.eventHandler.handle((Event)new TaskTAttemptEvent(taskAttempt.attemptId, TaskEventType.T_ATTEMPT_LAUNCHED));
        }
    }

    private static class DeallocateContainerTransition
    implements SingleArcTransition<TaskAttemptImpl, TaskAttemptEvent> {
        private final TaskAttemptStateInternal finalState;
        private final boolean withdrawsContainerRequest;

        DeallocateContainerTransition(TaskAttemptStateInternal finalState, boolean withdrawsContainerRequest) {
            this.finalState = finalState;
            this.withdrawsContainerRequest = withdrawsContainerRequest;
        }

        public void transition(TaskAttemptImpl taskAttempt, TaskAttemptEvent event) {
            taskAttempt.setFinishTime();
            taskAttempt.eventHandler.handle((Event)new ContainerAllocatorEvent(taskAttempt.attemptId, ContainerAllocator.EventType.CONTAINER_DEALLOCATE));
            if (this.withdrawsContainerRequest) {
                taskAttempt.eventHandler.handle((Event)new SpeculatorEvent(taskAttempt.getID().getTaskId(), -1));
            }
            switch (this.finalState) {
                case FAILED: {
                    taskAttempt.eventHandler.handle((Event)new TaskTAttemptEvent(taskAttempt.attemptId, TaskEventType.T_ATTEMPT_FAILED));
                    break;
                }
                case KILLED: {
                    taskAttempt.eventHandler.handle((Event)new TaskTAttemptEvent(taskAttempt.attemptId, TaskEventType.T_ATTEMPT_KILLED));
                    break;
                }
                default: {
                    LOG.error((Object)("Task final state is not FAILED or KILLED: " + (Object)((Object)this.finalState)));
                }
            }
            if (taskAttempt.getLaunchTime() != 0L) {
                TaskAttemptUnsuccessfulCompletionEvent tauce = TaskAttemptImpl.createTaskAttemptUnsuccessfulCompletionEvent(taskAttempt, this.finalState);
                if (this.finalState == TaskAttemptStateInternal.FAILED) {
                    taskAttempt.eventHandler.handle((Event)TaskAttemptImpl.createJobCounterUpdateEventTAFailed(taskAttempt, false));
                } else if (this.finalState == TaskAttemptStateInternal.KILLED) {
                    taskAttempt.eventHandler.handle((Event)TaskAttemptImpl.createJobCounterUpdateEventTAKilled(taskAttempt, false));
                }
                taskAttempt.eventHandler.handle((Event)new JobHistoryEvent(taskAttempt.attemptId.getTaskId().getJobId(), (HistoryEvent)tauce));
            } else {
                LOG.debug((Object)("Not generating HistoryFinish event since start event not generated for taskAttempt: " + taskAttempt.getID()));
            }
        }
    }

    private static class ContainerAssignedTransition
    implements SingleArcTransition<TaskAttemptImpl, TaskAttemptEvent> {
        private ContainerAssignedTransition() {
        }

        public void transition(TaskAttemptImpl taskAttempt, TaskAttemptEvent event) {
            String cHost;
            TaskAttemptContainerAssignedEvent cEvent = (TaskAttemptContainerAssignedEvent)event;
            taskAttempt.containerID = cEvent.getContainer().getId();
            taskAttempt.containerNodeId = cEvent.getContainer().getNodeId();
            taskAttempt.containerMgrAddress = StringInterner.weakIntern((String)taskAttempt.containerNodeId.toString());
            taskAttempt.nodeHttpAddress = StringInterner.weakIntern((String)cEvent.getContainer().getNodeHttpAddress());
            taskAttempt.nodeRackName = RackResolver.resolve((String)taskAttempt.containerNodeId.getHost()).getNetworkLocation();
            taskAttempt.containerToken = cEvent.getContainer().getContainerToken();
            taskAttempt.assignedCapability = cEvent.getContainer().getResource();
            taskAttempt.remoteTask = taskAttempt.createRemoteTask();
            taskAttempt.jvmID = new WrappedJvmID(taskAttempt.remoteTask.getTaskID().getJobID(), taskAttempt.remoteTask.isMapTask(), taskAttempt.containerID.getId());
            taskAttempt.taskAttemptListener.registerPendingTask(taskAttempt.remoteTask, taskAttempt.jvmID);
            taskAttempt.locality = Locality.OFF_SWITCH;
            if (taskAttempt.dataLocalHosts.size() > 0 && taskAttempt.dataLocalHosts.contains(cHost = taskAttempt.resolveHost(taskAttempt.containerNodeId.getHost()))) {
                taskAttempt.locality = Locality.NODE_LOCAL;
            }
            if (taskAttempt.locality == Locality.OFF_SWITCH && taskAttempt.dataLocalRacks.contains(taskAttempt.nodeRackName)) {
                taskAttempt.locality = Locality.RACK_LOCAL;
            }
            ContainerLaunchContext launchContext = TaskAttemptImpl.createContainerLaunchContext(cEvent.getApplicationACLs(), taskAttempt.containerID, (Configuration)taskAttempt.conf, (Token<JobTokenIdentifier>)taskAttempt.jobToken, taskAttempt.remoteTask, taskAttempt.oldJobId, taskAttempt.assignedCapability, taskAttempt.jvmID, taskAttempt.taskAttemptListener, taskAttempt.credentials);
            taskAttempt.eventHandler.handle((Event)new ContainerRemoteLaunchEvent(taskAttempt.attemptId, taskAttempt.containerID, taskAttempt.containerMgrAddress, taskAttempt.containerToken, launchContext, taskAttempt.remoteTask));
            taskAttempt.eventHandler.handle((Event)new SpeculatorEvent(taskAttempt.getID().getTaskId(), -1));
        }
    }

    static class RequestContainerTransition
    implements SingleArcTransition<TaskAttemptImpl, TaskAttemptEvent> {
        private final boolean rescheduled;

        public RequestContainerTransition(boolean rescheduled) {
            this.rescheduled = rescheduled;
        }

        public void transition(TaskAttemptImpl taskAttempt, TaskAttemptEvent event) {
            taskAttempt.eventHandler.handle((Event)new SpeculatorEvent(taskAttempt.getID().getTaskId(), 1));
            if (this.rescheduled) {
                taskAttempt.eventHandler.handle((Event)ContainerRequestEvent.createContainerRequestEventForFailedContainer(taskAttempt.attemptId, taskAttempt.resourceCapability));
            } else {
                taskAttempt.eventHandler.handle((Event)new ContainerRequestEvent(taskAttempt.attemptId, taskAttempt.resourceCapability, taskAttempt.dataLocalHosts.toArray(new String[taskAttempt.dataLocalHosts.size()]), taskAttempt.dataLocalRacks.toArray(new String[taskAttempt.dataLocalRacks.size()])));
            }
        }
    }
}

