/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.v2.app.launcher;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.security.PrivilegedAction;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapred.ShuffleHandler;
import org.apache.hadoop.mapreduce.v2.api.records.TaskAttemptId;
import org.apache.hadoop.mapreduce.v2.app.AppContext;
import org.apache.hadoop.mapreduce.v2.app.job.event.TaskAttemptContainerLaunchedEvent;
import org.apache.hadoop.mapreduce.v2.app.job.event.TaskAttemptDiagnosticsUpdateEvent;
import org.apache.hadoop.mapreduce.v2.app.job.event.TaskAttemptEvent;
import org.apache.hadoop.mapreduce.v2.app.job.event.TaskAttemptEventType;
import org.apache.hadoop.mapreduce.v2.app.launcher.ContainerLauncher;
import org.apache.hadoop.mapreduce.v2.app.launcher.ContainerLauncherEvent;
import org.apache.hadoop.mapreduce.v2.app.launcher.ContainerRemoteLaunchEvent;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.yarn.YarnException;
import org.apache.hadoop.yarn.api.ContainerManager;
import org.apache.hadoop.yarn.api.protocolrecords.StartContainerRequest;
import org.apache.hadoop.yarn.api.protocolrecords.StartContainerResponse;
import org.apache.hadoop.yarn.api.protocolrecords.StopContainerRequest;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ContainerLaunchContext;
import org.apache.hadoop.yarn.api.records.ContainerToken;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.ipc.YarnRPC;
import org.apache.hadoop.yarn.service.AbstractService;
import org.apache.hadoop.yarn.util.ProtoUtils;
import org.apache.hadoop.yarn.util.Records;

public class ContainerLauncherImpl
extends AbstractService
implements ContainerLauncher {
    static final Log LOG = LogFactory.getLog(ContainerLauncherImpl.class);
    private ConcurrentHashMap<ContainerId, Container> containers = new ConcurrentHashMap();
    private AppContext context;
    protected ThreadPoolExecutor launcherPool;
    protected static final int INITIAL_POOL_SIZE = 10;
    private int limitOnPoolSize;
    private Thread eventHandlingThread;
    protected BlockingQueue<ContainerLauncherEvent> eventQueue = new LinkedBlockingQueue<ContainerLauncherEvent>();
    YarnRPC rpc;
    private final AtomicBoolean stopped;
    Set<String> allNodes = new HashSet<String>();

    private Container getContainer(ContainerLauncherEvent event) {
        Container old;
        ContainerId id = event.getContainerID();
        Container c = this.containers.get(id);
        if (c == null && (old = this.containers.putIfAbsent(id, c = new Container(event.getTaskAttemptID(), event.getContainerID(), event.getContainerMgrAddress(), event.getContainerToken()))) != null) {
            c = old;
        }
        return c;
    }

    private void removeContainerIfDone(ContainerId id) {
        Container c = this.containers.get(id);
        if (c != null && c.isCompletelyDone()) {
            this.containers.remove(id);
        }
    }

    public ContainerLauncherImpl(AppContext context) {
        super(ContainerLauncherImpl.class.getName());
        this.context = context;
        this.stopped = new AtomicBoolean(false);
    }

    public synchronized void init(Configuration config) {
        Configuration conf = new Configuration(config);
        conf.setInt("ipc.client.connection.maxidletime", 0);
        this.limitOnPoolSize = conf.getInt("yarn.app.mapreduce.am.containerlauncher.thread-count-limit", 500);
        LOG.info((Object)("Upper limit on the thread pool size is " + this.limitOnPoolSize));
        this.rpc = this.createYarnRPC(conf);
        super.init(conf);
    }

    protected YarnRPC createYarnRPC(Configuration conf) {
        return YarnRPC.create((Configuration)conf);
    }

    public void start() {
        ThreadFactory tf = new ThreadFactoryBuilder().setNameFormat("ContainerLauncher #%d").setDaemon(true).build();
        this.launcherPool = new ThreadPoolExecutor(10, Integer.MAX_VALUE, 1L, TimeUnit.HOURS, new LinkedBlockingQueue<Runnable>(), tf);
        this.eventHandlingThread = new Thread(){

            @Override
            public void run() {
                ContainerLauncherEvent event = null;
                while (!ContainerLauncherImpl.this.stopped.get() && !Thread.currentThread().isInterrupted()) {
                    try {
                        event = ContainerLauncherImpl.this.eventQueue.take();
                    }
                    catch (InterruptedException e) {
                        if (!ContainerLauncherImpl.this.stopped.get()) {
                            LOG.error((Object)("Returning, interrupted : " + e));
                        }
                        return;
                    }
                    int poolSize = ContainerLauncherImpl.this.launcherPool.getCorePoolSize();
                    if (poolSize != ContainerLauncherImpl.this.limitOnPoolSize) {
                        int numNodes = ContainerLauncherImpl.this.allNodes.size();
                        int idealPoolSize = Math.min(ContainerLauncherImpl.this.limitOnPoolSize, numNodes);
                        if (poolSize < idealPoolSize) {
                            int newPoolSize = Math.min(ContainerLauncherImpl.this.limitOnPoolSize, idealPoolSize + 10);
                            LOG.info((Object)("Setting ContainerLauncher pool size to " + newPoolSize + " as number-of-nodes to talk to is " + numNodes));
                            ContainerLauncherImpl.this.launcherPool.setCorePoolSize(newPoolSize);
                        }
                    }
                    ContainerLauncherImpl.this.launcherPool.execute(ContainerLauncherImpl.this.createEventProcessor(event));
                }
            }
        };
        this.eventHandlingThread.setName("ContainerLauncher Event Handler");
        this.eventHandlingThread.start();
        super.start();
    }

    private void shutdownAllContainers() {
        for (Container ct : this.containers.values()) {
            if (ct == null) continue;
            ct.kill();
        }
    }

    public void stop() {
        if (this.stopped.getAndSet(true)) {
            return;
        }
        this.shutdownAllContainers();
        this.eventHandlingThread.interrupt();
        this.launcherPool.shutdownNow();
        super.stop();
    }

    protected EventProcessor createEventProcessor(ContainerLauncherEvent event) {
        return new EventProcessor(event);
    }

    protected ContainerManager getCMProxy(ContainerId containerID, String containerManagerBindAddr, ContainerToken containerToken) throws IOException {
        final InetSocketAddress cmAddr = NetUtils.createSocketAddr((String)containerManagerBindAddr);
        UserGroupInformation user = UserGroupInformation.getCurrentUser();
        if (UserGroupInformation.isSecurityEnabled()) {
            Token token = ProtoUtils.convertFromProtoFormat((org.apache.hadoop.yarn.api.records.Token)containerToken, (InetSocketAddress)cmAddr);
            user = UserGroupInformation.createRemoteUser((String)containerID.toString());
            user.addToken(token);
        }
        ContainerManager proxy = (ContainerManager)user.doAs((PrivilegedAction)new PrivilegedAction<ContainerManager>(){

            @Override
            public ContainerManager run() {
                return (ContainerManager)ContainerLauncherImpl.this.rpc.getProxy(ContainerManager.class, cmAddr, ContainerLauncherImpl.this.getConfig());
            }
        });
        return proxy;
    }

    void sendContainerLaunchFailedMsg(TaskAttemptId taskAttemptID, String message) {
        LOG.error((Object)message);
        this.context.getEventHandler().handle((Event)new TaskAttemptDiagnosticsUpdateEvent(taskAttemptID, message));
        this.context.getEventHandler().handle((Event)new TaskAttemptEvent(taskAttemptID, TaskAttemptEventType.TA_CONTAINER_LAUNCH_FAILED));
    }

    public void handle(ContainerLauncherEvent event) {
        try {
            this.eventQueue.put(event);
            this.allNodes.add(event.getContainerMgrAddress());
        }
        catch (InterruptedException e) {
            throw new YarnException((Throwable)e);
        }
    }

    class EventProcessor
    implements Runnable {
        private ContainerLauncherEvent event;

        EventProcessor(ContainerLauncherEvent event) {
            this.event = event;
        }

        @Override
        public void run() {
            LOG.info((Object)("Processing the event " + this.event.toString()));
            ContainerId containerID = this.event.getContainerID();
            Container c = ContainerLauncherImpl.this.getContainer(this.event);
            switch ((ContainerLauncher.EventType)this.event.getType()) {
                case CONTAINER_REMOTE_LAUNCH: {
                    ContainerRemoteLaunchEvent launchEvent = (ContainerRemoteLaunchEvent)this.event;
                    c.launch(launchEvent);
                    break;
                }
                case CONTAINER_REMOTE_CLEANUP: {
                    c.kill();
                }
            }
            ContainerLauncherImpl.this.removeContainerIfDone(containerID);
        }
    }

    private class Container {
        private ContainerState state = ContainerState.PREP;
        private TaskAttemptId taskAttemptID;
        private ContainerId containerID;
        private final String containerMgrAddress;
        private ContainerToken containerToken;

        public Container(TaskAttemptId taId, ContainerId containerID, String containerMgrAddress, ContainerToken containerToken) {
            this.taskAttemptID = taId;
            this.containerMgrAddress = containerMgrAddress;
            this.containerID = containerID;
            this.containerToken = containerToken;
        }

        public synchronized boolean isCompletelyDone() {
            return this.state == ContainerState.DONE || this.state == ContainerState.FAILED;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void launch(ContainerRemoteLaunchEvent event) {
            LOG.info((Object)("Launching " + this.taskAttemptID));
            if (this.state == ContainerState.KILLED_BEFORE_LAUNCH) {
                this.state = ContainerState.DONE;
                ContainerLauncherImpl.this.sendContainerLaunchFailedMsg(this.taskAttemptID, "Container was killed before it was launched");
                return;
            }
            ContainerManager proxy = null;
            try {
                proxy = ContainerLauncherImpl.this.getCMProxy(this.containerID, this.containerMgrAddress, this.containerToken);
                ContainerLaunchContext containerLaunchContext = event.getContainer();
                StartContainerRequest startRequest = (StartContainerRequest)Records.newRecord(StartContainerRequest.class);
                startRequest.setContainerLaunchContext(containerLaunchContext);
                StartContainerResponse response = proxy.startContainer(startRequest);
                ByteBuffer portInfo = response.getServiceResponse("mapreduce.shuffle");
                int port = -1;
                if (portInfo != null) {
                    port = ShuffleHandler.deserializeMetaData((ByteBuffer)portInfo);
                }
                LOG.info((Object)("Shuffle port returned by ContainerManager for " + this.taskAttemptID + " : " + port));
                if (port < 0) {
                    this.state = ContainerState.FAILED;
                    throw new IllegalStateException("Invalid shuffle port number " + port + " returned for " + this.taskAttemptID);
                }
                ContainerLauncherImpl.this.context.getEventHandler().handle((Event)new TaskAttemptContainerLaunchedEvent(this.taskAttemptID, port));
                this.state = ContainerState.RUNNING;
            }
            catch (Throwable t) {
                String message = "Container launch failed for " + this.containerID + " : " + StringUtils.stringifyException((Throwable)t);
                this.state = ContainerState.FAILED;
                ContainerLauncherImpl.this.sendContainerLaunchFailedMsg(this.taskAttemptID, message);
            }
            finally {
                if (proxy != null) {
                    ContainerLauncherImpl.this.rpc.stopProxy((Object)proxy, ContainerLauncherImpl.this.getConfig());
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void kill() {
            if (this.state == ContainerState.PREP) {
                this.state = ContainerState.KILLED_BEFORE_LAUNCH;
            } else if (!this.isCompletelyDone()) {
                LOG.info((Object)("KILLING " + this.taskAttemptID));
                ContainerManager proxy = null;
                try {
                    proxy = ContainerLauncherImpl.this.getCMProxy(this.containerID, this.containerMgrAddress, this.containerToken);
                    StopContainerRequest stopRequest = (StopContainerRequest)Records.newRecord(StopContainerRequest.class);
                    stopRequest.setContainerId(this.containerID);
                    proxy.stopContainer(stopRequest);
                }
                catch (Throwable t) {
                    String message = "cleanup failed for container " + this.containerID + " : " + StringUtils.stringifyException((Throwable)t);
                    ContainerLauncherImpl.this.context.getEventHandler().handle((Event)new TaskAttemptDiagnosticsUpdateEvent(this.taskAttemptID, message));
                    LOG.warn((Object)message);
                }
                finally {
                    if (proxy != null) {
                        ContainerLauncherImpl.this.rpc.stopProxy((Object)proxy, ContainerLauncherImpl.this.getConfig());
                    }
                }
                this.state = ContainerState.DONE;
            }
            ContainerLauncherImpl.this.context.getEventHandler().handle((Event)new TaskAttemptEvent(this.taskAttemptID, TaskAttemptEventType.TA_CONTAINER_CLEANED));
        }
    }

    private static enum ContainerState {
        PREP,
        FAILED,
        RUNNING,
        DONE,
        KILLED_BEFORE_LAUNCH;

    }
}

