/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.jobhistory;

import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileAlreadyExistsException;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.mapreduce.Counter;
import org.apache.hadoop.mapreduce.Counters;
import org.apache.hadoop.mapreduce.JobCounter;
import org.apache.hadoop.mapreduce.JobID;
import org.apache.hadoop.mapreduce.JobStatus;
import org.apache.hadoop.mapreduce.TaskType;
import org.apache.hadoop.mapreduce.TypeConverter;
import org.apache.hadoop.mapreduce.jobhistory.EventType;
import org.apache.hadoop.mapreduce.jobhistory.EventWriter;
import org.apache.hadoop.mapreduce.jobhistory.HistoryEvent;
import org.apache.hadoop.mapreduce.jobhistory.JobFinishedEvent;
import org.apache.hadoop.mapreduce.jobhistory.JobHistoryEvent;
import org.apache.hadoop.mapreduce.jobhistory.JobHistoryEventHandler;
import org.apache.hadoop.mapreduce.jobhistory.JobInitedEvent;
import org.apache.hadoop.mapreduce.jobhistory.JobSubmittedEvent;
import org.apache.hadoop.mapreduce.jobhistory.JobSummary;
import org.apache.hadoop.mapreduce.jobhistory.JobUnsuccessfulCompletionEvent;
import org.apache.hadoop.mapreduce.jobhistory.NormalizedResourceEvent;
import org.apache.hadoop.mapreduce.jobhistory.TaskAttemptStartedEvent;
import org.apache.hadoop.mapreduce.v2.api.records.JobId;
import org.apache.hadoop.mapreduce.v2.api.records.JobState;
import org.apache.hadoop.mapreduce.v2.app.AppContext;
import org.apache.hadoop.mapreduce.v2.jobhistory.FileNameIndexUtils;
import org.apache.hadoop.mapreduce.v2.jobhistory.JobHistoryUtils;
import org.apache.hadoop.mapreduce.v2.jobhistory.JobIndexInfo;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.yarn.YarnException;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.event.EventHandler;
import org.apache.hadoop.yarn.service.AbstractService;

/*
 * Exception performing whole class analysis ignored.
 */
public class JobHistoryEventHandler
extends AbstractService
implements EventHandler<JobHistoryEvent> {
    private final AppContext context;
    private final int startCount;
    private int eventCounter;
    private FileSystem stagingDirFS;
    private FileSystem doneDirFS;
    private Path stagingDirPath = null;
    private Path doneDirPrefixPath = null;
    private int maxUnflushedCompletionEvents;
    private int postJobCompletionMultiplier;
    private long flushTimeout;
    private int minQueueSizeForBatchingFlushes;
    private int numUnflushedCompletionEvents = 0;
    private boolean isTimerActive;
    protected BlockingQueue<JobHistoryEvent> eventQueue = new LinkedBlockingQueue();
    protected Thread eventHandlingThread;
    private volatile boolean stopped;
    private final Object lock = new Object();
    private static final Log LOG = LogFactory.getLog(JobHistoryEventHandler.class);
    protected static final Map<JobId, MetaInfo> fileMap = Collections.synchronizedMap(new HashMap());
    protected volatile boolean forceJobCompletion = false;

    public JobHistoryEventHandler(AppContext context, int startCount) {
        super("JobHistoryEventHandler");
        this.context = context;
        this.startCount = startCount;
    }

    public void init(Configuration conf) {
        String userDoneDirStr;
        block9: {
            String jobId = TypeConverter.fromYarn((ApplicationId)this.context.getApplicationID()).toString();
            String stagingDirStr = null;
            String doneDirStr = null;
            userDoneDirStr = null;
            try {
                stagingDirStr = JobHistoryUtils.getConfiguredHistoryStagingDirPrefix((Configuration)conf, (String)jobId);
                doneDirStr = JobHistoryUtils.getConfiguredHistoryIntermediateDoneDirPrefix((Configuration)conf);
                userDoneDirStr = JobHistoryUtils.getHistoryIntermediateDoneDirForUser((Configuration)conf);
            }
            catch (IOException e) {
                LOG.error((Object)"Failed while getting the configured log directories", (Throwable)e);
                throw new YarnException((Throwable)e);
            }
            try {
                this.stagingDirPath = FileSystem.get((Configuration)conf).makeQualified(new Path(stagingDirStr));
                this.stagingDirFS = FileSystem.get((URI)this.stagingDirPath.toUri(), (Configuration)conf);
                this.mkdir(this.stagingDirFS, this.stagingDirPath, new FsPermission(JobHistoryUtils.HISTORY_STAGING_DIR_PERMISSIONS));
            }
            catch (IOException e) {
                LOG.error((Object)("Failed while checking for/creating  history staging path: [" + this.stagingDirPath + "]"), (Throwable)e);
                throw new YarnException((Throwable)e);
            }
            Path doneDirPath = null;
            try {
                doneDirPath = FileSystem.get((Configuration)conf).makeQualified(new Path(doneDirStr));
                this.doneDirFS = FileSystem.get((URI)doneDirPath.toUri(), (Configuration)conf);
                if (this.doneDirFS.exists(doneDirPath)) break block9;
                if (JobHistoryUtils.shouldCreateNonUserDirectory((Configuration)conf)) {
                    LOG.info((Object)("Creating intermediate history logDir: [" + doneDirPath + "] + based on conf. Should ideally be created by the JobHistoryServer: " + "yarn.app.mapreduce.am.create-intermediate-jh-base-dir"));
                    this.mkdir(this.doneDirFS, doneDirPath, new FsPermission(JobHistoryUtils.HISTORY_INTERMEDIATE_DONE_DIR_PERMISSIONS.toShort()));
                    break block9;
                }
                String message = "Not creating intermediate history logDir: [" + doneDirPath + "] based on conf: " + "yarn.app.mapreduce.am.create-intermediate-jh-base-dir" + ". Either set to true or pre-create this directory with" + " appropriate permissions";
                LOG.error((Object)message);
                throw new YarnException(message);
            }
            catch (IOException e) {
                LOG.error((Object)("Failed checking for the existance of history intermediate done directory: [" + doneDirPath + "]"));
                throw new YarnException((Throwable)e);
            }
        }
        try {
            this.doneDirPrefixPath = FileSystem.get((Configuration)conf).makeQualified(new Path(userDoneDirStr));
            this.mkdir(this.doneDirFS, this.doneDirPrefixPath, new FsPermission(JobHistoryUtils.HISTORY_INTERMEDIATE_USER_DIR_PERMISSIONS));
        }
        catch (IOException e) {
            LOG.error((Object)("Error creating user intermediate history done directory: [ " + this.doneDirPrefixPath + "]"), (Throwable)e);
            throw new YarnException((Throwable)e);
        }
        this.maxUnflushedCompletionEvents = conf.getInt("yarn.app.mapreduce.am.history.max-unflushed-events", 200);
        this.postJobCompletionMultiplier = conf.getInt("yarn.app.mapreduce.am.history.job-complete-unflushed-multiplier", 30);
        this.flushTimeout = conf.getLong("yarn.app.mapreduce.am.history.complete-event-flush-timeout", 30000L);
        this.minQueueSizeForBatchingFlushes = conf.getInt("yarn.app.mapreduce.am.history.use-batched-flush.queue-size.threshold", 50);
        super.init(conf);
    }

    private void mkdir(FileSystem fs, Path path, FsPermission fsp) throws IOException {
        if (!fs.exists(path)) {
            try {
                fs.mkdirs(path, fsp);
                FileStatus fsStatus = fs.getFileStatus(path);
                LOG.info((Object)("Perms after creating " + fsStatus.getPermission().toShort() + ", Expected: " + fsp.toShort()));
                if (fsStatus.getPermission().toShort() != fsp.toShort()) {
                    LOG.info((Object)("Explicitly setting permissions to : " + fsp.toShort() + ", " + fsp));
                    fs.setPermission(path, fsp);
                }
            }
            catch (FileAlreadyExistsException e) {
                LOG.info((Object)("Directory: [" + path + "] already exists."));
            }
        }
    }

    public void start() {
        this.eventHandlingThread = new Thread((Runnable)new /* Unavailable Anonymous Inner Class!! */);
        this.eventHandlingThread.start();
        super.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        LOG.info((Object)("Stopping JobHistoryEventHandler. Size of the outstanding queue size is " + this.eventQueue.size()));
        this.stopped = true;
        Object object = this.lock;
        synchronized (object) {
            if (this.eventHandlingThread != null) {
                this.eventHandlingThread.interrupt();
            }
        }
        try {
            if (this.eventHandlingThread != null) {
                this.eventHandlingThread.join();
            }
        }
        catch (InterruptedException ie) {
            LOG.info((Object)"Interruped Exception while stopping", (Throwable)ie);
        }
        for (MetaInfo mi : fileMap.values()) {
            try {
                mi.shutDownTimer();
            }
            catch (IOException e) {
                LOG.info((Object)("Exception while cancelling delayed flush timer. Likely caused by a failed flush " + e.getMessage()));
            }
        }
        for (JobHistoryEvent ev : this.eventQueue) {
            LOG.info((Object)("In stop, writing event " + ev.getType()));
            this.handleEvent(ev);
        }
        Iterator jobIt = fileMap.keySet().iterator();
        if (this.forceJobCompletion) {
            while (jobIt.hasNext()) {
                JobId toClose = (JobId)jobIt.next();
                MetaInfo mi = (MetaInfo)fileMap.get(toClose);
                if (mi == null || !mi.isWriterActive()) continue;
                LOG.warn((Object)("Found jobId " + toClose + " to have not been closed. Will close"));
                JobUnsuccessfulCompletionEvent jucEvent = new JobUnsuccessfulCompletionEvent((JobID)TypeConverter.fromYarn((JobId)toClose), System.currentTimeMillis(), this.context.getJob(toClose).getCompletedMaps(), this.context.getJob(toClose).getCompletedReduces(), JobState.KILLED.toString());
                JobHistoryEvent jfEvent = new JobHistoryEvent(toClose, (HistoryEvent)jucEvent);
                this.handleEvent(jfEvent);
            }
        }
        for (MetaInfo mi : fileMap.values()) {
            try {
                mi.closeWriter();
            }
            catch (IOException e) {
                LOG.info((Object)("Exception while closing file " + e.getMessage()));
            }
        }
        LOG.info((Object)"Stopped JobHistoryEventHandler. super.stop()");
        super.stop();
    }

    protected EventWriter createEventWriter(Path historyFilePath) throws IOException {
        FSDataOutputStream out = this.stagingDirFS.create(historyFilePath, true);
        return new EventWriter(out);
    }

    protected void setupEventWriter(JobId jobId) throws IOException {
        if (this.stagingDirPath == null) {
            LOG.error((Object)"Log Directory is null, returning");
            throw new IOException("Missing Log Directory for History");
        }
        MetaInfo oldFi = (MetaInfo)fileMap.get(jobId);
        Configuration conf = this.getConfig();
        Path historyFile = JobHistoryUtils.getStagingJobHistoryFile((Path)this.stagingDirPath, (JobId)jobId, (int)this.startCount);
        String user = UserGroupInformation.getCurrentUser().getShortUserName();
        if (user == null) {
            throw new IOException("User is null while setting up jobhistory eventwriter");
        }
        String jobName = this.context.getJob(jobId).getName();
        EventWriter writer = oldFi == null ? null : MetaInfo.access$400((MetaInfo)oldFi);
        Path logDirConfPath = JobHistoryUtils.getStagingConfFile((Path)this.stagingDirPath, (JobId)jobId, (int)this.startCount);
        if (writer == null) {
            try {
                writer = this.createEventWriter(historyFile);
                LOG.info((Object)("Event Writer setup for JobId: " + jobId + ", File: " + historyFile));
            }
            catch (IOException ioe) {
                LOG.info((Object)("Could not create log file: [" + historyFile + "] + for job " + "[" + jobName + "]"));
                throw ioe;
            }
            if (conf != null) {
                FSDataOutputStream jobFileOut = null;
                try {
                    if (logDirConfPath != null) {
                        jobFileOut = this.stagingDirFS.create(logDirConfPath, true);
                        conf.writeXml((OutputStream)jobFileOut);
                        jobFileOut.close();
                    }
                }
                catch (IOException e) {
                    LOG.info((Object)"Failed to write the job configuration file", (Throwable)e);
                    throw e;
                }
            }
        }
        MetaInfo fi = new MetaInfo(this, historyFile, logDirConfPath, writer, user, jobName, jobId);
        fi.getJobSummary().setJobId(jobId);
        fileMap.put(jobId, fi);
    }

    public void closeWriter(JobId id) throws IOException {
        try {
            MetaInfo mi = (MetaInfo)fileMap.get(id);
            if (mi != null) {
                mi.closeWriter();
            }
        }
        catch (IOException e) {
            LOG.error((Object)("Error closing writer for JobID: " + id));
            throw e;
        }
    }

    public void handle(JobHistoryEvent event) {
        try {
            if (this.isJobCompletionEvent(event.getHistoryEvent())) {
                this.maxUnflushedCompletionEvents *= this.postJobCompletionMultiplier;
            }
            this.eventQueue.put(event);
        }
        catch (InterruptedException e) {
            throw new YarnException((Throwable)e);
        }
    }

    private boolean isJobCompletionEvent(HistoryEvent historyEvent) {
        return EnumSet.of(EventType.JOB_FINISHED, EventType.JOB_FAILED, EventType.JOB_KILLED).contains(historyEvent.getEventType());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleEvent(JobHistoryEvent event) {
        Object object = this.lock;
        synchronized (object) {
            if (event.getHistoryEvent().getEventType() == EventType.AM_STARTED) {
                try {
                    this.setupEventWriter(event.getJobID());
                }
                catch (IOException ioe) {
                    LOG.error((Object)("Error JobHistoryEventHandler in handleEvent: " + event), (Throwable)ioe);
                    throw new YarnException((Throwable)ioe);
                }
            }
            MetaInfo mi = (MetaInfo)fileMap.get(event.getJobID());
            try {
                HistoryEvent historyEvent = event.getHistoryEvent();
                if (!(historyEvent instanceof NormalizedResourceEvent)) {
                    mi.writeEvent(historyEvent);
                }
                this.processEventForJobSummary(event.getHistoryEvent(), mi.getJobSummary(), event.getJobID());
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("In HistoryEventHandler " + event.getHistoryEvent().getEventType()));
                }
            }
            catch (IOException e) {
                LOG.error((Object)("Error writing History Event: " + event.getHistoryEvent()), (Throwable)e);
                throw new YarnException((Throwable)e);
            }
            if (event.getHistoryEvent().getEventType() == EventType.JOB_SUBMITTED) {
                JobSubmittedEvent jobSubmittedEvent = (JobSubmittedEvent)event.getHistoryEvent();
                mi.getJobIndexInfo().setSubmitTime(jobSubmittedEvent.getSubmitTime());
                mi.getJobIndexInfo().setQueueName(jobSubmittedEvent.getJobQueueName());
            }
            if (event.getHistoryEvent().getEventType() == EventType.JOB_FINISHED) {
                try {
                    JobFinishedEvent jFinishedEvent = (JobFinishedEvent)event.getHistoryEvent();
                    mi.getJobIndexInfo().setFinishTime(jFinishedEvent.getFinishTime());
                    mi.getJobIndexInfo().setNumMaps(jFinishedEvent.getFinishedMaps());
                    mi.getJobIndexInfo().setNumReduces(jFinishedEvent.getFinishedReduces());
                    mi.getJobIndexInfo().setJobStatus(JobState.SUCCEEDED.toString());
                    this.closeEventWriter(event.getJobID());
                }
                catch (IOException e) {
                    throw new YarnException((Throwable)e);
                }
            }
            if (event.getHistoryEvent().getEventType() == EventType.JOB_FAILED || event.getHistoryEvent().getEventType() == EventType.JOB_KILLED) {
                try {
                    JobUnsuccessfulCompletionEvent jucEvent = (JobUnsuccessfulCompletionEvent)event.getHistoryEvent();
                    mi.getJobIndexInfo().setFinishTime(jucEvent.getFinishTime());
                    mi.getJobIndexInfo().setNumMaps(jucEvent.getFinishedMaps());
                    mi.getJobIndexInfo().setNumReduces(jucEvent.getFinishedReduces());
                    mi.getJobIndexInfo().setJobStatus(jucEvent.getStatus());
                    this.closeEventWriter(event.getJobID());
                }
                catch (IOException e) {
                    throw new YarnException((Throwable)e);
                }
            }
        }
    }

    public void processEventForJobSummary(HistoryEvent event, JobSummary summary, JobId jobId) {
        switch (2.$SwitchMap$org$apache$hadoop$mapreduce$jobhistory$EventType[event.getEventType().ordinal()]) {
            case 1: {
                JobSubmittedEvent jse = (JobSubmittedEvent)event;
                summary.setUser(jse.getUserName());
                summary.setQueue(jse.getJobQueueName());
                summary.setJobSubmitTime(jse.getSubmitTime());
                summary.setJobName(jse.getJobName());
                break;
            }
            case 2: {
                NormalizedResourceEvent normalizedResourceEvent = (NormalizedResourceEvent)event;
                if (normalizedResourceEvent.getTaskType() == TaskType.MAP) {
                    summary.setResourcesPerMap(normalizedResourceEvent.getMemory());
                    break;
                }
                if (normalizedResourceEvent.getTaskType() != TaskType.REDUCE) break;
                summary.setResourcesPerReduce(normalizedResourceEvent.getMemory());
                break;
            }
            case 3: {
                JobInitedEvent jie = (JobInitedEvent)event;
                summary.setJobLaunchTime(jie.getLaunchTime());
                break;
            }
            case 4: {
                TaskAttemptStartedEvent mtase = (TaskAttemptStartedEvent)event;
                if (summary.getFirstMapTaskLaunchTime() != 0L) break;
                summary.setFirstMapTaskLaunchTime(mtase.getStartTime());
                break;
            }
            case 5: {
                TaskAttemptStartedEvent rtase = (TaskAttemptStartedEvent)event;
                if (summary.getFirstReduceTaskLaunchTime() != 0L) break;
                summary.setFirstReduceTaskLaunchTime(rtase.getStartTime());
                break;
            }
            case 6: {
                JobFinishedEvent jfe = (JobFinishedEvent)event;
                summary.setJobFinishTime(jfe.getFinishTime());
                summary.setNumFinishedMaps(jfe.getFinishedMaps());
                summary.setNumFailedMaps(jfe.getFailedMaps());
                summary.setNumFinishedReduces(jfe.getFinishedReduces());
                summary.setNumFailedReduces(jfe.getFailedReduces());
                if (summary.getJobStatus() == null) {
                    summary.setJobStatus(JobStatus.State.SUCCEEDED.toString());
                }
                this.setSummarySlotSeconds(summary, jfe.getTotalCounters());
                break;
            }
            case 7: 
            case 8: {
                JobUnsuccessfulCompletionEvent juce = (JobUnsuccessfulCompletionEvent)event;
                summary.setJobStatus(juce.getStatus());
                summary.setNumFinishedMaps(this.context.getJob(jobId).getTotalMaps());
                summary.setNumFinishedReduces(this.context.getJob(jobId).getTotalReduces());
                summary.setJobFinishTime(juce.getFinishTime());
                this.setSummarySlotSeconds(summary, this.context.getJob(jobId).getAllCounters());
                break;
            }
        }
    }

    private void setSummarySlotSeconds(JobSummary summary, Counters allCounters) {
        Counter slotMillisReduceCounter;
        Counter slotMillisMapCounter = allCounters.findCounter((Enum)JobCounter.SLOTS_MILLIS_MAPS);
        if (slotMillisMapCounter != null) {
            summary.setMapSlotSeconds(slotMillisMapCounter.getValue() / 1000L);
        }
        if ((slotMillisReduceCounter = allCounters.findCounter((Enum)JobCounter.SLOTS_MILLIS_REDUCES)) != null) {
            summary.setReduceSlotSeconds(slotMillisReduceCounter.getValue() / 1000L);
        }
    }

    protected void closeEventWriter(JobId jobId) throws IOException {
        MetaInfo mi = (MetaInfo)fileMap.get(jobId);
        if (mi == null) {
            throw new IOException("No MetaInfo found for JobId: [" + jobId + "]");
        }
        if (!mi.isWriterActive()) {
            throw new IOException("Inactive Writer: Likely received multiple JobFinished / JobUnsuccessful events for JobId: [" + jobId + "]");
        }
        try {
            mi.closeWriter();
        }
        catch (IOException e) {
            LOG.error((Object)("Error closing writer for JobID: " + jobId));
            throw e;
        }
        if (mi.getHistoryFile() == null) {
            LOG.warn((Object)("No file for job-history with " + jobId + " found in cache!"));
        }
        if (mi.getConfFile() == null) {
            LOG.warn((Object)("No file for jobconf with " + jobId + " found in cache!"));
        }
        Path qualifiedSummaryDoneFile = null;
        FSDataOutputStream summaryFileOut = null;
        try {
            String doneSummaryFileName = this.getTempFileName(JobHistoryUtils.getIntermediateSummaryFileName((JobId)jobId));
            qualifiedSummaryDoneFile = this.doneDirFS.makeQualified(new Path(this.doneDirPrefixPath, doneSummaryFileName));
            summaryFileOut = this.doneDirFS.create(qualifiedSummaryDoneFile, true);
            summaryFileOut.writeUTF(mi.getJobSummary().getJobSummaryString());
            summaryFileOut.close();
            this.doneDirFS.setPermission(qualifiedSummaryDoneFile, new FsPermission(JobHistoryUtils.HISTORY_INTERMEDIATE_FILE_PERMISSIONS));
        }
        catch (IOException e) {
            LOG.info((Object)("Unable to write out JobSummaryInfo to [" + qualifiedSummaryDoneFile + "]"), (Throwable)e);
            throw e;
        }
        try {
            Path qualifiedDoneFile = null;
            if (mi.getHistoryFile() != null) {
                Path historyFile = mi.getHistoryFile();
                Path qualifiedLogFile = this.stagingDirFS.makeQualified(historyFile);
                String doneJobHistoryFileName = this.getTempFileName(FileNameIndexUtils.getDoneFileName((JobIndexInfo)mi.getJobIndexInfo()));
                qualifiedDoneFile = this.doneDirFS.makeQualified(new Path(this.doneDirPrefixPath, doneJobHistoryFileName));
                this.moveToDoneNow(qualifiedLogFile, qualifiedDoneFile);
            }
            Path qualifiedConfDoneFile = null;
            if (mi.getConfFile() != null) {
                Path confFile = mi.getConfFile();
                Path qualifiedConfFile = this.stagingDirFS.makeQualified(confFile);
                String doneConfFileName = this.getTempFileName(JobHistoryUtils.getIntermediateConfFileName((JobId)jobId));
                qualifiedConfDoneFile = this.doneDirFS.makeQualified(new Path(this.doneDirPrefixPath, doneConfFileName));
                this.moveToDoneNow(qualifiedConfFile, qualifiedConfDoneFile);
            }
            this.moveTmpToDone(qualifiedSummaryDoneFile);
            this.moveTmpToDone(qualifiedConfDoneFile);
            this.moveTmpToDone(qualifiedDoneFile);
        }
        catch (IOException e) {
            LOG.error((Object)("Error closing writer for JobID: " + jobId));
            throw e;
        }
    }

    private void moveTmpToDone(Path tmpPath) throws IOException {
        if (tmpPath != null) {
            String tmpFileName = tmpPath.getName();
            String fileName = this.getFileNameFromTmpFN(tmpFileName);
            Path path = new Path(tmpPath.getParent(), fileName);
            this.doneDirFS.rename(tmpPath, path);
            LOG.info((Object)("Moved tmp to done: " + tmpPath + " to " + path));
        }
    }

    private void moveToDoneNow(Path fromPath, Path toPath) throws IOException {
        if (this.stagingDirFS.exists(fromPath)) {
            boolean copied;
            LOG.info((Object)("Copying " + fromPath.toString() + " to " + toPath.toString()));
            if (this.doneDirFS.exists(toPath)) {
                this.doneDirFS.delete(toPath, true);
            }
            if (copied = FileUtil.copy((FileSystem)this.stagingDirFS, (Path)fromPath, (FileSystem)this.doneDirFS, (Path)toPath, (boolean)false, (Configuration)this.getConfig())) {
                LOG.info((Object)("Copied to done location: " + toPath));
            } else {
                LOG.info((Object)"copy failed");
            }
            this.doneDirFS.setPermission(toPath, new FsPermission(JobHistoryUtils.HISTORY_INTERMEDIATE_FILE_PERMISSIONS));
        }
    }

    boolean pathExists(FileSystem fileSys, Path path) throws IOException {
        return fileSys.exists(path);
    }

    private String getTempFileName(String srcFile) {
        return srcFile + "_tmp";
    }

    private String getFileNameFromTmpFN(String tmpFileName) {
        return tmpFileName.substring(0, tmpFileName.length() - 4);
    }

    public void setForcejobCompletion(boolean forceJobCompletion) {
        this.forceJobCompletion = forceJobCompletion;
        LOG.info((Object)("JobHistoryEventHandler notified that forceJobCompletion is " + forceJobCompletion));
    }

    static /* synthetic */ boolean access$000(JobHistoryEventHandler x0) {
        return x0.stopped;
    }

    static /* synthetic */ int access$100(JobHistoryEventHandler x0) {
        return x0.eventCounter;
    }

    static /* synthetic */ int access$102(JobHistoryEventHandler x0, int x1) {
        x0.eventCounter = x1;
        return x0.eventCounter;
    }

    static /* synthetic */ Log access$200() {
        return LOG;
    }

    static /* synthetic */ int access$108(JobHistoryEventHandler x0) {
        return x0.eventCounter++;
    }

    static /* synthetic */ Object access$300(JobHistoryEventHandler x0) {
        return x0.lock;
    }

    static /* synthetic */ int access$508(JobHistoryEventHandler x0) {
        return x0.numUnflushedCompletionEvents++;
    }

    static /* synthetic */ boolean access$600(JobHistoryEventHandler x0) {
        return x0.isTimerActive;
    }

    static /* synthetic */ long access$700(JobHistoryEventHandler x0) {
        return x0.flushTimeout;
    }

    static /* synthetic */ boolean access$602(JobHistoryEventHandler x0, boolean x1) {
        x0.isTimerActive = x1;
        return x0.isTimerActive;
    }

    static /* synthetic */ int access$800(JobHistoryEventHandler x0) {
        return x0.minQueueSizeForBatchingFlushes;
    }

    static /* synthetic */ int access$500(JobHistoryEventHandler x0) {
        return x0.numUnflushedCompletionEvents;
    }

    static /* synthetic */ int access$900(JobHistoryEventHandler x0) {
        return x0.maxUnflushedCompletionEvents;
    }

    static /* synthetic */ boolean access$1000(JobHistoryEventHandler x0, HistoryEvent x1) {
        return x0.isJobCompletionEvent(x1);
    }

    static /* synthetic */ int access$502(JobHistoryEventHandler x0, int x1) {
        x0.numUnflushedCompletionEvents = x1;
        return x0.numUnflushedCompletionEvents;
    }
}

