/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.jobhistory;

import java.io.File;
import java.io.IOException;
import junit.framework.Assert;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileContext;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.Counters;
import org.apache.hadoop.mapreduce.JobID;
import org.apache.hadoop.mapreduce.TaskType;
import org.apache.hadoop.mapreduce.TypeConverter;
import org.apache.hadoop.mapreduce.jobhistory.AMStartedEvent;
import org.apache.hadoop.mapreduce.jobhistory.EventType;
import org.apache.hadoop.mapreduce.jobhistory.EventWriter;
import org.apache.hadoop.mapreduce.jobhistory.HistoryEvent;
import org.apache.hadoop.mapreduce.jobhistory.JHEvenHandlerForTest;
import org.apache.hadoop.mapreduce.jobhistory.JHEventHandlerForSigtermTest;
import org.apache.hadoop.mapreduce.jobhistory.JobFinishedEvent;
import org.apache.hadoop.mapreduce.jobhistory.JobHistoryEvent;
import org.apache.hadoop.mapreduce.jobhistory.JobUnsuccessfulCompletionEvent;
import org.apache.hadoop.mapreduce.jobhistory.TaskFinishedEvent;
import org.apache.hadoop.mapreduce.jobhistory.TaskStartedEvent;
import org.apache.hadoop.mapreduce.jobhistory.TestJobHistoryEventHandler;
import org.apache.hadoop.mapreduce.v2.api.records.JobId;
import org.apache.hadoop.mapreduce.v2.app.AppContext;
import org.apache.hadoop.mapreduce.v2.app.job.Job;
import org.apache.hadoop.yarn.YarnException;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class TestJobHistoryEventHandler {
    private static final Log LOG = LogFactory.getLog(TestJobHistoryEventHandler.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFirstFlushOnCompletionEvent() throws Exception {
        TestParams t = new TestParams(this, null);
        Configuration conf = new Configuration();
        conf.set("yarn.app.mapreduce.am.staging-dir", t.workDir);
        conf.setLong("yarn.app.mapreduce.am.history.complete-event-flush-timeout", 60000L);
        conf.setInt("yarn.app.mapreduce.am.history.job-complete-unflushed-multiplier", 10);
        conf.setInt("yarn.app.mapreduce.am.history.max-unflushed-events", 10);
        conf.setInt("yarn.app.mapreduce.am.history.use-batched-flush.queue-size.threshold", 200);
        JHEvenHandlerForTest realJheh = new JHEvenHandlerForTest(t.mockAppContext, 0);
        JHEvenHandlerForTest jheh = (JHEvenHandlerForTest)Mockito.spy((Object)realJheh);
        jheh.init(conf);
        EventWriter mockWriter = null;
        try {
            jheh.start();
            this.handleEvent(jheh, new JobHistoryEvent(t.jobId, (HistoryEvent)new AMStartedEvent(t.appAttemptId, 200L, t.containerId, "nmhost", 3000, 4000)));
            mockWriter = jheh.getEventWriter();
            ((EventWriter)Mockito.verify((Object)mockWriter)).write((HistoryEvent)Mockito.any(HistoryEvent.class));
            for (int i = 0; i < 100; ++i) {
                this.queueEvent(jheh, new JobHistoryEvent(t.jobId, (HistoryEvent)new TaskStartedEvent(t.taskID, 0L, TaskType.MAP, "")));
            }
            this.handleNextNEvents(jheh, 100);
            ((EventWriter)Mockito.verify((Object)mockWriter, (VerificationMode)Mockito.times((int)0))).flush();
            this.handleEvent(jheh, new JobHistoryEvent(t.jobId, (HistoryEvent)new TaskFinishedEvent(t.taskID, null, 0L, TaskType.MAP, "", null)));
            ((EventWriter)Mockito.verify((Object)mockWriter)).flush();
        }
        catch (Throwable throwable) {
            jheh.stop();
            ((EventWriter)Mockito.verify(mockWriter)).close();
            throw throwable;
        }
        jheh.stop();
        ((EventWriter)Mockito.verify((Object)mockWriter)).close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMaxUnflushedCompletionEvents() throws Exception {
        TestParams t = new TestParams(this, null);
        Configuration conf = new Configuration();
        conf.set("yarn.app.mapreduce.am.staging-dir", t.workDir);
        conf.setLong("yarn.app.mapreduce.am.history.complete-event-flush-timeout", 60000L);
        conf.setInt("yarn.app.mapreduce.am.history.job-complete-unflushed-multiplier", 10);
        conf.setInt("yarn.app.mapreduce.am.history.max-unflushed-events", 10);
        conf.setInt("yarn.app.mapreduce.am.history.use-batched-flush.queue-size.threshold", 5);
        JHEvenHandlerForTest realJheh = new JHEvenHandlerForTest(t.mockAppContext, 0);
        JHEvenHandlerForTest jheh = (JHEvenHandlerForTest)Mockito.spy((Object)realJheh);
        jheh.init(conf);
        EventWriter mockWriter = null;
        try {
            jheh.start();
            this.handleEvent(jheh, new JobHistoryEvent(t.jobId, (HistoryEvent)new AMStartedEvent(t.appAttemptId, 200L, t.containerId, "nmhost", 3000, 4000)));
            mockWriter = jheh.getEventWriter();
            ((EventWriter)Mockito.verify((Object)mockWriter)).write((HistoryEvent)Mockito.any(HistoryEvent.class));
            for (int i = 0; i < 100; ++i) {
                this.queueEvent(jheh, new JobHistoryEvent(t.jobId, (HistoryEvent)new TaskFinishedEvent(t.taskID, null, 0L, TaskType.MAP, "", null)));
            }
            this.handleNextNEvents(jheh, 9);
            ((EventWriter)Mockito.verify((Object)mockWriter, (VerificationMode)Mockito.times((int)0))).flush();
            this.handleNextNEvents(jheh, 1);
            ((EventWriter)Mockito.verify((Object)mockWriter)).flush();
            this.handleNextNEvents(jheh, 50);
            ((EventWriter)Mockito.verify((Object)mockWriter, (VerificationMode)Mockito.times((int)6))).flush();
        }
        catch (Throwable throwable) {
            jheh.stop();
            ((EventWriter)Mockito.verify(mockWriter)).close();
            throw throwable;
        }
        jheh.stop();
        ((EventWriter)Mockito.verify((Object)mockWriter)).close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUnflushedTimer() throws Exception {
        TestParams t = new TestParams(this, null);
        Configuration conf = new Configuration();
        conf.set("yarn.app.mapreduce.am.staging-dir", t.workDir);
        conf.setLong("yarn.app.mapreduce.am.history.complete-event-flush-timeout", 2000L);
        conf.setInt("yarn.app.mapreduce.am.history.job-complete-unflushed-multiplier", 10);
        conf.setInt("yarn.app.mapreduce.am.history.max-unflushed-events", 100);
        conf.setInt("yarn.app.mapreduce.am.history.use-batched-flush.queue-size.threshold", 5);
        JHEvenHandlerForTest realJheh = new JHEvenHandlerForTest(t.mockAppContext, 0);
        JHEvenHandlerForTest jheh = (JHEvenHandlerForTest)Mockito.spy((Object)realJheh);
        jheh.init(conf);
        EventWriter mockWriter = null;
        try {
            jheh.start();
            this.handleEvent(jheh, new JobHistoryEvent(t.jobId, (HistoryEvent)new AMStartedEvent(t.appAttemptId, 200L, t.containerId, "nmhost", 3000, 4000)));
            mockWriter = jheh.getEventWriter();
            ((EventWriter)Mockito.verify((Object)mockWriter)).write((HistoryEvent)Mockito.any(HistoryEvent.class));
            for (int i = 0; i < 100; ++i) {
                this.queueEvent(jheh, new JobHistoryEvent(t.jobId, (HistoryEvent)new TaskFinishedEvent(t.taskID, null, 0L, TaskType.MAP, "", null)));
            }
            this.handleNextNEvents(jheh, 9);
            ((EventWriter)Mockito.verify((Object)mockWriter, (VerificationMode)Mockito.times((int)0))).flush();
            Thread.sleep(8000L);
            ((EventWriter)Mockito.verify((Object)mockWriter)).flush();
        }
        catch (Throwable throwable) {
            jheh.stop();
            ((EventWriter)Mockito.verify(mockWriter)).close();
            throw throwable;
        }
        jheh.stop();
        ((EventWriter)Mockito.verify((Object)mockWriter)).close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBatchedFlushJobEndMultiplier() throws Exception {
        TestParams t = new TestParams(this, null);
        Configuration conf = new Configuration();
        conf.set("yarn.app.mapreduce.am.staging-dir", t.workDir);
        conf.setLong("yarn.app.mapreduce.am.history.complete-event-flush-timeout", 60000L);
        conf.setInt("yarn.app.mapreduce.am.history.job-complete-unflushed-multiplier", 3);
        conf.setInt("yarn.app.mapreduce.am.history.max-unflushed-events", 10);
        conf.setInt("yarn.app.mapreduce.am.history.use-batched-flush.queue-size.threshold", 0);
        JHEvenHandlerForTest realJheh = new JHEvenHandlerForTest(t.mockAppContext, 0);
        JHEvenHandlerForTest jheh = (JHEvenHandlerForTest)Mockito.spy((Object)realJheh);
        jheh.init(conf);
        EventWriter mockWriter = null;
        try {
            jheh.start();
            this.handleEvent(jheh, new JobHistoryEvent(t.jobId, (HistoryEvent)new AMStartedEvent(t.appAttemptId, 200L, t.containerId, "nmhost", 3000, 4000)));
            mockWriter = jheh.getEventWriter();
            ((EventWriter)Mockito.verify((Object)mockWriter)).write((HistoryEvent)Mockito.any(HistoryEvent.class));
            for (int i = 0; i < 100; ++i) {
                this.queueEvent(jheh, new JobHistoryEvent(t.jobId, (HistoryEvent)new TaskFinishedEvent(t.taskID, null, 0L, TaskType.MAP, "", null)));
            }
            this.queueEvent(jheh, new JobHistoryEvent(t.jobId, (HistoryEvent)new JobFinishedEvent((JobID)TypeConverter.fromYarn((JobId)t.jobId), 0L, 10, 10, 0, 0, null, null, new Counters())));
            this.handleNextNEvents(jheh, 29);
            ((EventWriter)Mockito.verify((Object)mockWriter, (VerificationMode)Mockito.times((int)0))).flush();
            this.handleNextNEvents(jheh, 72);
            ((EventWriter)Mockito.verify((Object)mockWriter, (VerificationMode)Mockito.times((int)4))).flush();
        }
        catch (Throwable throwable) {
            jheh.stop();
            ((EventWriter)Mockito.verify(mockWriter)).close();
            throw throwable;
        }
        jheh.stop();
        ((EventWriter)Mockito.verify((Object)mockWriter)).close();
    }

    private void queueEvent(JHEvenHandlerForTest jheh, JobHistoryEvent event) {
        jheh.handle(event);
    }

    private void handleEvent(JHEvenHandlerForTest jheh, JobHistoryEvent event) throws InterruptedException {
        jheh.handle(event);
        jheh.handleEvent((JobHistoryEvent)jheh.eventQueue.take());
    }

    private void handleNextNEvents(JHEvenHandlerForTest jheh, int numEvents) throws InterruptedException {
        for (int i = 0; i < numEvents; ++i) {
            jheh.handleEvent((JobHistoryEvent)jheh.eventQueue.take());
        }
    }

    private String setupTestWorkDir() {
        File testWorkDir = new File("target", this.getClass().getCanonicalName());
        try {
            FileContext.getLocalFSFileContext().delete(new Path(testWorkDir.getAbsolutePath()), true);
            return testWorkDir.getAbsolutePath();
        }
        catch (Exception e) {
            LOG.warn((Object)"Could not cleanup", (Throwable)e);
            throw new YarnException("could not cleanup test dir", (Throwable)e);
        }
    }

    private AppContext mockAppContext(ApplicationId appId) {
        JobId jobId = TypeConverter.toYarn((JobID)TypeConverter.fromYarn((ApplicationId)appId));
        AppContext mockContext = (AppContext)Mockito.mock(AppContext.class);
        Job mockJob = (Job)Mockito.mock(Job.class);
        Mockito.when((Object)mockJob.getTotalMaps()).thenReturn((Object)10);
        Mockito.when((Object)mockJob.getTotalReduces()).thenReturn((Object)10);
        Mockito.when((Object)mockJob.getName()).thenReturn((Object)"mockjob");
        Mockito.when((Object)mockContext.getJob(jobId)).thenReturn((Object)mockJob);
        Mockito.when((Object)mockContext.getApplicationID()).thenReturn((Object)appId);
        return mockContext;
    }

    private JobHistoryEvent getEventToEnqueue(JobId jobId) {
        JobHistoryEvent toReturn = (JobHistoryEvent)Mockito.mock(JobHistoryEvent.class);
        HistoryEvent he = (HistoryEvent)Mockito.mock(HistoryEvent.class);
        Mockito.when((Object)he.getEventType()).thenReturn((Object)EventType.JOB_STATUS_CHANGED);
        Mockito.when((Object)toReturn.getHistoryEvent()).thenReturn((Object)he);
        Mockito.when((Object)toReturn.getJobID()).thenReturn((Object)jobId);
        return toReturn;
    }

    @Test
    public void testSigTermedFunctionality() throws IOException {
        AppContext mockedContext = (AppContext)Mockito.mock(AppContext.class);
        JHEventHandlerForSigtermTest jheh = new JHEventHandlerForSigtermTest(mockedContext, 0);
        JobId jobId = (JobId)Mockito.mock(JobId.class);
        jheh.addToFileMap(jobId);
        int numEvents = 4;
        JobHistoryEvent[] events = new JobHistoryEvent[4];
        for (int i = 0; i < 4; ++i) {
            events[i] = this.getEventToEnqueue(jobId);
            jheh.handle(events[i]);
        }
        jheh.stop();
        Assert.assertTrue((String)("handleEvent should've been called only 4 times but was " + jheh.eventsHandled), (jheh.eventsHandled == 4 ? 1 : 0) != 0);
        jheh = new JHEventHandlerForSigtermTest(mockedContext, 0);
        Job job = (Job)Mockito.mock(Job.class);
        Mockito.when((Object)mockedContext.getJob(jobId)).thenReturn((Object)job);
        ApplicationId mockAppId = (ApplicationId)Mockito.mock(ApplicationId.class);
        Mockito.when((Object)mockAppId.getClusterTimestamp()).thenReturn((Object)1000L);
        Mockito.when((Object)jobId.getAppId()).thenReturn((Object)mockAppId);
        jheh.addToFileMap(jobId);
        jheh.setForcejobCompletion(true);
        for (int i = 0; i < 4; ++i) {
            events[i] = this.getEventToEnqueue(jobId);
            jheh.handle(events[i]);
        }
        jheh.stop();
        Assert.assertTrue((String)("handleEvent should've been called only 5 times but was " + jheh.eventsHandled), (jheh.eventsHandled == 5 ? 1 : 0) != 0);
        Assert.assertTrue((String)"Last event handled wasn't JobUnsuccessfulCompletionEvent", (boolean)(jheh.lastEventHandled.getHistoryEvent() instanceof JobUnsuccessfulCompletionEvent));
    }

    static /* synthetic */ String access$100(TestJobHistoryEventHandler x0) {
        return x0.setupTestWorkDir();
    }

    static /* synthetic */ AppContext access$200(TestJobHistoryEventHandler x0, ApplicationId x1) {
        return x0.mockAppContext(x1);
    }
}

