/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.v2.app;

import java.net.Proxy;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.v2.api.records.JobReport;
import org.apache.hadoop.mapreduce.v2.app.JobEndNotifier;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class TestJobEndNotifier
extends JobEndNotifier {
    protected int notificationCount = 0;

    private void testNumRetries(Configuration conf) {
        conf.set("mapreduce.job.end-notification.max.attempts", "0");
        conf.set("mapreduce.job.end-notification.retry.attempts", "10");
        this.setConf(conf);
        Assert.assertTrue((String)("Expected numTries to be 0, but was " + this.numTries), (this.numTries == 0 ? 1 : 0) != 0);
        conf.set("mapreduce.job.end-notification.max.attempts", "1");
        this.setConf(conf);
        Assert.assertTrue((String)("Expected numTries to be 1, but was " + this.numTries), (this.numTries == 1 ? 1 : 0) != 0);
        conf.set("mapreduce.job.end-notification.max.attempts", "20");
        this.setConf(conf);
        Assert.assertTrue((String)("Expected numTries to be 11, but was " + this.numTries), (this.numTries == 11 ? 1 : 0) != 0);
    }

    private void testWaitInterval(Configuration conf) {
        conf.set("mapreduce.job.end-notification.max.retry.interval", "5000");
        conf.set("mapreduce.job.end-notification.retry.interval", "1000");
        this.setConf(conf);
        Assert.assertTrue((String)("Expected waitInterval to be 1000, but was " + this.waitInterval), (this.waitInterval == 1000 ? 1 : 0) != 0);
        conf.set("mapreduce.job.end-notification.retry.interval", "10000");
        this.setConf(conf);
        Assert.assertTrue((String)("Expected waitInterval to be 5000, but was " + this.waitInterval), (this.waitInterval == 5000 ? 1 : 0) != 0);
        conf.set("mapreduce.job.end-notification.retry.interval", "-10");
        this.setConf(conf);
        Assert.assertTrue((String)("Expected waitInterval to be 5000, but was " + this.waitInterval), (this.waitInterval == 5000 ? 1 : 0) != 0);
    }

    private void testTimeout(Configuration conf) {
        conf.set("mapreduce.job.end-notification.timeout", "1000");
        this.setConf(conf);
        Assert.assertTrue((String)("Expected timeout to be 1000, but was " + this.timeout), (this.timeout == 1000 ? 1 : 0) != 0);
    }

    private void testProxyConfiguration(Configuration conf) {
        conf.set("mapreduce.job.end-notification.proxy", "somehost");
        this.setConf(conf);
        Assert.assertTrue((String)"Proxy shouldn't be set because port wasn't specified", (this.proxyToUse.type() == Proxy.Type.DIRECT ? 1 : 0) != 0);
        conf.set("mapreduce.job.end-notification.proxy", "somehost:someport");
        this.setConf(conf);
        Assert.assertTrue((String)"Proxy shouldn't be set because port wasn't numeric", (this.proxyToUse.type() == Proxy.Type.DIRECT ? 1 : 0) != 0);
        conf.set("mapreduce.job.end-notification.proxy", "somehost:1000");
        this.setConf(conf);
        Assert.assertTrue((String)"Proxy should have been set but wasn't ", (boolean)this.proxyToUse.toString().equals("HTTP @ somehost:1000"));
        conf.set("mapreduce.job.end-notification.proxy", "socks@somehost:1000");
        this.setConf(conf);
        Assert.assertTrue((String)"Proxy should have been socks but wasn't ", (boolean)this.proxyToUse.toString().equals("SOCKS @ somehost:1000"));
        conf.set("mapreduce.job.end-notification.proxy", "SOCKS@somehost:1000");
        this.setConf(conf);
        Assert.assertTrue((String)"Proxy should have been socks but wasn't ", (boolean)this.proxyToUse.toString().equals("SOCKS @ somehost:1000"));
        conf.set("mapreduce.job.end-notification.proxy", "sfafn@somehost:1000");
        this.setConf(conf);
        Assert.assertTrue((String)"Proxy should have been http but wasn't ", (boolean)this.proxyToUse.toString().equals("HTTP @ somehost:1000"));
    }

    @Test
    public void checkConfiguration() {
        Configuration conf = new Configuration();
        this.testNumRetries(conf);
        this.testWaitInterval(conf);
        this.testTimeout(conf);
        this.testProxyConfiguration(conf);
    }

    protected boolean notifyURLOnce() {
        boolean success = super.notifyURLOnce();
        ++this.notificationCount;
        return success;
    }

    @Test
    public void testNotifyRetries() throws InterruptedException {
        Configuration conf = new Configuration();
        conf.set("mapreduce.job.end-notification.url", "http://nonexistent");
        JobReport jobReport = (JobReport)Mockito.mock(JobReport.class);
        long startTime = System.currentTimeMillis();
        this.notificationCount = 0;
        this.setConf(conf);
        this.notify(jobReport);
        long endTime = System.currentTimeMillis();
        Assert.assertEquals((String)("Only 1 try was expected but was : " + this.notificationCount), (long)this.notificationCount, (long)1L);
        Assert.assertTrue((String)("Should have taken more than 5 seconds it took " + (endTime - startTime)), (endTime - startTime > 5000L ? 1 : 0) != 0);
        conf.set("mapreduce.job.end-notification.max.attempts", "3");
        conf.set("mapreduce.job.end-notification.retry.attempts", "3");
        conf.set("mapreduce.job.end-notification.retry.interval", "3000");
        conf.set("mapreduce.job.end-notification.max.retry.interval", "3000");
        startTime = System.currentTimeMillis();
        this.notificationCount = 0;
        this.setConf(conf);
        this.notify(jobReport);
        endTime = System.currentTimeMillis();
        Assert.assertEquals((String)("Only 3 retries were expected but was : " + this.notificationCount), (long)this.notificationCount, (long)3L);
        Assert.assertTrue((String)("Should have taken more than 9 seconds it took " + (endTime - startTime)), (endTime - startTime > 9000L ? 1 : 0) != 0);
    }
}

