/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.v2.app.job.impl;

import java.net.InetSocketAddress;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.MapTaskAttemptImpl;
import org.apache.hadoop.mapreduce.JobCounter;
import org.apache.hadoop.mapreduce.split.JobSplit;
import org.apache.hadoop.mapreduce.v2.api.records.JobId;
import org.apache.hadoop.mapreduce.v2.api.records.JobState;
import org.apache.hadoop.mapreduce.v2.api.records.Locality;
import org.apache.hadoop.mapreduce.v2.api.records.TaskAttemptId;
import org.apache.hadoop.mapreduce.v2.api.records.TaskAttemptReport;
import org.apache.hadoop.mapreduce.v2.api.records.TaskAttemptState;
import org.apache.hadoop.mapreduce.v2.api.records.TaskId;
import org.apache.hadoop.mapreduce.v2.api.records.TaskState;
import org.apache.hadoop.mapreduce.v2.api.records.TaskType;
import org.apache.hadoop.mapreduce.v2.app.AppContext;
import org.apache.hadoop.mapreduce.v2.app.ClusterInfo;
import org.apache.hadoop.mapreduce.v2.app.ControlledClock;
import org.apache.hadoop.mapreduce.v2.app.MRApp;
import org.apache.hadoop.mapreduce.v2.app.TaskAttemptListener;
import org.apache.hadoop.mapreduce.v2.app.job.Job;
import org.apache.hadoop.mapreduce.v2.app.job.Task;
import org.apache.hadoop.mapreduce.v2.app.job.TaskAttempt;
import org.apache.hadoop.mapreduce.v2.app.job.event.TaskAttemptContainerAssignedEvent;
import org.apache.hadoop.mapreduce.v2.app.job.event.TaskAttemptContainerLaunchedEvent;
import org.apache.hadoop.mapreduce.v2.app.job.event.TaskAttemptDiagnosticsUpdateEvent;
import org.apache.hadoop.mapreduce.v2.app.job.event.TaskAttemptEvent;
import org.apache.hadoop.mapreduce.v2.app.job.event.TaskAttemptEventType;
import org.apache.hadoop.mapreduce.v2.app.job.impl.TaskAttemptImpl;
import org.apache.hadoop.mapreduce.v2.app.job.impl.TestTaskAttempt;
import org.apache.hadoop.mapreduce.v2.app.rm.ContainerRequestEvent;
import org.apache.hadoop.mapreduce.v2.util.MRBuilderUtils;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.event.EventHandler;
import org.apache.hadoop.yarn.util.Clock;
import org.apache.hadoop.yarn.util.SystemClock;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class TestTaskAttempt {
    @Test
    public void testMRAppHistoryForMap() throws Exception {
        FailingAttemptsMRApp app = new FailingAttemptsMRApp(1, 0);
        this.testMRAppHistory((MRApp)app);
    }

    @Test
    public void testMRAppHistoryForReduce() throws Exception {
        FailingAttemptsMRApp app = new FailingAttemptsMRApp(0, 1);
        this.testMRAppHistory((MRApp)app);
    }

    @Test
    public void testSingleRackRequest() throws Exception {
        TaskAttemptImpl.RequestContainerTransition rct = new TaskAttemptImpl.RequestContainerTransition(false);
        EventHandler eventHandler = (EventHandler)Mockito.mock(EventHandler.class);
        String[] hosts = new String[]{"host1", "host2", "host3"};
        JobSplit.TaskSplitMetaInfo splitInfo = new JobSplit.TaskSplitMetaInfo(hosts, 0L, 0x8000000L);
        TaskAttemptImpl mockTaskAttempt = this.createMapTaskAttemptImplForTest(eventHandler, splitInfo);
        TaskAttemptEvent mockTAEvent = (TaskAttemptEvent)Mockito.mock(TaskAttemptEvent.class);
        rct.transition(mockTaskAttempt, mockTAEvent);
        ArgumentCaptor arg = ArgumentCaptor.forClass(Event.class);
        ((EventHandler)Mockito.verify((Object)eventHandler, (VerificationMode)Mockito.times((int)2))).handle((Event)arg.capture());
        if (!(arg.getAllValues().get(1) instanceof ContainerRequestEvent)) {
            junit.framework.Assert.fail((String)"Second Event not of type ContainerRequestEvent");
        }
        ContainerRequestEvent cre = (ContainerRequestEvent)arg.getAllValues().get(1);
        String[] requestedRacks = cre.getRacks();
        Assert.assertEquals((long)1L, (long)requestedRacks.length);
    }

    @Test
    public void testHostResolveAttempt() throws Exception {
        String[] requestedHosts;
        TaskAttemptImpl.RequestContainerTransition rct = new TaskAttemptImpl.RequestContainerTransition(false);
        EventHandler eventHandler = (EventHandler)Mockito.mock(EventHandler.class);
        String[] hosts = new String[]{"192.168.1.1", "host2", "host3"};
        JobSplit.TaskSplitMetaInfo splitInfo = new JobSplit.TaskSplitMetaInfo(hosts, 0L, 0x8000000L);
        TaskAttemptImpl mockTaskAttempt = this.createMapTaskAttemptImplForTest(eventHandler, splitInfo);
        TaskAttemptImpl spyTa = (TaskAttemptImpl)Mockito.spy((Object)mockTaskAttempt);
        Mockito.when((Object)spyTa.resolveHost(hosts[0])).thenReturn((Object)"host1");
        spyTa.dataLocalHosts = spyTa.resolveHosts(splitInfo.getLocations());
        TaskAttemptEvent mockTAEvent = (TaskAttemptEvent)Mockito.mock(TaskAttemptEvent.class);
        rct.transition(spyTa, mockTAEvent);
        ((TaskAttemptImpl)Mockito.verify((Object)spyTa)).resolveHost(hosts[0]);
        ArgumentCaptor arg = ArgumentCaptor.forClass(Event.class);
        ((EventHandler)Mockito.verify((Object)eventHandler, (VerificationMode)Mockito.times((int)2))).handle((Event)arg.capture());
        if (!(arg.getAllValues().get(1) instanceof ContainerRequestEvent)) {
            junit.framework.Assert.fail((String)"Second Event not of type ContainerRequestEvent");
        }
        HashMap<String, Boolean> expected = new HashMap<String, Boolean>();
        expected.put("host1", true);
        expected.put("host2", true);
        expected.put("host3", true);
        ContainerRequestEvent cre = (ContainerRequestEvent)arg.getAllValues().get(1);
        for (String h : requestedHosts = cre.getHosts()) {
            expected.remove(h);
        }
        Assert.assertEquals((long)0L, (long)expected.size());
    }

    @Test
    public void testSlotMillisCounterUpdate() throws Exception {
        this.verifySlotMillis(2048, 2048, 1024);
        this.verifySlotMillis(2048, 1024, 1024);
        this.verifySlotMillis(10240, 1024, 2048);
    }

    public void verifySlotMillis(int mapMemMb, int reduceMemMb, int minContainerSize) throws Exception {
        SystemClock actualClock = new SystemClock();
        ControlledClock clock = new ControlledClock((Clock)actualClock);
        clock.setTime(10L);
        MRApp app = new MRApp(1, 1, false, "testSlotMillisCounterUpdate", true, (Clock)clock);
        Configuration conf = new Configuration();
        conf.setInt("mapreduce.map.memory.mb", mapMemMb);
        conf.setInt("mapreduce.reduce.memory.mb", reduceMemMb);
        conf.setInt("yarn.scheduler.minimum-allocation-mb", minContainerSize);
        app.setClusterInfo(new ClusterInfo(Resource.newInstance((int)10240, (int)1)));
        Job job = app.submit(conf);
        app.waitForState(job, JobState.RUNNING);
        Map tasks = job.getTasks();
        junit.framework.Assert.assertEquals((String)"Num tasks is not correct", (int)2, (int)tasks.size());
        Iterator taskIter = tasks.values().iterator();
        Task mTask = (Task)taskIter.next();
        app.waitForState(mTask, TaskState.RUNNING);
        Task rTask = (Task)taskIter.next();
        app.waitForState(rTask, TaskState.RUNNING);
        Map mAttempts = mTask.getAttempts();
        junit.framework.Assert.assertEquals((String)"Num attempts is not correct", (int)1, (int)mAttempts.size());
        Map rAttempts = rTask.getAttempts();
        junit.framework.Assert.assertEquals((String)"Num attempts is not correct", (int)1, (int)rAttempts.size());
        TaskAttempt mta = (TaskAttempt)mAttempts.values().iterator().next();
        TaskAttempt rta = (TaskAttempt)rAttempts.values().iterator().next();
        app.waitForState(mta, TaskAttemptState.RUNNING);
        app.waitForState(rta, TaskAttemptState.RUNNING);
        clock.setTime(11L);
        app.getContext().getEventHandler().handle((Event)new TaskAttemptEvent(mta.getID(), TaskAttemptEventType.TA_DONE));
        app.getContext().getEventHandler().handle((Event)new TaskAttemptEvent(rta.getID(), TaskAttemptEventType.TA_DONE));
        app.waitForState(job, JobState.SUCCEEDED);
        junit.framework.Assert.assertEquals((long)mta.getFinishTime(), (long)11L);
        junit.framework.Assert.assertEquals((long)mta.getLaunchTime(), (long)10L);
        junit.framework.Assert.assertEquals((long)rta.getFinishTime(), (long)11L);
        junit.framework.Assert.assertEquals((long)rta.getLaunchTime(), (long)10L);
        junit.framework.Assert.assertEquals((long)((int)Math.ceil((float)mapMemMb / (float)minContainerSize)), (long)job.getAllCounters().findCounter((Enum)JobCounter.SLOTS_MILLIS_MAPS).getValue());
        junit.framework.Assert.assertEquals((long)((int)Math.ceil((float)reduceMemMb / (float)minContainerSize)), (long)job.getAllCounters().findCounter((Enum)JobCounter.SLOTS_MILLIS_REDUCES).getValue());
    }

    private TaskAttemptImpl createMapTaskAttemptImplForTest(EventHandler eventHandler, JobSplit.TaskSplitMetaInfo taskSplitMetaInfo) {
        SystemClock clock = new SystemClock();
        return this.createMapTaskAttemptImplForTest(eventHandler, taskSplitMetaInfo, (Clock)clock);
    }

    private TaskAttemptImpl createMapTaskAttemptImplForTest(EventHandler eventHandler, JobSplit.TaskSplitMetaInfo taskSplitMetaInfo, Clock clock) {
        ApplicationId appId = ApplicationId.newInstance((long)1L, (int)1);
        JobId jobId = MRBuilderUtils.newJobId((ApplicationId)appId, (int)1);
        TaskId taskId = MRBuilderUtils.newTaskId((JobId)jobId, (int)1, (TaskType)TaskType.MAP);
        TaskAttemptListener taListener = (TaskAttemptListener)Mockito.mock(TaskAttemptListener.class);
        Path jobFile = (Path)Mockito.mock(Path.class);
        JobConf jobConf = new JobConf();
        MapTaskAttemptImpl taImpl = new MapTaskAttemptImpl(taskId, 1, eventHandler, jobFile, 1, taskSplitMetaInfo, jobConf, taListener, null, null, clock, null);
        return taImpl;
    }

    private void testMRAppHistory(MRApp app) throws Exception {
        Configuration conf = new Configuration();
        Job job = app.submit(conf);
        app.waitForState(job, JobState.FAILED);
        Map tasks = job.getTasks();
        junit.framework.Assert.assertEquals((String)"Num tasks is not correct", (int)1, (int)tasks.size());
        Task task = (Task)tasks.values().iterator().next();
        junit.framework.Assert.assertEquals((String)"Task state not correct", (Object)TaskState.FAILED, (Object)task.getReport().getTaskState());
        Map attempts = ((Task)tasks.values().iterator().next()).getAttempts();
        junit.framework.Assert.assertEquals((String)"Num attempts is not correct", (int)4, (int)attempts.size());
        Iterator it = attempts.values().iterator();
        TaskAttemptReport report = ((TaskAttempt)it.next()).getReport();
        junit.framework.Assert.assertEquals((String)"Attempt state not correct", (Object)TaskAttemptState.FAILED, (Object)report.getTaskAttemptState());
        junit.framework.Assert.assertEquals((String)"Diagnostic Information is not Correct", (String)"Test Diagnostic Event", (String)report.getDiagnosticInfo());
        report = ((TaskAttempt)it.next()).getReport();
        junit.framework.Assert.assertEquals((String)"Attempt state not correct", (Object)TaskAttemptState.FAILED, (Object)report.getTaskAttemptState());
    }

    @Test
    public void testLaunchFailedWhileKilling() throws Exception {
        ApplicationId appId = ApplicationId.newInstance((long)1L, (int)2);
        ApplicationAttemptId appAttemptId = ApplicationAttemptId.newInstance((ApplicationId)appId, (int)0);
        JobId jobId = MRBuilderUtils.newJobId((ApplicationId)appId, (int)1);
        TaskId taskId = MRBuilderUtils.newTaskId((JobId)jobId, (int)1, (TaskType)TaskType.MAP);
        TaskAttemptId attemptId = MRBuilderUtils.newTaskAttemptId((TaskId)taskId, (int)0);
        Path jobFile = (Path)Mockito.mock(Path.class);
        MockEventHandler eventHandler = new MockEventHandler();
        TaskAttemptListener taListener = (TaskAttemptListener)Mockito.mock(TaskAttemptListener.class);
        Mockito.when((Object)taListener.getAddress()).thenReturn((Object)new InetSocketAddress("localhost", 0));
        JobConf jobConf = new JobConf();
        jobConf.setClass("fs.file.impl", StubbedFS.class, FileSystem.class);
        jobConf.setBoolean("fs.file.impl.disable.cache", true);
        jobConf.set("mapreduce.map.env", "");
        jobConf.set("mapreduce.job.application.attempt.id", "10");
        JobSplit.TaskSplitMetaInfo splits = (JobSplit.TaskSplitMetaInfo)Mockito.mock(JobSplit.TaskSplitMetaInfo.class);
        Mockito.when((Object)splits.getLocations()).thenReturn((Object)new String[]{"127.0.0.1"});
        MapTaskAttemptImpl taImpl = new MapTaskAttemptImpl(taskId, 1, (EventHandler)eventHandler, jobFile, 1, splits, jobConf, taListener, (Token)Mockito.mock(Token.class), new Credentials(), (Clock)new SystemClock(), null);
        NodeId nid = NodeId.newInstance((String)"127.0.0.1", (int)0);
        ContainerId contId = ContainerId.newInstance((ApplicationAttemptId)appAttemptId, (int)3);
        Container container = (Container)Mockito.mock(Container.class);
        Mockito.when((Object)container.getId()).thenReturn((Object)contId);
        Mockito.when((Object)container.getNodeId()).thenReturn((Object)nid);
        taImpl.handle(new TaskAttemptEvent(attemptId, TaskAttemptEventType.TA_SCHEDULE));
        taImpl.handle((TaskAttemptEvent)new TaskAttemptContainerAssignedEvent(attemptId, container, (Map)Mockito.mock(Map.class)));
        taImpl.handle(new TaskAttemptEvent(attemptId, TaskAttemptEventType.TA_KILL));
        taImpl.handle(new TaskAttemptEvent(attemptId, TaskAttemptEventType.TA_CONTAINER_CLEANED));
        taImpl.handle(new TaskAttemptEvent(attemptId, TaskAttemptEventType.TA_CONTAINER_LAUNCH_FAILED));
        Assert.assertFalse((boolean)eventHandler.internalError);
        Assert.assertEquals((String)"Task attempt is not assigned on the local node", (Object)Locality.NODE_LOCAL, (Object)taImpl.getLocality());
    }

    @Test
    public void testContainerCleanedWhileRunning() throws Exception {
        ApplicationId appId = ApplicationId.newInstance((long)1L, (int)2);
        ApplicationAttemptId appAttemptId = ApplicationAttemptId.newInstance((ApplicationId)appId, (int)0);
        JobId jobId = MRBuilderUtils.newJobId((ApplicationId)appId, (int)1);
        TaskId taskId = MRBuilderUtils.newTaskId((JobId)jobId, (int)1, (TaskType)TaskType.MAP);
        TaskAttemptId attemptId = MRBuilderUtils.newTaskAttemptId((TaskId)taskId, (int)0);
        Path jobFile = (Path)Mockito.mock(Path.class);
        MockEventHandler eventHandler = new MockEventHandler();
        TaskAttemptListener taListener = (TaskAttemptListener)Mockito.mock(TaskAttemptListener.class);
        Mockito.when((Object)taListener.getAddress()).thenReturn((Object)new InetSocketAddress("localhost", 0));
        JobConf jobConf = new JobConf();
        jobConf.setClass("fs.file.impl", StubbedFS.class, FileSystem.class);
        jobConf.setBoolean("fs.file.impl.disable.cache", true);
        jobConf.set("mapreduce.map.env", "");
        jobConf.set("mapreduce.job.application.attempt.id", "10");
        JobSplit.TaskSplitMetaInfo splits = (JobSplit.TaskSplitMetaInfo)Mockito.mock(JobSplit.TaskSplitMetaInfo.class);
        Mockito.when((Object)splits.getLocations()).thenReturn((Object)new String[]{"127.0.0.1"});
        AppContext appCtx = (AppContext)Mockito.mock(AppContext.class);
        ClusterInfo clusterInfo = (ClusterInfo)Mockito.mock(ClusterInfo.class);
        Resource resource = (Resource)Mockito.mock(Resource.class);
        Mockito.when((Object)appCtx.getClusterInfo()).thenReturn((Object)clusterInfo);
        Mockito.when((Object)resource.getMemory()).thenReturn((Object)1024);
        MapTaskAttemptImpl taImpl = new MapTaskAttemptImpl(taskId, 1, (EventHandler)eventHandler, jobFile, 1, splits, jobConf, taListener, (Token)Mockito.mock(Token.class), new Credentials(), (Clock)new SystemClock(), appCtx);
        NodeId nid = NodeId.newInstance((String)"127.0.0.2", (int)0);
        ContainerId contId = ContainerId.newInstance((ApplicationAttemptId)appAttemptId, (int)3);
        Container container = (Container)Mockito.mock(Container.class);
        Mockito.when((Object)container.getId()).thenReturn((Object)contId);
        Mockito.when((Object)container.getNodeId()).thenReturn((Object)nid);
        Mockito.when((Object)container.getNodeHttpAddress()).thenReturn((Object)"localhost:0");
        taImpl.handle(new TaskAttemptEvent(attemptId, TaskAttemptEventType.TA_SCHEDULE));
        taImpl.handle((TaskAttemptEvent)new TaskAttemptContainerAssignedEvent(attemptId, container, (Map)Mockito.mock(Map.class)));
        taImpl.handle((TaskAttemptEvent)new TaskAttemptContainerLaunchedEvent(attemptId, 0));
        Assert.assertEquals((String)"Task attempt is not in running state", (Object)taImpl.getState(), (Object)TaskAttemptState.RUNNING);
        taImpl.handle(new TaskAttemptEvent(attemptId, TaskAttemptEventType.TA_CONTAINER_CLEANED));
        Assert.assertFalse((String)"InternalError occurred trying to handle TA_CONTAINER_CLEANED", (boolean)eventHandler.internalError);
        Assert.assertEquals((String)"Task attempt is not assigned on the local rack", (Object)Locality.RACK_LOCAL, (Object)taImpl.getLocality());
    }

    @Test
    public void testContainerCleanedWhileCommitting() throws Exception {
        ApplicationId appId = ApplicationId.newInstance((long)1L, (int)2);
        ApplicationAttemptId appAttemptId = ApplicationAttemptId.newInstance((ApplicationId)appId, (int)0);
        JobId jobId = MRBuilderUtils.newJobId((ApplicationId)appId, (int)1);
        TaskId taskId = MRBuilderUtils.newTaskId((JobId)jobId, (int)1, (TaskType)TaskType.MAP);
        TaskAttemptId attemptId = MRBuilderUtils.newTaskAttemptId((TaskId)taskId, (int)0);
        Path jobFile = (Path)Mockito.mock(Path.class);
        MockEventHandler eventHandler = new MockEventHandler();
        TaskAttemptListener taListener = (TaskAttemptListener)Mockito.mock(TaskAttemptListener.class);
        Mockito.when((Object)taListener.getAddress()).thenReturn((Object)new InetSocketAddress("localhost", 0));
        JobConf jobConf = new JobConf();
        jobConf.setClass("fs.file.impl", StubbedFS.class, FileSystem.class);
        jobConf.setBoolean("fs.file.impl.disable.cache", true);
        jobConf.set("mapreduce.map.env", "");
        jobConf.set("mapreduce.job.application.attempt.id", "10");
        JobSplit.TaskSplitMetaInfo splits = (JobSplit.TaskSplitMetaInfo)Mockito.mock(JobSplit.TaskSplitMetaInfo.class);
        Mockito.when((Object)splits.getLocations()).thenReturn((Object)new String[0]);
        AppContext appCtx = (AppContext)Mockito.mock(AppContext.class);
        ClusterInfo clusterInfo = (ClusterInfo)Mockito.mock(ClusterInfo.class);
        Resource resource = (Resource)Mockito.mock(Resource.class);
        Mockito.when((Object)appCtx.getClusterInfo()).thenReturn((Object)clusterInfo);
        Mockito.when((Object)resource.getMemory()).thenReturn((Object)1024);
        MapTaskAttemptImpl taImpl = new MapTaskAttemptImpl(taskId, 1, (EventHandler)eventHandler, jobFile, 1, splits, jobConf, taListener, (Token)Mockito.mock(Token.class), new Credentials(), (Clock)new SystemClock(), appCtx);
        NodeId nid = NodeId.newInstance((String)"127.0.0.1", (int)0);
        ContainerId contId = ContainerId.newInstance((ApplicationAttemptId)appAttemptId, (int)3);
        Container container = (Container)Mockito.mock(Container.class);
        Mockito.when((Object)container.getId()).thenReturn((Object)contId);
        Mockito.when((Object)container.getNodeId()).thenReturn((Object)nid);
        Mockito.when((Object)container.getNodeHttpAddress()).thenReturn((Object)"localhost:0");
        taImpl.handle(new TaskAttemptEvent(attemptId, TaskAttemptEventType.TA_SCHEDULE));
        taImpl.handle((TaskAttemptEvent)new TaskAttemptContainerAssignedEvent(attemptId, container, (Map)Mockito.mock(Map.class)));
        taImpl.handle((TaskAttemptEvent)new TaskAttemptContainerLaunchedEvent(attemptId, 0));
        taImpl.handle(new TaskAttemptEvent(attemptId, TaskAttemptEventType.TA_COMMIT_PENDING));
        Assert.assertEquals((String)"Task attempt is not in commit pending state", (Object)taImpl.getState(), (Object)TaskAttemptState.COMMIT_PENDING);
        taImpl.handle(new TaskAttemptEvent(attemptId, TaskAttemptEventType.TA_CONTAINER_CLEANED));
        Assert.assertFalse((String)"InternalError occurred trying to handle TA_CONTAINER_CLEANED", (boolean)eventHandler.internalError);
        Assert.assertEquals((String)"Task attempt is assigned locally", (Object)Locality.OFF_SWITCH, (Object)taImpl.getLocality());
    }

    @Test
    public void testDoubleTooManyFetchFailure() throws Exception {
        ApplicationId appId = ApplicationId.newInstance((long)1L, (int)2);
        ApplicationAttemptId appAttemptId = ApplicationAttemptId.newInstance((ApplicationId)appId, (int)0);
        JobId jobId = MRBuilderUtils.newJobId((ApplicationId)appId, (int)1);
        TaskId taskId = MRBuilderUtils.newTaskId((JobId)jobId, (int)1, (TaskType)TaskType.MAP);
        TaskAttemptId attemptId = MRBuilderUtils.newTaskAttemptId((TaskId)taskId, (int)0);
        Path jobFile = (Path)Mockito.mock(Path.class);
        MockEventHandler eventHandler = new MockEventHandler();
        TaskAttemptListener taListener = (TaskAttemptListener)Mockito.mock(TaskAttemptListener.class);
        Mockito.when((Object)taListener.getAddress()).thenReturn((Object)new InetSocketAddress("localhost", 0));
        JobConf jobConf = new JobConf();
        jobConf.setClass("fs.file.impl", StubbedFS.class, FileSystem.class);
        jobConf.setBoolean("fs.file.impl.disable.cache", true);
        jobConf.set("mapreduce.map.env", "");
        jobConf.set("mapreduce.job.application.attempt.id", "10");
        JobSplit.TaskSplitMetaInfo splits = (JobSplit.TaskSplitMetaInfo)Mockito.mock(JobSplit.TaskSplitMetaInfo.class);
        Mockito.when((Object)splits.getLocations()).thenReturn((Object)new String[]{"127.0.0.1"});
        AppContext appCtx = (AppContext)Mockito.mock(AppContext.class);
        ClusterInfo clusterInfo = (ClusterInfo)Mockito.mock(ClusterInfo.class);
        Resource resource = (Resource)Mockito.mock(Resource.class);
        Mockito.when((Object)appCtx.getClusterInfo()).thenReturn((Object)clusterInfo);
        Mockito.when((Object)resource.getMemory()).thenReturn((Object)1024);
        MapTaskAttemptImpl taImpl = new MapTaskAttemptImpl(taskId, 1, (EventHandler)eventHandler, jobFile, 1, splits, jobConf, taListener, (Token)Mockito.mock(Token.class), new Credentials(), (Clock)new SystemClock(), appCtx);
        NodeId nid = NodeId.newInstance((String)"127.0.0.1", (int)0);
        ContainerId contId = ContainerId.newInstance((ApplicationAttemptId)appAttemptId, (int)3);
        Container container = (Container)Mockito.mock(Container.class);
        Mockito.when((Object)container.getId()).thenReturn((Object)contId);
        Mockito.when((Object)container.getNodeId()).thenReturn((Object)nid);
        Mockito.when((Object)container.getNodeHttpAddress()).thenReturn((Object)"localhost:0");
        taImpl.handle(new TaskAttemptEvent(attemptId, TaskAttemptEventType.TA_SCHEDULE));
        taImpl.handle((TaskAttemptEvent)new TaskAttemptContainerAssignedEvent(attemptId, container, (Map)Mockito.mock(Map.class)));
        taImpl.handle((TaskAttemptEvent)new TaskAttemptContainerLaunchedEvent(attemptId, 0));
        taImpl.handle(new TaskAttemptEvent(attemptId, TaskAttemptEventType.TA_DONE));
        taImpl.handle(new TaskAttemptEvent(attemptId, TaskAttemptEventType.TA_CONTAINER_CLEANED));
        Assert.assertEquals((String)"Task attempt is not in succeeded state", (Object)taImpl.getState(), (Object)TaskAttemptState.SUCCEEDED);
        taImpl.handle(new TaskAttemptEvent(attemptId, TaskAttemptEventType.TA_TOO_MANY_FETCH_FAILURE));
        Assert.assertEquals((String)"Task attempt is not in FAILED state", (Object)taImpl.getState(), (Object)TaskAttemptState.FAILED);
        taImpl.handle(new TaskAttemptEvent(attemptId, TaskAttemptEventType.TA_TOO_MANY_FETCH_FAILURE));
        Assert.assertEquals((String)"Task attempt is not in FAILED state, still", (Object)taImpl.getState(), (Object)TaskAttemptState.FAILED);
        Assert.assertFalse((String)"InternalError occurred trying to handle TA_CONTAINER_CLEANED", (boolean)eventHandler.internalError);
    }

    @Test
    public void testAppDiognosticEventOnUnassignedTask() throws Exception {
        ApplicationId appId = ApplicationId.newInstance((long)1L, (int)2);
        ApplicationAttemptId appAttemptId = ApplicationAttemptId.newInstance((ApplicationId)appId, (int)0);
        JobId jobId = MRBuilderUtils.newJobId((ApplicationId)appId, (int)1);
        TaskId taskId = MRBuilderUtils.newTaskId((JobId)jobId, (int)1, (TaskType)TaskType.MAP);
        TaskAttemptId attemptId = MRBuilderUtils.newTaskAttemptId((TaskId)taskId, (int)0);
        Path jobFile = (Path)Mockito.mock(Path.class);
        MockEventHandler eventHandler = new MockEventHandler();
        TaskAttemptListener taListener = (TaskAttemptListener)Mockito.mock(TaskAttemptListener.class);
        Mockito.when((Object)taListener.getAddress()).thenReturn((Object)new InetSocketAddress("localhost", 0));
        JobConf jobConf = new JobConf();
        jobConf.setClass("fs.file.impl", StubbedFS.class, FileSystem.class);
        jobConf.setBoolean("fs.file.impl.disable.cache", true);
        jobConf.set("mapreduce.map.env", "");
        jobConf.set("mapreduce.job.application.attempt.id", "10");
        JobSplit.TaskSplitMetaInfo splits = (JobSplit.TaskSplitMetaInfo)Mockito.mock(JobSplit.TaskSplitMetaInfo.class);
        Mockito.when((Object)splits.getLocations()).thenReturn((Object)new String[]{"127.0.0.1"});
        AppContext appCtx = (AppContext)Mockito.mock(AppContext.class);
        ClusterInfo clusterInfo = (ClusterInfo)Mockito.mock(ClusterInfo.class);
        Resource resource = (Resource)Mockito.mock(Resource.class);
        Mockito.when((Object)appCtx.getClusterInfo()).thenReturn((Object)clusterInfo);
        Mockito.when((Object)resource.getMemory()).thenReturn((Object)1024);
        MapTaskAttemptImpl taImpl = new MapTaskAttemptImpl(taskId, 1, (EventHandler)eventHandler, jobFile, 1, splits, jobConf, taListener, (Token)Mockito.mock(Token.class), new Credentials(), (Clock)new SystemClock(), appCtx);
        NodeId nid = NodeId.newInstance((String)"127.0.0.1", (int)0);
        ContainerId contId = ContainerId.newInstance((ApplicationAttemptId)appAttemptId, (int)3);
        Container container = (Container)Mockito.mock(Container.class);
        Mockito.when((Object)container.getId()).thenReturn((Object)contId);
        Mockito.when((Object)container.getNodeId()).thenReturn((Object)nid);
        Mockito.when((Object)container.getNodeHttpAddress()).thenReturn((Object)"localhost:0");
        taImpl.handle(new TaskAttemptEvent(attemptId, TaskAttemptEventType.TA_SCHEDULE));
        taImpl.handle((TaskAttemptEvent)new TaskAttemptDiagnosticsUpdateEvent(attemptId, "Task got killed"));
        Assert.assertFalse((String)"InternalError occurred trying to handle TA_DIAGNOSTICS_UPDATE on assigned task", (boolean)eventHandler.internalError);
    }

    @Test
    public void testAppDiognosticEventOnNewTask() throws Exception {
        ApplicationId appId = ApplicationId.newInstance((long)1L, (int)2);
        ApplicationAttemptId appAttemptId = ApplicationAttemptId.newInstance((ApplicationId)appId, (int)0);
        JobId jobId = MRBuilderUtils.newJobId((ApplicationId)appId, (int)1);
        TaskId taskId = MRBuilderUtils.newTaskId((JobId)jobId, (int)1, (TaskType)TaskType.MAP);
        TaskAttemptId attemptId = MRBuilderUtils.newTaskAttemptId((TaskId)taskId, (int)0);
        Path jobFile = (Path)Mockito.mock(Path.class);
        MockEventHandler eventHandler = new MockEventHandler();
        TaskAttemptListener taListener = (TaskAttemptListener)Mockito.mock(TaskAttemptListener.class);
        Mockito.when((Object)taListener.getAddress()).thenReturn((Object)new InetSocketAddress("localhost", 0));
        JobConf jobConf = new JobConf();
        jobConf.setClass("fs.file.impl", StubbedFS.class, FileSystem.class);
        jobConf.setBoolean("fs.file.impl.disable.cache", true);
        jobConf.set("mapreduce.map.env", "");
        jobConf.set("mapreduce.job.application.attempt.id", "10");
        JobSplit.TaskSplitMetaInfo splits = (JobSplit.TaskSplitMetaInfo)Mockito.mock(JobSplit.TaskSplitMetaInfo.class);
        Mockito.when((Object)splits.getLocations()).thenReturn((Object)new String[]{"127.0.0.1"});
        AppContext appCtx = (AppContext)Mockito.mock(AppContext.class);
        ClusterInfo clusterInfo = (ClusterInfo)Mockito.mock(ClusterInfo.class);
        Resource resource = (Resource)Mockito.mock(Resource.class);
        Mockito.when((Object)appCtx.getClusterInfo()).thenReturn((Object)clusterInfo);
        Mockito.when((Object)resource.getMemory()).thenReturn((Object)1024);
        MapTaskAttemptImpl taImpl = new MapTaskAttemptImpl(taskId, 1, (EventHandler)eventHandler, jobFile, 1, splits, jobConf, taListener, (Token)Mockito.mock(Token.class), new Credentials(), (Clock)new SystemClock(), appCtx);
        NodeId nid = NodeId.newInstance((String)"127.0.0.1", (int)0);
        ContainerId contId = ContainerId.newInstance((ApplicationAttemptId)appAttemptId, (int)3);
        Container container = (Container)Mockito.mock(Container.class);
        Mockito.when((Object)container.getId()).thenReturn((Object)contId);
        Mockito.when((Object)container.getNodeId()).thenReturn((Object)nid);
        Mockito.when((Object)container.getNodeHttpAddress()).thenReturn((Object)"localhost:0");
        taImpl.handle((TaskAttemptEvent)new TaskAttemptDiagnosticsUpdateEvent(attemptId, "Task got killed"));
        Assert.assertFalse((String)"InternalError occurred trying to handle TA_DIAGNOSTICS_UPDATE on assigned task", (boolean)eventHandler.internalError);
    }
}

