/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.v2.app.rm;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.JobID;
import org.apache.hadoop.mapreduce.TypeConverter;
import org.apache.hadoop.mapreduce.v2.api.records.JobId;
import org.apache.hadoop.mapreduce.v2.app.AppContext;
import org.apache.hadoop.mapreduce.v2.app.client.ClientService;
import org.apache.hadoop.mapreduce.v2.app.job.Job;
import org.apache.hadoop.mapreduce.v2.app.job.JobStateInternal;
import org.apache.hadoop.mapreduce.v2.app.job.impl.JobImpl;
import org.apache.hadoop.mapreduce.v2.app.rm.RMContainerAllocator;
import org.apache.hadoop.mapreduce.v2.app.rm.RMHeartbeatHandler;
import org.apache.hadoop.mapreduce.v2.jobhistory.JobHistoryUtils;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.service.AbstractService;
import org.apache.hadoop.yarn.api.ApplicationMasterProtocol;
import org.apache.hadoop.yarn.api.protocolrecords.FinishApplicationMasterRequest;
import org.apache.hadoop.yarn.api.protocolrecords.RegisterApplicationMasterRequest;
import org.apache.hadoop.yarn.api.protocolrecords.RegisterApplicationMasterResponse;
import org.apache.hadoop.yarn.api.records.ApplicationAccessType;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.FinalApplicationStatus;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.client.ClientRMProxy;
import org.apache.hadoop.yarn.event.EventHandler;
import org.apache.hadoop.yarn.exceptions.YarnRuntimeException;
import org.apache.hadoop.yarn.factories.RecordFactory;
import org.apache.hadoop.yarn.factory.providers.RecordFactoryProvider;

public abstract class RMCommunicator
extends AbstractService
implements RMHeartbeatHandler {
    private static final Log LOG = LogFactory.getLog(RMContainerAllocator.class);
    private int rmPollInterval;
    protected ApplicationId applicationId;
    private final AtomicBoolean stopped;
    protected Thread allocatorThread;
    protected EventHandler eventHandler;
    protected ApplicationMasterProtocol scheduler;
    private final ClientService clientService;
    protected int lastResponseID;
    private Resource maxContainerCapability;
    protected Map<ApplicationAccessType, String> applicationACLs;
    private volatile long lastHeartbeatTime;
    private ConcurrentLinkedQueue<Runnable> heartbeatCallbacks;
    private final RecordFactory recordFactory = RecordFactoryProvider.getRecordFactory(null);
    private final AppContext context;
    private Job job;
    protected volatile boolean isSignalled = false;
    private volatile boolean shouldUnregister = true;

    public RMCommunicator(ClientService clientService, AppContext context) {
        super("RMCommunicator");
        this.clientService = clientService;
        this.context = context;
        this.eventHandler = context.getEventHandler();
        this.applicationId = context.getApplicationID();
        this.stopped = new AtomicBoolean(false);
        this.heartbeatCallbacks = new ConcurrentLinkedQueue();
    }

    protected void serviceInit(Configuration conf) throws Exception {
        super.serviceInit(conf);
        this.rmPollInterval = conf.getInt("yarn.app.mapreduce.am.scheduler.heartbeat.interval-ms", 1000);
    }

    protected void serviceStart() throws Exception {
        this.scheduler = this.createSchedulerProxy();
        this.register();
        this.startAllocatorThread();
        JobID id = TypeConverter.fromYarn((ApplicationId)this.applicationId);
        JobId jobId = TypeConverter.toYarn((JobID)id);
        this.job = this.context.getJob(jobId);
        super.serviceStart();
    }

    protected AppContext getContext() {
        return this.context;
    }

    protected Job getJob() {
        return this.job;
    }

    protected float getApplicationProgress() {
        return this.job.getProgress();
    }

    protected void register() {
        InetSocketAddress serviceAddr = null;
        if (this.clientService != null) {
            serviceAddr = this.clientService.getBindAddress();
        }
        try {
            RegisterApplicationMasterRequest request = (RegisterApplicationMasterRequest)this.recordFactory.newRecordInstance(RegisterApplicationMasterRequest.class);
            if (serviceAddr != null) {
                request.setHost(serviceAddr.getHostName());
                request.setRpcPort(serviceAddr.getPort());
                request.setTrackingUrl(serviceAddr.getHostName() + ":" + this.clientService.getHttpPort());
            }
            RegisterApplicationMasterResponse response = this.scheduler.registerApplicationMaster(request);
            this.maxContainerCapability = response.getMaximumResourceCapability();
            this.context.getClusterInfo().setMaxContainerCapability(this.maxContainerCapability);
            if (UserGroupInformation.isSecurityEnabled()) {
                this.setClientToAMToken(response.getClientToAMTokenMasterKey());
            }
            this.applicationACLs = response.getApplicationACLs();
            LOG.info((Object)("maxContainerCapability: " + this.maxContainerCapability.getMemory()));
        }
        catch (Exception are) {
            LOG.error((Object)"Exception while registering", (Throwable)are);
            throw new YarnRuntimeException((Throwable)are);
        }
    }

    private void setClientToAMToken(ByteBuffer clientToAMTokenMasterKey) {
        byte[] key = clientToAMTokenMasterKey.array();
        this.context.getClientToAMTokenSecretManager().setMasterKey(key);
    }

    protected void unregister() {
        try {
            FinalApplicationStatus finishState = FinalApplicationStatus.UNDEFINED;
            JobImpl jobImpl = (JobImpl)this.job;
            if (jobImpl.getInternalState() == JobStateInternal.SUCCEEDED) {
                finishState = FinalApplicationStatus.SUCCEEDED;
            } else if (jobImpl.getInternalState() == JobStateInternal.KILLED || jobImpl.getInternalState() == JobStateInternal.RUNNING && this.isSignalled) {
                finishState = FinalApplicationStatus.KILLED;
            } else if (jobImpl.getInternalState() == JobStateInternal.FAILED || jobImpl.getInternalState() == JobStateInternal.ERROR) {
                finishState = FinalApplicationStatus.FAILED;
            }
            StringBuffer sb = new StringBuffer();
            for (String s : this.job.getDiagnostics()) {
                sb.append(s).append("\n");
            }
            LOG.info((Object)("Setting job diagnostics to " + sb.toString()));
            String historyUrl = JobHistoryUtils.getHistoryUrl((Configuration)this.getConfig(), (ApplicationId)this.context.getApplicationID());
            LOG.info((Object)("History url is " + historyUrl));
            FinishApplicationMasterRequest request = FinishApplicationMasterRequest.newInstance((FinalApplicationStatus)finishState, (String)sb.toString(), (String)historyUrl);
            this.scheduler.finishApplicationMaster(request);
        }
        catch (Exception are) {
            LOG.error((Object)"Exception while unregistering ", (Throwable)are);
        }
    }

    protected Resource getMaxContainerCapability() {
        return this.maxContainerCapability;
    }

    protected void serviceStop() throws Exception {
        if (this.stopped.getAndSet(true)) {
            return;
        }
        if (this.allocatorThread != null) {
            this.allocatorThread.interrupt();
            try {
                this.allocatorThread.join();
            }
            catch (InterruptedException ie) {
                LOG.warn((Object)"InterruptedException while stopping", (Throwable)ie);
            }
        }
        if (this.shouldUnregister) {
            this.unregister();
        }
        super.serviceStop();
    }

    protected void startAllocatorThread() {
        this.allocatorThread = new Thread((Runnable)new /* Unavailable Anonymous Inner Class!! */);
        this.allocatorThread.setName("RMCommunicator Allocator");
        this.allocatorThread.start();
    }

    protected ApplicationMasterProtocol createSchedulerProxy() {
        Configuration conf = this.getConfig();
        try {
            return (ApplicationMasterProtocol)ClientRMProxy.createRMProxy((Configuration)conf, ApplicationMasterProtocol.class);
        }
        catch (IOException e) {
            throw new YarnRuntimeException((Throwable)e);
        }
    }

    protected abstract void heartbeat() throws Exception;

    private void executeHeartbeatCallbacks() {
        Runnable callback = null;
        while ((callback = (Runnable)this.heartbeatCallbacks.poll()) != null) {
            callback.run();
        }
    }

    public long getLastHeartbeatTime() {
        return this.lastHeartbeatTime;
    }

    public void runOnNextHeartbeat(Runnable callback) {
        this.heartbeatCallbacks.add(callback);
    }

    public void setShouldUnregister(boolean shouldUnregister) {
        this.shouldUnregister = shouldUnregister;
        LOG.info((Object)("RMCommunicator notified that shouldUnregistered is: " + shouldUnregister));
    }

    public void setSignalled(boolean isSignalled) {
        this.isSignalled = isSignalled;
        LOG.info((Object)("RMCommunicator notified that iSignalled is: " + isSignalled));
    }

    static /* synthetic */ AtomicBoolean access$000(RMCommunicator x0) {
        return x0.stopped;
    }

    static /* synthetic */ int access$100(RMCommunicator x0) {
        return x0.rmPollInterval;
    }

    static /* synthetic */ Log access$200() {
        return LOG;
    }

    static /* synthetic */ long access$302(RMCommunicator x0, long x1) {
        x0.lastHeartbeatTime = x1;
        return x0.lastHeartbeatTime;
    }

    static /* synthetic */ AppContext access$400(RMCommunicator x0) {
        return x0.context;
    }

    static /* synthetic */ void access$500(RMCommunicator x0) {
        x0.executeHeartbeatCallbacks();
    }
}

