/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.v2.app.webapp;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.v2.app.AppContext;
import org.apache.hadoop.mapreduce.v2.app.webapp.App;
import org.apache.hadoop.mapreduce.v2.app.webapp.AppController;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.webapp.Controller;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;

public class TestAppController {
    private AppController appController;
    private Controller.RequestContext ctx;

    @Before
    public void setUp() {
        AppContext context = (AppContext)Mockito.mock(AppContext.class);
        Mockito.when((Object)context.getApplicationID()).thenReturn((Object)ApplicationId.newInstance((long)0L, (int)0));
        App app = new App(context);
        Configuration conf = new Configuration();
        this.ctx = (Controller.RequestContext)Mockito.mock(Controller.RequestContext.class);
        this.appController = new AppController(app, conf, this.ctx);
    }

    @Test
    public void testBadRequest() {
        String message = "test string";
        this.appController.badRequest(message);
        this.verifyExpectations(message);
    }

    @Test
    public void testBadRequestWithNullMessage() {
        this.appController.badRequest(null);
        this.verifyExpectations("");
    }

    private void verifyExpectations(String message) {
        ((Controller.RequestContext)Mockito.verify((Object)this.ctx)).setStatus(400);
        ((Controller.RequestContext)Mockito.verify((Object)this.ctx)).set("app.id", "application_0_0000");
        ((Controller.RequestContext)Mockito.verify((Object)this.ctx)).set((String)Matchers.eq((Object)"rm.web"), Matchers.anyString());
        ((Controller.RequestContext)Mockito.verify((Object)this.ctx)).set("title", "Bad request: " + message);
    }
}

