/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.net.InetSocketAddress;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.Task;
import org.apache.hadoop.mapred.TaskAttemptID;
import org.apache.hadoop.mapred.TaskLog;
import org.apache.hadoop.mapred.YarnChild;
import org.apache.hadoop.mapreduce.ID;
import org.apache.hadoop.mapreduce.v2.util.MRApps;
import org.apache.hadoop.yarn.api.ApplicationConstants;
import org.apache.hadoop.yarn.util.Apps;

public class MapReduceChildJVM {
    private static String getTaskLogFile(TaskLog.LogName filter) {
        return "<LOG_DIR>/" + filter.toString();
    }

    private static String getChildEnv(JobConf jobConf, boolean isMap) {
        if (isMap) {
            return jobConf.get("mapreduce.map.env", jobConf.get("mapred.child.env"));
        }
        return jobConf.get("mapreduce.reduce.env", jobConf.get("mapred.child.env"));
    }

    private static String getChildLogLevel(JobConf conf, boolean isMap) {
        if (isMap) {
            return conf.get("mapreduce.map.log.level", JobConf.DEFAULT_LOG_LEVEL.toString());
        }
        return conf.get("mapreduce.reduce.log.level", JobConf.DEFAULT_LOG_LEVEL.toString());
    }

    public static void setVMEnv(Map<String, String> environment, Task task) {
        JobConf conf = task.conf;
        String mapredChildEnv = MapReduceChildJVM.getChildEnv(conf, task.isMapTask());
        Apps.setEnvFromInputString(environment, (String)mapredChildEnv);
        environment.put("HADOOP_ROOT_LOGGER", MapReduceChildJVM.getChildLogLevel(conf, task.isMapTask()) + ",CLA");
        String hadoopClientOpts = System.getenv("HADOOP_CLIENT_OPTS");
        hadoopClientOpts = hadoopClientOpts == null ? "" : hadoopClientOpts + " ";
        long logSize = TaskLog.getTaskLogLength((JobConf)conf);
        Vector<String> logProps = new Vector<String>(4);
        MapReduceChildJVM.setupLog4jProperties(task, logProps, logSize);
        Iterator<String> it = logProps.iterator();
        StringBuffer buffer = new StringBuffer();
        while (it.hasNext()) {
            buffer.append(" " + it.next());
        }
        hadoopClientOpts = hadoopClientOpts + buffer.toString();
        environment.put("HADOOP_CLIENT_OPTS", hadoopClientOpts);
        environment.put("STDOUT_LOGFILE_ENV", MapReduceChildJVM.getTaskLogFile(TaskLog.LogName.STDOUT));
        environment.put("STDERR_LOGFILE_ENV", MapReduceChildJVM.getTaskLogFile(TaskLog.LogName.STDERR));
    }

    private static String getChildJavaOpts(JobConf jobConf, boolean isMapTask) {
        String userClasspath = "";
        String adminClasspath = "";
        if (isMapTask) {
            userClasspath = jobConf.get("mapreduce.map.java.opts", jobConf.get("mapred.child.java.opts", "-Xmx200m"));
            adminClasspath = jobConf.get("mapreduce.admin.map.child.java.opts", "-Djava.net.preferIPv4Stack=true -Dhadoop.metrics.log.level=WARN ");
        } else {
            userClasspath = jobConf.get("mapreduce.reduce.java.opts", jobConf.get("mapred.child.java.opts", "-Xmx200m"));
            adminClasspath = jobConf.get("mapreduce.admin.reduce.child.java.opts", "-Djava.net.preferIPv4Stack=true -Dhadoop.metrics.log.level=WARN ");
        }
        return adminClasspath + " " + userClasspath;
    }

    private static void setupLog4jProperties(Task task, Vector<String> vargs, long logSize) {
        String logLevel = MapReduceChildJVM.getChildLogLevel(task.conf, task.isMapTask());
        MRApps.addLog4jSystemProperties((String)logLevel, (long)logSize, vargs);
    }

    public static List<String> getVMCommand(InetSocketAddress taskAttemptListenerAddr, Task task, ID jvmID) {
        TaskAttemptID attemptID = task.getTaskID();
        JobConf conf = task.conf;
        Vector<String> vargs = new Vector<String>(8);
        vargs.add(ApplicationConstants.Environment.JAVA_HOME.$() + "/bin/java");
        String javaOpts = MapReduceChildJVM.getChildJavaOpts(conf, task.isMapTask());
        javaOpts = javaOpts.replace("@taskid@", attemptID.toString());
        String[] javaOptsSplit = javaOpts.split(" ");
        for (int i = 0; i < javaOptsSplit.length; ++i) {
            vargs.add(javaOptsSplit[i]);
        }
        Path childTmpDir = new Path(ApplicationConstants.Environment.PWD.$(), "./tmp");
        vargs.add("-Djava.io.tmpdir=" + childTmpDir);
        long logSize = TaskLog.getTaskLogLength((JobConf)conf);
        MapReduceChildJVM.setupLog4jProperties(task, vargs, logSize);
        if (conf.getProfileEnabled() && conf.getProfileTaskRange(task.isMapTask()).isIncluded(task.getPartition())) {
            vargs.add(String.format(conf.getProfileParams(), MapReduceChildJVM.getTaskLogFile(TaskLog.LogName.PROFILE)));
            if (task.isMapTask()) {
                vargs.add(conf.get("mapreduce.task.profile.map.params", ""));
            } else {
                vargs.add(conf.get("mapreduce.task.profile.reduce.params", ""));
            }
        }
        vargs.add(YarnChild.class.getName());
        vargs.add(taskAttemptListenerAddr.getAddress().getHostAddress());
        vargs.add(Integer.toString(taskAttemptListenerAddr.getPort()));
        vargs.add(attemptID.toString());
        vargs.add(String.valueOf(jvmID.getId()));
        vargs.add("1>" + MapReduceChildJVM.getTaskLogFile(TaskLog.LogName.STDOUT));
        vargs.add("2>" + MapReduceChildJVM.getTaskLogFile(TaskLog.LogName.STDERR));
        StringBuilder mergedCommand = new StringBuilder();
        for (String str : vargs) {
            mergedCommand.append((CharSequence)str).append(" ");
        }
        Vector<String> vargsFinal = new Vector<String>(1);
        vargsFinal.add(mergedCommand.toString());
        return vargsFinal;
    }
}

