/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.v2.app.job.impl;

import java.io.File;
import java.io.IOException;
import java.util.concurrent.CyclicBarrier;
import org.apache.commons.io.FileUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.JobACL;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.JobID;
import org.apache.hadoop.mapreduce.JobStatus;
import org.apache.hadoop.mapreduce.OutputCommitter;
import org.apache.hadoop.mapreduce.TypeConverter;
import org.apache.hadoop.mapreduce.jobhistory.EventType;
import org.apache.hadoop.mapreduce.security.token.JobTokenSecretManager;
import org.apache.hadoop.mapreduce.v2.api.records.JobId;
import org.apache.hadoop.mapreduce.v2.api.records.JobState;
import org.apache.hadoop.mapreduce.v2.api.records.TaskState;
import org.apache.hadoop.mapreduce.v2.api.records.TaskType;
import org.apache.hadoop.mapreduce.v2.app.AppContext;
import org.apache.hadoop.mapreduce.v2.app.commit.CommitterEventHandler;
import org.apache.hadoop.mapreduce.v2.app.commit.CommitterEventType;
import org.apache.hadoop.mapreduce.v2.app.job.JobStateInternal;
import org.apache.hadoop.mapreduce.v2.app.job.Task;
import org.apache.hadoop.mapreduce.v2.app.job.TaskAttempt;
import org.apache.hadoop.mapreduce.v2.app.job.event.JobDiagnosticsUpdateEvent;
import org.apache.hadoop.mapreduce.v2.app.job.event.JobEvent;
import org.apache.hadoop.mapreduce.v2.app.job.event.JobEventType;
import org.apache.hadoop.mapreduce.v2.app.job.event.JobFinishEvent;
import org.apache.hadoop.mapreduce.v2.app.job.event.JobStartEvent;
import org.apache.hadoop.mapreduce.v2.app.job.event.JobTaskEvent;
import org.apache.hadoop.mapreduce.v2.app.job.event.TaskEvent;
import org.apache.hadoop.mapreduce.v2.app.job.event.TaskEventType;
import org.apache.hadoop.mapreduce.v2.app.job.event.TaskTAttemptEvent;
import org.apache.hadoop.mapreduce.v2.app.job.impl.JobImpl;
import org.apache.hadoop.mapreduce.v2.app.job.impl.TaskImpl;
import org.apache.hadoop.mapreduce.v2.app.job.impl.TestJobImpl;
import org.apache.hadoop.mapreduce.v2.app.metrics.MRAppMetrics;
import org.apache.hadoop.mapreduce.v2.app.rm.RMHeartbeatHandler;
import org.apache.hadoop.mapreduce.v2.util.MRBuilderUtils;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.event.AsyncDispatcher;
import org.apache.hadoop.yarn.event.Dispatcher;
import org.apache.hadoop.yarn.event.DrainDispatcher;
import org.apache.hadoop.yarn.event.EventHandler;
import org.apache.hadoop.yarn.event.InlineDispatcher;
import org.apache.hadoop.yarn.util.Clock;
import org.apache.hadoop.yarn.util.ConverterUtils;
import org.apache.hadoop.yarn.util.Records;
import org.apache.hadoop.yarn.util.SystemClock;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

/*
 * Exception performing whole class analysis ignored.
 */
public class TestJobImpl {
    static String stagingDir = "target/test-staging/";

    @BeforeClass
    public static void setup() {
        File dir = new File(stagingDir);
        stagingDir = dir.getAbsolutePath();
    }

    @Before
    public void cleanup() throws IOException {
        File dir = new File(stagingDir);
        if (dir.exists()) {
            FileUtils.deleteDirectory((File)dir);
        }
        dir.mkdirs();
    }

    @Test
    public void testJobNoTasks() {
        Configuration conf = new Configuration();
        conf.setInt("mapreduce.job.reduces", 0);
        conf.set("yarn.app.mapreduce.am.staging-dir", stagingDir);
        conf.set("mapreduce.workflow.id", "testId");
        conf.set("mapreduce.workflow.name", "testName");
        conf.set("mapreduce.workflow.node.name", "testNodeName");
        conf.set("mapreduce.workflow.adjacency.key1", "value1");
        conf.set("mapreduce.workflow.adjacency.key2", "value2");
        conf.set("mapreduce.workflow.tags", "tag1,tag2");
        AsyncDispatcher dispatcher = new AsyncDispatcher();
        dispatcher.init(conf);
        dispatcher.start();
        OutputCommitter committer = (OutputCommitter)Mockito.mock(OutputCommitter.class);
        CommitterEventHandler commitHandler = TestJobImpl.createCommitterEventHandler((Dispatcher)dispatcher, (OutputCommitter)committer);
        commitHandler.init(conf);
        commitHandler.start();
        JobSubmittedEventHandler jseHandler = new JobSubmittedEventHandler("testId", "testName", "testNodeName", "\"key2\"=\"value2\" \"key1\"=\"value1\" ", "tag1,tag2");
        dispatcher.register(EventType.class, (EventHandler)jseHandler);
        StubbedJob job = TestJobImpl.createStubbedJob((Configuration)conf, (Dispatcher)dispatcher, (int)0, null);
        job.handle(new JobEvent(job.getID(), JobEventType.JOB_INIT));
        TestJobImpl.assertJobState((JobImpl)job, (JobStateInternal)JobStateInternal.INITED);
        job.handle((JobEvent)new JobStartEvent(job.getID()));
        TestJobImpl.assertJobState((JobImpl)job, (JobStateInternal)JobStateInternal.SUCCEEDED);
        dispatcher.stop();
        commitHandler.stop();
        try {
            Assert.assertTrue((boolean)jseHandler.getAssertValue());
        }
        catch (InterruptedException e) {
            Assert.fail((String)"Workflow related attributes are not tested properly");
        }
    }

    @Test(timeout=20000L)
    public void testCommitJobFailsJob() throws Exception {
        Configuration conf = new Configuration();
        conf.set("yarn.app.mapreduce.am.staging-dir", stagingDir);
        AsyncDispatcher dispatcher = new AsyncDispatcher();
        dispatcher.init(conf);
        dispatcher.start();
        CyclicBarrier syncBarrier = new CyclicBarrier(2);
        TestingOutputCommitter committer = new TestingOutputCommitter(syncBarrier, false);
        CommitterEventHandler commitHandler = TestJobImpl.createCommitterEventHandler((Dispatcher)dispatcher, (OutputCommitter)committer);
        commitHandler.init(conf);
        commitHandler.start();
        StubbedJob job = TestJobImpl.createRunningStubbedJob((Configuration)conf, (Dispatcher)dispatcher, (int)2, null);
        TestJobImpl.completeJobTasks((JobImpl)job);
        TestJobImpl.assertJobState((JobImpl)job, (JobStateInternal)JobStateInternal.COMMITTING);
        syncBarrier.await();
        TestJobImpl.assertJobState((JobImpl)job, (JobStateInternal)JobStateInternal.FAILED);
        dispatcher.stop();
        commitHandler.stop();
    }

    @Test(timeout=20000L)
    public void testCheckJobCompleteSuccess() throws Exception {
        Configuration conf = new Configuration();
        conf.set("yarn.app.mapreduce.am.staging-dir", stagingDir);
        AsyncDispatcher dispatcher = new AsyncDispatcher();
        dispatcher.init(conf);
        dispatcher.start();
        CyclicBarrier syncBarrier = new CyclicBarrier(2);
        TestingOutputCommitter committer = new TestingOutputCommitter(syncBarrier, true);
        CommitterEventHandler commitHandler = TestJobImpl.createCommitterEventHandler((Dispatcher)dispatcher, (OutputCommitter)committer);
        commitHandler.init(conf);
        commitHandler.start();
        StubbedJob job = TestJobImpl.createRunningStubbedJob((Configuration)conf, (Dispatcher)dispatcher, (int)2, null);
        TestJobImpl.completeJobTasks((JobImpl)job);
        TestJobImpl.assertJobState((JobImpl)job, (JobStateInternal)JobStateInternal.COMMITTING);
        syncBarrier.await();
        TestJobImpl.assertJobState((JobImpl)job, (JobStateInternal)JobStateInternal.SUCCEEDED);
        job.handle(new JobEvent(job.getID(), JobEventType.JOB_TASK_ATTEMPT_COMPLETED));
        TestJobImpl.assertJobState((JobImpl)job, (JobStateInternal)JobStateInternal.SUCCEEDED);
        job.handle(new JobEvent(job.getID(), JobEventType.JOB_MAP_TASK_RESCHEDULED));
        TestJobImpl.assertJobState((JobImpl)job, (JobStateInternal)JobStateInternal.SUCCEEDED);
        dispatcher.stop();
        commitHandler.stop();
    }

    @Test(timeout=20000L)
    public void testRebootedDuringSetup() throws Exception {
        Configuration conf = new Configuration();
        conf.set("yarn.app.mapreduce.am.staging-dir", stagingDir);
        AsyncDispatcher dispatcher = new AsyncDispatcher();
        dispatcher.init(conf);
        dispatcher.start();
        1 committer = new /* Unavailable Anonymous Inner Class!! */;
        CommitterEventHandler commitHandler = TestJobImpl.createCommitterEventHandler((Dispatcher)dispatcher, (OutputCommitter)committer);
        commitHandler.init(conf);
        commitHandler.start();
        AppContext mockContext = (AppContext)Mockito.mock(AppContext.class);
        Mockito.when((Object)mockContext.isLastAMRetry()).thenReturn((Object)false);
        StubbedJob job = TestJobImpl.createStubbedJob((Configuration)conf, (Dispatcher)dispatcher, (int)2, (AppContext)mockContext);
        JobId jobId = job.getID();
        job.handle(new JobEvent(jobId, JobEventType.JOB_INIT));
        TestJobImpl.assertJobState((JobImpl)job, (JobStateInternal)JobStateInternal.INITED);
        job.handle((JobEvent)new JobStartEvent(jobId));
        TestJobImpl.assertJobState((JobImpl)job, (JobStateInternal)JobStateInternal.SETUP);
        job.handle(new JobEvent(job.getID(), JobEventType.JOB_AM_REBOOT));
        TestJobImpl.assertJobState((JobImpl)job, (JobStateInternal)JobStateInternal.REBOOT);
        Assert.assertEquals((Object)JobState.RUNNING, (Object)job.getState());
        dispatcher.stop();
        commitHandler.stop();
    }

    @Test(timeout=20000L)
    public void testRebootedDuringCommit() throws Exception {
        Configuration conf = new Configuration();
        conf.set("yarn.app.mapreduce.am.staging-dir", stagingDir);
        conf.setInt("mapreduce.am.max-attempts", 2);
        AsyncDispatcher dispatcher = new AsyncDispatcher();
        dispatcher.init(conf);
        dispatcher.start();
        CyclicBarrier syncBarrier = new CyclicBarrier(2);
        WaitingOutputCommitter committer = new WaitingOutputCommitter(syncBarrier, true);
        CommitterEventHandler commitHandler = TestJobImpl.createCommitterEventHandler((Dispatcher)dispatcher, (OutputCommitter)committer);
        commitHandler.init(conf);
        commitHandler.start();
        AppContext mockContext = (AppContext)Mockito.mock(AppContext.class);
        Mockito.when((Object)mockContext.isLastAMRetry()).thenReturn((Object)true);
        StubbedJob job = TestJobImpl.createRunningStubbedJob((Configuration)conf, (Dispatcher)dispatcher, (int)2, (AppContext)mockContext);
        TestJobImpl.completeJobTasks((JobImpl)job);
        TestJobImpl.assertJobState((JobImpl)job, (JobStateInternal)JobStateInternal.COMMITTING);
        syncBarrier.await();
        job.handle(new JobEvent(job.getID(), JobEventType.JOB_AM_REBOOT));
        TestJobImpl.assertJobState((JobImpl)job, (JobStateInternal)JobStateInternal.REBOOT);
        Assert.assertEquals((Object)JobState.ERROR, (Object)job.getState());
        dispatcher.stop();
        commitHandler.stop();
    }

    @Test(timeout=20000L)
    public void testKilledDuringSetup() throws Exception {
        Configuration conf = new Configuration();
        conf.set("yarn.app.mapreduce.am.staging-dir", stagingDir);
        AsyncDispatcher dispatcher = new AsyncDispatcher();
        dispatcher.init(conf);
        dispatcher.start();
        2 committer = new /* Unavailable Anonymous Inner Class!! */;
        CommitterEventHandler commitHandler = TestJobImpl.createCommitterEventHandler((Dispatcher)dispatcher, (OutputCommitter)committer);
        commitHandler.init(conf);
        commitHandler.start();
        StubbedJob job = TestJobImpl.createStubbedJob((Configuration)conf, (Dispatcher)dispatcher, (int)2, null);
        JobId jobId = job.getID();
        job.handle(new JobEvent(jobId, JobEventType.JOB_INIT));
        TestJobImpl.assertJobState((JobImpl)job, (JobStateInternal)JobStateInternal.INITED);
        job.handle((JobEvent)new JobStartEvent(jobId));
        TestJobImpl.assertJobState((JobImpl)job, (JobStateInternal)JobStateInternal.SETUP);
        job.handle(new JobEvent(job.getID(), JobEventType.JOB_KILL));
        TestJobImpl.assertJobState((JobImpl)job, (JobStateInternal)JobStateInternal.KILLED);
        dispatcher.stop();
        commitHandler.stop();
    }

    @Test(timeout=20000L)
    public void testKilledDuringCommit() throws Exception {
        Configuration conf = new Configuration();
        conf.set("yarn.app.mapreduce.am.staging-dir", stagingDir);
        AsyncDispatcher dispatcher = new AsyncDispatcher();
        dispatcher.init(conf);
        dispatcher.start();
        CyclicBarrier syncBarrier = new CyclicBarrier(2);
        WaitingOutputCommitter committer = new WaitingOutputCommitter(syncBarrier, true);
        CommitterEventHandler commitHandler = TestJobImpl.createCommitterEventHandler((Dispatcher)dispatcher, (OutputCommitter)committer);
        commitHandler.init(conf);
        commitHandler.start();
        StubbedJob job = TestJobImpl.createRunningStubbedJob((Configuration)conf, (Dispatcher)dispatcher, (int)2, null);
        TestJobImpl.completeJobTasks((JobImpl)job);
        TestJobImpl.assertJobState((JobImpl)job, (JobStateInternal)JobStateInternal.COMMITTING);
        syncBarrier.await();
        job.handle(new JobEvent(job.getID(), JobEventType.JOB_KILL));
        TestJobImpl.assertJobState((JobImpl)job, (JobStateInternal)JobStateInternal.KILLED);
        dispatcher.stop();
        commitHandler.stop();
    }

    @Test
    public void testAbortJobCalledAfterKillingTasks() throws IOException {
        Configuration conf = new Configuration();
        conf.set("yarn.app.mapreduce.am.staging-dir", stagingDir);
        conf.set("yarn.app.mapreduce.am.job.committer.cancel-timeout", "1000");
        InlineDispatcher dispatcher = new InlineDispatcher();
        dispatcher.init(conf);
        dispatcher.start();
        OutputCommitter committer = (OutputCommitter)Mockito.mock(OutputCommitter.class);
        CommitterEventHandler commitHandler = TestJobImpl.createCommitterEventHandler((Dispatcher)dispatcher, (OutputCommitter)committer);
        commitHandler.init(conf);
        commitHandler.start();
        StubbedJob job = TestJobImpl.createRunningStubbedJob((Configuration)conf, (Dispatcher)dispatcher, (int)2, null);
        job.handle((JobEvent)new JobTaskEvent(MRBuilderUtils.newTaskId((JobId)job.getID(), (int)1, (TaskType)TaskType.MAP), TaskState.FAILED));
        ((OutputCommitter)Mockito.verify((Object)committer, (VerificationMode)Mockito.never())).abortJob((JobContext)Mockito.any(), (JobStatus.State)Mockito.any());
        TestJobImpl.assertJobState((JobImpl)job, (JobStateInternal)JobStateInternal.FAIL_WAIT);
        ((OutputCommitter)Mockito.verify((Object)committer, (VerificationMode)Mockito.timeout((int)2000).times(1))).abortJob((JobContext)Mockito.any(), (JobStatus.State)Mockito.any());
        TestJobImpl.assertJobState((JobImpl)job, (JobStateInternal)JobStateInternal.FAILED);
        dispatcher.stop();
    }

    @Test(timeout=10000L)
    public void testFailAbortDoesntHang() throws IOException {
        Configuration conf = new Configuration();
        conf.set("yarn.app.mapreduce.am.staging-dir", stagingDir);
        conf.set("yarn.app.mapreduce.am.job.committer.cancel-timeout", "1000");
        DrainDispatcher dispatcher = new DrainDispatcher();
        dispatcher.init(conf);
        dispatcher.start();
        OutputCommitter committer = (OutputCommitter)Mockito.mock(OutputCommitter.class);
        CommitterEventHandler commitHandler = TestJobImpl.createCommitterEventHandler((Dispatcher)dispatcher, (OutputCommitter)committer);
        commitHandler.init(conf);
        commitHandler.start();
        conf.setInt("mapreduce.job.reduces", 0);
        conf.setInt("mapreduce.map.maxattempts", 1);
        StubbedJob job = TestJobImpl.createRunningStubbedJob((Configuration)conf, (Dispatcher)dispatcher, (int)1, null);
        for (Task t : job.tasks.values()) {
            TaskImpl task = (TaskImpl)t;
            task.handle(new TaskEvent(task.getID(), TaskEventType.T_SCHEDULE));
            for (TaskAttempt ta : task.getAttempts().values()) {
                task.handle((TaskEvent)new TaskTAttemptEvent(ta.getID(), TaskEventType.T_ATTEMPT_FAILED));
            }
        }
        TestJobImpl.assertJobState((JobImpl)job, (JobStateInternal)JobStateInternal.FAIL_ABORT);
        dispatcher.await();
        ((OutputCommitter)Mockito.verify((Object)committer, (VerificationMode)Mockito.timeout((int)2000).times(1))).abortJob((JobContext)Mockito.any(), (JobStatus.State)Mockito.any());
        TestJobImpl.assertJobState((JobImpl)job, (JobStateInternal)JobStateInternal.FAILED);
        dispatcher.stop();
    }

    @Test(timeout=20000L)
    public void testKilledDuringFailAbort() throws Exception {
        Configuration conf = new Configuration();
        conf.set("yarn.app.mapreduce.am.staging-dir", stagingDir);
        AsyncDispatcher dispatcher = new AsyncDispatcher();
        dispatcher.init(conf);
        dispatcher.start();
        3 committer = new /* Unavailable Anonymous Inner Class!! */;
        CommitterEventHandler commitHandler = TestJobImpl.createCommitterEventHandler((Dispatcher)dispatcher, (OutputCommitter)committer);
        commitHandler.init(conf);
        commitHandler.start();
        StubbedJob job = TestJobImpl.createStubbedJob((Configuration)conf, (Dispatcher)dispatcher, (int)2, null);
        JobId jobId = job.getID();
        job.handle(new JobEvent(jobId, JobEventType.JOB_INIT));
        TestJobImpl.assertJobState((JobImpl)job, (JobStateInternal)JobStateInternal.INITED);
        job.handle((JobEvent)new JobStartEvent(jobId));
        TestJobImpl.assertJobState((JobImpl)job, (JobStateInternal)JobStateInternal.FAIL_ABORT);
        job.handle(new JobEvent(jobId, JobEventType.JOB_KILL));
        TestJobImpl.assertJobState((JobImpl)job, (JobStateInternal)JobStateInternal.KILLED);
        dispatcher.stop();
        commitHandler.stop();
    }

    @Test(timeout=20000L)
    public void testKilledDuringKillAbort() throws Exception {
        Configuration conf = new Configuration();
        conf.set("yarn.app.mapreduce.am.staging-dir", stagingDir);
        AsyncDispatcher dispatcher = new AsyncDispatcher();
        dispatcher.init(conf);
        dispatcher.start();
        4 committer = new /* Unavailable Anonymous Inner Class!! */;
        CommitterEventHandler commitHandler = TestJobImpl.createCommitterEventHandler((Dispatcher)dispatcher, (OutputCommitter)committer);
        commitHandler.init(conf);
        commitHandler.start();
        StubbedJob job = TestJobImpl.createStubbedJob((Configuration)conf, (Dispatcher)dispatcher, (int)2, null);
        JobId jobId = job.getID();
        job.handle(new JobEvent(jobId, JobEventType.JOB_INIT));
        TestJobImpl.assertJobState((JobImpl)job, (JobStateInternal)JobStateInternal.INITED);
        job.handle((JobEvent)new JobStartEvent(jobId));
        TestJobImpl.assertJobState((JobImpl)job, (JobStateInternal)JobStateInternal.SETUP);
        job.handle(new JobEvent(jobId, JobEventType.JOB_KILL));
        TestJobImpl.assertJobState((JobImpl)job, (JobStateInternal)JobStateInternal.KILL_ABORT);
        job.handle(new JobEvent(jobId, JobEventType.JOB_KILL));
        TestJobImpl.assertJobState((JobImpl)job, (JobStateInternal)JobStateInternal.KILLED);
        dispatcher.stop();
        commitHandler.stop();
    }

    public static void main(String[] args) throws Exception {
        TestJobImpl t = new TestJobImpl();
        t.testJobNoTasks();
        t.testCheckJobCompleteSuccess();
        t.testCheckAccess();
        t.testReportDiagnostics();
        t.testUberDecision();
    }

    @Test
    public void testCheckAccess() {
        String user1 = System.getProperty("user.name");
        String user2 = user1 + "1234";
        UserGroupInformation ugi1 = UserGroupInformation.createRemoteUser((String)user1);
        UserGroupInformation ugi2 = UserGroupInformation.createRemoteUser((String)user2);
        JobID jobID = JobID.forName((String)"job_1234567890000_0001");
        JobId jobId = TypeConverter.toYarn((JobID)jobID);
        Configuration conf1 = new Configuration();
        conf1.setBoolean("mapreduce.cluster.acls.enabled", true);
        conf1.set("mapreduce.job.acl-view-job", "");
        JobImpl job1 = new JobImpl(jobId, null, conf1, null, null, null, null, null, null, null, null, true, null, 0L, null, null, null, null);
        Assert.assertTrue((boolean)job1.checkAccess(ugi1, JobACL.VIEW_JOB));
        Assert.assertFalse((boolean)job1.checkAccess(ugi2, JobACL.VIEW_JOB));
        Configuration conf2 = new Configuration();
        conf2.setBoolean("mapreduce.cluster.acls.enabled", true);
        conf2.set("mapreduce.job.acl-view-job", user2);
        JobImpl job2 = new JobImpl(jobId, null, conf2, null, null, null, null, null, null, null, null, true, null, 0L, null, null, null, null);
        Assert.assertTrue((boolean)job2.checkAccess(ugi1, JobACL.VIEW_JOB));
        Assert.assertTrue((boolean)job2.checkAccess(ugi2, JobACL.VIEW_JOB));
        Configuration conf3 = new Configuration();
        conf3.setBoolean("mapreduce.cluster.acls.enabled", true);
        conf3.set("mapreduce.job.acl-view-job", "*");
        JobImpl job3 = new JobImpl(jobId, null, conf3, null, null, null, null, null, null, null, null, true, null, 0L, null, null, null, null);
        Assert.assertTrue((boolean)job3.checkAccess(ugi1, JobACL.VIEW_JOB));
        Assert.assertTrue((boolean)job3.checkAccess(ugi2, JobACL.VIEW_JOB));
        Configuration conf4 = new Configuration();
        conf4.setBoolean("mapreduce.cluster.acls.enabled", false);
        conf4.set("mapreduce.job.acl-view-job", "");
        JobImpl job4 = new JobImpl(jobId, null, conf4, null, null, null, null, null, null, null, null, true, null, 0L, null, null, null, null);
        Assert.assertTrue((boolean)job4.checkAccess(ugi1, JobACL.VIEW_JOB));
        Assert.assertTrue((boolean)job4.checkAccess(ugi2, JobACL.VIEW_JOB));
        Configuration conf5 = new Configuration();
        conf5.setBoolean("mapreduce.cluster.acls.enabled", true);
        conf5.set("mapreduce.job.acl-view-job", "");
        JobImpl job5 = new JobImpl(jobId, null, conf5, null, null, null, null, null, null, null, null, true, null, 0L, null, null, null, null);
        Assert.assertTrue((boolean)job5.checkAccess(ugi1, null));
        Assert.assertTrue((boolean)job5.checkAccess(ugi2, null));
    }

    @Test
    public void testReportDiagnostics() throws Exception {
        JobID jobID = JobID.forName((String)"job_1234567890000_0001");
        JobId jobId = TypeConverter.toYarn((JobID)jobID);
        String diagMsg = "some diagnostic message";
        JobDiagnosticsUpdateEvent diagUpdateEvent = new JobDiagnosticsUpdateEvent(jobId, "some diagnostic message");
        MRAppMetrics mrAppMetrics = MRAppMetrics.create();
        JobImpl job = new JobImpl(jobId, (ApplicationAttemptId)Records.newRecord(ApplicationAttemptId.class), new Configuration(), (EventHandler)Mockito.mock(EventHandler.class), null, (JobTokenSecretManager)Mockito.mock(JobTokenSecretManager.class), null, (Clock)new SystemClock(), null, mrAppMetrics, null, true, null, 0L, null, null, null, null);
        job.handle((JobEvent)diagUpdateEvent);
        String diagnostics = job.getReport().getDiagnostics();
        Assert.assertNotNull((Object)diagnostics);
        Assert.assertTrue((boolean)diagnostics.contains("some diagnostic message"));
        job = new JobImpl(jobId, (ApplicationAttemptId)Records.newRecord(ApplicationAttemptId.class), new Configuration(), (EventHandler)Mockito.mock(EventHandler.class), null, (JobTokenSecretManager)Mockito.mock(JobTokenSecretManager.class), null, (Clock)new SystemClock(), null, mrAppMetrics, null, true, null, 0L, null, null, null, null);
        job.handle(new JobEvent(jobId, JobEventType.JOB_KILL));
        job.handle((JobEvent)diagUpdateEvent);
        diagnostics = job.getReport().getDiagnostics();
        Assert.assertNotNull((Object)diagnostics);
        Assert.assertTrue((boolean)diagnostics.contains("some diagnostic message"));
    }

    @Test
    public void testUberDecision() throws Exception {
        Configuration conf = new Configuration();
        boolean isUber = this.testUberDecision(conf);
        Assert.assertFalse((boolean)isUber);
        conf = new Configuration();
        conf.setBoolean("mapreduce.job.ubertask.enable", true);
        isUber = this.testUberDecision(conf);
        Assert.assertTrue((boolean)isUber);
        conf = new Configuration();
        conf.setBoolean("mapreduce.job.ubertask.enable", true);
        conf.setInt("mapreduce.job.ubertask.maxreduces", 0);
        conf.setInt("mapreduce.job.reduces", 1);
        isUber = this.testUberDecision(conf);
        Assert.assertFalse((boolean)isUber);
        conf = new Configuration();
        conf.setBoolean("mapreduce.job.ubertask.enable", true);
        conf.setInt("mapreduce.job.ubertask.maxreduces", 1);
        conf.setInt("mapreduce.job.reduces", 1);
        isUber = this.testUberDecision(conf);
        Assert.assertTrue((boolean)isUber);
        conf = new Configuration();
        conf.setBoolean("mapreduce.job.ubertask.enable", true);
        conf.setInt("mapreduce.job.ubertask.maxmaps", 1);
        isUber = this.testUberDecision(conf);
        Assert.assertFalse((boolean)isUber);
    }

    private boolean testUberDecision(Configuration conf) {
        JobID jobID = JobID.forName((String)"job_1234567890000_0001");
        JobId jobId = TypeConverter.toYarn((JobID)jobID);
        MRAppMetrics mrAppMetrics = MRAppMetrics.create();
        JobImpl job = new JobImpl(jobId, ApplicationAttemptId.newInstance((ApplicationId)ApplicationId.newInstance((long)0L, (int)0), (int)0), conf, (EventHandler)Mockito.mock(EventHandler.class), null, new JobTokenSecretManager(), new Credentials(), null, null, mrAppMetrics, null, true, null, 0L, null, null, null, null);
        JobImpl.InitTransition initTransition = TestJobImpl.getInitTransition((int)2);
        JobEvent mockJobEvent = (JobEvent)Mockito.mock(JobEvent.class);
        initTransition.transition(job, mockJobEvent);
        boolean isUber = job.isUber();
        return isUber;
    }

    private static JobImpl.InitTransition getInitTransition(int numSplits) {
        5 initTransition = new /* Unavailable Anonymous Inner Class!! */;
        return initTransition;
    }

    @Test
    public void testTransitionsAtFailed() throws IOException {
        Configuration conf = new Configuration();
        AsyncDispatcher dispatcher = new AsyncDispatcher();
        dispatcher.init(conf);
        dispatcher.start();
        OutputCommitter committer = (OutputCommitter)Mockito.mock(OutputCommitter.class);
        ((OutputCommitter)Mockito.doThrow((Throwable)new IOException("forcefail")).when((Object)committer)).setupJob((JobContext)Matchers.any(JobContext.class));
        CommitterEventHandler commitHandler = TestJobImpl.createCommitterEventHandler((Dispatcher)dispatcher, (OutputCommitter)committer);
        commitHandler.init(conf);
        commitHandler.start();
        StubbedJob job = TestJobImpl.createStubbedJob((Configuration)conf, (Dispatcher)dispatcher, (int)2, null);
        JobId jobId = job.getID();
        job.handle(new JobEvent(jobId, JobEventType.JOB_INIT));
        TestJobImpl.assertJobState((JobImpl)job, (JobStateInternal)JobStateInternal.INITED);
        job.handle((JobEvent)new JobStartEvent(jobId));
        TestJobImpl.assertJobState((JobImpl)job, (JobStateInternal)JobStateInternal.FAILED);
        job.handle(new JobEvent(jobId, JobEventType.JOB_TASK_COMPLETED));
        Assert.assertEquals((Object)JobState.FAILED, (Object)job.getState());
        job.handle(new JobEvent(jobId, JobEventType.JOB_TASK_ATTEMPT_COMPLETED));
        Assert.assertEquals((Object)JobState.FAILED, (Object)job.getState());
        job.handle(new JobEvent(jobId, JobEventType.JOB_MAP_TASK_RESCHEDULED));
        Assert.assertEquals((Object)JobState.FAILED, (Object)job.getState());
        job.handle(new JobEvent(jobId, JobEventType.JOB_TASK_ATTEMPT_FETCH_FAILURE));
        Assert.assertEquals((Object)JobState.FAILED, (Object)job.getState());
        dispatcher.stop();
        commitHandler.stop();
    }

    private static CommitterEventHandler createCommitterEventHandler(Dispatcher dispatcher, OutputCommitter committer) {
        SystemClock clock = new SystemClock();
        AppContext appContext = (AppContext)Mockito.mock(AppContext.class);
        Mockito.when((Object)appContext.getEventHandler()).thenReturn((Object)dispatcher.getEventHandler());
        Mockito.when((Object)appContext.getClock()).thenReturn((Object)clock);
        6 heartbeatHandler = new /* Unavailable Anonymous Inner Class!! */;
        ApplicationAttemptId id = ConverterUtils.toApplicationAttemptId((String)"appattempt_1234567890000_0001_0");
        Mockito.when((Object)appContext.getApplicationID()).thenReturn((Object)id.getApplicationId());
        Mockito.when((Object)appContext.getApplicationAttemptId()).thenReturn((Object)id);
        CommitterEventHandler handler = new CommitterEventHandler(appContext, committer, (RMHeartbeatHandler)heartbeatHandler);
        dispatcher.register(CommitterEventType.class, (EventHandler)handler);
        return handler;
    }

    private static StubbedJob createStubbedJob(Configuration conf, Dispatcher dispatcher, int numSplits, AppContext appContext) {
        JobID jobID = JobID.forName((String)"job_1234567890000_0001");
        JobId jobId = TypeConverter.toYarn((JobID)jobID);
        StubbedJob job = new StubbedJob(jobId, ApplicationAttemptId.newInstance((ApplicationId)ApplicationId.newInstance((long)0L, (int)0), (int)0), conf, dispatcher.getEventHandler(), true, "somebody", numSplits, appContext);
        dispatcher.register(JobEventType.class, (EventHandler)job);
        EventHandler mockHandler = (EventHandler)Mockito.mock(EventHandler.class);
        dispatcher.register(TaskEventType.class, mockHandler);
        dispatcher.register(EventType.class, mockHandler);
        dispatcher.register(JobFinishEvent.Type.class, mockHandler);
        return job;
    }

    private static StubbedJob createRunningStubbedJob(Configuration conf, Dispatcher dispatcher, int numSplits, AppContext appContext) {
        StubbedJob job = TestJobImpl.createStubbedJob((Configuration)conf, (Dispatcher)dispatcher, (int)numSplits, (AppContext)appContext);
        job.handle(new JobEvent(job.getID(), JobEventType.JOB_INIT));
        TestJobImpl.assertJobState((JobImpl)job, (JobStateInternal)JobStateInternal.INITED);
        job.handle((JobEvent)new JobStartEvent(job.getID()));
        TestJobImpl.assertJobState((JobImpl)job, (JobStateInternal)JobStateInternal.RUNNING);
        return job;
    }

    private static void completeJobTasks(JobImpl job) {
        int numMaps = job.getTotalMaps();
        for (int i = 0; i < numMaps; ++i) {
            job.handle((JobEvent)new JobTaskEvent(MRBuilderUtils.newTaskId((JobId)job.getID(), (int)1, (TaskType)TaskType.MAP), TaskState.SUCCEEDED));
            Assert.assertEquals((Object)JobState.RUNNING, (Object)job.getState());
        }
        int numReduces = job.getTotalReduces();
        for (int i = 0; i < numReduces; ++i) {
            job.handle((JobEvent)new JobTaskEvent(MRBuilderUtils.newTaskId((JobId)job.getID(), (int)1, (TaskType)TaskType.MAP), TaskState.SUCCEEDED));
            Assert.assertEquals((Object)JobState.RUNNING, (Object)job.getState());
        }
    }

    private static void assertJobState(JobImpl job, JobStateInternal state) {
        for (int timeToWaitMsec = 5000; timeToWaitMsec > 0 && job.getInternalState() != state; timeToWaitMsec -= 10) {
            try {
                Thread.sleep(10L);
                continue;
            }
            catch (InterruptedException e) {
                // empty catch block
                break;
            }
        }
        Assert.assertEquals((Object)state, (Object)job.getInternalState());
    }

    static /* synthetic */ JobImpl.InitTransition access$000(int x0) {
        return TestJobImpl.getInitTransition((int)x0);
    }
}

