/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.v2.app.job.impl;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.v2.api.records.JobState;
import org.apache.hadoop.mapreduce.v2.app.job.Job;
import org.apache.hadoop.mapreduce.v2.app.job.impl.TestMapReduceChildJVM;
import org.apache.hadoop.mapreduce.v2.util.MRApps;
import org.junit.Assert;
import org.junit.Test;

/*
 * Exception performing whole class analysis ignored.
 */
public class TestMapReduceChildJVM {
    private static final Log LOG = LogFactory.getLog(TestMapReduceChildJVM.class);

    @Test(timeout=30000L)
    public void testCommandLine() throws Exception {
        MyMRApp app = new MyMRApp(1, 0, true, this.getClass().getName(), true);
        Configuration conf = new Configuration();
        conf.setBoolean("mapreduce.app-submission.cross-platform", true);
        Job job = app.submit(conf);
        app.waitForState(job, JobState.SUCCEEDED);
        app.verifyCompleted();
        Assert.assertEquals((Object)("[" + MRApps.crossPlatformify((String)"JAVA_HOME") + "/bin/java" + " -Djava.net.preferIPv4Stack=true" + " -Dhadoop.metrics.log.level=WARN" + "  -Xmx200m -Djava.io.tmpdir=" + MRApps.crossPlatformify((String)"PWD") + "/tmp" + " -Dlog4j.configuration=container-log4j.properties" + " -Dyarn.app.container.log.dir=<LOG_DIR>" + " -Dyarn.app.container.log.filesize=0" + " -Dhadoop.root.logger=INFO,CLA -Dhadoop.root.logfile=syslog" + " org.apache.hadoop.mapred.YarnChild 127.0.0.1" + " 54321" + " attempt_0_0000_m_000000_0" + " 0" + " 1><LOG_DIR>/stdout" + " 2><LOG_DIR>/stderr ]"), (Object)MyMRApp.access$000((MyMRApp)app));
        Assert.assertTrue((String)"HADOOP_ROOT_LOGGER not set for job", (boolean)MyMRApp.access$100((MyMRApp)app).containsKey("HADOOP_ROOT_LOGGER"));
        Assert.assertEquals((Object)"INFO,console", MyMRApp.access$100((MyMRApp)app).get("HADOOP_ROOT_LOGGER"));
        Assert.assertTrue((String)"HADOOP_CLIENT_OPTS not set for job", (boolean)MyMRApp.access$100((MyMRApp)app).containsKey("HADOOP_CLIENT_OPTS"));
        Assert.assertEquals((Object)"", MyMRApp.access$100((MyMRApp)app).get("HADOOP_CLIENT_OPTS"));
    }

    @Test(timeout=30000L)
    public void testReduceCommandLineWithSeparateShuffle() throws Exception {
        Configuration conf = new Configuration();
        conf.setBoolean("yarn.app.mapreduce.shuffle.log.separate", true);
        this.testReduceCommandLine(conf);
    }

    @Test(timeout=30000L)
    public void testReduceCommandLineWithSeparateCRLAShuffle() throws Exception {
        Configuration conf = new Configuration();
        conf.setBoolean("yarn.app.mapreduce.shuffle.log.separate", true);
        conf.setLong("yarn.app.mapreduce.shuffle.log.limit.kb", 1L);
        conf.setInt("yarn.app.mapreduce.shuffle.log.backups", 3);
        this.testReduceCommandLine(conf);
    }

    @Test(timeout=30000L)
    public void testReduceCommandLine() throws Exception {
        Configuration conf = new Configuration();
        this.testReduceCommandLine(conf);
    }

    private void testReduceCommandLine(Configuration conf) throws Exception {
        MyMRApp app = new MyMRApp(0, 1, true, this.getClass().getName(), true);
        conf.setBoolean("mapreduce.app-submission.cross-platform", true);
        Job job = app.submit(conf);
        app.waitForState(job, JobState.SUCCEEDED);
        app.verifyCompleted();
        long shuffleLogSize = conf.getLong("yarn.app.mapreduce.shuffle.log.limit.kb", 0L) * 1024L;
        int shuffleBackups = conf.getInt("yarn.app.mapreduce.shuffle.log.backups", 0);
        String appenderName = shuffleLogSize > 0L && shuffleBackups > 0 ? "shuffleCRLA" : "shuffleCLA";
        Assert.assertEquals((Object)("[" + MRApps.crossPlatformify((String)"JAVA_HOME") + "/bin/java" + " -Djava.net.preferIPv4Stack=true" + " -Dhadoop.metrics.log.level=WARN" + "  -Xmx200m -Djava.io.tmpdir=" + MRApps.crossPlatformify((String)"PWD") + "/tmp" + " -Dlog4j.configuration=container-log4j.properties" + " -Dyarn.app.container.log.dir=<LOG_DIR>" + " -Dyarn.app.container.log.filesize=0" + " -Dhadoop.root.logger=INFO,CLA -Dhadoop.root.logfile=syslog" + " -Dyarn.app.mapreduce.shuffle.logger=INFO," + appenderName + " -Dyarn.app.mapreduce.shuffle.logfile=syslog.shuffle" + " -Dyarn.app.mapreduce.shuffle.log.filesize=" + shuffleLogSize + " -Dyarn.app.mapreduce.shuffle.log.backups=" + shuffleBackups + " org.apache.hadoop.mapred.YarnChild 127.0.0.1" + " 54321" + " attempt_0_0000_r_000000_0" + " 0" + " 1><LOG_DIR>/stdout" + " 2><LOG_DIR>/stderr ]"), (Object)MyMRApp.access$000((MyMRApp)app));
        Assert.assertTrue((String)"HADOOP_ROOT_LOGGER not set for job", (boolean)MyMRApp.access$100((MyMRApp)app).containsKey("HADOOP_ROOT_LOGGER"));
        Assert.assertEquals((Object)"INFO,console", MyMRApp.access$100((MyMRApp)app).get("HADOOP_ROOT_LOGGER"));
        Assert.assertTrue((String)"HADOOP_CLIENT_OPTS not set for job", (boolean)MyMRApp.access$100((MyMRApp)app).containsKey("HADOOP_CLIENT_OPTS"));
        Assert.assertEquals((Object)"", MyMRApp.access$100((MyMRApp)app).get("HADOOP_CLIENT_OPTS"));
    }

    @Test(timeout=30000L)
    public void testCommandLineWithLog4JConifg() throws Exception {
        MyMRApp app = new MyMRApp(1, 0, true, this.getClass().getName(), true);
        Configuration conf = new Configuration();
        conf.setBoolean("mapreduce.app-submission.cross-platform", true);
        String testLogPropertieFile = "test-log4j.properties";
        String testLogPropertiePath = "../test-log4j.properties";
        conf.set("mapreduce.job.log4j-properties-file", testLogPropertiePath);
        Job job = app.submit(conf);
        app.waitForState(job, JobState.SUCCEEDED);
        app.verifyCompleted();
        Assert.assertEquals((Object)("[" + MRApps.crossPlatformify((String)"JAVA_HOME") + "/bin/java" + " -Djava.net.preferIPv4Stack=true" + " -Dhadoop.metrics.log.level=WARN" + "  -Xmx200m -Djava.io.tmpdir=" + MRApps.crossPlatformify((String)"PWD") + "/tmp" + " -Dlog4j.configuration=" + testLogPropertieFile + " -Dyarn.app.container.log.dir=<LOG_DIR>" + " -Dyarn.app.container.log.filesize=0" + " -Dhadoop.root.logger=INFO,CLA -Dhadoop.root.logfile=syslog" + " org.apache.hadoop.mapred.YarnChild 127.0.0.1" + " 54321" + " attempt_0_0000_m_000000_0" + " 0" + " 1><LOG_DIR>/stdout" + " 2><LOG_DIR>/stderr ]"), (Object)MyMRApp.access$000((MyMRApp)app));
    }

    @Test
    public void testEnvironmentVariables() throws Exception {
        MyMRApp app = new MyMRApp(1, 0, true, this.getClass().getName(), true);
        Configuration conf = new Configuration();
        conf.set("mapreduce.map.env", "HADOOP_CLIENT_OPTS=test");
        conf.setStrings("mapreduce.map.log.level", new String[]{"WARN"});
        conf.setBoolean("mapreduce.app-submission.cross-platform", false);
        Job job = app.submit(conf);
        app.waitForState(job, JobState.SUCCEEDED);
        app.verifyCompleted();
        Assert.assertTrue((String)"HADOOP_ROOT_LOGGER not set for job", (boolean)MyMRApp.access$100((MyMRApp)app).containsKey("HADOOP_ROOT_LOGGER"));
        Assert.assertEquals((Object)"WARN,console", MyMRApp.access$100((MyMRApp)app).get("HADOOP_ROOT_LOGGER"));
        Assert.assertTrue((String)"HADOOP_CLIENT_OPTS not set for job", (boolean)MyMRApp.access$100((MyMRApp)app).containsKey("HADOOP_CLIENT_OPTS"));
        Assert.assertEquals((Object)"test", MyMRApp.access$100((MyMRApp)app).get("HADOOP_CLIENT_OPTS"));
        app = new MyMRApp(1, 0, true, this.getClass().getName(), true);
        conf = new Configuration();
        conf.set("mapreduce.map.env", "HADOOP_ROOT_LOGGER=trace");
        job = app.submit(conf);
        app.waitForState(job, JobState.SUCCEEDED);
        app.verifyCompleted();
        Assert.assertTrue((String)"HADOOP_ROOT_LOGGER not set for job", (boolean)MyMRApp.access$100((MyMRApp)app).containsKey("HADOOP_ROOT_LOGGER"));
        Assert.assertEquals((Object)"trace", MyMRApp.access$100((MyMRApp)app).get("HADOOP_ROOT_LOGGER"));
        app = new MyMRApp(1, 0, true, this.getClass().getName(), true);
        conf = new Configuration();
        conf.set("mapreduce.map.env.HADOOP_ROOT_LOGGER", "DEBUG,console");
        job = app.submit(conf);
        app.waitForState(job, JobState.SUCCEEDED);
        app.verifyCompleted();
        Assert.assertTrue((String)"HADOOP_ROOT_LOGGER not set for job", (boolean)MyMRApp.access$100((MyMRApp)app).containsKey("HADOOP_ROOT_LOGGER"));
        Assert.assertEquals((Object)"DEBUG,console", MyMRApp.access$100((MyMRApp)app).get("HADOOP_ROOT_LOGGER"));
    }

    static /* synthetic */ Log access$200() {
        return LOG;
    }
}

