/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.v2.app.speculate.forecast;

import java.util.concurrent.atomic.AtomicReference;
import org.apache.hadoop.mapreduce.v2.app.speculate.forecast.SimpleExponentialSmoothing;

/*
 * Exception performing whole class analysis ignored.
 */
public class SimpleExponentialSmoothing {
    private static final double DEFAULT_FORECAST = -1.0;
    private final int kMinimumReads;
    private final long kStagnatedWindow;
    private final long startTime;
    private long timeConstant;
    private AtomicReference<ForecastRecord> forecastRefEntry;

    public static SimpleExponentialSmoothing createForecast(long timeConstant, int skipCnt, long stagnatedWindow, long timeStamp) {
        return new SimpleExponentialSmoothing(timeConstant, skipCnt, stagnatedWindow, timeStamp);
    }

    SimpleExponentialSmoothing(long ktConstant, int skipCnt, long stagnatedWindow, long timeStamp) {
        this.kMinimumReads = skipCnt;
        this.kStagnatedWindow = stagnatedWindow;
        this.timeConstant = ktConstant;
        this.startTime = timeStamp;
        this.forecastRefEntry = new AtomicReference<Object>(null);
    }

    public boolean isDataStagnated(long timeStamp) {
        ForecastRecord rec = (ForecastRecord)this.forecastRefEntry.get();
        if (rec != null && ForecastRecord.access$300((ForecastRecord)rec) > (long)this.kMinimumReads) {
            return ForecastRecord.access$400((ForecastRecord)rec) + this.kStagnatedWindow > timeStamp;
        }
        return false;
    }

    static double processRawData(double oldRawData, long oldTime, double newRawData, long newTime) {
        double rate = (newRawData - oldRawData) / (double)(newTime - oldTime);
        return rate;
    }

    public void incorporateReading(long timeStamp, double currRawData) {
        ForecastRecord oldRec = (ForecastRecord)this.forecastRefEntry.get();
        if (oldRec == null) {
            double oldForecast = SimpleExponentialSmoothing.processRawData((double)0.0, (long)this.startTime, (double)currRawData, (long)timeStamp);
            this.forecastRefEntry.compareAndSet(null, new ForecastRecord(this, oldForecast, 0.0, this.startTime));
            this.incorporateReading(timeStamp, currRawData);
            return;
        }
        while (!this.forecastRefEntry.compareAndSet(oldRec, oldRec.append(timeStamp, currRawData))) {
            oldRec = (ForecastRecord)this.forecastRefEntry.get();
        }
    }

    public double getForecast() {
        ForecastRecord rec = (ForecastRecord)this.forecastRefEntry.get();
        if (rec != null && ForecastRecord.access$300((ForecastRecord)rec) > (long)this.kMinimumReads) {
            return ForecastRecord.access$500((ForecastRecord)rec);
        }
        return -1.0;
    }

    public boolean isDefaultForecast(double value) {
        return value == -1.0;
    }

    public double getSSE() {
        ForecastRecord rec = (ForecastRecord)this.forecastRefEntry.get();
        if (rec != null) {
            return ForecastRecord.access$600((ForecastRecord)rec);
        }
        return -1.0;
    }

    public boolean isErrorWithinBound(double bound) {
        double squaredErr = this.getSSE();
        if (squaredErr < 0.0) {
            return false;
        }
        return bound > squaredErr;
    }

    public double getRawData() {
        ForecastRecord rec = (ForecastRecord)this.forecastRefEntry.get();
        if (rec != null) {
            return ForecastRecord.access$700((ForecastRecord)rec);
        }
        return -1.0;
    }

    public long getTimeStamp() {
        ForecastRecord rec = (ForecastRecord)this.forecastRefEntry.get();
        if (rec != null) {
            return ForecastRecord.access$400((ForecastRecord)rec);
        }
        return 0L;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public AtomicReference<ForecastRecord> getForecastRefEntry() {
        return this.forecastRefEntry;
    }

    public String toString() {
        String res = "NULL";
        ForecastRecord rec = (ForecastRecord)this.forecastRefEntry.get();
        if (rec != null) {
            res = "rec.index = " + ForecastRecord.access$300((ForecastRecord)rec) + ", forecast t: " + ForecastRecord.access$400((ForecastRecord)rec) + ", forecast: " + ForecastRecord.access$500((ForecastRecord)rec) + ", sample: " + ForecastRecord.access$800((ForecastRecord)rec) + ", raw: " + ForecastRecord.access$700((ForecastRecord)rec) + ", error: " + ForecastRecord.access$600((ForecastRecord)rec) + ", alpha: " + ForecastRecord.access$900((ForecastRecord)rec);
        }
        return res;
    }

    static /* synthetic */ int access$000(SimpleExponentialSmoothing x0) {
        return x0.kMinimumReads;
    }

    static /* synthetic */ long access$102(SimpleExponentialSmoothing x0, long x1) {
        x0.timeConstant = x1;
        return x0.timeConstant;
    }

    static /* synthetic */ long access$100(SimpleExponentialSmoothing x0) {
        return x0.timeConstant;
    }

    static /* synthetic */ long access$200(SimpleExponentialSmoothing x0) {
        return x0.startTime;
    }
}

