/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.v2.app.metrics;

import org.apache.hadoop.mapreduce.v2.api.records.TaskType;
import org.apache.hadoop.mapreduce.v2.app.job.Job;
import org.apache.hadoop.mapreduce.v2.app.job.Task;
import org.apache.hadoop.mapreduce.v2.app.metrics.MRAppMetrics;
import org.apache.hadoop.metrics2.MetricsRecordBuilder;
import org.apache.hadoop.test.MetricsAsserts;
import org.apache.hadoop.test.MockitoMaker;
import org.junit.Test;
import org.mockito.Mockito;

public class TestMRAppMetrics {
    @Test
    public void testNames() {
        Job job = (Job)Mockito.mock(Job.class);
        Task mapTask = (Task)MockitoMaker.make((Object)((Task)MockitoMaker.stub(Task.class).returning((Object)TaskType.MAP).from).getType());
        Task reduceTask = (Task)MockitoMaker.make((Object)((Task)MockitoMaker.stub(Task.class).returning((Object)TaskType.REDUCE).from).getType());
        MRAppMetrics metrics = MRAppMetrics.create();
        metrics.submittedJob(job);
        metrics.waitingTask(mapTask);
        metrics.waitingTask(reduceTask);
        metrics.preparingJob(job);
        metrics.submittedJob(job);
        metrics.waitingTask(mapTask);
        metrics.waitingTask(reduceTask);
        metrics.preparingJob(job);
        metrics.submittedJob(job);
        metrics.waitingTask(mapTask);
        metrics.waitingTask(reduceTask);
        metrics.preparingJob(job);
        metrics.endPreparingJob(job);
        metrics.endPreparingJob(job);
        metrics.endPreparingJob(job);
        metrics.runningJob(job);
        metrics.launchedTask(mapTask);
        metrics.runningTask(mapTask);
        metrics.failedTask(mapTask);
        metrics.endWaitingTask(reduceTask);
        metrics.endRunningTask(mapTask);
        metrics.endRunningJob(job);
        metrics.failedJob(job);
        metrics.runningJob(job);
        metrics.launchedTask(mapTask);
        metrics.runningTask(mapTask);
        metrics.killedTask(mapTask);
        metrics.endWaitingTask(reduceTask);
        metrics.endRunningTask(mapTask);
        metrics.endRunningJob(job);
        metrics.killedJob(job);
        metrics.runningJob(job);
        metrics.launchedTask(mapTask);
        metrics.runningTask(mapTask);
        metrics.completedTask(mapTask);
        metrics.endRunningTask(mapTask);
        metrics.launchedTask(reduceTask);
        metrics.runningTask(reduceTask);
        metrics.completedTask(reduceTask);
        metrics.endRunningTask(reduceTask);
        metrics.endRunningJob(job);
        metrics.completedJob(job);
        this.checkMetrics(3, 1, 1, 1, 0, 0, 3, 1, 1, 1, 0, 0, 1, 1, 0, 0, 0, 0);
    }

    private void checkMetrics(int jobsSubmitted, int jobsCompleted, int jobsFailed, int jobsKilled, int jobsPreparing, int jobsRunning, int mapsLaunched, int mapsCompleted, int mapsFailed, int mapsKilled, int mapsRunning, int mapsWaiting, int reducesLaunched, int reducesCompleted, int reducesFailed, int reducesKilled, int reducesRunning, int reducesWaiting) {
        MetricsRecordBuilder rb = MetricsAsserts.getMetrics((String)"MRAppMetrics");
        MetricsAsserts.assertCounter((String)"JobsSubmitted", (int)jobsSubmitted, (MetricsRecordBuilder)rb);
        MetricsAsserts.assertCounter((String)"JobsCompleted", (int)jobsCompleted, (MetricsRecordBuilder)rb);
        MetricsAsserts.assertCounter((String)"JobsFailed", (int)jobsFailed, (MetricsRecordBuilder)rb);
        MetricsAsserts.assertCounter((String)"JobsKilled", (int)jobsKilled, (MetricsRecordBuilder)rb);
        MetricsAsserts.assertGauge((String)"JobsPreparing", (int)jobsPreparing, (MetricsRecordBuilder)rb);
        MetricsAsserts.assertGauge((String)"JobsRunning", (int)jobsRunning, (MetricsRecordBuilder)rb);
        MetricsAsserts.assertCounter((String)"MapsLaunched", (int)mapsLaunched, (MetricsRecordBuilder)rb);
        MetricsAsserts.assertCounter((String)"MapsCompleted", (int)mapsCompleted, (MetricsRecordBuilder)rb);
        MetricsAsserts.assertCounter((String)"MapsFailed", (int)mapsFailed, (MetricsRecordBuilder)rb);
        MetricsAsserts.assertCounter((String)"MapsKilled", (int)mapsKilled, (MetricsRecordBuilder)rb);
        MetricsAsserts.assertGauge((String)"MapsRunning", (int)mapsRunning, (MetricsRecordBuilder)rb);
        MetricsAsserts.assertGauge((String)"MapsWaiting", (int)mapsWaiting, (MetricsRecordBuilder)rb);
        MetricsAsserts.assertCounter((String)"ReducesLaunched", (int)reducesLaunched, (MetricsRecordBuilder)rb);
        MetricsAsserts.assertCounter((String)"ReducesCompleted", (int)reducesCompleted, (MetricsRecordBuilder)rb);
        MetricsAsserts.assertCounter((String)"ReducesFailed", (int)reducesFailed, (MetricsRecordBuilder)rb);
        MetricsAsserts.assertCounter((String)"ReducesKilled", (int)reducesKilled, (MetricsRecordBuilder)rb);
        MetricsAsserts.assertGauge((String)"ReducesRunning", (int)reducesRunning, (MetricsRecordBuilder)rb);
        MetricsAsserts.assertGauge((String)"ReducesWaiting", (int)reducesWaiting, (MetricsRecordBuilder)rb);
    }
}

