/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.net.InetSocketAddress;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.JVMId;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.Task;
import org.apache.hadoop.mapred.TaskAttemptID;
import org.apache.hadoop.mapred.TaskLog;
import org.apache.hadoop.mapred.YarnChild;
import org.apache.hadoop.mapreduce.v2.util.MRApps;
import org.apache.hadoop.yarn.api.ApplicationConstants;

/*
 * Exception performing whole class analysis ignored.
 */
public class MapReduceChildJVM {
    private static String getTaskLogFile(TaskLog.LogName filter) {
        return "<LOG_DIR>/" + filter.toString();
    }

    private static String getChildEnv(JobConf jobConf, boolean isMap) {
        if (isMap) {
            return jobConf.get("mapreduce.map.env", jobConf.get("mapred.child.env"));
        }
        return jobConf.get("mapreduce.reduce.env", jobConf.get("mapred.child.env"));
    }

    private static String getChildLogLevel(JobConf conf, boolean isMap) {
        if (isMap) {
            return conf.get("mapreduce.map.log.level", JobConf.DEFAULT_LOG_LEVEL.toString());
        }
        return conf.get("mapreduce.reduce.log.level", JobConf.DEFAULT_LOG_LEVEL.toString());
    }

    public static void setVMEnv(Map<String, String> environment, Task task) {
        String[] keys;
        JobConf conf = task.conf;
        String mapredChildEnv = MapReduceChildJVM.getChildEnv((JobConf)conf, (boolean)task.isMapTask());
        MRApps.setEnvFromInputString(environment, (String)mapredChildEnv, (Configuration)conf);
        environment.put("HADOOP_ROOT_LOGGER", MapReduceChildJVM.getChildLogLevel((JobConf)conf, (boolean)task.isMapTask()) + ",console");
        String hadoopClientOpts = System.getenv("HADOOP_CLIENT_OPTS");
        hadoopClientOpts = hadoopClientOpts == null ? "" : hadoopClientOpts + " ";
        environment.put("HADOOP_CLIENT_OPTS", hadoopClientOpts);
        HashMap tmpEnv = new HashMap();
        MRApps.setEnvFromInputString(tmpEnv, (String)mapredChildEnv, (Configuration)conf);
        for (String key : keys = new String[]{"HADOOP_ROOT_LOGGER", "HADOOP_CLIENT_OPTS"}) {
            if (!tmpEnv.containsKey(key)) continue;
            environment.put(key, (String)tmpEnv.get(key));
        }
        environment.put("STDOUT_LOGFILE_ENV", MapReduceChildJVM.getTaskLogFile((TaskLog.LogName)TaskLog.LogName.STDOUT));
        environment.put("STDERR_LOGFILE_ENV", MapReduceChildJVM.getTaskLogFile((TaskLog.LogName)TaskLog.LogName.STDERR));
    }

    private static String getChildJavaOpts(JobConf jobConf, boolean isMapTask) {
        String userClasspath = "";
        String adminClasspath = "";
        if (isMapTask) {
            userClasspath = jobConf.get("mapreduce.map.java.opts", jobConf.get("mapred.child.java.opts", "-Xmx200m"));
            adminClasspath = jobConf.get("mapreduce.admin.map.child.java.opts", "-Djava.net.preferIPv4Stack=true -Dhadoop.metrics.log.level=WARN ");
        } else {
            userClasspath = jobConf.get("mapreduce.reduce.java.opts", jobConf.get("mapred.child.java.opts", "-Xmx200m"));
            adminClasspath = jobConf.get("mapreduce.admin.reduce.child.java.opts", "-Djava.net.preferIPv4Stack=true -Dhadoop.metrics.log.level=WARN ");
        }
        return adminClasspath + " " + userClasspath;
    }

    private static void setupLog4jProperties(Task task, Vector<String> vargs, long logSize, Configuration conf) {
        String logLevel = MapReduceChildJVM.getChildLogLevel((JobConf)task.conf, (boolean)task.isMapTask());
        int numBackups = task.conf.getInt("yarn.app.mapreduce.task.container.log.backups", 0);
        MRApps.addLog4jSystemProperties((String)logLevel, (long)logSize, (int)numBackups, vargs, (Configuration)conf);
    }

    public static List<String> getVMCommand(InetSocketAddress taskAttemptListenerAddr, Task task, JVMId jvmID) {
        TaskAttemptID attemptID = task.getTaskID();
        JobConf conf = task.conf;
        Vector<String> vargs = new Vector<String>(8);
        vargs.add(MRApps.crossPlatformifyMREnv((Configuration)task.conf, (ApplicationConstants.Environment)ApplicationConstants.Environment.JAVA_HOME) + "/bin/java");
        String javaOpts = MapReduceChildJVM.getChildJavaOpts((JobConf)conf, (boolean)task.isMapTask());
        javaOpts = javaOpts.replace("@taskid@", attemptID.toString());
        String[] javaOptsSplit = javaOpts.split(" ");
        for (int i = 0; i < javaOptsSplit.length; ++i) {
            vargs.add(javaOptsSplit[i]);
        }
        Path childTmpDir = new Path(MRApps.crossPlatformifyMREnv((Configuration)conf, (ApplicationConstants.Environment)ApplicationConstants.Environment.PWD), "./tmp");
        vargs.add("-Djava.io.tmpdir=" + childTmpDir);
        long logSize = TaskLog.getTaskLogLength((JobConf)conf);
        MapReduceChildJVM.setupLog4jProperties((Task)task, vargs, (long)logSize, (Configuration)conf);
        if (conf.getProfileEnabled() && conf.getProfileTaskRange(task.isMapTask()).isIncluded(task.getPartition())) {
            String profileParams = conf.get(task.isMapTask() ? "mapreduce.task.profile.map.params" : "mapreduce.task.profile.reduce.params", conf.getProfileParams());
            vargs.add(String.format(profileParams, MapReduceChildJVM.getTaskLogFile((TaskLog.LogName)TaskLog.LogName.PROFILE)));
        }
        vargs.add(YarnChild.class.getName());
        vargs.add(taskAttemptListenerAddr.getAddress().getHostAddress());
        vargs.add(Integer.toString(taskAttemptListenerAddr.getPort()));
        vargs.add(attemptID.toString());
        vargs.add(String.valueOf(jvmID.getId()));
        vargs.add("1>" + MapReduceChildJVM.getTaskLogFile((TaskLog.LogName)TaskLog.LogName.STDOUT));
        vargs.add("2>" + MapReduceChildJVM.getTaskLogFile((TaskLog.LogName)TaskLog.LogName.STDERR));
        StringBuilder mergedCommand = new StringBuilder();
        for (String str : vargs) {
            mergedCommand.append((CharSequence)str).append(" ");
        }
        Vector<String> vargsFinal = new Vector<String>(1);
        vargsFinal.add(mergedCommand.toString());
        return vargsFinal;
    }
}

