/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.v2.app.webapp;

import com.google.inject.Inject;
import java.util.List;
import org.apache.hadoop.mapreduce.v2.api.records.AMInfo;
import org.apache.hadoop.mapreduce.v2.api.records.JobId;
import org.apache.hadoop.mapreduce.v2.api.records.TaskId;
import org.apache.hadoop.mapreduce.v2.app.webapp.App;
import org.apache.hadoop.mapreduce.v2.util.MRApps;
import org.apache.hadoop.mapreduce.v2.util.MRWebAppUtil;
import org.apache.hadoop.yarn.webapp.hamlet.Hamlet;
import org.apache.hadoop.yarn.webapp.view.HtmlBlock;

public class NavBlock
extends HtmlBlock {
    final App app;

    @Inject
    NavBlock(App app) {
        this.app = app;
    }

    protected void render(HtmlBlock.Block html) {
        String rmweb = this.$("rm.web");
        Hamlet.DIV nav = (Hamlet.DIV)((Hamlet.UL)((Hamlet.UL)((Hamlet.DIV)((Hamlet.UL)((Hamlet.UL)((Hamlet.UL)html.div("#nav").h3("Cluster").ul().li().a(this.url(new String[]{rmweb, "cluster", "cluster"}), "About")._()).li().a(this.url(new String[]{rmweb, "cluster", "apps"}), "Applications")._()).li().a(this.url(new String[]{rmweb, "cluster", "scheduler"}), "Scheduler")._())._()).h3("Application").ul().li().a(this.url(new String[]{"app/info"}), "About")._()).li().a(this.url(new String[]{"app"}), "Jobs")._())._();
        if (this.app.getJob() != null) {
            String jobid = MRApps.toString((JobId)this.app.getJob().getID());
            List amInfos = this.app.getJob().getAMInfos();
            AMInfo thisAmInfo = (AMInfo)amInfos.get(amInfos.size() - 1);
            String nodeHttpAddress = thisAmInfo.getNodeManagerHost() + ":" + thisAmInfo.getNodeManagerHttpPort();
            ((Hamlet.UL)((Hamlet.UL)((Hamlet.UL)((Hamlet.UL)((Hamlet.UL)((Hamlet.UL)nav.h3("Job").ul().li().a(this.url(new String[]{"job", jobid}), "Overview")._()).li().a(this.url(new String[]{"jobcounters", jobid}), "Counters")._()).li().a(this.url(new String[]{"conf", jobid}), "Configuration")._()).li().a(this.url(new String[]{"tasks", jobid, "m"}), "Map tasks")._()).li().a(this.url(new String[]{"tasks", jobid, "r"}), "Reduce tasks")._()).li().a(".logslink", this.url(new String[]{MRWebAppUtil.getYARNWebappScheme(), nodeHttpAddress, "node", "containerlogs", thisAmInfo.getContainerId().toString(), this.app.getJob().getUserName()}), "AM Logs")._())._();
            if (this.app.getTask() != null) {
                String taskid = MRApps.toString((TaskId)this.app.getTask().getID());
                ((Hamlet.UL)((Hamlet.UL)nav.h3("Task").ul().li().a(this.url(new String[]{"task", taskid}), "Task Overview")._()).li().a(this.url(new String[]{"taskcounters", taskid}), "Counters")._())._();
            }
        }
        ((Hamlet.DIV)((Hamlet.UL)((Hamlet.UL)((Hamlet.UL)((Hamlet.UL)nav.h3("Tools").ul().li().a("/conf", "Configuration")._()).li().a("/logs", "Local logs")._()).li().a("/stacks", "Server stacks")._()).li().a("/metrics", "Server metrics")._())._())._();
    }
}

