/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.AMFeedback;
import org.apache.hadoop.mapred.Counters;
import org.apache.hadoop.mapred.JVMId;
import org.apache.hadoop.mapred.JobID;
import org.apache.hadoop.mapred.JvmContext;
import org.apache.hadoop.mapred.JvmTask;
import org.apache.hadoop.mapred.MapTaskCompletionEventsUpdate;
import org.apache.hadoop.mapred.MapTaskStatus;
import org.apache.hadoop.mapred.ReduceTaskStatus;
import org.apache.hadoop.mapred.Task;
import org.apache.hadoop.mapred.TaskAttemptID;
import org.apache.hadoop.mapred.TaskAttemptListenerImpl;
import org.apache.hadoop.mapred.TaskID;
import org.apache.hadoop.mapred.TaskStatus;
import org.apache.hadoop.mapred.WrappedJvmID;
import org.apache.hadoop.mapreduce.TaskType;
import org.apache.hadoop.mapreduce.TypeConverter;
import org.apache.hadoop.mapreduce.checkpoint.EnumCounter;
import org.apache.hadoop.mapreduce.checkpoint.FSCheckpointID;
import org.apache.hadoop.mapreduce.checkpoint.TaskCheckpointID;
import org.apache.hadoop.mapreduce.security.token.JobTokenSecretManager;
import org.apache.hadoop.mapreduce.v2.api.records.JobId;
import org.apache.hadoop.mapreduce.v2.api.records.Phase;
import org.apache.hadoop.mapreduce.v2.api.records.TaskAttemptCompletionEvent;
import org.apache.hadoop.mapreduce.v2.api.records.TaskAttemptCompletionEventStatus;
import org.apache.hadoop.mapreduce.v2.api.records.TaskAttemptId;
import org.apache.hadoop.mapreduce.v2.api.records.TaskId;
import org.apache.hadoop.mapreduce.v2.app.AppContext;
import org.apache.hadoop.mapreduce.v2.app.TaskHeartbeatHandler;
import org.apache.hadoop.mapreduce.v2.app.job.Job;
import org.apache.hadoop.mapreduce.v2.app.job.event.TaskAttemptStatusUpdateEvent;
import org.apache.hadoop.mapreduce.v2.app.rm.RMHeartbeatHandler;
import org.apache.hadoop.mapreduce.v2.app.rm.preemption.AMPreemptionPolicy;
import org.apache.hadoop.mapreduce.v2.app.rm.preemption.CheckpointAMPreemptionPolicy;
import org.apache.hadoop.mapreduce.v2.util.MRBuilderUtils;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.yarn.event.Dispatcher;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.event.EventHandler;
import org.apache.hadoop.yarn.factories.RecordFactory;
import org.apache.hadoop.yarn.factory.providers.RecordFactoryProvider;
import org.apache.hadoop.yarn.util.ControlledClock;
import org.apache.hadoop.yarn.util.SystemClock;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.Captor;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class TestTaskAttemptListenerImpl {
    private static final String ATTEMPT1_ID = "attempt_123456789012_0001_m_000001_0";
    private static final String ATTEMPT2_ID = "attempt_123456789012_0001_m_000002_0";
    private static final TaskAttemptId TASKATTEMPTID1 = TypeConverter.toYarn((TaskAttemptID)TaskAttemptID.forName((String)"attempt_123456789012_0001_m_000001_0"));
    private static final TaskAttemptId TASKATTEMPTID2 = TypeConverter.toYarn((TaskAttemptID)TaskAttemptID.forName((String)"attempt_123456789012_0001_m_000002_0"));
    @Mock
    private AppContext appCtx;
    @Mock
    private JobTokenSecretManager secret;
    @Mock
    private RMHeartbeatHandler rmHeartbeatHandler;
    @Mock
    private TaskHeartbeatHandler hbHandler;
    @Mock
    private Dispatcher dispatcher;
    @Mock
    private Task task;
    @Mock
    private EventHandler<Event> ea;
    @Captor
    private ArgumentCaptor<Event> eventCaptor;
    private CheckpointAMPreemptionPolicy policy;
    private JVMId id;
    private WrappedJvmID wid;
    private TaskAttemptID attemptID;
    private TaskAttemptId attemptId;
    private ReduceTaskStatus firstReduceStatus;
    private ReduceTaskStatus secondReduceStatus;
    private ReduceTaskStatus thirdReduceStatus;
    private MockTaskAttemptListenerImpl listener;

    @After
    public void after() throws IOException {
        if (this.listener != null) {
            this.listener.close();
            this.listener = null;
        }
    }

    @Test(timeout=5000L)
    public void testGetTask() throws IOException {
        this.configureMocks();
        this.startListener(false);
        JvmContext context = new JvmContext();
        context.jvmId = this.id;
        JvmTask result = this.listener.getTask(context);
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)result.shouldDie);
        this.listener.registerPendingTask(this.task, this.wid);
        result = this.listener.getTask(context);
        Assert.assertNull((Object)result);
        this.listener.unregister(this.attemptId, this.wid);
        this.listener.registerPendingTask(this.task, this.wid);
        this.listener.registerLaunchedTask(this.attemptId, this.wid);
        ((TaskHeartbeatHandler)Mockito.verify((Object)this.hbHandler)).register(this.attemptId);
        result = this.listener.getTask(context);
        Assert.assertNotNull((Object)result);
        Assert.assertFalse((boolean)result.shouldDie);
        result = this.listener.getTask(context);
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)result.shouldDie);
        this.listener.unregister(this.attemptId, this.wid);
        result = this.listener.getTask(context);
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)result.shouldDie);
        JVMId jvmid = JVMId.forName((String)"jvm_001_002_m_004");
        Assert.assertNotNull((Object)jvmid);
        try {
            JVMId.forName((String)"jvm_001_002_m_004_006");
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)e.getMessage(), (Object)"TaskId string : jvm_001_002_m_004_006 is not properly formed");
        }
    }

    @Test(timeout=5000L)
    public void testJVMId() {
        JVMId jvmid = new JVMId("test", 1, true, 2L);
        JVMId jvmid1 = JVMId.forName((String)"jvm_test_0001_m_000002");
        Assert.assertEquals((long)0L, (long)jvmid.compareTo(jvmid1));
    }

    @Test(timeout=10000L)
    public void testGetMapCompletionEvents() throws IOException {
        TaskAttemptCompletionEvent[] empty = new TaskAttemptCompletionEvent[]{};
        TaskAttemptCompletionEvent[] taskEvents = new TaskAttemptCompletionEvent[]{TestTaskAttemptListenerImpl.createTce(0, true, TaskAttemptCompletionEventStatus.OBSOLETE), TestTaskAttemptListenerImpl.createTce(1, false, TaskAttemptCompletionEventStatus.FAILED), TestTaskAttemptListenerImpl.createTce(2, true, TaskAttemptCompletionEventStatus.SUCCEEDED), TestTaskAttemptListenerImpl.createTce(3, false, TaskAttemptCompletionEventStatus.FAILED)};
        TaskAttemptCompletionEvent[] mapEvents = new TaskAttemptCompletionEvent[]{taskEvents[0], taskEvents[2]};
        Job mockJob = (Job)Mockito.mock(Job.class);
        Mockito.when((Object)mockJob.getTaskAttemptCompletionEvents(0, 100)).thenReturn((Object)taskEvents);
        Mockito.when((Object)mockJob.getTaskAttemptCompletionEvents(0, 2)).thenReturn((Object)Arrays.copyOfRange(taskEvents, 0, 2));
        Mockito.when((Object)mockJob.getTaskAttemptCompletionEvents(2, 100)).thenReturn((Object)Arrays.copyOfRange(taskEvents, 2, 4));
        Mockito.when((Object)mockJob.getMapAttemptCompletionEvents(0, 100)).thenReturn((Object)TypeConverter.fromYarn((TaskAttemptCompletionEvent[])mapEvents));
        Mockito.when((Object)mockJob.getMapAttemptCompletionEvents(0, 2)).thenReturn((Object)TypeConverter.fromYarn((TaskAttemptCompletionEvent[])mapEvents));
        Mockito.when((Object)mockJob.getMapAttemptCompletionEvents(2, 100)).thenReturn((Object)TypeConverter.fromYarn((TaskAttemptCompletionEvent[])empty));
        this.configureMocks();
        Mockito.when((Object)this.appCtx.getJob((JobId)Mockito.any(JobId.class))).thenReturn((Object)mockJob);
        this.listener = new MockTaskAttemptListenerImpl(this.appCtx, this.secret, this.rmHeartbeatHandler, (AMPreemptionPolicy)this.policy){

            @Override
            protected void registerHeartbeatHandler(Configuration conf) {
                this.taskHeartbeatHandler = TestTaskAttemptListenerImpl.this.hbHandler;
            }
        };
        Configuration conf = new Configuration();
        this.listener.init(conf);
        this.listener.start();
        JobID jid = new JobID("12345", 1);
        TaskAttemptID tid = new TaskAttemptID("12345", 1, TaskType.REDUCE, 1, 0);
        MapTaskCompletionEventsUpdate update = this.listener.getMapCompletionEvents(jid, 0, 100, tid);
        Assert.assertEquals((long)2L, (long)update.events.length);
        update = this.listener.getMapCompletionEvents(jid, 0, 2, tid);
        Assert.assertEquals((long)2L, (long)update.events.length);
        update = this.listener.getMapCompletionEvents(jid, 2, 100, tid);
        Assert.assertEquals((long)0L, (long)update.events.length);
    }

    private static TaskAttemptCompletionEvent createTce(int eventId, boolean isMap, TaskAttemptCompletionEventStatus status) {
        JobId jid = MRBuilderUtils.newJobId((long)12345L, (int)1, (int)1);
        TaskId tid = MRBuilderUtils.newTaskId((JobId)jid, (int)0, (org.apache.hadoop.mapreduce.v2.api.records.TaskType)(isMap ? org.apache.hadoop.mapreduce.v2.api.records.TaskType.MAP : org.apache.hadoop.mapreduce.v2.api.records.TaskType.REDUCE));
        TaskAttemptId attemptId = MRBuilderUtils.newTaskAttemptId((TaskId)tid, (int)0);
        RecordFactory recordFactory = RecordFactoryProvider.getRecordFactory(null);
        TaskAttemptCompletionEvent tce = (TaskAttemptCompletionEvent)recordFactory.newRecordInstance(TaskAttemptCompletionEvent.class);
        tce.setEventId(eventId);
        tce.setAttemptId(attemptId);
        tce.setStatus(status);
        return tce;
    }

    @Test(timeout=10000L)
    public void testCommitWindow() throws IOException {
        SystemClock clock = SystemClock.getInstance();
        this.configureMocks();
        org.apache.hadoop.mapreduce.v2.app.job.Task mockTask = (org.apache.hadoop.mapreduce.v2.app.job.Task)Mockito.mock(org.apache.hadoop.mapreduce.v2.app.job.Task.class);
        Mockito.when((Object)mockTask.canCommit((TaskAttemptId)Mockito.any(TaskAttemptId.class))).thenReturn((Object)true);
        Job mockJob = (Job)Mockito.mock(Job.class);
        Mockito.when((Object)mockJob.getTask((TaskId)Mockito.any(TaskId.class))).thenReturn((Object)mockTask);
        Mockito.when((Object)this.appCtx.getJob((JobId)Mockito.any(JobId.class))).thenReturn((Object)mockJob);
        Mockito.when((Object)this.appCtx.getClock()).thenReturn((Object)clock);
        this.listener = new MockTaskAttemptListenerImpl(this.appCtx, this.secret, this.rmHeartbeatHandler, (AMPreemptionPolicy)this.policy){

            @Override
            protected void registerHeartbeatHandler(Configuration conf) {
                this.taskHeartbeatHandler = TestTaskAttemptListenerImpl.this.hbHandler;
            }
        };
        Configuration conf = new Configuration();
        this.listener.init(conf);
        this.listener.start();
        TaskAttemptID tid = new TaskAttemptID("12345", 1, TaskType.REDUCE, 1, 0);
        boolean canCommit = this.listener.canCommit(tid);
        Assert.assertFalse((boolean)canCommit);
        ((org.apache.hadoop.mapreduce.v2.app.job.Task)Mockito.verify((Object)mockTask, (VerificationMode)Mockito.never())).canCommit((TaskAttemptId)Mockito.any(TaskAttemptId.class));
        Mockito.when((Object)this.rmHeartbeatHandler.getLastHeartbeatTime()).thenReturn((Object)clock.getTime());
        canCommit = this.listener.canCommit(tid);
        Assert.assertTrue((boolean)canCommit);
        ((org.apache.hadoop.mapreduce.v2.app.job.Task)Mockito.verify((Object)mockTask, (VerificationMode)Mockito.times((int)1))).canCommit((TaskAttemptId)Mockito.any(TaskAttemptId.class));
    }

    @Test
    public void testCheckpointIDTracking() throws IOException, InterruptedException {
        TaskCheckpointID outcid;
        SystemClock clock = SystemClock.getInstance();
        this.configureMocks();
        org.apache.hadoop.mapreduce.v2.app.job.Task mockTask = (org.apache.hadoop.mapreduce.v2.app.job.Task)Mockito.mock(org.apache.hadoop.mapreduce.v2.app.job.Task.class);
        Mockito.when((Object)mockTask.canCommit((TaskAttemptId)Mockito.any(TaskAttemptId.class))).thenReturn((Object)true);
        Job mockJob = (Job)Mockito.mock(Job.class);
        Mockito.when((Object)mockJob.getTask((TaskId)Mockito.any(TaskId.class))).thenReturn((Object)mockTask);
        Mockito.when((Object)this.appCtx.getJob((JobId)Mockito.any(JobId.class))).thenReturn((Object)mockJob);
        Mockito.when((Object)this.appCtx.getClock()).thenReturn((Object)clock);
        this.listener = new MockTaskAttemptListenerImpl(this.appCtx, this.secret, this.rmHeartbeatHandler, (AMPreemptionPolicy)this.policy){

            @Override
            protected void registerHeartbeatHandler(Configuration conf) {
                this.taskHeartbeatHandler = TestTaskAttemptListenerImpl.this.hbHandler;
            }
        };
        Configuration conf = new Configuration();
        conf.setBoolean("mapreduce.job.preemption", true);
        this.listener.init(conf);
        this.listener.start();
        TaskAttemptID tid = new TaskAttemptID("12345", 1, TaskType.REDUCE, 1, 0);
        ArrayList<Path> partialOut = new ArrayList<Path>();
        partialOut.add(new Path("/prev1"));
        partialOut.add(new Path("/prev2"));
        Counters counters = (Counters)Mockito.mock(Counters.class);
        long CBYTES = 0x4000000L;
        long CTIME = 4344L;
        Path CLOC = new Path("/test/1");
        Counters.Counter cbytes = (Counters.Counter)Mockito.mock(Counters.Counter.class);
        Mockito.when((Object)cbytes.getValue()).thenReturn((Object)0x4000000L);
        Counters.Counter ctime = (Counters.Counter)Mockito.mock(Counters.Counter.class);
        Mockito.when((Object)ctime.getValue()).thenReturn((Object)4344L);
        Mockito.when((Object)counters.findCounter((Enum)Mockito.eq((Object)EnumCounter.CHECKPOINT_BYTES))).thenReturn((Object)cbytes);
        Mockito.when((Object)counters.findCounter((Enum)Mockito.eq((Object)EnumCounter.CHECKPOINT_MS))).thenReturn((Object)ctime);
        TaskCheckpointID incid = new TaskCheckpointID(new FSCheckpointID(CLOC), partialOut, counters);
        this.listener.setCheckpointID(TaskID.downgrade((org.apache.hadoop.mapreduce.TaskID)tid.getTaskID()), incid);
        TaskCheckpointID tcid = outcid = this.listener.getCheckpointID(tid.getTaskID());
        Assert.assertEquals((long)0x4000000L, (long)tcid.getCheckpointBytes());
        Assert.assertEquals((long)4344L, (long)tcid.getCheckpointTime());
        Assert.assertTrue((boolean)partialOut.containsAll(tcid.getPartialCommittedOutput()));
        Assert.assertTrue((boolean)tcid.getPartialCommittedOutput().containsAll(partialOut));
        assert (outcid == incid);
    }

    @Test
    public void testStatusUpdateProgress() throws IOException, InterruptedException {
        this.configureMocks();
        this.startListener(true);
        ((TaskHeartbeatHandler)Mockito.verify((Object)this.hbHandler)).register(this.attemptId);
        AMFeedback feedback = this.listener.statusUpdate(this.attemptID, null);
        Assert.assertTrue((boolean)feedback.getTaskFound());
        ((TaskHeartbeatHandler)Mockito.verify((Object)this.hbHandler, (VerificationMode)Mockito.never())).progressing((TaskAttemptId)Mockito.eq((Object)this.attemptId));
        MapTaskStatus mockStatus = new MapTaskStatus(this.attemptID, 0.0f, 1, TaskStatus.State.RUNNING, "", "RUNNING", "", TaskStatus.Phase.MAP, new Counters());
        feedback = this.listener.statusUpdate(this.attemptID, (TaskStatus)mockStatus);
        Assert.assertTrue((boolean)feedback.getTaskFound());
        ((TaskHeartbeatHandler)Mockito.verify((Object)this.hbHandler)).progressing((TaskAttemptId)Mockito.eq((Object)this.attemptId));
    }

    @Test
    public void testSingleStatusUpdate() throws IOException, InterruptedException {
        this.configureMocks();
        this.startListener(true);
        this.listener.statusUpdate(this.attemptID, (TaskStatus)this.firstReduceStatus);
        ((EventHandler)Mockito.verify(this.ea)).handle((Event)this.eventCaptor.capture());
        TaskAttemptStatusUpdateEvent updateEvent = (TaskAttemptStatusUpdateEvent)this.eventCaptor.getValue();
        TaskAttemptStatusUpdateEvent.TaskAttemptStatus status = (TaskAttemptStatusUpdateEvent.TaskAttemptStatus)updateEvent.getTaskAttemptStatusRef().get();
        Assert.assertTrue((boolean)status.fetchFailedMaps.contains(TASKATTEMPTID1));
        Assert.assertEquals((long)1L, (long)status.fetchFailedMaps.size());
        Assert.assertEquals((Object)Phase.SHUFFLE, (Object)status.phase);
    }

    @Test
    public void testStatusUpdateEventCoalescing() throws IOException, InterruptedException {
        this.configureMocks();
        this.startListener(true);
        this.listener.statusUpdate(this.attemptID, (TaskStatus)this.firstReduceStatus);
        this.listener.statusUpdate(this.attemptID, (TaskStatus)this.secondReduceStatus);
        ((EventHandler)Mockito.verify(this.ea)).handle((Event)Mockito.any(Event.class));
        ConcurrentMap attemptIdToStatus = this.listener.getAttemptIdToStatus();
        TaskAttemptStatusUpdateEvent.TaskAttemptStatus status = (TaskAttemptStatusUpdateEvent.TaskAttemptStatus)((AtomicReference)attemptIdToStatus.get(this.attemptId)).get();
        Assert.assertTrue((boolean)status.fetchFailedMaps.contains(TASKATTEMPTID1));
        Assert.assertTrue((boolean)status.fetchFailedMaps.contains(TASKATTEMPTID2));
        Assert.assertEquals((long)2L, (long)status.fetchFailedMaps.size());
        Assert.assertEquals((Object)Phase.SORT, (Object)status.phase);
    }

    @Test
    public void testCoalescedStatusUpdatesCleared() throws IOException, InterruptedException {
        this.configureMocks();
        this.startListener(true);
        this.listener.statusUpdate(this.attemptID, (TaskStatus)this.firstReduceStatus);
        this.listener.statusUpdate(this.attemptID, (TaskStatus)this.secondReduceStatus);
        ConcurrentMap attemptIdToStatus = this.listener.getAttemptIdToStatus();
        ((AtomicReference)attemptIdToStatus.get(this.attemptId)).set(null);
        this.listener.statusUpdate(this.attemptID, (TaskStatus)this.thirdReduceStatus);
        ((EventHandler)Mockito.verify(this.ea, (VerificationMode)Mockito.times((int)2))).handle((Event)this.eventCaptor.capture());
        TaskAttemptStatusUpdateEvent updateEvent = (TaskAttemptStatusUpdateEvent)this.eventCaptor.getValue();
        TaskAttemptStatusUpdateEvent.TaskAttemptStatus status = (TaskAttemptStatusUpdateEvent.TaskAttemptStatus)updateEvent.getTaskAttemptStatusRef().get();
        Assert.assertNull((Object)status.fetchFailedMaps);
        Assert.assertEquals((Object)Phase.REDUCE, (Object)status.phase);
    }

    @Test
    public void testStatusUpdateFromUnregisteredTask() throws Exception {
        this.configureMocks();
        ControlledClock clock = new ControlledClock();
        clock.setTime(0L);
        ((AppContext)Mockito.doReturn((Object)clock).when((Object)this.appCtx)).getClock();
        final TaskAttemptListenerImpl tal = new TaskAttemptListenerImpl(this.appCtx, this.secret, this.rmHeartbeatHandler, (AMPreemptionPolicy)this.policy){

            protected void startRpcServer() {
            }

            protected void stopRpcServer() {
            }
        };
        Configuration conf = new Configuration();
        conf.setLong("mapreduce.task.timeout.check-interval-ms", 1L);
        conf.setDouble("mapreduce.task.log.progress.delta.threshold", 0.01);
        conf.setDouble("mapreduce.task.log.progress.wait.interval-seconds", 1.0);
        tal.init(conf);
        tal.start();
        AMFeedback feedback = tal.statusUpdate(this.attemptID, (TaskStatus)this.firstReduceStatus);
        Assert.assertFalse((boolean)feedback.getTaskFound());
        tal.registerPendingTask(this.task, this.wid);
        tal.registerLaunchedTask(this.attemptId, this.wid);
        feedback = tal.statusUpdate(this.attemptID, (TaskStatus)this.firstReduceStatus);
        Assert.assertTrue((boolean)feedback.getTaskFound());
        tal.unregister(this.attemptId, this.wid);
        feedback = tal.statusUpdate(this.attemptID, (TaskStatus)this.firstReduceStatus);
        Assert.assertTrue((boolean)feedback.getTaskFound());
        long unregisterTimeout = conf.getLong("mapreduce.task.exit.timeout", 60000L);
        clock.setTime(unregisterTimeout + 1L);
        GenericTestUtils.waitFor((Supplier)new Supplier<Boolean>(){

            @Override
            public Boolean get() {
                try {
                    AMFeedback response = tal.statusUpdate(TestTaskAttemptListenerImpl.this.attemptID, (TaskStatus)TestTaskAttemptListenerImpl.this.firstReduceStatus);
                    return !response.getTaskFound();
                }
                catch (Exception e) {
                    throw new RuntimeException("status update failed", e);
                }
            }
        }, (long)10L, (long)10000L);
    }

    private void configureMocks() {
        this.firstReduceStatus = new ReduceTaskStatus(this.attemptID, 0.0f, 1, TaskStatus.State.RUNNING, "", "RUNNING", "", TaskStatus.Phase.SHUFFLE, new Counters());
        this.firstReduceStatus.addFetchFailedMap(TaskAttemptID.forName((String)ATTEMPT1_ID));
        this.secondReduceStatus = new ReduceTaskStatus(this.attemptID, 0.0f, 1, TaskStatus.State.RUNNING, "", "RUNNING", "", TaskStatus.Phase.SORT, new Counters());
        this.secondReduceStatus.addFetchFailedMap(TaskAttemptID.forName((String)ATTEMPT2_ID));
        this.thirdReduceStatus = new ReduceTaskStatus(this.attemptID, 0.0f, 1, TaskStatus.State.RUNNING, "", "RUNNING", "", TaskStatus.Phase.REDUCE, new Counters());
        Mockito.when((Object)this.dispatcher.getEventHandler()).thenReturn(this.ea);
        Mockito.when((Object)this.appCtx.getEventHandler()).thenReturn(this.ea);
        this.policy = new CheckpointAMPreemptionPolicy();
        this.policy.init(this.appCtx);
        this.listener = new MockTaskAttemptListenerImpl(this.appCtx, this.secret, this.rmHeartbeatHandler, this.hbHandler, (AMPreemptionPolicy)this.policy);
        this.id = new JVMId("foo", 1, true, 1L);
        this.wid = new WrappedJvmID(this.id.getJobId(), this.id.isMap, this.id.getId());
        this.attemptID = new TaskAttemptID("1", 1, TaskType.MAP, 1, 1);
        this.attemptId = TypeConverter.toYarn((TaskAttemptID)this.attemptID);
    }

    private void startListener(boolean registerTask) {
        Configuration conf = new Configuration();
        this.listener.init(conf);
        this.listener.start();
        if (registerTask) {
            this.listener.registerPendingTask(this.task, this.wid);
            this.listener.registerLaunchedTask(this.attemptId, this.wid);
        }
    }

    public static class MockTaskAttemptListenerImpl
    extends TaskAttemptListenerImpl {
        public MockTaskAttemptListenerImpl(AppContext context, JobTokenSecretManager jobTokenSecretManager, RMHeartbeatHandler rmHeartbeatHandler, AMPreemptionPolicy policy) {
            super(context, jobTokenSecretManager, rmHeartbeatHandler, policy);
        }

        public MockTaskAttemptListenerImpl(AppContext context, JobTokenSecretManager jobTokenSecretManager, RMHeartbeatHandler rmHeartbeatHandler, TaskHeartbeatHandler hbHandler, AMPreemptionPolicy policy) {
            super(context, jobTokenSecretManager, rmHeartbeatHandler, policy);
            this.taskHeartbeatHandler = hbHandler;
        }

        protected void registerHeartbeatHandler(Configuration conf) {
        }

        protected void startRpcServer() {
        }

        protected void stopRpcServer() {
        }
    }
}

