/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.v2.util;

import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.Task;
import org.apache.hadoop.mapred.TaskLog;
import org.apache.hadoop.mapreduce.JobID;
import org.apache.hadoop.mapreduce.MRJobConfig;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.hadoop.mapreduce.TaskID;
import org.apache.hadoop.mapreduce.TypeConverter;
import org.apache.hadoop.mapreduce.filecache.DistributedCache;
import org.apache.hadoop.mapreduce.v2.api.records.JobId;
import org.apache.hadoop.mapreduce.v2.api.records.TaskAttemptId;
import org.apache.hadoop.mapreduce.v2.api.records.TaskAttemptState;
import org.apache.hadoop.mapreduce.v2.api.records.TaskId;
import org.apache.hadoop.mapreduce.v2.api.records.TaskState;
import org.apache.hadoop.mapreduce.v2.api.records.TaskType;
import org.apache.hadoop.util.ApplicationClassLoader;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.yarn.api.ApplicationConstants;
import org.apache.hadoop.yarn.api.records.LocalResource;
import org.apache.hadoop.yarn.api.records.LocalResourceType;
import org.apache.hadoop.yarn.api.records.LocalResourceVisibility;
import org.apache.hadoop.yarn.api.records.URL;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.exceptions.YarnRuntimeException;
import org.apache.hadoop.yarn.util.Apps;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class MRApps
extends Apps {
    public static final Log LOG = LogFactory.getLog(MRApps.class);
    private static final String STAGING_CONSTANT = ".staging";

    public static String toString(JobId jid) {
        return jid.toString();
    }

    public static JobId toJobID(String jid) {
        return TypeConverter.toYarn(JobID.forName((String)jid));
    }

    public static String toString(TaskId tid) {
        return tid.toString();
    }

    public static TaskId toTaskID(String tid) {
        return TypeConverter.toYarn(TaskID.forName((String)tid));
    }

    public static String toString(TaskAttemptId taid) {
        return taid.toString();
    }

    public static TaskAttemptId toTaskAttemptID(String taid) {
        return TypeConverter.toYarn(TaskAttemptID.forName((String)taid));
    }

    public static String taskSymbol(TaskType type) {
        switch (type) {
            case MAP: {
                return "m";
            }
            case REDUCE: {
                return "r";
            }
        }
        throw new YarnRuntimeException("Unknown task type: " + type.toString());
    }

    public static TaskType taskType(String symbol) {
        if (symbol.equals("m")) {
            return TaskType.MAP;
        }
        if (symbol.equals("r")) {
            return TaskType.REDUCE;
        }
        throw new YarnRuntimeException("Unknown task symbol: " + symbol);
    }

    public static TaskAttemptStateUI taskAttemptState(String attemptStateStr) {
        return TaskAttemptStateUI.valueOf(attemptStateStr);
    }

    public static TaskStateUI taskState(String taskStateStr) {
        return TaskStateUI.valueOf(taskStateStr);
    }

    private static String getMRFrameworkName(Configuration conf) {
        String frameworkName = null;
        String framework = conf.get("mapreduce.application.framework.path", "");
        if (!framework.isEmpty()) {
            URI uri;
            try {
                uri = new URI(framework);
            }
            catch (URISyntaxException e) {
                throw new IllegalArgumentException("Unable to parse '" + framework + "' as a URI, check the setting for " + "mapreduce.application.framework.path", e);
            }
            frameworkName = uri.getFragment();
            if (frameworkName == null) {
                frameworkName = new Path(uri).getName();
            }
        }
        return frameworkName;
    }

    private static void setMRFrameworkClasspath(Map<String, String> environment, Configuration conf) throws IOException {
        if (conf.getBoolean("yarn.is.minicluster", false)) {
            MRApps.addToEnvironment(environment, ApplicationConstants.Environment.CLASSPATH.name(), System.getProperty("java.class.path"), conf);
        }
        boolean crossPlatform = conf.getBoolean("mapreduce.app-submission.cross-platform", false);
        String frameworkName = MRApps.getMRFrameworkName(conf);
        if (frameworkName == null) {
            for (String c : conf.getStrings("yarn.application.classpath", crossPlatform ? YarnConfiguration.DEFAULT_YARN_CROSS_PLATFORM_APPLICATION_CLASSPATH : YarnConfiguration.DEFAULT_YARN_APPLICATION_CLASSPATH)) {
                MRApps.addToEnvironment(environment, ApplicationConstants.Environment.CLASSPATH.name(), c.trim(), conf);
            }
        }
        boolean foundFrameworkInClasspath = frameworkName == null;
        for (String c : conf.getStrings("mapreduce.application.classpath", crossPlatform ? StringUtils.getStrings((String)MRJobConfig.DEFAULT_MAPREDUCE_CROSS_PLATFORM_APPLICATION_CLASSPATH) : StringUtils.getStrings((String)MRJobConfig.DEFAULT_MAPREDUCE_APPLICATION_CLASSPATH))) {
            MRApps.addToEnvironment(environment, ApplicationConstants.Environment.CLASSPATH.name(), c.trim(), conf);
            if (foundFrameworkInClasspath) continue;
            foundFrameworkInClasspath = c.contains(frameworkName);
        }
        if (!foundFrameworkInClasspath) {
            throw new IllegalArgumentException("Could not locate MapReduce framework name '" + frameworkName + "' in " + "mapreduce.application.classpath");
        }
    }

    public static void setClasspath(Map<String, String> environment, Configuration conf) throws IOException {
        boolean userClassesTakesPrecedence = conf.getBoolean("mapreduce.job.user.classpath.first", false);
        String classpathEnvVar = conf.getBoolean("mapreduce.job.classloader", false) ? ApplicationConstants.Environment.APP_CLASSPATH.name() : ApplicationConstants.Environment.CLASSPATH.name();
        String hadoopClasspathEnvVar = ApplicationConstants.Environment.HADOOP_CLASSPATH.name();
        MRApps.addToEnvironment(environment, classpathEnvVar, MRApps.crossPlatformifyMREnv(conf, ApplicationConstants.Environment.PWD), conf);
        MRApps.addToEnvironment(environment, hadoopClasspathEnvVar, MRApps.crossPlatformifyMREnv(conf, ApplicationConstants.Environment.PWD), conf);
        if (!userClassesTakesPrecedence) {
            MRApps.setMRFrameworkClasspath(environment, conf);
        }
        MRApps.addClasspathToEnv(environment, classpathEnvVar, conf);
        MRApps.addClasspathToEnv(environment, hadoopClasspathEnvVar, conf);
        MRApps.addToEnvironment(environment, hadoopClasspathEnvVar, System.getenv(hadoopClasspathEnvVar), conf);
        if (userClassesTakesPrecedence) {
            MRApps.setMRFrameworkClasspath(environment, conf);
        }
    }

    public static void addClasspathToEnv(Map<String, String> environment, String classpathEnvVar, Configuration conf) throws IOException {
        MRApps.addToEnvironment(environment, classpathEnvVar, "job.jar/job.jar", conf);
        MRApps.addToEnvironment(environment, classpathEnvVar, "job.jar/classes/", conf);
        MRApps.addToEnvironment(environment, classpathEnvVar, "job.jar/lib/*", conf);
        MRApps.addToEnvironment(environment, classpathEnvVar, MRApps.crossPlatformifyMREnv(conf, ApplicationConstants.Environment.PWD) + "/" + "*", conf);
        MRApps.addToClasspathIfNotJar(DistributedCache.getFileClassPaths((Configuration)conf), DistributedCache.getCacheFiles((Configuration)conf), conf, environment, classpathEnvVar);
        MRApps.addToClasspathIfNotJar(DistributedCache.getArchiveClassPaths((Configuration)conf), DistributedCache.getCacheArchives((Configuration)conf), conf, environment, classpathEnvVar);
    }

    private static void addToClasspathIfNotJar(Path[] paths, URI[] withLinks, Configuration conf, Map<String, String> environment, String classpathEnvVar) throws IOException {
        if (paths != null) {
            HashMap<Path, String> linkLookup = new HashMap<Path, String>();
            if (withLinks != null) {
                for (URI uRI : withLinks) {
                    String name;
                    Path p = new Path(uRI);
                    FileSystem remoteFS = p.getFileSystem(conf);
                    p = remoteFS.resolvePath(p.makeQualified(remoteFS.getUri(), remoteFS.getWorkingDirectory()));
                    String string = name = null == uRI.getFragment() ? p.getName() : uRI.getFragment();
                    if (StringUtils.toLowerCase((String)name).endsWith(".jar")) continue;
                    linkLookup.put(p, name);
                }
            }
            for (URI uRI : paths) {
                FileSystem remoteFS = uRI.getFileSystem(conf);
                Path path = remoteFS.resolvePath(uRI.makeQualified(remoteFS.getUri(), remoteFS.getWorkingDirectory()));
                String name = (String)linkLookup.get(path);
                if (name == null) {
                    name = path.getName();
                }
                if (StringUtils.toLowerCase((String)name).endsWith(".jar")) continue;
                MRApps.addToEnvironment(environment, classpathEnvVar, MRApps.crossPlatformifyMREnv(conf, ApplicationConstants.Environment.PWD) + "/" + name, conf);
            }
        }
    }

    public static void setJobClassLoader(Configuration conf) throws IOException {
        MRApps.setClassLoader(MRApps.createJobClassLoader(conf), conf);
    }

    public static ClassLoader createJobClassLoader(Configuration conf) throws IOException {
        ClassLoader jobClassLoader = null;
        if (conf.getBoolean("mapreduce.job.classloader", false)) {
            String appClasspath = System.getenv(ApplicationConstants.Environment.APP_CLASSPATH.key());
            if (appClasspath == null) {
                LOG.warn((Object)"Not creating job classloader since APP_CLASSPATH is not set.");
            } else {
                LOG.info((Object)"Creating job classloader");
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("APP_CLASSPATH=" + appClasspath));
                }
                String[] systemClasses = MRApps.getSystemClasses(conf);
                jobClassLoader = MRApps.createJobClassLoader(appClasspath, systemClasses);
            }
        }
        return jobClassLoader;
    }

    public static void setClassLoader(ClassLoader classLoader, Configuration conf) {
        if (classLoader != null) {
            LOG.info((Object)("Setting classloader " + classLoader + " on the configuration and as the thread context classloader"));
            conf.setClassLoader(classLoader);
            Thread.currentThread().setContextClassLoader(classLoader);
        }
    }

    @VisibleForTesting
    static String[] getSystemClasses(Configuration conf) {
        return conf.getTrimmedStrings("mapreduce.job.classloader.system.classes");
    }

    private static ClassLoader createJobClassLoader(final String appClasspath, final String[] systemClasses) throws IOException {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<ClassLoader>(){

                @Override
                public ClassLoader run() throws MalformedURLException {
                    return new ApplicationClassLoader(appClasspath, MRApps.class.getClassLoader(), Arrays.asList(systemClasses));
                }
            });
        }
        catch (PrivilegedActionException e) {
            Throwable t = e.getCause();
            if (t instanceof MalformedURLException) {
                throw (MalformedURLException)t;
            }
            throw new IOException(e);
        }
    }

    public static Path getStagingAreaDir(Configuration conf, String user) {
        return new Path(conf.get("yarn.app.mapreduce.am.staging-dir", "/tmp/hadoop-yarn/staging") + "/" + user + "/" + STAGING_CONSTANT);
    }

    public static String getJobFile(Configuration conf, String user, JobID jobId) {
        Path jobFile = new Path(MRApps.getStagingAreaDir(conf, user), jobId.toString() + "/" + "job.xml");
        return jobFile.toString();
    }

    public static Path getEndJobCommitSuccessFile(Configuration conf, String user, JobId jobId) {
        Path endCommitFile = new Path(MRApps.getStagingAreaDir(conf, user), jobId.toString() + "/" + "COMMIT_SUCCESS");
        return endCommitFile;
    }

    public static Path getEndJobCommitFailureFile(Configuration conf, String user, JobId jobId) {
        Path endCommitFile = new Path(MRApps.getStagingAreaDir(conf, user), jobId.toString() + "/" + "COMMIT_FAIL");
        return endCommitFile;
    }

    public static Path getStartJobCommitFile(Configuration conf, String user, JobId jobId) {
        Path startCommitFile = new Path(MRApps.getStagingAreaDir(conf, user), jobId.toString() + "/" + "COMMIT_STARTED");
        return startCommitFile;
    }

    public static void setupDistributedCache(Configuration conf, Map<String, LocalResource> localResources) throws IOException {
        MRApps.parseDistributedCacheArtifacts(conf, localResources, LocalResourceType.ARCHIVE, DistributedCache.getCacheArchives((Configuration)conf), DistributedCache.getArchiveTimestamps((Configuration)conf), MRApps.getFileSizes(conf, "mapreduce.job.cache.archives.filesizes"), DistributedCache.getArchiveVisibilities((Configuration)conf));
        MRApps.parseDistributedCacheArtifacts(conf, localResources, LocalResourceType.FILE, DistributedCache.getCacheFiles((Configuration)conf), DistributedCache.getFileTimestamps((Configuration)conf), MRApps.getFileSizes(conf, "mapreduce.job.cache.files.filesizes"), DistributedCache.getFileVisibilities((Configuration)conf));
    }

    public static void setupDistributedCacheLocal(Configuration conf) throws IOException {
        URI[] cacheFiles;
        String localWorkDir = System.getenv("PWD");
        URI[] cacheArchives = DistributedCache.getCacheArchives((Configuration)conf);
        if (cacheArchives != null) {
            ArrayList<String> localArchives = new ArrayList<String>();
            for (int i = 0; i < cacheArchives.length; ++i) {
                URI u = cacheArchives[i];
                Path p = new Path(u);
                Path name = new Path(null == u.getFragment() ? p.getName() : u.getFragment());
                String linkName = name.toUri().getPath();
                localArchives.add(new Path(localWorkDir, linkName).toUri().getPath());
            }
            if (!localArchives.isEmpty()) {
                conf.set("mapreduce.job.cache.local.archives", StringUtils.arrayToString((String[])localArchives.toArray(new String[localArchives.size()])));
            }
        }
        if ((cacheFiles = DistributedCache.getCacheFiles((Configuration)conf)) != null) {
            ArrayList<String> localFiles = new ArrayList<String>();
            for (int i = 0; i < cacheFiles.length; ++i) {
                URI u = cacheFiles[i];
                Path p = new Path(u);
                Path name = new Path(null == u.getFragment() ? p.getName() : u.getFragment());
                String linkName = name.toUri().getPath();
                localFiles.add(new Path(localWorkDir, linkName).toUri().getPath());
            }
            if (!localFiles.isEmpty()) {
                conf.set("mapreduce.job.cache.local.files", StringUtils.arrayToString((String[])localFiles.toArray(new String[localFiles.size()])));
            }
        }
    }

    private static String getResourceDescription(LocalResourceType type) {
        if (type == LocalResourceType.ARCHIVE || type == LocalResourceType.PATTERN) {
            return "cache archive (mapreduce.job.cache.archives) ";
        }
        return "cache file (mapreduce.job.cache.files) ";
    }

    private static String toString(URL url) {
        StringBuffer b = new StringBuffer();
        b.append(url.getScheme()).append("://").append(url.getHost());
        if (url.getPort() >= 0) {
            b.append(":").append(url.getPort());
        }
        b.append(url.getFile());
        return b.toString();
    }

    private static void parseDistributedCacheArtifacts(Configuration conf, Map<String, LocalResource> localResources, LocalResourceType type, URI[] uris, long[] timestamps, long[] sizes, boolean[] visibilities) throws IOException {
        if (uris != null) {
            if (uris.length != timestamps.length || uris.length != sizes.length || uris.length != visibilities.length) {
                throw new IllegalArgumentException("Invalid specification for distributed-cache artifacts of type " + type + " : #uris=" + uris.length + " #timestamps=" + timestamps.length + " #visibilities=" + visibilities.length);
            }
            for (int i = 0; i < uris.length; ++i) {
                URI u = uris[i];
                Path p = new Path(u);
                FileSystem remoteFS = p.getFileSystem(conf);
                p = remoteFS.resolvePath(p.makeQualified(remoteFS.getUri(), remoteFS.getWorkingDirectory()));
                Path name = new Path(null == u.getFragment() ? p.getName() : u.getFragment());
                if (name.isAbsolute()) {
                    throw new IllegalArgumentException("Resource name must be relative");
                }
                String linkName = name.toUri().getPath();
                LocalResource orig = localResources.get(linkName);
                URL url = URL.fromURI((URI)p.toUri());
                if (orig != null && !orig.getResource().equals(url)) {
                    LOG.warn((Object)(MRApps.getResourceDescription(orig.getType()) + MRApps.toString(orig.getResource()) + " conflicts with " + MRApps.getResourceDescription(type) + MRApps.toString(url) + " This will be an error in Hadoop 2.0"));
                    continue;
                }
                localResources.put(linkName, LocalResource.newInstance((URL)URL.fromURI((URI)p.toUri()), (LocalResourceType)type, (LocalResourceVisibility)(visibilities[i] ? LocalResourceVisibility.PUBLIC : LocalResourceVisibility.PRIVATE), (long)sizes[i], (long)timestamps[i]));
            }
        }
    }

    private static long[] getFileSizes(Configuration conf, String key) {
        String[] strs = conf.getStrings(key);
        if (strs == null) {
            return null;
        }
        long[] result = new long[strs.length];
        for (int i = 0; i < strs.length; ++i) {
            result[i] = Long.parseLong(strs[i]);
        }
        return result;
    }

    public static String getChildLogLevel(Configuration conf, boolean isMap) {
        if (isMap) {
            return conf.get("mapreduce.map.log.level", JobConf.DEFAULT_LOG_LEVEL.toString());
        }
        return conf.get("mapreduce.reduce.log.level", JobConf.DEFAULT_LOG_LEVEL.toString());
    }

    public static void addLog4jSystemProperties(Task task, List<String> vargs, Configuration conf) {
        int numBackups;
        String logLevel;
        long logSize;
        String log4jPropertyFile = conf.get("mapreduce.job.log4j-properties-file", "");
        if (log4jPropertyFile.isEmpty()) {
            vargs.add("-Dlog4j.configuration=container-log4j.properties");
        } else {
            URI log4jURI = null;
            try {
                log4jURI = new URI(log4jPropertyFile);
            }
            catch (URISyntaxException e) {
                throw new IllegalArgumentException(e);
            }
            Path log4jPath = new Path(log4jURI);
            vargs.add("-Dlog4j.configuration=" + log4jPath.getName());
        }
        if (task == null) {
            logSize = conf.getLong("yarn.app.mapreduce.am.container.log.limit.kb", 0L) << 10;
            logLevel = conf.get("yarn.app.mapreduce.am.log.level", "INFO");
            numBackups = conf.getInt("yarn.app.mapreduce.am.container.log.backups", 0);
        } else {
            logSize = TaskLog.getTaskLogLimitBytes((Configuration)conf);
            logLevel = MRApps.getChildLogLevel(conf, task.isMapTask());
            numBackups = conf.getInt("yarn.app.mapreduce.task.container.log.backups", 0);
        }
        vargs.add("-Dyarn.app.container.log.dir=<LOG_DIR>");
        vargs.add("-Dyarn.app.container.log.filesize=" + logSize);
        if (logSize > 0L && numBackups > 0) {
            vargs.add("-Dyarn.app.container.log.backups=" + numBackups);
            vargs.add("-Dhadoop.root.logger=" + logLevel + ",CRLA");
        } else {
            vargs.add("-Dhadoop.root.logger=" + logLevel + ",CLA");
        }
        vargs.add("-Dhadoop.root.logfile=" + TaskLog.LogName.SYSLOG);
        if (task != null && !task.isMapTask() && conf.getBoolean("yarn.app.mapreduce.shuffle.log.separate", true)) {
            int numShuffleBackups = conf.getInt("yarn.app.mapreduce.shuffle.log.backups", 0);
            long shuffleLogSize = conf.getLong("yarn.app.mapreduce.shuffle.log.limit.kb", 0L) << 10;
            String shuffleLogger = logLevel + (shuffleLogSize > 0L && numShuffleBackups > 0 ? ",shuffleCRLA" : ",shuffleCLA");
            vargs.add("-Dyarn.app.mapreduce.shuffle.logger=" + shuffleLogger);
            vargs.add("-Dyarn.app.mapreduce.shuffle.logfile=" + TaskLog.LogName.SYSLOG + ".shuffle");
            vargs.add("-Dyarn.app.mapreduce.shuffle.log.filesize=" + shuffleLogSize);
            vargs.add("-Dyarn.app.mapreduce.shuffle.log.backups=" + numShuffleBackups);
        }
    }

    public static void setEnvFromInputString(Map<String, String> env, String envString, Configuration conf) {
        String classPathSeparator = conf.getBoolean("mapreduce.app-submission.cross-platform", false) ? "<CPS>" : File.pathSeparator;
        Apps.setEnvFromInputString(env, (String)envString, (String)classPathSeparator);
    }

    @InterfaceAudience.Public
    @InterfaceStability.Unstable
    public static void addToEnvironment(Map<String, String> environment, String variable, String value, Configuration conf) {
        String classPathSeparator = conf.getBoolean("mapreduce.app-submission.cross-platform", false) ? "<CPS>" : File.pathSeparator;
        Apps.addToEnvironment(environment, (String)variable, (String)value, (String)classPathSeparator);
    }

    public static String crossPlatformifyMREnv(Configuration conf, ApplicationConstants.Environment env) {
        boolean crossPlatform = conf.getBoolean("mapreduce.app-submission.cross-platform", false);
        return crossPlatform ? env.$$() : env.$();
    }

    public static String getSystemPropertiesToLog(Configuration conf) {
        String[] props;
        String key = conf.get("mapreduce.jvm.system-properties-to-log", "os.name,os.version,java.home,java.runtime.version,java.vendor,java.version,java.vm.name,java.class.path,java.io.tmpdir,user.dir,user.name");
        if (key != null && !(key = key.trim()).isEmpty() && (props = key.split(",")).length > 0) {
            StringBuilder sb = new StringBuilder();
            sb.append("\n/************************************************************\n");
            sb.append("[system properties]\n");
            for (String prop : props) {
                if ((prop = prop.trim()).isEmpty()) continue;
                sb.append(prop).append(": ").append(System.getProperty(prop)).append('\n');
            }
            sb.append("************************************************************/");
            return sb.toString();
        }
        return null;
    }

    public static enum TaskStateUI {
        RUNNING(new TaskState[]{TaskState.RUNNING}),
        PENDING(new TaskState[]{TaskState.SCHEDULED}),
        COMPLETED(new TaskState[]{TaskState.SUCCEEDED, TaskState.FAILED, TaskState.KILLED});

        private final List<TaskState> correspondingStates;

        private TaskStateUI(TaskState[] correspondingStates) {
            this.correspondingStates = Arrays.asList(correspondingStates);
        }

        public boolean correspondsTo(TaskState state) {
            return this.correspondingStates.contains((Object)state);
        }
    }

    public static enum TaskAttemptStateUI {
        NEW(new TaskAttemptState[]{TaskAttemptState.NEW, TaskAttemptState.STARTING}),
        RUNNING(new TaskAttemptState[]{TaskAttemptState.RUNNING, TaskAttemptState.COMMIT_PENDING}),
        SUCCESSFUL(new TaskAttemptState[]{TaskAttemptState.SUCCEEDED}),
        FAILED(new TaskAttemptState[]{TaskAttemptState.FAILED}),
        KILLED(new TaskAttemptState[]{TaskAttemptState.KILLED});

        private final List<TaskAttemptState> correspondingStates;

        private TaskAttemptStateUI(TaskAttemptState[] correspondingStates) {
            this.correspondingStates = Arrays.asList(correspondingStates);
        }

        public boolean correspondsTo(TaskAttemptState state) {
            return this.correspondingStates.contains((Object)state);
        }
    }
}

