/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.v2.hs.webapp;

import com.google.inject.Inject;
import org.apache.hadoop.mapreduce.v2.api.records.JobId;
import org.apache.hadoop.mapreduce.v2.api.records.TaskId;
import org.apache.hadoop.mapreduce.v2.app.webapp.App;
import org.apache.hadoop.mapreduce.v2.util.MRApps;
import org.apache.hadoop.yarn.webapp.hamlet.Hamlet;
import org.apache.hadoop.yarn.webapp.view.HtmlBlock;

public class HsNavBlock
extends HtmlBlock {
    final App app;

    @Inject
    HsNavBlock(App app) {
        this.app = app;
    }

    protected void render(HtmlBlock.Block html) {
        Hamlet.DIV nav = (Hamlet.DIV)((Hamlet.UL)((Hamlet.UL)html.div("#nav").h3("Application").ul().li().a(this.url(new String[]{"about"}), "About")._()).li().a(this.url(new String[]{"app"}), "Jobs")._())._();
        if (this.app.getJob() != null) {
            String jobid = MRApps.toString((JobId)this.app.getJob().getID());
            ((Hamlet.UL)((Hamlet.UL)((Hamlet.UL)((Hamlet.UL)((Hamlet.UL)nav.h3("Job").ul().li().a(this.url(new String[]{"job", jobid}), "Overview")._()).li().a(this.url(new String[]{"jobcounters", jobid}), "Counters")._()).li().a(this.url(new String[]{"conf", jobid}), "Configuration")._()).li().a(this.url(new String[]{"tasks", jobid, "m"}), "Map tasks")._()).li().a(this.url(new String[]{"tasks", jobid, "r"}), "Reduce tasks")._())._();
            if (this.app.getTask() != null) {
                String taskid = MRApps.toString((TaskId)this.app.getTask().getID());
                ((Hamlet.UL)((Hamlet.UL)nav.h3("Task").ul().li().a(this.url(new String[]{"task", taskid}), "Task Overview")._()).li().a(this.url(new String[]{"taskcounters", taskid}), "Counters")._())._();
            }
        }
        ((Hamlet.DIV)((Hamlet.UL)((Hamlet.UL)((Hamlet.UL)((Hamlet.UL)nav.h3("Tools").ul().li().a("/conf", "Configuration")._()).li().a("/logs", "Local logs")._()).li().a("/stacks", "Server stacks")._()).li().a("/jmx?qry=Hadoop:*", "Server metrics")._())._())._();
    }
}

