/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.JobStatus;
import org.apache.hadoop.mapred.RunningJob;
import org.apache.hadoop.mapred.UtilsForTests;
import org.apache.hadoop.mapreduce.jobhistory.EventType;
import org.apache.hadoop.mapreduce.jobhistory.TestJobHistoryEventHandler;
import org.apache.hadoop.mapreduce.v2.MiniMRYarnCluster;
import org.apache.hadoop.yarn.api.records.timeline.TimelineEntities;
import org.apache.hadoop.yarn.api.records.timeline.TimelineEntity;
import org.apache.hadoop.yarn.api.records.timeline.TimelineEvent;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.server.timeline.TimelineStore;
import org.junit.Assert;
import org.junit.Test;

public class TestMRTimelineEventHandling {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMRTimelineEventHandling() throws Exception {
        YarnConfiguration conf = new YarnConfiguration();
        conf.setBoolean("yarn.timeline-service.enabled", true);
        conf.setBoolean("mapreduce.job.emit-timeline-data", true);
        MiniMRYarnCluster cluster = null;
        try {
            cluster = new MiniMRYarnCluster(TestJobHistoryEventHandler.class.getSimpleName(), 1, true);
            cluster.init((Configuration)conf);
            cluster.start();
            TimelineStore ts = cluster.getApplicationHistoryServer().getTimelineStore();
            Path inDir = new Path("input");
            Path outDir = new Path("output");
            RunningJob job = UtilsForTests.runJobSucceed(new JobConf((Configuration)conf), inDir, outDir);
            Assert.assertEquals((long)JobStatus.SUCCEEDED, (long)job.getJobStatus().getState().getValue());
            TimelineEntities entities = ts.getEntities("MAPREDUCE_JOB", null, null, null, null, null, null, null, null);
            Assert.assertEquals((long)1L, (long)entities.getEntities().size());
            TimelineEntity tEntity = (TimelineEntity)entities.getEntities().get(0);
            Assert.assertEquals((Object)job.getID().toString(), (Object)tEntity.getEntityId());
            Assert.assertEquals((Object)"MAPREDUCE_JOB", (Object)tEntity.getEntityType());
            Assert.assertEquals((Object)EventType.AM_STARTED.toString(), (Object)((TimelineEvent)tEntity.getEvents().get(tEntity.getEvents().size() - 1)).getEventType());
            Assert.assertEquals((Object)EventType.JOB_FINISHED.toString(), (Object)((TimelineEvent)tEntity.getEvents().get(0)).getEventType());
            job = UtilsForTests.runJobFail(new JobConf((Configuration)conf), inDir, outDir);
            Assert.assertEquals((long)JobStatus.FAILED, (long)job.getJobStatus().getState().getValue());
            entities = ts.getEntities("MAPREDUCE_JOB", null, null, null, null, null, null, null, null);
            Assert.assertEquals((long)2L, (long)entities.getEntities().size());
            tEntity = (TimelineEntity)entities.getEntities().get(0);
            Assert.assertEquals((Object)job.getID().toString(), (Object)tEntity.getEntityId());
            Assert.assertEquals((Object)"MAPREDUCE_JOB", (Object)tEntity.getEntityType());
            Assert.assertEquals((Object)EventType.AM_STARTED.toString(), (Object)((TimelineEvent)tEntity.getEvents().get(tEntity.getEvents().size() - 1)).getEventType());
            Assert.assertEquals((Object)EventType.JOB_FAILED.toString(), (Object)((TimelineEvent)tEntity.getEvents().get(0)).getEventType());
        }
        finally {
            if (cluster != null) {
                cluster.stop();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMapreduceJobTimelineServiceEnabled() throws Exception {
        TimelineEntity tEntity;
        TimelineEntities entities;
        RunningJob job;
        Path outDir;
        Path inDir;
        TimelineStore ts;
        YarnConfiguration conf = new YarnConfiguration();
        conf.setBoolean("yarn.timeline-service.enabled", true);
        conf.setBoolean("mapreduce.job.emit-timeline-data", false);
        MiniMRYarnCluster cluster = null;
        try {
            cluster = new MiniMRYarnCluster(TestJobHistoryEventHandler.class.getSimpleName(), 1, true);
            cluster.init((Configuration)conf);
            cluster.start();
            ts = cluster.getApplicationHistoryServer().getTimelineStore();
            inDir = new Path("input");
            outDir = new Path("output");
            job = UtilsForTests.runJobSucceed(new JobConf((Configuration)conf), inDir, outDir);
            Assert.assertEquals((long)JobStatus.SUCCEEDED, (long)job.getJobStatus().getState().getValue());
            entities = ts.getEntities("MAPREDUCE_JOB", null, null, null, null, null, null, null, null);
            Assert.assertEquals((long)0L, (long)entities.getEntities().size());
            conf.setBoolean("mapreduce.job.emit-timeline-data", true);
            job = UtilsForTests.runJobSucceed(new JobConf((Configuration)conf), inDir, outDir);
            Assert.assertEquals((long)JobStatus.SUCCEEDED, (long)job.getJobStatus().getState().getValue());
            entities = ts.getEntities("MAPREDUCE_JOB", null, null, null, null, null, null, null, null);
            Assert.assertEquals((long)1L, (long)entities.getEntities().size());
            tEntity = (TimelineEntity)entities.getEntities().get(0);
            Assert.assertEquals((Object)job.getID().toString(), (Object)tEntity.getEntityId());
        }
        finally {
            if (cluster != null) {
                cluster.stop();
            }
        }
        conf = new YarnConfiguration();
        conf.setBoolean("yarn.timeline-service.enabled", true);
        conf.setBoolean("mapreduce.job.emit-timeline-data", true);
        cluster = null;
        try {
            cluster = new MiniMRYarnCluster(TestJobHistoryEventHandler.class.getSimpleName(), 1, true);
            cluster.init((Configuration)conf);
            cluster.start();
            ts = cluster.getApplicationHistoryServer().getTimelineStore();
            inDir = new Path("input");
            outDir = new Path("output");
            conf.setBoolean("mapreduce.job.emit-timeline-data", false);
            job = UtilsForTests.runJobSucceed(new JobConf((Configuration)conf), inDir, outDir);
            Assert.assertEquals((long)JobStatus.SUCCEEDED, (long)job.getJobStatus().getState().getValue());
            entities = ts.getEntities("MAPREDUCE_JOB", null, null, null, null, null, null, null, null);
            Assert.assertEquals((long)0L, (long)entities.getEntities().size());
            conf.setBoolean("mapreduce.job.emit-timeline-data", true);
            job = UtilsForTests.runJobSucceed(new JobConf((Configuration)conf), inDir, outDir);
            Assert.assertEquals((long)JobStatus.SUCCEEDED, (long)job.getJobStatus().getState().getValue());
            entities = ts.getEntities("MAPREDUCE_JOB", null, null, null, null, null, null, null, null);
            Assert.assertEquals((long)1L, (long)entities.getEntities().size());
            tEntity = (TimelineEntity)entities.getEntities().get(0);
            Assert.assertEquals((Object)job.getID().toString(), (Object)tEntity.getEntityId());
        }
        finally {
            if (cluster != null) {
                cluster.stop();
            }
        }
    }
}

