/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.util.BitSet;
import java.util.Random;
import junit.framework.TestCase;
import org.apache.commons.logging.Log;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapred.SequenceFileAsTextInputFormat;
import org.apache.hadoop.mapred.SequenceFileAsTextRecordReader;

public class TestSequenceFileAsTextInputFormat
extends TestCase {
    private static final Log LOG = FileInputFormat.LOG;
    private static int MAX_LENGTH = 10000;
    private static Configuration conf = new Configuration();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testFormat() throws Exception {
        JobConf job = new JobConf(conf);
        LocalFileSystem fs = FileSystem.getLocal((Configuration)conf);
        Path dir = new Path(System.getProperty("test.build.data", ".") + "/mapred");
        Path file = new Path(dir, "test.seq");
        Reporter reporter = Reporter.NULL;
        int seed = new Random().nextInt();
        Random random = new Random(seed);
        fs.delete(dir, true);
        FileInputFormat.setInputPaths((JobConf)job, (Path[])new Path[]{dir});
        for (int length = 0; length < MAX_LENGTH; length += random.nextInt(MAX_LENGTH / 10) + 1) {
            try (SequenceFile.Writer writer = SequenceFile.createWriter((FileSystem)fs, (Configuration)conf, (Path)file, IntWritable.class, LongWritable.class);){
                for (int i = 0; i < length; ++i) {
                    IntWritable key = new IntWritable(i);
                    LongWritable value = new LongWritable((long)(10 * i));
                    writer.append((Writable)key, (Writable)value);
                }
            }
            SequenceFileAsTextInputFormat format = new SequenceFileAsTextInputFormat();
            for (int i = 0; i < 3; ++i) {
                int numSplits = random.nextInt(MAX_LENGTH / 100) + 1;
                InputSplit[] splits = format.getSplits(job, numSplits);
                BitSet bits = new BitSet(length);
                for (int j = 0; j < splits.length; ++j) {
                    RecordReader reader = format.getRecordReader(splits[j], job, reporter);
                    Class<?> readerClass = reader.getClass();
                    TestSequenceFileAsTextInputFormat.assertEquals((String)"reader class is SequenceFileAsTextRecordReader.", SequenceFileAsTextRecordReader.class, readerClass);
                    Text value = (Text)reader.createValue();
                    Text key = (Text)reader.createKey();
                    try {
                        int count = 0;
                        while (reader.next((Object)key, (Object)value)) {
                            int keyInt = Integer.parseInt(key.toString());
                            TestSequenceFileAsTextInputFormat.assertFalse((String)"Key in multiple partitions.", (boolean)bits.get(keyInt));
                            bits.set(keyInt);
                            ++count;
                        }
                        continue;
                    }
                    finally {
                        reader.close();
                    }
                }
                TestSequenceFileAsTextInputFormat.assertEquals((String)"Some keys in no partition.", (int)length, (int)bits.cardinality());
            }
        }
    }

    public static void main(String[] args) throws Exception {
        new TestSequenceFileAsTextInputFormat().testFormat();
    }
}

