/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.lib.fieldsel;

import java.text.NumberFormat;
import junit.framework.TestCase;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.MapReduceTestUtil;
import org.apache.hadoop.mapreduce.lib.fieldsel.FieldSelectionMapper;
import org.apache.hadoop.mapreduce.lib.fieldsel.FieldSelectionReducer;

public class TestMRFieldSelection
extends TestCase {
    private static NumberFormat idFormat = NumberFormat.getInstance();
    private static Path testDir;

    public void testFieldSelection() throws Exception {
        TestMRFieldSelection.launch();
    }

    public static void launch() throws Exception {
        Configuration conf = new Configuration();
        FileSystem fs = FileSystem.get((Configuration)conf);
        int numOfInputLines = 10;
        Path outDir = new Path(testDir, "output_for_field_selection_test");
        Path inDir = new Path(testDir, "input_for_field_selection_test");
        StringBuffer inputData = new StringBuffer();
        StringBuffer expectedOutput = new StringBuffer();
        TestMRFieldSelection.constructInputOutputData(inputData, expectedOutput, numOfInputLines);
        conf.set("mapreduce.fieldsel.data.field.separator", "-");
        conf.set("mapreduce.fieldsel.map.output.key.value.fields.spec", "6,5,1-3:0-");
        conf.set("mapreduce.fieldsel.reduce.output.key.value.fields.spec", ":4,3,2,1,0,0-");
        Job job = MapReduceTestUtil.createJob(conf, inDir, outDir, 1, 1, inputData.toString());
        job.setMapperClass(FieldSelectionMapper.class);
        job.setReducerClass(FieldSelectionReducer.class);
        job.setOutputKeyClass(Text.class);
        job.setOutputValueClass(Text.class);
        job.setNumReduceTasks(1);
        job.waitForCompletion(true);
        TestMRFieldSelection.assertTrue((String)"Job Failed!", (boolean)job.isSuccessful());
        String outdata = MapReduceTestUtil.readOutput(outDir, conf);
        TestMRFieldSelection.assertEquals((String)"Outputs doesnt match.", (String)expectedOutput.toString(), (String)outdata);
        fs.delete(outDir, true);
    }

    public static void constructInputOutputData(StringBuffer inputData, StringBuffer expectedOutput, int numOfInputLines) {
        for (int i = 0; i < numOfInputLines; ++i) {
            inputData.append(idFormat.format(i));
            inputData.append("-").append(idFormat.format(i + 1));
            inputData.append("-").append(idFormat.format(i + 2));
            inputData.append("-").append(idFormat.format(i + 3));
            inputData.append("-").append(idFormat.format(i + 4));
            inputData.append("-").append(idFormat.format(i + 5));
            inputData.append("-").append(idFormat.format(i + 6));
            inputData.append("\n");
            expectedOutput.append(idFormat.format(i + 3));
            expectedOutput.append("-").append(idFormat.format(i + 2));
            expectedOutput.append("-").append(idFormat.format(i + 1));
            expectedOutput.append("-").append(idFormat.format(i + 5));
            expectedOutput.append("-").append(idFormat.format(i + 6));
            expectedOutput.append("-").append(idFormat.format(i + 6));
            expectedOutput.append("-").append(idFormat.format(i + 5));
            expectedOutput.append("-").append(idFormat.format(i + 1));
            expectedOutput.append("-").append(idFormat.format(i + 2));
            expectedOutput.append("-").append(idFormat.format(i + 3));
            expectedOutput.append("-").append(idFormat.format(i + 0));
            expectedOutput.append("-").append(idFormat.format(i + 1));
            expectedOutput.append("-").append(idFormat.format(i + 2));
            expectedOutput.append("-").append(idFormat.format(i + 3));
            expectedOutput.append("-").append(idFormat.format(i + 4));
            expectedOutput.append("-").append(idFormat.format(i + 5));
            expectedOutput.append("-").append(idFormat.format(i + 6));
            expectedOutput.append("\n");
        }
        System.out.println("inputData:");
        System.out.println(inputData.toString());
        System.out.println("ExpectedData:");
        System.out.println(expectedOutput.toString());
    }

    public static void main(String[] argv) throws Exception {
        TestMRFieldSelection.launch();
    }

    static {
        idFormat.setMinimumIntegerDigits(4);
        idFormat.setGroupingUsed(false);
        testDir = new Path(System.getProperty("test.build.data", "/tmp"), "field");
    }
}

