/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.slive;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.List;
import java.util.Random;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.slive.ConfigExtractor;
import org.apache.hadoop.fs.slive.Operation;
import org.apache.hadoop.fs.slive.OperationOutput;
import org.apache.hadoop.fs.slive.Timer;

class DeleteOp
extends Operation {
    private static final Log LOG = LogFactory.getLog(DeleteOp.class);

    DeleteOp(ConfigExtractor cfg, Random rnd) {
        super(DeleteOp.class.getSimpleName(), cfg, rnd);
    }

    protected Path getDeleteFile() {
        Path fn = this.getFinder().getFile();
        return fn;
    }

    @Override
    List<OperationOutput> run(FileSystem fs) {
        List<OperationOutput> out = super.run(fs);
        try {
            Path fn = this.getDeleteFile();
            long timeTaken = 0L;
            boolean deleteStatus = false;
            long startTime = Timer.now();
            deleteStatus = fs.delete(fn, false);
            timeTaken = Timer.elapsed(startTime);
            if (!deleteStatus) {
                out.add(new OperationOutput(OperationOutput.OutputType.LONG, this.getType(), "failures", 1L));
                LOG.info((Object)("Could not delete " + fn));
            } else {
                out.add(new OperationOutput(OperationOutput.OutputType.LONG, this.getType(), "milliseconds_taken", timeTaken));
                out.add(new OperationOutput(OperationOutput.OutputType.LONG, this.getType(), "successes", 1L));
                LOG.info((Object)("Could delete " + fn));
            }
        }
        catch (FileNotFoundException e) {
            out.add(new OperationOutput(OperationOutput.OutputType.LONG, this.getType(), "files_not_found", 1L));
            LOG.warn((Object)"Error with deleting", (Throwable)e);
        }
        catch (IOException e) {
            out.add(new OperationOutput(OperationOutput.OutputType.LONG, this.getType(), "failures", 1L));
            LOG.warn((Object)"Error with deleting", (Throwable)e);
        }
        return out;
    }
}

