/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.MiniMRCluster;
import org.junit.After;
import org.junit.Before;

public abstract class ClusterMapReduceTestCase {
    private MiniDFSCluster dfsCluster = null;
    private MiniMRCluster mrCluster = null;

    @Before
    public void setUp() throws Exception {
        this.startCluster(true, null);
    }

    protected synchronized void startCluster(boolean reformatDFS, Properties props) throws Exception {
        if (this.dfsCluster == null) {
            JobConf conf = new JobConf();
            if (props != null) {
                for (Map.Entry<Object, Object> entry : props.entrySet()) {
                    conf.set((String)entry.getKey(), (String)entry.getValue());
                }
            }
            this.dfsCluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(2).format(reformatDFS).racks(null).build();
            ConfigurableMiniMRCluster.setConfiguration(props);
            this.mrCluster = new ConfigurableMiniMRCluster(2, this.getFileSystem().getUri().toString(), 1, conf);
        }
    }

    protected void stopCluster() throws Exception {
        if (this.mrCluster != null) {
            this.mrCluster.shutdown();
            this.mrCluster = null;
        }
        if (this.dfsCluster != null) {
            this.dfsCluster.shutdown();
            this.dfsCluster = null;
        }
    }

    @After
    public void tearDown() throws Exception {
        this.stopCluster();
    }

    protected FileSystem getFileSystem() throws IOException {
        return this.dfsCluster.getFileSystem();
    }

    protected MiniMRCluster getMRCluster() {
        return this.mrCluster;
    }

    protected Path getTestRootDir() {
        return new Path("x").getParent();
    }

    protected Path getInputDir() {
        return new Path("target/input");
    }

    protected Path getOutputDir() {
        return new Path("target/output");
    }

    protected JobConf createJobConf() {
        return this.mrCluster.createJobConf();
    }

    private static class ConfigurableMiniMRCluster
    extends MiniMRCluster {
        private static Properties config;

        public static void setConfiguration(Properties props) {
            config = props;
        }

        public ConfigurableMiniMRCluster(int numTaskTrackers, String namenode, int numDir, JobConf conf) throws Exception {
            super(0, 0, numTaskTrackers, namenode, numDir, null, null, null, conf);
        }

        @Override
        public JobConf createJobConf() {
            JobConf conf = super.createJobConf();
            if (config != null) {
                for (Map.Entry<Object, Object> entry : config.entrySet()) {
                    conf.set((String)entry.getKey(), (String)entry.getValue());
                }
            }
            return conf;
        }
    }
}

