/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.v2;

import java.io.File;
import java.io.IOException;
import org.apache.hadoop.mapreduce.Counters;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobCounter;
import org.apache.hadoop.mapreduce.JobStatus;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.hadoop.mapreduce.TaskCompletionEvent;
import org.apache.hadoop.mapreduce.TaskID;
import org.apache.hadoop.mapreduce.TaskType;
import org.apache.hadoop.mapreduce.v2.MiniMRYarnCluster;
import org.apache.hadoop.mapreduce.v2.TestMRJobs;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestUberAM
extends TestMRJobs {
    private static final Logger LOG = LoggerFactory.getLogger(TestUberAM.class);

    @BeforeClass
    public static void setup() throws IOException {
        TestMRJobs.setup();
        if (mrCluster != null) {
            mrCluster.getConfig().setBoolean("mapreduce.job.ubertask.enable", true);
            mrCluster.getConfig().setInt("mapreduce.job.ubertask.maxreduces", 3);
        }
    }

    @Override
    @Test
    public void testSleepJob() throws Exception {
        this.numSleepReducers = 1;
        super.testSleepJob();
    }

    @Test
    public void testSleepJobWithMultipleReducers() throws Exception {
        this.numSleepReducers = 3;
        super.testSleepJob();
    }

    @Override
    protected void verifySleepJobCounters(Job job) throws InterruptedException, IOException {
        Counters counters = job.getCounters();
        super.verifySleepJobCounters(job);
        Assert.assertEquals((long)3L, (long)counters.findCounter((Enum)JobCounter.NUM_UBER_SUBMAPS).getValue());
        Assert.assertEquals((long)this.numSleepReducers, (long)counters.findCounter((Enum)JobCounter.NUM_UBER_SUBREDUCES).getValue());
        Assert.assertEquals((long)(3 + this.numSleepReducers), (long)counters.findCounter((Enum)JobCounter.TOTAL_LAUNCHED_UBERTASKS).getValue());
    }

    @Override
    @Test
    public void testRandomWriter() throws IOException, InterruptedException, ClassNotFoundException {
        super.testRandomWriter();
    }

    @Override
    protected void verifyRandomWriterCounters(Job job) throws InterruptedException, IOException {
        super.verifyRandomWriterCounters(job);
        Counters counters = job.getCounters();
        Assert.assertEquals((long)3L, (long)counters.findCounter((Enum)JobCounter.NUM_UBER_SUBMAPS).getValue());
        Assert.assertEquals((long)3L, (long)counters.findCounter((Enum)JobCounter.TOTAL_LAUNCHED_UBERTASKS).getValue());
    }

    @Override
    @Test
    public void testFailingMapper() throws IOException, InterruptedException, ClassNotFoundException {
        LOG.info("\n\n\nStarting uberized testFailingMapper().");
        if (!new File(MiniMRYarnCluster.APPJAR).exists()) {
            LOG.info("MRAppJar " + MiniMRYarnCluster.APPJAR + " not found. Not running test.");
            return;
        }
        Job job = this.runFailingMapperJob();
        TaskID taskID = new TaskID(job.getJobID(), TaskType.MAP, 0);
        TaskAttemptID aId = new TaskAttemptID(taskID, 0);
        System.out.println("Diagnostics for " + aId + " :");
        for (String diag : job.getTaskDiagnostics(aId)) {
            System.out.println(diag);
        }
        boolean secondTaskAttemptExists = true;
        try {
            aId = new TaskAttemptID(taskID, 1);
            System.out.println("Diagnostics for " + aId + " :");
            for (String diag : job.getTaskDiagnostics(aId)) {
                System.out.println(diag);
            }
        }
        catch (Exception e) {
            secondTaskAttemptExists = false;
        }
        Assert.assertEquals((Object)false, (Object)secondTaskAttemptExists);
        TaskCompletionEvent[] events = job.getTaskCompletionEvents(0, 2);
        Assert.assertEquals((long)1L, (long)events.length);
        TaskCompletionEvent.Status status = events[0].getStatus();
        Assert.assertTrue((status == TaskCompletionEvent.Status.FAILED || status == TaskCompletionEvent.Status.TIPFAILED ? 1 : 0) != 0);
        Assert.assertEquals((Object)JobStatus.State.FAILED, (Object)job.getJobState());
    }

    @Override
    protected void verifyFailingMapperCounters(Job job) throws InterruptedException, IOException {
        Counters counters = job.getCounters();
        super.verifyFailingMapperCounters(job);
        Assert.assertEquals((long)2L, (long)counters.findCounter((Enum)JobCounter.TOTAL_LAUNCHED_UBERTASKS).getValue());
        Assert.assertEquals((long)2L, (long)counters.findCounter((Enum)JobCounter.NUM_UBER_SUBMAPS).getValue());
        Assert.assertEquals((long)2L, (long)counters.findCounter((Enum)JobCounter.NUM_FAILED_UBERTASKS).getValue());
    }

    @Override
    public void testSleepJobWithSecurityOn() throws IOException, InterruptedException, ClassNotFoundException {
        super.testSleepJobWithSecurityOn();
    }
}

