/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred.pipes;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.Reporter;

public class WordCountInputFormat
extends FileInputFormat<IntWritable, Text> {
    public InputSplit[] getSplits(JobConf conf, int numSplits) throws IOException {
        ArrayList<WordCountInputSplit> result = new ArrayList<WordCountInputSplit>();
        LocalFileSystem local = FileSystem.getLocal((Configuration)conf);
        for (Path dir : WordCountInputFormat.getInputPaths((JobConf)conf)) {
            for (FileStatus file : local.listStatus(dir)) {
                result.add(new WordCountInputSplit(file.getPath()));
            }
        }
        return result.toArray(new InputSplit[result.size()]);
    }

    public RecordReader<IntWritable, Text> getRecordReader(InputSplit split, JobConf conf, Reporter reporter) {
        return new RecordReader<IntWritable, Text>(){

            public boolean next(IntWritable key, Text value) throws IOException {
                return false;
            }

            public IntWritable createKey() {
                return new IntWritable();
            }

            public Text createValue() {
                return new Text();
            }

            public long getPos() {
                return 0L;
            }

            public void close() {
            }

            public float getProgress() {
                return 0.0f;
            }
        };
    }

    static class WordCountInputSplit
    implements InputSplit {
        private String filename;

        WordCountInputSplit() {
        }

        WordCountInputSplit(Path filename) {
            this.filename = filename.toUri().getPath();
        }

        public void write(DataOutput out) throws IOException {
            Text.writeString((DataOutput)out, (String)this.filename);
        }

        public void readFields(DataInput in) throws IOException {
            this.filename = Text.readString((DataInput)in);
        }

        public long getLength() {
            return 0L;
        }

        public String[] getLocations() {
            return new String[0];
        }
    }
}

