/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.DataInput;
import java.io.DataInputStream;
import java.net.HttpURLConnection;
import java.net.SocketException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapred.ShuffleHandler;
import org.apache.hadoop.mapred.TestShuffleHandler;
import org.apache.hadoop.mapreduce.task.reduce.ShuffleHeader;
import org.apache.hadoop.metrics2.MetricsRecordBuilder;
import org.apache.hadoop.metrics2.MetricsSource;
import org.apache.hadoop.metrics2.MetricsSystem;
import org.apache.hadoop.metrics2.impl.MetricsSystemImpl;
import org.apache.hadoop.test.MetricsAsserts;
import org.apache.hadoop.test.MockitoMaker;
import org.jboss.netty.channel.ChannelFuture;
import org.junit.Assert;
import org.junit.Test;

/*
 * Exception performing whole class analysis ignored.
 */
public class TestShuffleHandler {
    static final long MiB = 0x100000L;
    private static final Log LOG = LogFactory.getLog(TestShuffleHandler.class);

    @Test(timeout=10000L)
    public void testSerializeMeta() throws Exception {
        Assert.assertEquals((long)1L, (long)ShuffleHandler.deserializeMetaData((ByteBuffer)ShuffleHandler.serializeMetaData((int)1)));
        Assert.assertEquals((long)-1L, (long)ShuffleHandler.deserializeMetaData((ByteBuffer)ShuffleHandler.serializeMetaData((int)-1)));
        Assert.assertEquals((long)8080L, (long)ShuffleHandler.deserializeMetaData((ByteBuffer)ShuffleHandler.serializeMetaData((int)8080)));
    }

    @Test(timeout=10000L)
    public void testShuffleMetrics() throws Exception {
        MetricsSystemImpl ms = new MetricsSystemImpl();
        ShuffleHandler sh = new ShuffleHandler((MetricsSystem)ms);
        ChannelFuture cf = (ChannelFuture)MockitoMaker.make((Object)((ChannelFuture)MockitoMaker.stub(ChannelFuture.class).returning((Object)Boolean.valueOf((boolean)true), (Object[])new Object[]{Boolean.valueOf((boolean)false)}).from).isSuccess());
        sh.metrics.shuffleConnections.incr();
        sh.metrics.shuffleOutputBytes.incr(0x100000L);
        sh.metrics.shuffleConnections.incr();
        sh.metrics.shuffleOutputBytes.incr(0x200000L);
        TestShuffleHandler.checkShuffleMetrics((MetricsSystem)ms, (long)0x300000L, (int)0, (int)0, (int)2);
        sh.metrics.operationComplete(cf);
        sh.metrics.operationComplete(cf);
        TestShuffleHandler.checkShuffleMetrics((MetricsSystem)ms, (long)0x300000L, (int)1, (int)1, (int)0);
    }

    static void checkShuffleMetrics(MetricsSystem ms, long bytes, int failed, int succeeded, int connections) {
        MetricsSource source = ms.getSource("ShuffleMetrics");
        MetricsRecordBuilder rb = MetricsAsserts.getMetrics((MetricsSource)source);
        MetricsAsserts.assertCounter((String)"ShuffleOutputBytes", (long)bytes, (MetricsRecordBuilder)rb);
        MetricsAsserts.assertCounter((String)"ShuffleOutputsFailed", (int)failed, (MetricsRecordBuilder)rb);
        MetricsAsserts.assertCounter((String)"ShuffleOutputsOK", (int)succeeded, (MetricsRecordBuilder)rb);
        MetricsAsserts.assertGauge((String)"ShuffleConnections", (int)connections, (MetricsRecordBuilder)rb);
    }

    @Test(timeout=10000L)
    public void testClientClosesConnection() throws Exception {
        ArrayList failures = new ArrayList(1);
        Configuration conf = new Configuration();
        conf.setInt("mapreduce.shuffle.port", 0);
        1 shuffleHandler = new /* Unavailable Anonymous Inner Class!! */;
        shuffleHandler.init(conf);
        shuffleHandler.start();
        URL url = new URL("http://127.0.0.1:" + shuffleHandler.getConfig().get("mapreduce.shuffle.port") + "/mapOutput?job=job_12345_1&reduce=1&map=attempt_12345_1_m_1_0");
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.connect();
        DataInputStream input = new DataInputStream(conn.getInputStream());
        Assert.assertEquals((long)200L, (long)conn.getResponseCode());
        ShuffleHeader header = new ShuffleHeader();
        header.readFields((DataInput)input);
        input.close();
        shuffleHandler.stop();
        Assert.assertTrue((String)"sendError called when client closed connection", (failures.size() == 0 ? 1 : 0) != 0);
    }

    @Test(timeout=10000L)
    public void testMaxConnections() throws Exception {
        int i;
        Configuration conf = new Configuration();
        conf.setInt("mapreduce.shuffle.port", 0);
        conf.setInt("mapreduce.shuffle.max.connections", 3);
        2 shuffleHandler = new /* Unavailable Anonymous Inner Class!! */;
        shuffleHandler.init(conf);
        shuffleHandler.start();
        int connAttempts = 3;
        HttpURLConnection[] conns = new HttpURLConnection[connAttempts];
        for (i = 0; i < connAttempts; ++i) {
            String URLstring = "http://127.0.0.1:" + shuffleHandler.getConfig().get("mapreduce.shuffle.port") + "/mapOutput?job=job_12345_1&reduce=1&map=attempt_12345_1_m_" + i + "_0";
            URL url = new URL(URLstring);
            conns[i] = (HttpURLConnection)url.openConnection();
        }
        for (i = 0; i < connAttempts; ++i) {
            conns[i].connect();
        }
        conns[0].getInputStream();
        int rc = conns[0].getResponseCode();
        Assert.assertEquals((long)200L, (long)rc);
        conns[1].getInputStream();
        rc = conns[1].getResponseCode();
        Assert.assertEquals((long)200L, (long)rc);
        try {
            conns[2].getInputStream();
            rc = conns[2].getResponseCode();
            Assert.fail((String)"Expected a SocketException");
        }
        catch (SocketException se) {
            LOG.info((Object)"Expected - connection should not be open");
        }
        catch (Exception e) {
            Assert.fail((String)"Expected a SocketException");
        }
        shuffleHandler.stop();
    }
}

